/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.nio.charset.Charset;
import java.util.Collections;
import org.apache.calcite.plan.AbstractRelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ConversionUtil;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIn;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePointLookupOptimizerRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.TestRuleHelper;
import org.apache.hadoop.hive.ql.parse.type.RexNodeExprFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHivePointLookupOptimizerRule {
    @Mock
    private RelOptSchema schemaMock;
    @Mock
    RelOptHiveTable tableMock;
    @Mock
    Table hiveTableMDMock;
    private AbstractRelOptPlanner planner;
    private RelBuilder relBuilder;

    @Before
    public void before() {
        this.planner = TestRuleHelper.buildPlanner(Collections.singletonList(new HivePointLookupOptimizerRule.FilterCondition(2)));
        this.relBuilder = TestRuleHelper.buildRelBuilder(this.planner, this.schemaMock, this.tableMock, this.hiveTableMDMock, MyRecord.class);
        this.relBuilder = this.relBuilder.transform(c -> c.withSimplify(false));
    }

    @Test
    public void testSimpleCase() {
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 2)), TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f2", 3), TestRuleHelper.eq(this.relBuilder, "f2", 4)))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        Assert.assertEquals((Object)"AND(IN($0, 1, 2), IN($1, 3, 4))", (Object)condition.toString());
    }

    @Test
    public void testInExprsMergedSingleOverlap() {
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 2)), TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 3)))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        Assert.assertEquals((Object)"=($0, 1)", (Object)condition.toString());
    }

    @Test
    public void testInExprsAndEqualsMerged() {
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 2)), TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 3)), TestRuleHelper.eq(this.relBuilder, "f1", 1))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        Assert.assertEquals((Object)"=($0, 1)", (Object)condition.toString());
    }

    @Test
    public void testInExprsMergedMultipleOverlap() {
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 2), TestRuleHelper.eq(this.relBuilder, "f1", 4), TestRuleHelper.eq(this.relBuilder, "f1", 3)), TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 5), TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 2), TestRuleHelper.eq(this.relBuilder, "f1", 3)))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        Assert.assertEquals((Object)"IN($0, 1, 2, 3)", (Object)condition.toString());
    }

    @Test
    public void testCaseWithConstantsOfDifferentType() {
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 2)), TestRuleHelper.eq(this.relBuilder, "f1", 1.0), TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f4", 3.0), TestRuleHelper.eq(this.relBuilder, "f4", 4.1)))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        Assert.assertEquals((Object)"AND(IN($0, 1, 2), =($0, 1.0E0:DOUBLE), IN($3, 3.0E0:DOUBLE, 4.1E0:DOUBLE))", (Object)condition.toString());
    }

    @Test
    public void testCaseInAndEqualsWithConstantsOfDifferentType() {
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 2)), TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f4", 3.0), TestRuleHelper.eq(this.relBuilder, "f4", 4.1)), TestRuleHelper.eq(this.relBuilder, "f4", 4.1))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        Assert.assertEquals((Object)"AND(=($0, 1), =($3, 4.1E0:DOUBLE))", (Object)condition.toString());
    }

    @Test
    public void testSimpleStructCase() {
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.or(this.relBuilder, TestRuleHelper.and(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f2", 1)), TestRuleHelper.and(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 2), TestRuleHelper.eq(this.relBuilder, "f2", 2)))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        Assert.assertEquals((Object)"IN(ROW($0, $1), ROW(1, 1), ROW(2, 2))", (Object)condition.toString());
    }

    @Test
    public void testObscuredSimple() {
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f2", 99), TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 2))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        System.out.println(condition);
        Assert.assertEquals((Object)"OR(IN($0, 1, 2), =($1, 99))", (Object)condition.toString());
    }

    @Test
    public void testRecursionIsNotObstructed() {
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f1", 1), TestRuleHelper.eq(this.relBuilder, "f1", 2)), TestRuleHelper.or(this.relBuilder, TestRuleHelper.and(this.relBuilder, TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f2", 1), TestRuleHelper.eq(this.relBuilder, "f2", 2)), TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f3", 1), TestRuleHelper.eq(this.relBuilder, "f3", 2))), TestRuleHelper.and(this.relBuilder, TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f2", 3), TestRuleHelper.eq(this.relBuilder, "f2", 4)), TestRuleHelper.or(this.relBuilder, TestRuleHelper.eq(this.relBuilder, "f3", 3), TestRuleHelper.eq(this.relBuilder, "f3", 4)))))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        System.out.println(condition);
        Assert.assertEquals((Object)"AND(IN($0, 1, 2), OR(AND(IN($1, 1, 2), IN($2, 1, 2)), AND(IN($1, 3, 4), IN($2, 3, 4))))", (Object)condition.toString());
    }

    @Test
    public void testSameVarcharLiteralDifferentPrecision() {
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        RelDataType stringType30 = rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 30), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
        RexNode lita30 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"AAA111"), stringType30, true);
        RexNode litb30 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"BBB222"), stringType30, true);
        RelDataType stringType14 = rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 14), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
        RexNode lita14 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"AAA111"), stringType14, true);
        RexNode litb14 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"BBB222"), stringType14, true);
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), lita30, litb30}), this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), lita14, litb14}))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        System.out.println(condition);
        Assert.assertEquals((Object)"IN($1, _UTF-16LE'AAA111':VARCHAR(30) CHARACTER SET \"UTF-16LE\", _UTF-16LE'BBB222':VARCHAR(30) CHARACTER SET \"UTF-16LE\")", (Object)condition.toString());
    }

    @Test
    public void testSameVarcharLiteralDifferentPrecisionValueOverflow() {
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        RelDataType stringType30 = rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 30), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
        RexNode lita30 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"AAA111"), stringType30, true);
        RexNode litb30 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"BBB222"), stringType30, true);
        RelDataType stringType4 = rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 4), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
        RexNode litaOverflow = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"AAA111"), stringType4, true);
        RexNode litbOverflow = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"BBB222"), stringType4, true);
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), lita30, litb30}), this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), litaOverflow, litbOverflow}))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        System.out.println(condition);
        Assert.assertEquals((Object)"false", (Object)condition.toString());
    }

    @Test
    public void testSameVarcharAndNullLiterals() {
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        RelDataType stringType30 = rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 30), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
        RexLiteral lita30 = rexBuilder.makeNullLiteral(stringType30);
        RexLiteral litb30 = rexBuilder.makeNullLiteral(stringType30);
        RelDataType stringType14 = rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 14), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
        RexNode lita14 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"AAA111"), stringType14, true);
        RexNode litb14 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"BBB222"), stringType14, true);
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), lita30, litb30}), this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), lita14, litb14}))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        System.out.println(condition);
        Assert.assertEquals((Object)"AND(IS NULL(null:VARCHAR(30) CHARACTER SET \"UTF-16LE\"), null)", (Object)condition.toString());
    }

    @Test
    public void testSameVarcharLiteralsDifferentPrecisionInOrExpression() {
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        RelDataType stringType30 = rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 30), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
        RexNode lita30 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"AAA111"), stringType30, true);
        RexNode litb30 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"BBB222"), stringType30, true);
        RelDataType stringType14 = rexBuilder.getTypeFactory().createTypeWithCharsetAndCollation(rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR, 14), Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME), SqlCollation.IMPLICIT);
        RexNode lita14 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"AAA111"), stringType14, true);
        RexNode litb14 = rexBuilder.makeLiteral((Object)RexNodeExprFactory.makeHiveUnicodeString((String)"BBB222"), stringType14, true);
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.or(this.relBuilder, this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), lita30, litb30}), this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), lita14, litb14}))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        System.out.println(condition);
        Assert.assertEquals((Object)"IN($1, _UTF-16LE'AAA111':VARCHAR(30) CHARACTER SET \"UTF-16LE\", _UTF-16LE'BBB222':VARCHAR(30) CHARACTER SET \"UTF-16LE\")", (Object)condition.toString());
    }

    @Test
    public void testSameDecimalLiteralDifferentPrecision() {
        RexBuilder rexBuilder = this.relBuilder.getRexBuilder();
        RelDataType decimalType30 = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, 30, 5);
        RexNode lita30 = rexBuilder.makeLiteral((Object)10000, decimalType30, true);
        RexNode litb30 = rexBuilder.makeLiteral((Object)11000, decimalType30, true);
        RelDataType decimalType14 = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, 14, 5);
        RexNode lita14 = rexBuilder.makeLiteral((Object)10000, decimalType14, true);
        RexNode litb14 = rexBuilder.makeLiteral((Object)11000, decimalType14, true);
        RelNode basePlan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.and(this.relBuilder, this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), lita30, litb30}), this.relBuilder.call((SqlOperator)HiveIn.INSTANCE, new RexNode[]{this.relBuilder.field("f2"), lita14, litb14}))}).build();
        this.planner.setRoot(basePlan);
        RelNode optimizedRelNode = this.planner.findBestExp();
        HiveFilter filter = (HiveFilter)optimizedRelNode;
        RexNode condition = filter.getCondition();
        System.out.println(condition);
        Assert.assertEquals((Object)"IN($1, 10000:DECIMAL(19, 5), 11000:DECIMAL(19, 5))", (Object)condition.toString());
    }

    private static class MyRecord {
        public int f1;
        public int f2;
        public int f3;
        public double f4;

        private MyRecord() {
        }
    }
}

