/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveToUnixTimestampSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnixTimestampSqlOperator;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestSqlOperatorInferReturnType {
    private static final RelDataTypeFactory TYPE_FACTORY = new JavaTypeFactoryImpl((RelDataTypeSystem)new HiveTypeSystemImpl());
    final SqlOperator op;
    final List<RelDataType> inputTypes;
    final RelDataType returnType;

    public TestSqlOperatorInferReturnType(SqlOperator op, List<RelDataType> inputTypes, RelDataType returnType) {
        this.op = op;
        this.inputTypes = inputTypes;
        this.returnType = returnType;
    }

    @Test
    public void testInferReturnType() {
        Assert.assertEquals((Object)this.returnType, (Object)this.op.inferReturnType(TYPE_FACTORY, this.inputTypes));
    }

    @Parameterized.Parameters(name="op={0}, inTypes={1}, expectedReturnType={2}")
    public static Collection<Object[]> generateValidOperatorCalls() throws SemanticException {
        RelDataType varchar19 = TYPE_FACTORY.createSqlType(SqlTypeName.VARCHAR, 19);
        RelDataType bigint = TYPE_FACTORY.createSqlType(SqlTypeName.BIGINT);
        ArrayList<Object[]> calls = new ArrayList<Object[]>();
        calls.add(new Object[]{HiveUnixTimestampSqlOperator.INSTANCE, Collections.emptyList(), bigint});
        calls.add(new Object[]{HiveUnixTimestampSqlOperator.INSTANCE, Collections.singletonList(varchar19), bigint});
        calls.add(new Object[]{HiveUnixTimestampSqlOperator.INSTANCE, Arrays.asList(varchar19, varchar19), bigint});
        calls.add(new Object[]{HiveToUnixTimestampSqlOperator.INSTANCE, Collections.emptyList(), bigint});
        calls.add(new Object[]{HiveToUnixTimestampSqlOperator.INSTANCE, Collections.singletonList(varchar19), bigint});
        calls.add(new Object[]{HiveToUnixTimestampSqlOperator.INSTANCE, Arrays.asList(varchar19, varchar19), bigint});
        return calls;
    }
}

