/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.parse.ParsedQueryTables;
import org.apache.hadoop.hive.ql.parse.QueryTables;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveTableScan {
    @Test
    public void testGetConventionWithWithHepPlannerCluster() {
        RelNode scan = TestHiveTableScan.createScanWithPlanner((RelOptPlanner)new HepPlanner(HepProgram.builder().build()));
        Assert.assertNull((Object)scan.getConvention());
    }

    @Test
    public void testGetConventionWithVolcanoPlannerCluster() {
        RelNode scan = TestHiveTableScan.createScanWithPlanner((RelOptPlanner)new VolcanoPlanner());
        Assert.assertEquals((Object)HiveRelNode.CONVENTION, (Object)scan.getConvention());
    }

    private static RelNode createScanWithPlanner(RelOptPlanner planner) {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)new RexBuilder((RelDataTypeFactory)typeFactory));
        return new HiveTableScan(cluster, cluster.traitSet(), TestHiveTableScan.dummyRelOptTable((RelDataTypeFactory)typeFactory), "alias", "alias", false, false);
    }

    private static RelOptHiveTable dummyRelOptTable(RelDataTypeFactory factory) {
        RelDataType tblType = factory.builder().add("col1", SqlTypeName.INTEGER).add("col2", SqlTypeName.VARCHAR).build();
        Table tblMeta = new Table("default", "dummy");
        return new RelOptHiveTable(null, factory, Arrays.asList("default", "dummy"), tblType, tblMeta, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), new HiveConf(), (ParsedQueryTables)new QueryTables(), new HashMap(), new HashMap(), new AtomicInteger(0));
    }
}

