/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.SharedWorkOptimizer;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestSharedWorkOptimizer {
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> unset = EnumSet.of(ReduceSinkDesc.ReducerTraits.UNSET);
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> fixed = EnumSet.of(ReduceSinkDesc.ReducerTraits.FIXED);
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> uniform = EnumSet.of(ReduceSinkDesc.ReducerTraits.UNIFORM);
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> autoparallel = EnumSet.of(ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
    private static final EnumSet<ReduceSinkDesc.ReducerTraits> uniformAutoparallel = EnumSet.of(ReduceSinkDesc.ReducerTraits.UNIFORM, ReduceSinkDesc.ReducerTraits.AUTOPARALLEL);
    CompilationOpContext cCtx = new CompilationOpContext();

    private void ensureDeduplicate(EnumSet<ReduceSinkDesc.ReducerTraits> traits1, int numReducers1, EnumSet<ReduceSinkDesc.ReducerTraits> traits2, int numReducers2, EnumSet<ReduceSinkDesc.ReducerTraits> expectedTraits, int expectedNumReducers) {
        ReduceSinkDesc rsConf1 = new ReduceSinkDesc();
        rsConf1.setReducerTraits(traits1);
        rsConf1.setNumReducers(numReducers1);
        ReduceSinkDesc rsConf2 = new ReduceSinkDesc();
        rsConf2.setReducerTraits(traits2);
        rsConf2.setNumReducers(numReducers2);
        boolean deduplicated = SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)rsConf1, (ReduceSinkDesc)rsConf2);
        Assert.assertTrue((boolean)deduplicated);
        Assert.assertEquals(expectedTraits, (Object)rsConf1.getReducerTraits());
        Assert.assertEquals((long)expectedNumReducers, (long)rsConf1.getNumReducers());
        rsConf1 = new ReduceSinkDesc();
        rsConf1.setReducerTraits(traits1);
        rsConf1.setNumReducers(numReducers1);
        rsConf2 = new ReduceSinkDesc();
        rsConf2.setReducerTraits(traits2);
        rsConf2.setNumReducers(numReducers2);
        deduplicated = SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)rsConf2, (ReduceSinkDesc)rsConf1);
        Assert.assertTrue((boolean)deduplicated);
        Assert.assertEquals(expectedTraits, (Object)rsConf2.getReducerTraits());
        Assert.assertEquals((long)expectedNumReducers, (long)rsConf2.getNumReducers());
    }

    private void ensureNotDeduplicate(EnumSet<ReduceSinkDesc.ReducerTraits> traits1, int numReducers1, EnumSet<ReduceSinkDesc.ReducerTraits> traits2, int numReducers2) {
        ReduceSinkDesc rsConf1 = new ReduceSinkDesc();
        rsConf1.setReducerTraits(traits1);
        rsConf1.setNumReducers(numReducers1);
        ReduceSinkDesc rsConf2 = new ReduceSinkDesc();
        rsConf2.setReducerTraits(traits2);
        rsConf2.setNumReducers(numReducers2);
        boolean deduplicated = SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)rsConf1, (ReduceSinkDesc)rsConf2);
        Assert.assertFalse((boolean)deduplicated);
        rsConf1 = new ReduceSinkDesc();
        rsConf1.setReducerTraits(traits1);
        rsConf1.setNumReducers(numReducers1);
        rsConf2 = new ReduceSinkDesc();
        rsConf2.setReducerTraits(traits2);
        rsConf2.setNumReducers(numReducers2);
        deduplicated = SharedWorkOptimizer.deduplicateReduceTraits((ReduceSinkDesc)rsConf1, (ReduceSinkDesc)rsConf2);
        Assert.assertFalse((boolean)deduplicated);
    }

    @Test
    public void testDeduplicate() {
        this.ensureDeduplicate(unset, 0, unset, 0, unset, 0);
        this.ensureDeduplicate(unset, 0, fixed, 1, fixed, 1);
        this.ensureDeduplicate(unset, 0, uniform, 1, uniform, 1);
        this.ensureDeduplicate(unset, 0, autoparallel, 1, autoparallel, 1);
        this.ensureDeduplicate(unset, 0, uniformAutoparallel, 1, uniformAutoparallel, 1);
        this.ensureDeduplicate(fixed, 1, fixed, 1, fixed, 1);
        this.ensureNotDeduplicate(fixed, 1, fixed, 2);
        this.ensureDeduplicate(fixed, 1, uniform, 1, fixed, 1);
        this.ensureDeduplicate(fixed, 1, autoparallel, 2, fixed, 1);
        this.ensureDeduplicate(fixed, 1, uniformAutoparallel, 2, fixed, 1);
        this.ensureDeduplicate(uniform, 1, uniform, 2, uniform, 2);
        this.ensureNotDeduplicate(uniform, 1, autoparallel, 2);
        this.ensureDeduplicate(uniform, 1, uniformAutoparallel, 2, uniform, 2);
        this.ensureDeduplicate(autoparallel, 1, uniformAutoparallel, 2, autoparallel, 2);
        this.ensureDeduplicate(uniformAutoparallel, 1, uniformAutoparallel, 2, uniformAutoparallel, 2);
    }

    @Test
    public void testTSCmp() {
        ArrayList li = Lists.newArrayList((Object[])new TableScanOperator[]{this.addFilter(this.getTsOp(), 1), this.getTsOp()});
        li.sort(new SharedWorkOptimizer.TSComparator());
        Assert.assertNull((Object)((TableScanDesc)((TableScanOperator)li.get(0)).getConf()).getFilterExpr());
    }

    @Test
    public void testTSCmpOrdersById() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        ArrayList li1 = Lists.newArrayList((Object[])new TableScanOperator[]{ts1, ts2});
        ArrayList li2 = Lists.newArrayList((Object[])new TableScanOperator[]{ts2, ts1});
        li1.sort(new SharedWorkOptimizer.TSComparator());
        li2.sort(new SharedWorkOptimizer.TSComparator());
        Assert.assertTrue((li1.get(0) == li2.get(0) ? 1 : 0) != 0);
    }

    @Test
    public void testTSCmpOrdersByDataSizeDesc() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        TableScanOperator ts3 = this.getTsOp();
        ts1.setStatistics(new Statistics(100L, 100L, 1L, 1L));
        ts2.setStatistics(new Statistics(1000L, 1000L, 1L, 1L));
        ts3.setStatistics(new Statistics(10L, 10L, 1L, 1L));
        ArrayList li1 = Lists.newArrayList((Object[])new TableScanOperator[]{ts1, ts3, ts2});
        li1.sort(new SharedWorkOptimizer.TSComparator());
        Assert.assertTrue((((TableScanOperator)li1.get(0)).getStatistics().getDataSize() == 1000L ? 1 : 0) != 0);
        Assert.assertTrue((((TableScanOperator)li1.get(1)).getStatistics().getDataSize() == 100L ? 1 : 0) != 0);
        Assert.assertTrue((((TableScanOperator)li1.get(2)).getStatistics().getDataSize() == 10L ? 1 : 0) != 0);
    }

    private TableScanOperator getTsOp() {
        Table tblMetadata = new Table("db", "table");
        TableScanDesc desc = new TableScanDesc("alias_" + this.cCtx.nextOperatorId(), tblMetadata);
        Operator ts = OperatorFactory.get((CompilationOpContext)this.cCtx, (OperatorDesc)desc);
        return (TableScanOperator)ts;
    }

    private TableScanOperator addFilter(TableScanOperator ts, int i) {
        TableScanDesc desc = (TableScanDesc)ts.getConf();
        ArrayList as = Lists.newArrayList((Object[])new ExprNodeDesc[]{new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)i), new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "c1", "aa", false)});
        GenericUDFConcat udf = new GenericUDFConcat();
        ExprNodeGenericFuncDesc f1 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)udf, (List)as);
        desc.setFilterExpr(f1);
        return ts;
    }

    private Operator<? extends OperatorDesc> getFilterOp(int constVal) {
        ExprNodeConstantDesc pred = new ExprNodeConstantDesc((Object)constVal);
        FilterDesc fd = new FilterDesc((ExprNodeDesc)pred, true);
        Operator op = OperatorFactory.get((CompilationOpContext)this.cCtx, (OperatorDesc)fd);
        return op;
    }

    @Test
    public void testSharedWorkOptimizerCache() {
        int i;
        ArrayList<Operator<? extends OperatorDesc>> ops = new ArrayList<Operator<? extends OperatorDesc>>();
        for (int i2 = 0; i2 < 100; ++i2) {
            ops.add(this.getFilterOp(i2));
        }
        SharedWorkOptimizer.SharedWorkOptimizerCache c = new SharedWorkOptimizer.SharedWorkOptimizerCache();
        for (i = 1; i < 10; ++i) {
            int u = 10 * i;
            c.addWorkGroup(ops.subList(u, u + 10));
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)c.getWorkGroup((Operator)ops.get(i)).isEmpty());
        }
        for (i = 40; i < 50; ++i) {
            Assert.assertEquals((Object)c.getWorkGroup((Operator)ops.get(40)), (Object)c.getWorkGroup((Operator)ops.get(i)));
        }
        for (i = 10; i < 100; i += 10) {
            for (int j = i + 10; j < 100; j += 10) {
                Assert.assertNotEquals((Object)c.getWorkGroup((Operator)ops.get(i)), (Object)c.getWorkGroup((Operator)ops.get(j)));
            }
        }
        c.removeOpAndCombineWork((Operator)ops.get(10), (Operator)ops.get(20));
        Assert.assertTrue((boolean)c.getWorkGroup((Operator)ops.get(10)).isEmpty());
        Assert.assertEquals((long)19L, (long)c.getWorkGroup((Operator)ops.get(11)).size());
        for (i = 11; i < 20; ++i) {
            Assert.assertTrue((boolean)c.getWorkGroup((Operator)ops.get(11)).contains(ops.get(i)));
        }
        c.putIfWorkExists((Operator)ops.get(0), (Operator)ops.get(1));
        Assert.assertTrue((boolean)c.getWorkGroup((Operator)ops.get(0)).isEmpty());
        Assert.assertTrue((boolean)c.getWorkGroup((Operator)ops.get(1)).isEmpty());
        c.putIfWorkExists((Operator)ops.get(0), (Operator)ops.get(30));
        Assert.assertFalse((boolean)c.getWorkGroup((Operator)ops.get(0)).isEmpty());
        Assert.assertTrue((boolean)c.getWorkGroup((Operator)ops.get(31)).contains(ops.get(0)));
        c.removeOp((Operator)ops.get(1));
        c.removeOp((Operator)ops.get(50));
        Assert.assertTrue((boolean)c.getWorkGroup((Operator)ops.get(50)).isEmpty());
        Assert.assertFalse((boolean)c.getWorkGroup((Operator)ops.get(51)).contains(ops.get(50)));
    }

    private ReduceSinkDesc getReduceSinkDesc() {
        TableDesc dummyKeySerializeInfo = new TableDesc();
        dummyKeySerializeInfo.setProperties(new Properties());
        ReduceSinkDesc conf = new ReduceSinkDesc(new ArrayList(), 0, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), 0, new ArrayList(), 0, null, null, null);
        conf.setKeySerializeInfo(dummyKeySerializeInfo);
        return conf;
    }

    private MapJoinDesc getMapJoinDesc(int posBigTable) {
        MapJoinDesc conf = new MapJoinDesc();
        conf.setPosBigTable(posBigTable);
        return conf;
    }

    private void runMapJoinCacheReuseOptimization(Operator<?> op1, Operator<?> op2) {
        SharedWorkOptimizer sharedWorkOptimizer = new SharedWorkOptimizer();
        SharedWorkOptimizer.SharedWorkOptimizerCache optimizerCache = new SharedWorkOptimizer.SharedWorkOptimizerCache();
        optimizerCache.addWorkGroup(Arrays.asList(op1, op2));
        try {
            sharedWorkOptimizer.runMapJoinCacheReuseOptimization(null, optimizerCache);
        }
        catch (SemanticException se) {
            Assert.fail();
        }
    }

    @Test
    public void testMapJoinCacheReuseSameSources() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsB2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)ts2, (Operator<?>)rsA1, (Operator<?>)rsA2, (Operator<?>)rsB1, (Operator<?>)rsB2, 0, 0, JoinType.INNER.ordinal(), JoinType.INNER.ordinal(), true);
    }

    @Test
    public void testMapJoinCacheReuseDifferentSources() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableC = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsC2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableC, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)ts2, (Operator<?>)rsA1, (Operator<?>)rsA2, (Operator<?>)rsB1, (Operator<?>)rsC2, 0, 0, JoinType.INNER.ordinal(), JoinType.INNER.ordinal(), false);
    }

    @Test
    public void testMapJoinCacheReuseDifferentOrdering() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsB2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)rsA2, (Operator<?>)rsA1, (Operator<?>)ts2, (Operator<?>)rsB1, (Operator<?>)rsB2, 0, 1, JoinType.INNER.ordinal(), JoinType.INNER.ordinal(), false);
    }

    @Test
    public void testMapJoinCacheReuseInnerLeftOuter() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsB2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)ts2, (Operator<?>)rsA1, (Operator<?>)rsA2, (Operator<?>)rsB1, (Operator<?>)rsB2, 0, 0, JoinType.INNER.ordinal(), JoinType.LEFTOUTER.ordinal(), false);
    }

    @Test
    public void testMapJoinCacheReuseInnerRightOuter() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsB2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)ts2, (Operator<?>)rsA1, (Operator<?>)rsA2, (Operator<?>)rsB1, (Operator<?>)rsB2, 0, 0, JoinType.INNER.ordinal(), JoinType.RIGHTOUTER.ordinal(), false);
    }

    @Test
    public void testMapJoinCacheReuseInnerLeftSemi() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsB2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)ts2, (Operator<?>)rsA1, (Operator<?>)rsA2, (Operator<?>)rsB1, (Operator<?>)rsB2, 0, 0, JoinType.INNER.ordinal(), JoinType.LEFTSEMI.ordinal(), false);
    }

    @Test
    public void testMapJoinCacheReuseInnerAnti() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsB2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)ts2, (Operator<?>)rsA1, (Operator<?>)rsA2, (Operator<?>)rsB1, (Operator<?>)rsB2, 0, 0, JoinType.INNER.ordinal(), JoinType.ANTI.ordinal(), false);
    }

    @Test
    public void testMapJoinCacheReuseRightOuterLeftSemi() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsB2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)ts2, (Operator<?>)rsA1, (Operator<?>)rsA2, (Operator<?>)rsB1, (Operator<?>)rsB2, 0, 0, JoinType.RIGHTOUTER.ordinal(), JoinType.LEFTSEMI.ordinal(), false);
    }

    @Test
    public void testMapJoinCacheReuseRightOuterLeftOuter() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsB2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)ts2, (Operator<?>)rsA1, (Operator<?>)rsA2, (Operator<?>)rsB1, (Operator<?>)rsB2, 0, 0, JoinType.RIGHTOUTER.ordinal(), JoinType.LEFTOUTER.ordinal(), true);
    }

    @Test
    public void testMapJoinCacheReuseFullOuterInner() {
        TableScanOperator ts1 = this.getTsOp();
        TableScanOperator ts2 = this.getTsOp();
        Operator<? extends OperatorDesc> smallTableA = this.getFilterOp(0);
        Operator<? extends OperatorDesc> smallTableB = this.getFilterOp(0);
        Operator rsA1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsA2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableA, (Operator[])new Operator[0]);
        Operator rsB1 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        Operator rsB2 = OperatorFactory.getAndMakeChild((OperatorDesc)this.getReduceSinkDesc(), smallTableB, (Operator[])new Operator[0]);
        this.setupJoinOperatorsAndTest((Operator<?>)ts1, (Operator<?>)ts2, (Operator<?>)rsA1, (Operator<?>)rsA2, (Operator<?>)rsB1, (Operator<?>)rsB2, 0, 0, JoinType.FULLOUTER.ordinal(), JoinType.INNER.ordinal(), false);
    }

    private void setupJoinOperatorsAndTest(Operator<?> join1Source1, Operator<?> join2Source1, Operator<?> join1Source2, Operator<?> join2Source2, Operator<?> join1Source3, Operator<?> join2Source3, int join1PosBigTable, int join2PosBigTable, int join1Type, int join2Type, boolean positive) {
        List<Operator<?>> join1Source = Arrays.asList(join1Source1, join1Source2, join1Source3);
        List<Operator<?>> join2Source = Arrays.asList(join2Source1, join2Source2, join2Source3);
        MapJoinOperator mapJoin1 = this.setupMapJoin(join1Source, join1Type, join1PosBigTable);
        MapJoinOperator mapJoin2 = this.setupMapJoin(join2Source, join2Type, join2PosBigTable);
        this.runMapJoinCacheReuseOptimization((Operator<?>)mapJoin1, (Operator<?>)mapJoin2);
        if (positive) {
            Assert.assertEquals((Object)((MapJoinDesc)mapJoin1.getConf()).getCacheKey(), (Object)((MapJoinDesc)mapJoin2.getConf()).getCacheKey());
            return;
        }
        Assert.assertNotEquals((Object)((MapJoinDesc)mapJoin1.getConf()).getCacheKey(), (Object)((MapJoinDesc)mapJoin2.getConf()).getCacheKey());
    }

    MapJoinOperator setupMapJoin(List<Operator<?>> joinSource, int joinType, int joinPosBigTable) {
        MapJoinOperator mapJoin = (MapJoinOperator)OperatorFactory.getAndMakeChild((CompilationOpContext)this.cCtx, (OperatorDesc)this.getMapJoinDesc(joinPosBigTable), joinSource);
        JoinCondDesc cond = new JoinCondDesc(0, 0, joinType);
        ((MapJoinDesc)mapJoin.getConf()).setConds(new JoinCondDesc[]{cond});
        boolean isNoOuterJoin = joinType != JoinType.RIGHTOUTER.ordinal() && joinType != JoinType.LEFTOUTER.ordinal() && joinType != JoinType.FULLOUTER.ordinal();
        ((MapJoinDesc)mapJoin.getConf()).setNoOuterJoin(isNoOuterJoin);
        return mapJoin;
    }
}

