/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.optimizer.BucketVersionPopulator;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.junit.Assert;
import org.junit.Test;

public class TestBucketVersionPopulator {
    CompilationOpContext cCtx = new CompilationOpContext();

    @Test
    public void testVersionInfoSort() {
        ArrayList<BucketVersionPopulator.OperatorBucketingVersionInfo> arr = new ArrayList<BucketVersionPopulator.OperatorBucketingVersionInfo>();
        BucketVersionPopulator.OperatorBucketingVersionInfo opt2 = this.buildInfo(BucketVersionPopulator.InfoType.OPTIONAL, 2);
        BucketVersionPopulator.OperatorBucketingVersionInfo opt1 = this.buildInfo(BucketVersionPopulator.InfoType.OPTIONAL, 1);
        BucketVersionPopulator.OperatorBucketingVersionInfo mand2 = this.buildInfo(BucketVersionPopulator.InfoType.MANDATORY, 2);
        BucketVersionPopulator.OperatorBucketingVersionInfo mand1 = this.buildInfo(BucketVersionPopulator.InfoType.MANDATORY, 1);
        arr.add(opt2);
        arr.add(opt1);
        arr.add(mand2);
        arr.add(mand1);
        arr.sort(BucketVersionPopulator.OperatorBucketingVersionInfo.MANDATORY_FIRST);
        Assert.assertEquals(arr.get(0), (Object)mand2);
        Assert.assertEquals(arr.get(1), (Object)mand1);
        Assert.assertEquals(arr.get(2), (Object)opt2);
        Assert.assertEquals(arr.get(3), (Object)opt1);
    }

    private BucketVersionPopulator.OperatorBucketingVersionInfo buildInfo(BucketVersionPopulator.InfoType optional, int version) {
        return new BucketVersionPopulator.OperatorBucketingVersionInfo(this.getOp(), optional, version);
    }

    private Operator<? extends OperatorDesc> getOp() {
        ExprNodeConstantDesc pred = new ExprNodeConstantDesc((Object)1);
        FilterDesc fd = new FilterDesc((ExprNodeDesc)pred, true);
        Operator op = OperatorFactory.get((CompilationOpContext)this.cCtx, (OperatorDesc)fd);
        return op;
    }
}

