/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMPoolTrigger;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMResourcePlanStatus;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.ql.ddl.workloadmanagement.resourceplan.show.formatter.JsonShowResourcePlanFormatter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJsonRPFormatter {
    private final JsonShowResourcePlanFormatter formatter = new JsonShowResourcePlanFormatter();
    private ByteArrayOutputStream bos;
    private DataOutputStream out;

    @Before
    public void setup() {
        this.bos = new ByteArrayOutputStream();
        this.out = new DataOutputStream(this.bos);
    }

    @After
    public void teardown() throws Exception {
        this.out.close();
        this.bos.close();
    }

    private WMFullResourcePlan createRP(String name, Integer parallelism, String defaultPoolPath) {
        WMResourcePlan rp = new WMResourcePlan(name);
        rp.setStatus(WMResourcePlanStatus.ACTIVE);
        if (parallelism != null) {
            rp.setQueryParallelism(parallelism.intValue());
        }
        if (defaultPoolPath != null) {
            rp.setDefaultPoolPath(defaultPoolPath);
        }
        WMFullResourcePlan fullRp = new WMFullResourcePlan(rp, new ArrayList());
        return fullRp;
    }

    private void addPool(WMFullResourcePlan fullRp, String poolName, double allocFraction, int parallelism, String policy) {
        WMPool pool = new WMPool(fullRp.getPlan().getName(), poolName);
        pool.setAllocFraction(allocFraction);
        pool.setQueryParallelism(parallelism);
        if (policy != null) {
            pool.setSchedulingPolicy(policy);
        }
        fullRp.addToPools(pool);
    }

    private void addTrigger(WMFullResourcePlan fullRp, String triggerName, String action, String expr, String poolName) {
        WMTrigger trigger = new WMTrigger(fullRp.getPlan().getName(), triggerName);
        trigger.setActionExpression(action);
        trigger.setTriggerExpression(expr);
        fullRp.addToTriggers(trigger);
        WMPoolTrigger pool2Trigger = new WMPoolTrigger(poolName, triggerName);
        fullRp.addToPoolTriggers(pool2Trigger);
    }

    private void addMapping(WMFullResourcePlan fullRp, String type, String name, String poolName) {
        WMMapping mapping = new WMMapping(fullRp.getPlan().getName(), type, name);
        mapping.setPoolPath(poolName);
        fullRp.addToMappings(mapping);
    }

    @Test
    public void testJsonEmptyRPFormatter() throws Exception {
        WMFullResourcePlan fullRp = this.createRP("test_rp_1", null, null);
        this.formatter.showFullResourcePlan(this.out, fullRp);
        this.out.flush();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonTree = objectMapper.readTree(this.bos.toByteArray());
        Assert.assertNotNull((Object)jsonTree);
        Assert.assertTrue((boolean)jsonTree.isObject());
        Assert.assertEquals((Object)"test_rp_1", (Object)jsonTree.get("name").asText());
        Assert.assertTrue((boolean)jsonTree.get("parallelism").isNull());
        Assert.assertTrue((boolean)jsonTree.get("defaultPool").isNull());
        Assert.assertTrue((boolean)jsonTree.get("pools").isArray());
        Assert.assertEquals((long)0L, (long)jsonTree.get("pools").size());
    }

    @Test
    public void testJsonRPFormatter() throws Exception {
        WMFullResourcePlan fullRp = this.createRP("test_rp_2", 10, "def");
        this.addPool(fullRp, "pool1", 0.3, 3, "fair");
        this.addTrigger(fullRp, "trigger1", "KILL", "BYTES > 2", "pool1");
        this.addPool(fullRp, "pool2", 0.7, 7, "fcfs");
        this.addMapping(fullRp, "user", "foo", "pool2");
        this.addMapping(fullRp, "user", "bar", "pool2");
        this.formatter.showFullResourcePlan(this.out, fullRp);
        this.out.flush();
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonTree = objectMapper.readTree(this.bos.toByteArray());
        Assert.assertNotNull((Object)jsonTree);
        Assert.assertTrue((boolean)jsonTree.isObject());
        Assert.assertEquals((Object)"test_rp_2", (Object)jsonTree.get("name").asText());
        Assert.assertEquals((long)10L, (long)jsonTree.get("parallelism").asInt());
        Assert.assertEquals((Object)"def", (Object)jsonTree.get("defaultPool").asText());
        Assert.assertTrue((boolean)jsonTree.get("pools").isArray());
        Assert.assertEquals((long)2L, (long)jsonTree.get("pools").size());
        JsonNode pool2 = jsonTree.get("pools").get(0);
        Assert.assertEquals((Object)"pool2", (Object)pool2.get("name").asText());
        Assert.assertEquals((Object)"fcfs", (Object)pool2.get("schedulingPolicy").asText());
        Assert.assertEquals((long)7L, (long)pool2.get("parallelism").asInt());
        Assert.assertEquals((double)0.7, (double)pool2.get("allocFraction").asDouble(), (double)1.0E-5);
        Assert.assertTrue((boolean)pool2.get("triggers").isArray());
        Assert.assertEquals((long)0L, (long)pool2.get("triggers").size());
        Assert.assertTrue((boolean)pool2.get("mappings").isArray());
        JsonNode type0 = pool2.get("mappings").get(0);
        Assert.assertEquals((Object)"user", (Object)type0.get("type").asText());
        Assert.assertTrue((boolean)type0.get("values").isArray());
        Assert.assertEquals((long)2L, (long)type0.get("values").size());
        HashSet<String> vals = new HashSet<String>();
        for (int i = 0; i < type0.get("values").size(); ++i) {
            vals.add(type0.get("values").get(i).asText());
        }
        Assert.assertTrue((boolean)vals.contains("foo"));
        Assert.assertTrue((boolean)vals.contains("bar"));
        JsonNode pool1 = jsonTree.get("pools").get(1);
        Assert.assertEquals((Object)"pool1", (Object)pool1.get("name").asText());
        Assert.assertEquals((Object)"fair", (Object)pool1.get("schedulingPolicy").asText());
        Assert.assertEquals((long)3L, (long)pool1.get("parallelism").asInt());
        Assert.assertEquals((double)0.3, (double)pool1.get("allocFraction").asDouble(), (double)1.0E-5);
        Assert.assertTrue((boolean)pool1.get("triggers").isArray());
        Assert.assertEquals((long)1L, (long)pool1.get("triggers").size());
        JsonNode trigger1 = pool1.get("triggers").get(0);
        Assert.assertEquals((Object)"trigger1", (Object)trigger1.get("name").asText());
        Assert.assertEquals((Object)"KILL", (Object)trigger1.get("action").asText());
        Assert.assertEquals((Object)"BYTES > 2", (Object)trigger1.get("trigger").asText());
    }
}

