/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTempAcidTable {
    private static Hive hive;

    @BeforeClass
    public static void setUp() throws Exception {
        hive = Hive.get();
        HiveConfForTest hiveConf = new HiveConfForTest(TestTempAcidTable.class);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_IN_TEST, true);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
        hiveConf.setVar(HiveConf.ConfVars.METASTORE_CLIENT_CAPABILITIES, "HIVEFULLACIDWRITE,HIVEMANAGEDINSERTWRITE");
        MetastoreConf.setVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_METADATA_TRANSFORMER_CLASS, (String)"org.apache.hadoop.hive.metastore.MetastoreDefaultTransformer");
        SessionState ss = SessionState.start((HiveConf)hiveConf);
        ss.initTxnMgr(hive.getConf());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Hive.closeCurrent();
    }

    @Test
    public void testTempInsertOnlyTableTranslate() throws Throwable {
        try {
            String dbName = "default";
            String tableName = "temp_table";
            hive.dropTable(dbName, tableName);
            Table table = new Table(dbName, tableName);
            table.setInputFormatClass(OrcInputFormat.class);
            table.setOutputFormatClass(OrcOutputFormat.class);
            Map params = table.getParameters();
            params.put("transactional", "true");
            params.put("transactional_properties", "insert_only");
            table.setTemporary(true);
            hive.createTable(table);
            Table table1 = hive.getTable(dbName, tableName);
            Assert.assertNotNull((Object)table1);
            Assert.assertEquals((Object)tableName, (Object)table1.getTableName());
            Assert.assertTrue((boolean)table.isTemporary());
            Table table2 = hive.getTranslateTableDryrun(table1.getTTable());
            Assert.assertNotNull((Object)table2);
            Assert.assertEquals((Object)table1.getTTable().getSd().getLocation(), (Object)table2.getTTable().getSd().getLocation());
            hive.dropTable(dbName, tableName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testTempInsertOnlyAcidTableTranslate() failed");
            throw e;
        }
    }

    @Test
    public void testTempFullAcidTableTranslate() throws Throwable {
        try {
            String dbName = "default";
            String tableName = "temp_table";
            hive.dropTable(dbName, tableName);
            Table table = new Table(dbName, tableName);
            table.setInputFormatClass(OrcInputFormat.class);
            table.setOutputFormatClass(OrcOutputFormat.class);
            Map params = table.getParameters();
            params.put("transactional", "true");
            table.setTemporary(true);
            hive.createTable(table);
            Table table1 = hive.getTable(dbName, tableName);
            Assert.assertNotNull((Object)table1);
            Assert.assertEquals((Object)tableName, (Object)table1.getTableName());
            Assert.assertTrue((boolean)table.isTemporary());
            Table table2 = hive.getTranslateTableDryrun(table1.getTTable());
            Assert.assertNotNull((Object)table2);
            Assert.assertEquals((Object)table1.getTTable().getSd().getLocation(), (Object)table2.getTTable().getSd().getLocation());
            hive.dropTable(dbName, tableName);
        }
        catch (Throwable e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("testTempFullAcidTableTranslate() failed");
            throw e;
        }
    }
}

