/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TestMetastoreExpr;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.GetPartitionNamesPsRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.CustomIgnoreRule;
import org.apache.hadoop.hive.metastore.client.TestListPartitions;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreClientWithLocalCache;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestSessionHiveMetastoreClientListPartitionsTempTable
extends TestListPartitions {
    private HiveConf conf;
    private static final String PART_PRIV = "PARTITION_LEVEL_PRIVILEGE";

    public TestSessionHiveMetastoreClientListPartitionsTempTable(String name, AbstractMetaStoreService metaStore) {
        super(name, metaStore);
        this.ignoreRule = new CustomIgnoreRule();
    }

    @Before
    public void setUp() throws Exception {
        this.initHiveConf();
        SessionState.start((HiveConf)this.conf);
        QueryState queryState = QueryState.getNewQueryState((HiveConf)this.conf, (LineageState)new LineageState());
        queryState.createHMSCache();
        SessionState.get().addQueryState(queryState.getQueryId(), queryState);
        if (this.conf.getBoolVar(HiveConf.ConfVars.MSC_CACHE_ENABLED)) {
            HiveMetaStoreClientWithLocalCache.init((Configuration)this.conf);
        }
        this.setClient(Hive.get((HiveConf)this.conf).getMSC());
        this.getClient().dropDatabase("testpartdb", true, true, true);
        this.getMetaStore().cleanWarehouseDirs();
    }

    private void initHiveConf() throws HiveException {
        this.conf = new HiveConfForTest((Configuration)Hive.get().getConf(), ((Object)((Object)this)).getClass());
        this.conf.setBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH, true);
    }

    protected Table createTestTable(IMetaStoreClient client, String dbName, String tableName, List<String> partCols, boolean setPartitionLevelPrivileges) throws TException {
        TableBuilder builder = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("id", "int")).addCol("name", "string")).setTemporary(true);
        partCols.forEach(col -> builder.addPartCol(col, "string"));
        Table table = builder.build((Configuration)this.conf);
        if (setPartitionLevelPrivileges) {
            table.putToParameters(PART_PRIV, "true");
        }
        client.createTable(table);
        return table;
    }

    protected void addPartition(IMetaStoreClient client, Table table, List<String> values) throws TException {
        PartitionBuilder builder = new PartitionBuilder().inTable(table);
        values.forEach(arg_0 -> ((PartitionBuilder)builder).addValue(arg_0));
        Partition partition = builder.build((Configuration)this.conf);
        if (table.getParameters().containsKey(PART_PRIV) && ((String)table.getParameters().get(PART_PRIV)).equals("true")) {
            PrincipalPrivilegeSet privileges = new PrincipalPrivilegeSet();
            HashMap userPrivileges = new HashMap();
            userPrivileges.put("user0", new ArrayList());
            privileges.setUserPrivileges(userPrivileges);
            HashMap groupPrivileges = new HashMap();
            groupPrivileges.put("group0", new ArrayList());
            privileges.setGroupPrivileges(groupPrivileges);
            partition.setPrivileges(privileges);
        }
        client.add_partition(partition);
    }

    protected void assertAuthInfoReturned(String userName, String group, Partition partition) {
        PrincipalPrivilegeSet privileges = partition.getPrivileges();
        Assert.assertNotNull((Object)privileges);
        TestCase.assertTrue((boolean)privileges.getUserPrivileges().containsKey(userName));
        TestCase.assertTrue((boolean)privileges.getGroupPrivileges().containsKey(group));
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsAllNullTblName() throws Exception {
        super.testListPartitionsAllNullTblName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsAllNullDbName() throws Exception {
        super.testListPartitionsAllNullDbName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionSpecsNullTblName() throws Exception {
        super.testListPartitionSpecsNullTblName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsWithAuthByValuesNullDbName() throws Exception {
        super.testListPartitionsWithAuthByValuesNullDbName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsWithAuthByValuesNullTblName() throws Exception {
        super.testListPartitionsWithAuthByValuesNullTblName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionNamesNullDbName() throws Exception {
        super.testListPartitionNamesNullDbName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionNamesNullTblName() throws Exception {
        super.testListPartitionNamesNullTblName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionNamesByValuesNullDbName() throws Exception {
        super.testListPartitionNamesByValuesNullDbName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionNamesByValuesNullTblName() throws Exception {
        super.testListPartitionNamesByValuesNullTblName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByFilterNullTblName() throws Exception {
        super.testListPartitionsByFilterNullTblName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByFilterNullDbName() throws Exception {
        super.testListPartitionsByFilterNullDbName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionValuesNullDbName() throws Exception {
        super.testListPartitionValuesNullDbName();
    }

    @Test(expected=MetaException.class)
    public void testListPartitionValuesNullTblName() throws Exception {
        super.testListPartitionValuesNullTblName();
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesNoDb() throws Exception {
        super.testListPartitionNamesNoDb();
    }

    @Test
    public void testListPartitionsAllNoTable() throws Exception {
        super.testListPartitionsAllNoTable();
    }

    private void checkPartitionNames(List<String> expected, short numParts, String order, String defaultPartName, ExprNodeGenericFuncDesc expr, Table t) throws Exception {
        PartitionsByExprRequest request = new PartitionsByExprRequest();
        request.setDbName("testpartdb");
        request.setTblName("testparttable");
        byte[] exprs = new byte[]{-1};
        if (expr != null) {
            exprs = SerializationUtilities.serializeObjectWithTypeInformation((Serializable)expr);
        }
        request.setExpr(exprs);
        request.setMaxParts(numParts);
        request.setOrder(order);
        request.setDefaultPartitionName(defaultPartName);
        request.setId(t.getId());
        List partitionNames = this.getClient().listPartitionNames(request);
        Assert.assertArrayEquals((Object[])expected.toArray(), (Object[])partitionNames.toArray());
    }

    @Test
    public void testListPartitionNames() throws Exception {
        Table t = this.createTable4PartColsParts((IMetaStoreClient)this.getClient()).table;
        String defaultPartitionName = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULT_PARTITION_NAME);
        ArrayList testValues = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new String[]{"1999", defaultPartitionName, "02"}), Lists.newArrayList((Object[])new String[]{defaultPartitionName, "02", "10"}), Lists.newArrayList((Object[])new String[]{"2017", "10", defaultPartitionName})});
        for (List vals : testValues) {
            this.addPartition(this.getClient(), t, vals);
        }
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        this.checkPartitionNames(Lists.newArrayList((Object[])new String[]{"yyyy=2017/mm=10/dd=26", "yyyy=2017/mm=10/dd=__HIVE_DEFAULT_PARTITION__", "yyyy=2017/mm=11/dd=27"}), (short)3, null, defaultPartitionName, e.val("2017").strCol("yyyy").pred(">=", 2).build(), t);
        this.checkPartitionNames(Lists.newArrayList((Object[])new String[]{"yyyy=2017/mm=11/dd=27", "yyyy=2017/mm=10/dd=26"}), (short)2, "1,2:-+", defaultPartitionName, e.val("2017").strCol("yyyy").pred(">=", 2).build(), t);
        this.checkPartitionNames(Lists.newArrayList((Object[])new String[]{"yyyy=1999/mm=01/dd=02", "yyyy=1999/mm=__HIVE_DEFAULT_PARTITION__/dd=02", "yyyy=2009/mm=02/dd=10"}), (short)3, null, defaultPartitionName, null, t);
        this.checkPartitionNames(Lists.newArrayList((Object[])new String[]{"yyyy=__HIVE_DEFAULT_PARTITION__/mm=02/dd=10", "yyyy=2017/mm=10/dd=26", "yyyy=2017/mm=10/dd=__HIVE_DEFAULT_PARTITION__"}), (short)3, "0,1:-+", defaultPartitionName, null, t);
        this.checkPartitionNames(Lists.newArrayList((Object[])new String[]{"yyyy=1999/mm=01/dd=02", "yyyy=1999/mm=__HIVE_DEFAULT_PARTITION__/dd=02", "yyyy=2009/mm=02/dd=10"}), (short)3, null, defaultPartitionName, null, t);
    }

    private void checkPartitionNames(int numParts, List<String> partVals) throws Exception {
        GetPartitionNamesPsRequest request = new GetPartitionNamesPsRequest();
        request.setDbName("testpartdb");
        request.setTblName("testparttable");
        request.setPartValues(partVals);
        request.setMaxParts((short)-1);
        List partNames = this.getClient().listPartitionNamesRequest(request).getNames();
        TestCase.assertTrue((partNames.size() == numParts ? 1 : 0) != 0);
    }

    @Test
    public void testListPartitionNamesRequest() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        this.checkPartitionNames(1, Lists.newArrayList((Object[])new String[]{"1999", "01", "02"}));
        this.checkPartitionNames(2, Lists.newArrayList((Object[])new String[]{"2017", "", ""}));
        this.checkPartitionNames(0, Lists.newArrayList((Object[])new String[]{"2008", "02", "10"}));
    }

    @Test
    public void testListPartitionsByExpr() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        this.checkExpr(2, e.strCol("yyyy").val("2017").pred("=", 2).build());
        this.checkExpr(3, e.strCol("mm").val("11").pred(">", 2).build());
        this.checkExpr(4, e.strCol("dd").val("29").pred(">=", 2).build());
        this.checkExpr(2, e.strCol("yyyy").val("2017").pred("!=", 2).build());
        this.checkExpr(1, e.strCol("yyyy").val("2017").pred("=", 2).strCol("mm").val("10").pred(">=", 2).pred("and", 2).build());
        this.checkExpr(3, e.strCol("dd").val("10").pred("<", 2).strCol("yyyy").val("2009").pred("!=", 2).pred("or", 2).build());
        this.checkExpr(0, e.strCol("yyyy").val("2019").pred("=", 2).build());
    }

    @Test(expected=AssertionError.class)
    public void testListPartitionsByExprNullResult() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        this.getClient().listPartitionsByExpr("testpartdb", "testparttable", SerializationUtilities.serializeObjectWithTypeInformation((Serializable)e.strCol("yyyy").val("2017").pred("=", 2).build()), null, (short)-1, null);
    }

    @Test
    public void testListPartitionsByExprDefMaxParts() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        ArrayList result = new ArrayList();
        this.getClient().listPartitionsByExpr("testpartdb", "testparttable", SerializationUtilities.serializeObjectWithTypeInformation((Serializable)e.strCol("yyyy").val("2017").pred(">=", 2).build()), null, (short)3, result);
        Assert.assertEquals((long)3L, (long)result.size());
    }

    @Test
    public void testListPartitionsByExprHighMaxParts() throws Exception {
        this.createTable4PartColsParts(this.getClient());
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        ArrayList result = new ArrayList();
        this.getClient().listPartitionsByExpr("testpartdb", "testparttable", SerializationUtilities.serializeObjectWithTypeInformation((Serializable)e.strCol("yyyy").val("2017").pred(">=", 2).build()), null, (short)100, result);
        Assert.assertEquals((long)4L, (long)result.size());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByExprNoDb() throws Exception {
        this.getClient().dropDatabase("testpartdb");
        this.getClient().listPartitionsByExpr("testpartdb", "testparttable", new byte[]{102, 111, 111}, null, (short)-1, new ArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByExprNoTbl() throws Exception {
        this.getClient().listPartitionsByExpr("testpartdb", "testparttable", new byte[]{102, 111, 111}, null, (short)-1, new ArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByExprEmptyDbName() throws Exception {
        this.getClient().listPartitionsByExpr("", "testparttable", new byte[]{102, 111, 111}, null, (short)-1, new ArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsByExprEmptyTblName() throws Exception {
        this.createTable3PartCols1Part(this.getClient());
        this.getClient().listPartitionsByExpr("testpartdb", "", new byte[]{102, 111, 111}, null, (short)-1, new ArrayList());
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByExprNullDbName() throws Exception {
        this.getClient().listPartitionsByExpr(null, "testparttable", new byte[]{102, 111, 111}, null, (short)-1, new ArrayList());
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsByExprNullTblName() throws Exception {
        this.getClient().listPartitionsByExpr("testpartdb", null, new byte[]{102, 111, 111}, null, (short)-1, new ArrayList());
    }

    private void checkExpr(int numParts, ExprNodeGenericFuncDesc expr) throws Exception {
        ArrayList parts = new ArrayList();
        this.getClient().listPartitionsByExpr("testpartdb", "testparttable", SerializationUtilities.serializeObjectWithTypeInformation((Serializable)expr), null, (short)-1, parts);
        Assert.assertEquals((String)("Partition check failed: " + expr.getExprString()), (long)numParts, (long)parts.size());
    }

    @Test
    public void testListPartitionsSpecByExpr() throws Exception {
        Table t = this.createTable4PartColsParts((IMetaStoreClient)this.getClient()).table;
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        this.checkExprPartitionSpec(2, e.strCol("yyyy").val("2017").pred("=", 2).build(), t);
        this.checkExprPartitionSpec(3, e.strCol("mm").val("11").pred(">", 2).build(), t);
        this.checkExprPartitionSpec(4, e.strCol("dd").val("29").pred(">=", 2).build(), t);
        this.checkExprPartitionSpec(2, e.strCol("yyyy").val("2017").pred("!=", 2).build(), t);
        this.checkExprPartitionSpec(1, e.strCol("yyyy").val("2017").pred("=", 2).strCol("mm").val("10").pred(">=", 2).pred("and", 2).build(), t);
        this.checkExprPartitionSpec(3, e.strCol("dd").val("10").pred("<", 2).strCol("yyyy").val("2009").pred("!=", 2).pred("or", 2).build(), t);
        this.checkExprPartitionSpec(0, e.strCol("yyyy").val("2019").pred("=", 2).build(), t);
    }

    @Test(expected=AssertionError.class)
    public void testListPartitionsSpecByExprNullResult() throws Exception {
        Table t = this.createTable4PartColsParts((IMetaStoreClient)this.getClient()).table;
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        PartitionsByExprRequest req = new PartitionsByExprRequest("testpartdb", "testparttable", ByteBuffer.wrap(SerializationUtilities.serializeObjectWithTypeInformation((Serializable)e.strCol("yyyy").val("2017").pred("=", 2).build())));
        req.setMaxParts((short)-1);
        req.setId(t.getId());
        this.getClient().listPartitionsSpecByExpr(req, null);
    }

    @Test
    public void testListPartitionsSpecByExprDefMaxParts() throws Exception {
        Table t = this.createTable4PartColsParts((IMetaStoreClient)this.getClient()).table;
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        ArrayList result = new ArrayList();
        PartitionsByExprRequest req = new PartitionsByExprRequest("testpartdb", "testparttable", ByteBuffer.wrap(SerializationUtilities.serializeObjectWithTypeInformation((Serializable)e.strCol("yyyy").val("2017").pred(">=", 2).build())));
        req.setMaxParts((short)3);
        req.setId(t.getId());
        this.getClient().listPartitionsSpecByExpr(req, result);
        Assert.assertEquals((long)3L, (long)((PartitionSpec)result.iterator().next()).getSharedSDPartitionSpec().getPartitionsSize());
    }

    @Test
    public void testListPartitionsSpecByExprHighMaxParts() throws Exception {
        Table t = this.createTable4PartColsParts((IMetaStoreClient)this.getClient()).table;
        TestMetastoreExpr.ExprBuilder e = new TestMetastoreExpr.ExprBuilder("testparttable");
        ArrayList result = new ArrayList();
        PartitionsByExprRequest req = new PartitionsByExprRequest("testpartdb", "testparttable", ByteBuffer.wrap(SerializationUtilities.serializeObjectWithTypeInformation((Serializable)e.strCol("yyyy").val("2017").pred(">=", 2).build())));
        req.setMaxParts((short)100);
        req.setId(t.getId());
        this.getClient().listPartitionsSpecByExpr(req, result);
        Assert.assertEquals((long)4L, (long)((PartitionSpec)result.iterator().next()).getSharedSDPartitionSpec().getPartitionsSize());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsSpecByExprNoDb() throws Exception {
        this.getClient().dropDatabase("testpartdb");
        PartitionsByExprRequest req = new PartitionsByExprRequest("testpartdb", "testparttable", ByteBuffer.wrap(new byte[]{102, 111, 111}));
        req.setMaxParts((short)-1);
        this.getClient().listPartitionsSpecByExpr(req, null);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsSpecByExprNoTbl() throws Exception {
        PartitionsByExprRequest req = new PartitionsByExprRequest("testpartdb", "testparttable", ByteBuffer.wrap(new byte[]{102, 111, 111}));
        req.setMaxParts((short)-1);
        this.getClient().listPartitionsSpecByExpr(req, new ArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsSpecByExprEmptyDbName() throws Exception {
        PartitionsByExprRequest req = new PartitionsByExprRequest("", "testparttable", ByteBuffer.wrap(new byte[]{102, 111, 111}));
        req.setMaxParts((short)-1);
        this.getClient().listPartitionsSpecByExpr(req, new ArrayList());
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionsSpecByExprEmptyTblName() throws Exception {
        Table t = this.createTable3PartCols1Part(this.getClient());
        PartitionsByExprRequest req = new PartitionsByExprRequest("testpartdb", "", ByteBuffer.wrap(new byte[]{102, 111, 111}));
        req.setMaxParts((short)-1);
        req.setId(t.getId());
        this.getClient().listPartitionsSpecByExpr(req, new ArrayList());
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsSpecByExprNullDbName() throws Exception {
        PartitionsByExprRequest req = new PartitionsByExprRequest(null, "testparttable", ByteBuffer.wrap(new byte[]{102, 111, 111}));
        req.setMaxParts((short)-1);
        this.getClient().listPartitionsSpecByExpr(req, null);
    }

    @Test(expected=MetaException.class)
    public void testListPartitionsSpecByExprNullTblName() throws Exception {
        PartitionsByExprRequest req = new PartitionsByExprRequest("testpartdb", null, ByteBuffer.wrap(new byte[]{102, 111, 111}));
        req.setMaxParts((short)-1);
        this.getClient().listPartitionsSpecByExpr(req, null);
    }

    private void checkExprPartitionSpec(int numParts, ExprNodeGenericFuncDesc expr, Table t) throws Exception {
        ArrayList parts = new ArrayList();
        this.getClient().listPartitionsByExpr("testpartdb", "testparttable", SerializationUtilities.serializeObjectWithTypeInformation((Serializable)expr), null, (short)-1, parts);
        Assert.assertEquals((String)("Partition check failed: " + expr.getExprString()), (long)numParts, (long)parts.size());
        PartitionsByExprRequest req = new PartitionsByExprRequest("testpartdb", "testparttable", ByteBuffer.wrap(SerializationUtilities.serializeObjectWithTypeInformation((Serializable)expr)));
        req.setMaxParts((short)-1);
        req.setId(t.getId());
        ArrayList partSpec = new ArrayList();
        this.getClient().listPartitionsSpecByExpr(req, partSpec);
        int partSpecSize = 0;
        if (!partSpec.isEmpty()) {
            partSpecSize = ((PartitionSpec)partSpec.iterator().next()).getSharedSDPartitionSpec().getPartitionsSize();
        }
        Assert.assertEquals((String)("Partition Spec check failed: " + expr.getExprString()), (long)numParts, (long)partSpecSize);
    }

    @Test(expected=NoSuchObjectException.class)
    public void testListPartitionNamesNoTable() throws Exception {
        super.testListPartitionNamesNoTable();
    }
}

