/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.TestExchangePartitions;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestSessionHiveMetastoreClientExchangePartitionsTempTable
extends TestExchangePartitions {
    private HiveConf conf;
    private Warehouse wh;

    public TestSessionHiveMetastoreClientExchangePartitionsTempTable(String name, AbstractMetaStoreService metaStore) {
        super(name, metaStore);
    }

    @Before
    public void setUp() throws Exception {
        this.initHiveConf();
        this.wh = new Warehouse((Configuration)this.conf);
        SessionState.start((HiveConf)this.conf);
        this.setClient(Hive.get((HiveConf)this.conf).getMSC());
        this.getClient().dropDatabase("test_partition_db", true, true, true);
        this.getMetaStore().cleanWarehouseDirs();
        this.createTestTables();
    }

    private void initHiveConf() throws Exception {
        this.conf = new HiveConfForTest((Configuration)Hive.get().getConf(), ((Object)((Object)this)).getClass());
        this.conf.setBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH, true);
    }

    protected Table createTable(String dbName, String tableName, List<FieldSchema> partCols, List<FieldSchema> cols, String location) throws Exception {
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).setCols(cols)).setPartCols(partCols).setLocation(location)).setTemporary(true).create(this.getClient(), this.getMetaStore().getConf());
        return this.getClient().getTable(dbName, tableName);
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsNonExistingPartLocation() throws Exception {
        Map partitionSpecs = TestSessionHiveMetastoreClientExchangePartitionsTempTable.getPartitionSpec((Partition)this.getPartitions()[1]);
        this.getMetaStore().cleanWarehouseDirs();
        this.cleanTempTableDir(this.getSourceTable());
        this.cleanTempTableDir(this.getDestTable());
        this.getClient().exchange_partitions(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
    }

    @Test
    public void testExchangePartitionsCustomTableAndPartLocation() throws Exception {
        Table source = this.createTable("test_partition_db", "test_source_table_cust_loc", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), this.getMetaStore().getWarehouseRoot() + "/sourceTable");
        Table dest = this.createTable("test_partition_db", "test_dest_table_cust_loc", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), this.getMetaStore().getWarehouseRoot() + "/destTable");
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "may", "11"}), source.getSd().getLocation() + "/2019m11"), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "july", "23"}), source.getSd().getLocation() + "/2019j23")};
        Map partitionSpecs = TestSessionHiveMetastoreClientExchangePartitionsTempTable.getPartitionSpec((Partition)parts[1]);
        this.getClient().exchange_partitions(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0]}));
        List destTablePartitions = this.getClient().listPartitions(dest.getDbName(), dest.getTableName(), (short)-1);
        Assert.assertEquals((long)1L, (long)destTablePartitions.size());
        this.checkExchangedPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[1]}));
    }

    @Test
    public void testExchangePartitionsCustomPartLocation() throws Exception {
        Table source = this.createTable("test_partition_db", "test_source_table", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), null);
        Table dest = this.createTable("test_partition_db", "test_dest_table", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), null);
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "march", "15"}), source.getSd().getLocation() + "/2019m15"), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "march", "22"}), source.getSd().getLocation() + "/2019m22")};
        Map partitionSpecs = TestSessionHiveMetastoreClientExchangePartitionsTempTable.getPartitionSpec((Partition)parts[1]);
        this.getClient().exchange_partitions(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0]}));
        List destTablePartitions = this.getClient().listPartitions(dest.getDbName(), dest.getTableName(), (short)-1);
        Assert.assertEquals((long)1L, (long)destTablePartitions.size());
        this.checkExchangedPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[1]}));
    }

    @Test
    public void testExchangePartitionsOnlyMonthSetInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("year", "");
        partitionSpecs.put("month", "march");
        partitionSpecs.put("day", "");
        this.getClient().exchange_partitions(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
        this.checkRemainingPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[2], this.getPartitions()[3], this.getPartitions()[4]}));
        List exchangedPartitions = this.getClient().listPartitions(this.getDestTable().getDbName(), this.getDestTable().getTableName(), (short)-1);
        Assert.assertEquals((long)2L, (long)exchangedPartitions.size());
        this.checkExchangedPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[0], this.getPartitions()[1]}));
    }

    @Test
    public void testExchangePartitionsYearAndDaySetInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("year", "2017");
        partitionSpecs.put("month", "");
        partitionSpecs.put("day", "22");
        this.getClient().exchange_partitions(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
        this.checkRemainingPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[0], this.getPartitions()[2], this.getPartitions()[3], this.getPartitions()[4]}));
        List exchangedPartitions = this.getClient().listPartitions(this.getDestTable().getDbName(), this.getDestTable().getTableName(), (short)-1);
        Assert.assertEquals((long)1L, (long)exchangedPartitions.size());
        this.checkExchangedPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[1]}));
    }

    @Test
    public void testExchangePartition() throws Exception {
        Map partitionSpecs = TestSessionHiveMetastoreClientExchangePartitionsTempTable.getPartitionSpec((Partition)this.getPartitions()[1]);
        Partition exchangedPartition = this.getClient().exchange_partition(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
        Assert.assertNotNull((Object)exchangedPartition);
        this.checkExchangedPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[1]}));
        this.checkRemainingPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[0], this.getPartitions()[2], this.getPartitions()[3], this.getPartitions()[4]}));
    }

    @Test
    public void testExchangePartitionYearSet() throws Exception {
        Map partitionSpecs = TestSessionHiveMetastoreClientExchangePartitionsTempTable.getPartitionSpec((List)Lists.newArrayList((Object[])new String[]{"2017", "", ""}));
        Partition exchangedPartition = this.getClient().exchange_partition(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
        Assert.assertNotNull((Object)exchangedPartition);
        this.checkExchangedPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[0], this.getPartitions()[1], this.getPartitions()[2], this.getPartitions()[3]}));
        this.checkRemainingPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[4]}));
    }

    @Test
    public void testExchangePartitionCustomTableAndPartLocation() throws Exception {
        Table source = this.createTable("test_partition_db", "test_source_table_cust_loc", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), this.getMetaStore().getWarehouseRoot() + "/sourceTable");
        Table dest = this.createTable("test_partition_db", "test_dest_table_cust_loc", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), this.getMetaStore().getWarehouseRoot() + "/destTable");
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "may", "11"}), source.getSd().getLocation() + "/2019m11"), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "july", "23"}), source.getSd().getLocation() + "/2019j23")};
        Map partitionSpecs = TestSessionHiveMetastoreClientExchangePartitionsTempTable.getPartitionSpec((Partition)parts[1]);
        this.getClient().exchange_partition(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0]}));
        List destTablePartitions = this.getClient().listPartitions(dest.getDbName(), dest.getTableName(), (short)-1);
        Assert.assertEquals((long)1L, (long)destTablePartitions.size());
        this.checkExchangedPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[1]}));
    }

    @Test
    public void testExchangePartitionCustomPartLocation() throws Exception {
        Table source = this.createTable("test_partition_db", "test_source_table", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), null);
        Table dest = this.createTable("test_partition_db", "test_dest_table", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), null);
        Partition[] parts = new Partition[]{this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "march", "15"}), source.getSd().getLocation() + "/2019m15"), this.createPartition(source, Lists.newArrayList((Object[])new String[]{"2019", "march", "22"}), source.getSd().getLocation() + "/2019m22")};
        Map partitionSpecs = TestSessionHiveMetastoreClientExchangePartitionsTempTable.getPartitionSpec((Partition)parts[1]);
        this.getClient().exchange_partition(partitionSpecs, source.getDbName(), source.getTableName(), dest.getDbName(), dest.getTableName());
        this.checkRemainingPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[0]}));
        List destTablePartitions = this.getClient().listPartitions(dest.getDbName(), dest.getTableName(), (short)-1);
        Assert.assertEquals((long)1L, (long)destTablePartitions.size());
        this.checkExchangedPartitions(source, dest, Lists.newArrayList((Object[])new Partition[]{parts[1]}));
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionNonExistingPartLocation() throws Exception {
        Map partitionSpecs = TestSessionHiveMetastoreClientExchangePartitionsTempTable.getPartitionSpec((Partition)this.getPartitions()[1]);
        this.cleanTempTableDir(this.getSourceTable());
        this.cleanTempTableDir(this.getDestTable());
        this.getClient().exchange_partition(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
    }

    @Test
    public void testExchangePartitionOnlyMonthSetInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("year", "");
        partitionSpecs.put("month", "march");
        partitionSpecs.put("day", "");
        this.getClient().exchange_partitions(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
        this.checkRemainingPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[2], this.getPartitions()[3], this.getPartitions()[4]}));
        List exchangedPartitions = this.getClient().listPartitions(this.getDestTable().getDbName(), this.getDestTable().getTableName(), (short)-1);
        Assert.assertEquals((long)2L, (long)exchangedPartitions.size());
        this.checkExchangedPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[0], this.getPartitions()[1]}));
    }

    @Test
    public void testExchangePartitionYearAndDaySetInPartSpec() throws Exception {
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("year", "2017");
        partitionSpecs.put("month", "");
        partitionSpecs.put("day", "22");
        this.getClient().exchange_partition(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
        this.checkRemainingPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[0], this.getPartitions()[2], this.getPartitions()[3], this.getPartitions()[4]}));
        List exchangedPartitions = this.getClient().listPartitions(this.getDestTable().getDbName(), this.getDestTable().getTableName(), (short)-1);
        Assert.assertEquals((long)1L, (long)exchangedPartitions.size());
        this.checkExchangedPartitions(this.getSourceTable(), this.getDestTable(), Lists.newArrayList((Object[])new Partition[]{this.getPartitions()[1]}));
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionBetweenTempAndNonTemp() throws Exception {
        Table nonTempTable = this.createNonTempTable("test_partition_db", "nonTempTable", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), null);
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("year", "2017");
        partitionSpecs.put("month", "march");
        partitionSpecs.put("day", "22");
        this.getClient().exchange_partition(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), nonTempTable.getDbName(), nonTempTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionBetweenNonTempAndTemp() throws Exception {
        Table nonTempTable = this.createNonTempTable("test_partition_db", "nonTempTable", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), null);
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("year", "2017");
        partitionSpecs.put("month", "march");
        partitionSpecs.put("day", "22");
        this.getClient().exchange_partition(partitionSpecs, nonTempTable.getDbName(), nonTempTable.getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsBetweenTempAndNonTemp() throws Exception {
        Table nonTempTable = this.createNonTempTable("test_partition_db", "nonTempTable", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), null);
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("year", "2017");
        partitionSpecs.put("month", "");
        partitionSpecs.put("day", "23");
        this.getClient().exchange_partitions(partitionSpecs, this.getSourceTable().getDbName(), this.getSourceTable().getTableName(), nonTempTable.getDbName(), nonTempTable.getTableName());
    }

    @Test(expected=MetaException.class)
    public void testExchangePartitionsBetweenNonTempAndTemp() throws Exception {
        Table nonTempTable = this.createNonTempTable("test_partition_db", "nonTempTable", TestSessionHiveMetastoreClientExchangePartitionsTempTable.getYearMonthAndDayPartCols(), null);
        HashMap<String, String> partitionSpecs = new HashMap<String, String>();
        partitionSpecs.put("year", "2017");
        partitionSpecs.put("month", "");
        partitionSpecs.put("day", "23");
        this.getClient().exchange_partitions(partitionSpecs, nonTempTable.getDbName(), nonTempTable.getTableName(), this.getDestTable().getDbName(), this.getDestTable().getTableName());
    }

    private Table createNonTempTable(String dbName, String tableName, List<FieldSchema> partCols, String location) throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("test_id", "int", "test col id"));
        cols.add(new FieldSchema("test_value", "string", "test col value"));
        ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).setCols(cols)).setPartCols(partCols).setLocation(location)).setTemporary(false).create(this.getClient(), this.getMetaStore().getConf());
        return this.getClient().getTable(dbName, tableName);
    }

    private void cleanTempTableDir(Table table) throws MetaException {
        this.wh.deleteDir(new Path(table.getSd().getLocation()), true, false, false);
    }
}

