/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.annotation.MetastoreCheckinTest;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.client.CustomIgnoreRule;
import org.apache.hadoop.hive.metastore.client.TestAddPartitions;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={MetastoreCheckinTest.class})
public class TestSessionHiveMetastoreClientAddPartitionsTempTable
extends TestAddPartitions {
    private HiveConf conf;

    public TestSessionHiveMetastoreClientAddPartitionsTempTable(String name, AbstractMetaStoreService metaStore) {
        super(name, metaStore);
        this.ignoreRule = new CustomIgnoreRule();
    }

    @Before
    public void setUp() throws Exception {
        this.initHiveConf();
        SessionState.start((HiveConf)this.conf);
        this.setClient(Hive.get((HiveConf)this.conf).getMSC());
        this.getClient().dropDatabase("test_partition_db", true, true, true);
        this.getMetaStore().cleanWarehouseDirs();
        new DatabaseBuilder().setName("test_partition_db").create(this.getClient(), (Configuration)this.conf);
    }

    private void initHiveConf() throws HiveException {
        this.conf = new HiveConfForTest((Configuration)Hive.get().getConf(), ((Object)((Object)this)).getClass());
        this.conf.setBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH, true);
    }

    protected org.apache.hadoop.hive.metastore.api.Table createTable(String dbName, String tableName, List<FieldSchema> partCols, String location) throws Exception {
        ((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName(dbName).setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", "string", "test col value")).addTableParam("partTestTableParamKey", "partTestTableParamValue").setPartCols(partCols).addStorageDescriptorParam("partTestSDParamKey", "partTestSDParamValue")).setSerdeName(tableName)).setStoredAsSubDirectories(false)).addSerdeParam("partTestSerdeParamKey", "partTestSerdeParamValue")).setLocation(location)).setTemporary(true).create(this.getClient(), (Configuration)this.conf);
        return this.getClient().getTable(dbName, tableName);
    }

    protected void createExternalTable(String tableName, String location) throws Exception {
        ((TableBuilder)((TableBuilder)((TableBuilder)new TableBuilder().setDbName("test_partition_db").setTableName(tableName).addCol("test_id", "int", "test col id")).addCol("test_value", "string", "test col value")).addPartCol("year", "string").addTableParam("EXTERNAL", "TRUE").setLocation(location)).setTemporary(true).create(this.getClient(), (Configuration)this.conf);
    }

    protected void verifyPartition(org.apache.hadoop.hive.metastore.api.Table table, String name, List<String> values, int index) throws Exception {
        Partition part = this.getClient().getPartition(table.getDbName(), table.getTableName(), name);
        Assert.assertNotNull((String)"The partition should not be null.", (Object)part);
        Assert.assertEquals((String)"The table name in the partition is not correct.", (Object)table.getTableName(), (Object)part.getTableName());
        List partValues = part.getValues();
        Assert.assertEquals((long)values.size(), (long)partValues.size());
        Assert.assertTrue((String)"The partition has wrong values.", (boolean)partValues.containsAll(values));
        Assert.assertEquals((String)"The DB name in the partition is not correct.", (Object)table.getDbName(), (Object)part.getDbName());
        Assert.assertEquals((String)"The last access time is not correct.", (long)123456L, (long)part.getLastAccessTime());
        Assert.assertEquals((String)"The partition's parameter map should contain the partparamkey - partparamvalue pair.", (Object)("partparamvalue" + index), part.getParameters().get("partparamkey" + index));
        StorageDescriptor sd = part.getSd();
        Assert.assertNotNull((String)"The partition's storage descriptor must not be null.", (Object)sd);
        Assert.assertEquals((String)"The input format is not correct.", (Object)("TestInputFormat" + index), (Object)sd.getInputFormat());
        Assert.assertEquals((String)"The output format is not correct.", (Object)("TestOutputFormat" + index), (Object)sd.getOutputFormat());
        Assert.assertEquals((String)"The serdeInfo name is not correct.", (Object)("partserde" + index), (Object)sd.getSerdeInfo().getName());
        Assert.assertEquals((String)"The parameter map of the partition's storage descriptor should contain the partsdkey - partsdvalue pair.", (Object)("partsdvalue" + index), sd.getParameters().get("partsdkey" + index));
        Assert.assertEquals((String)"The parameter's location is not correct.", (Object)(this.getMetaStore().getWarehouseRoot() + "/test_partition_table/" + name), (Object)sd.getLocation());
        Assert.assertTrue((String)"The parameter's location should exist on the file system.", (boolean)this.getMetaStore().isPathExists(new Path(sd.getLocation())));
        Assert.assertFalse((String)"The partition should not inherit the table parameters.", (boolean)part.getParameters().keySet().contains(table.getParameters().keySet()));
    }

    protected void verifyPartitionAttributesDefaultValues(Partition partition, String tableLocation) {
        Assert.assertNotEquals((String)"The partition's last access time should be set.", (long)0L, (long)partition.getLastAccessTime());
        Assert.assertNotEquals((String)"The partition's create time should be set.", (long)0L, (long)partition.getCreateTime());
        StorageDescriptor sd = partition.getSd();
        Assert.assertNotNull((String)"The storage descriptor of the partition must not be null.", (Object)sd);
        Assert.assertEquals((String)"The partition location is not correct.", (Object)(tableLocation + "/year=2017"), (Object)sd.getLocation());
        Assert.assertEquals((String)"The input format doesn't have the default value.", (Object)"org.apache.hadoop.hive.ql.io.HiveInputFormat", (Object)sd.getInputFormat());
        Assert.assertEquals((String)"The output format doesn't have the default value.", (Object)"org.apache.hadoop.hive.ql.io.HiveOutputFormat", (Object)sd.getOutputFormat());
        Assert.assertFalse((String)"The compressed attribute doesn't have the default value.", (boolean)sd.isCompressed());
        Assert.assertFalse((String)"The storedAsSubDirectories attribute doesn't have the default value.", (boolean)sd.isStoredAsSubDirectories());
        Assert.assertEquals((String)"The numBuckets attribute doesn't have the default value.", (long)0L, (long)sd.getNumBuckets());
        Assert.assertTrue((String)"The default value of the attribute 'bucketCols' should be an empty list.", (boolean)sd.getBucketCols().isEmpty());
        Assert.assertTrue((String)"The default value of the attribute 'sortCols' should be an empty list.", (boolean)sd.getSortCols().isEmpty());
        Assert.assertTrue((String)"Per default the storage descriptor parameters should be empty.", (boolean)sd.getParameters().isEmpty());
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        Assert.assertNotNull((String)"The serdeInfo attribute should not be null.", (Object)serdeInfo);
        Assert.assertNull((String)"The default value of the serde's name attribute should be null.", (Object)serdeInfo.getName());
        Assert.assertEquals((String)"The serde's 'serializationLib' attribute doesn't have the default value.", (Object)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", (Object)serdeInfo.getSerializationLib());
        Assert.assertTrue((String)"Per default the serde info parameters should be empty.", (boolean)serdeInfo.getParameters().isEmpty());
        SkewedInfo skewedInfo = sd.getSkewedInfo();
        Assert.assertTrue((String)"Per default the skewedInfo column names list should be empty.", (boolean)skewedInfo.getSkewedColNames().isEmpty());
        Assert.assertTrue((String)"Per default the skewedInfo column value list should be empty.", (boolean)skewedInfo.getSkewedColValues().isEmpty());
        Assert.assertTrue((String)"Per default the skewedInfo column value location map should be empty.", (boolean)skewedInfo.getSkewedColValueLocationMaps().isEmpty());
    }

    @Test
    public void testAddPartitionNullLocationInTableToo() throws Exception {
        this.createTable("test_partition_db", "test_partition_table", null);
        Partition partition = this.buildPartition("test_partition_db", "test_partition_table", "2017", null);
        this.getClient().add_partition(partition);
        Partition part = this.getClient().getPartition("test_partition_db", "test_partition_table", "year=2017");
        Assert.assertTrue((boolean)this.getMetaStore().isPathExists(new Path(part.getSd().getLocation())));
        Assert.assertEquals((Object)(((Table)((Map)SessionState.get().getTempTables().get("test_partition_db")).get("test_partition_table")).getSd().getLocation() + "/year=2017"), (Object)part.getSd().getLocation());
    }

    @Test
    public void testAddPartitionForExternalTableNullLocation() throws Exception {
        String tableName = "part_add_ext_table";
        this.createExternalTable(tableName, null);
        Partition partition = this.buildPartition("test_partition_db", tableName, "2017", null);
        this.getClient().add_partition(partition);
        Partition resultPart = this.getClient().getPartition("test_partition_db", tableName, (List)Lists.newArrayList((Object[])new String[]{"2017"}));
        Assert.assertNotNull((Object)resultPart);
        Assert.assertNotNull((Object)resultPart.getSd());
        Assert.assertEquals((Object)(((Table)((Map)SessionState.get().getTempTables().get("test_partition_db")).get(tableName)).getSd().getLocation() + "/year=2017"), (Object)resultPart.getSd().getLocation());
    }

    @Test
    public void testAddPartitionsNullLocationInTableToo() throws Exception {
        this.createTable("test_partition_db", "test_partition_table", null);
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        Partition partition = this.buildPartition("test_partition_db", "test_partition_table", "2017", null);
        partitions.add(partition);
        this.getClient().add_partitions(partitions);
        Partition part = this.getClient().getPartition("test_partition_db", "test_partition_table", "year=2017");
        Assert.assertEquals((Object)(((Table)((Map)SessionState.get().getTempTables().get("test_partition_db")).get("test_partition_table")).getSd().getLocation() + "/year=2017"), (Object)part.getSd().getLocation());
        Assert.assertTrue((boolean)this.getMetaStore().isPathExists(new Path(part.getSd().getLocation())));
    }

    @Test
    public void testAddPartitionsForExternalTableNullLocation() throws Exception {
        String tableName = "part_add_ext_table";
        this.createExternalTable(tableName, null);
        Partition partition1 = this.buildPartition("test_partition_db", tableName, "2017", null);
        Partition partition2 = this.buildPartition("test_partition_db", tableName, "2018", null);
        ArrayList partitions = Lists.newArrayList((Object[])new Partition[]{partition1, partition2});
        this.getClient().add_partitions((List)partitions);
        List resultParts = this.getClient().getPartitionsByNames("test_partition_db", tableName, (List)Lists.newArrayList((Object[])new String[]{"year=2017", "year=2018"}));
        Assert.assertNotNull((Object)resultParts);
        Assert.assertEquals((long)2L, (long)resultParts.size());
        String defaultTableLocation = ((Table)((Map)SessionState.get().getTempTables().get("test_partition_db")).get(tableName)).getSd().getLocation();
        String defaultPartLocation1 = defaultTableLocation + "/year=2017";
        String defaultPartLocation2 = defaultTableLocation + "/year=2018";
        if (((String)((Partition)resultParts.get(0)).getValues().get(0)).equals("2017")) {
            Assert.assertEquals((Object)defaultPartLocation1, (Object)((Partition)resultParts.get(0)).getSd().getLocation());
            Assert.assertEquals((Object)defaultPartLocation2, (Object)((Partition)resultParts.get(1)).getSd().getLocation());
        } else {
            Assert.assertEquals((Object)defaultPartLocation2, (Object)((Partition)resultParts.get(0)).getSd().getLocation());
            Assert.assertEquals((Object)defaultPartLocation1, (Object)((Partition)resultParts.get(1)).getSd().getLocation());
        }
    }
}

