/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelDigest;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.MaterializedViewsCache;
import org.apache.hadoop.hive.ql.metadata.RewriteAlgorithm;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.IncrementalRebuildMode;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class TestMaterializedViewsCache {
    private MaterializedViewsCache materializedViewsCache;
    private Table defaultMV1;
    private HiveRelOptMaterialization defaultMaterialization1;
    private Table defaultMV1Same;
    private HiveRelOptMaterialization defaultMaterialization1Same;
    private Table defaultMVUpCase;
    private HiveRelOptMaterialization defaultMaterializationUpCase;
    private Table db1MV1;
    private HiveRelOptMaterialization db1Materialization1;

    TestMaterializedViewsCache() {
    }

    @BeforeEach
    void setUp() throws ParseException {
        this.defaultMV1 = this.getTable("default", "mat1", "select col0 from t1 where col0 = 'foo'");
        this.defaultMaterialization1 = TestMaterializedViewsCache.createMaterialization(this.defaultMV1);
        this.defaultMV1Same = this.getTable("default", "mat_same", "select col0 from t1 where col0 = 'foo'");
        this.defaultMaterialization1Same = TestMaterializedViewsCache.createMaterialization(this.defaultMV1Same);
        this.defaultMVUpCase = this.getTable("default", "mat2", "select col0 from t1 where col0 = 'FOO'");
        this.defaultMaterializationUpCase = TestMaterializedViewsCache.createMaterialization(this.defaultMVUpCase);
        this.db1MV1 = this.getTable("db1", "mat1", "select col0 from t1 where col0 = 'foo'");
        this.db1Materialization1 = TestMaterializedViewsCache.createMaterialization(this.db1MV1);
        this.materializedViewsCache = new MaterializedViewsCache();
    }

    @Test
    void testEmptyCache() {
        MaterializedViewsCache emptyCache = new MaterializedViewsCache();
        ASTNode any = (ASTNode)ParseDriver.adaptor.create(24, "any");
        MatcherAssert.assertThat((Object)emptyCache.get(any).isEmpty(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)emptyCache.isEmpty(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)emptyCache.values().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    void testGetByTableNameFromEmptyCache() {
        MaterializedViewsCache emptyCache = new MaterializedViewsCache();
        MatcherAssert.assertThat((Object)emptyCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    void testQueryDoesNotMatchAnyMVDefinition() {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        ASTNode notFound = (ASTNode)ParseDriver.adaptor.create(24, "notFound");
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(notFound).isEmpty(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    void testAdd() {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((HiveRelOptMaterialization)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).get(0)), (Matcher)Is.is((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((HiveRelOptMaterialization)this.materializedViewsCache.values().get(0)), (Matcher)Is.is((Object)this.defaultMaterialization1));
    }

    @Test
    void testAddSameMVTwice() {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((HiveRelOptMaterialization)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).get(0)), (Matcher)Is.is((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)((HiveRelOptMaterialization)this.materializedViewsCache.values().get(0)), (Matcher)Is.is((Object)this.defaultMaterialization1));
    }

    private Table getTable(String db, String tableName, String definition) {
        Table table = new Table(new org.apache.hadoop.hive.metastore.api.Table());
        table.setDbName(db);
        table.setTableName(tableName);
        table.setViewExpandedText(definition);
        return table;
    }

    private static HiveRelOptMaterialization createMaterialization(Table table) throws ParseException {
        return new HiveRelOptMaterialization((RelNode)new DummyRel(table), (RelNode)new DummyRel(table), null, Arrays.asList(table.getDbName(), table.getTableName()), (Set)RewriteAlgorithm.ALL, IncrementalRebuildMode.AVAILABLE, ParseUtils.parse((String)table.getViewExpandedText(), null));
    }

    @Test
    void testAddMVsWithSameDefinition() {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        this.materializedViewsCache.putIfAbsent(this.defaultMV1Same, this.defaultMaterialization1Same);
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1Same.getDbName(), this.defaultMV1Same.getTableName()), (Matcher)Is.is((Object)this.defaultMaterialization1Same));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()), (Matcher)CoreMatchers.hasItem((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()), (Matcher)CoreMatchers.hasItem((Object)this.defaultMaterialization1Same));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().size(), (Matcher)Is.is((Object)2));
    }

    @Test
    void testAddMVsWithSameDefinitionButDifferentDatabase() {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        this.materializedViewsCache.putIfAbsent(this.db1MV1, this.db1Materialization1);
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.db1MV1.getDbName(), this.db1MV1.getTableName()), (Matcher)Is.is((Object)this.db1Materialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()), (Matcher)CoreMatchers.hasItem((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()), (Matcher)CoreMatchers.hasItem((Object)this.db1Materialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().size(), (Matcher)Is.is((Object)2));
    }

    @Test
    void testLookupByTextIsCaseSensitive() {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        this.materializedViewsCache.putIfAbsent(this.defaultMVUpCase, this.defaultMaterializationUpCase);
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()), (Matcher)CoreMatchers.hasItem((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().size(), (Matcher)Is.is((Object)2));
    }

    @Test
    void testRefreshWhenMVWasNotCached() {
        this.materializedViewsCache.refresh(this.defaultMV1, this.defaultMV1, this.defaultMaterialization1);
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()), (Matcher)CoreMatchers.hasItem((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values(), (Matcher)CoreMatchers.hasItem((Object)this.defaultMaterialization1));
    }

    @Test
    void testRefreshWhenMVIsCachedButWasUpdated() throws ParseException {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        HiveRelOptMaterialization newMaterialization = TestMaterializedViewsCache.createMaterialization(this.defaultMV1);
        this.materializedViewsCache.refresh(this.defaultMV1, this.defaultMV1, newMaterialization);
        MatcherAssert.assertThat((Object)newMaterialization, (Matcher)Is.is((Matcher)CoreMatchers.not((Object)this.defaultMaterialization1)));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Object)newMaterialization));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()), (Matcher)CoreMatchers.hasItem((Object)newMaterialization));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values(), (Matcher)CoreMatchers.hasItem((Object)newMaterialization));
    }

    @Test
    void testRefreshWhenMVRefersToANewMaterialization() {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        this.materializedViewsCache.refresh(this.defaultMV1Same, this.defaultMV1, this.defaultMaterialization1);
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()), (Matcher)CoreMatchers.hasItem((Object)this.defaultMaterialization1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values(), (Matcher)CoreMatchers.hasItem((Object)this.defaultMaterialization1));
    }

    @Test
    void testRemoveByTable() {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        this.materializedViewsCache.remove(this.defaultMV1);
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).isEmpty(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.isEmpty(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    void testRemoveByTableName() {
        this.materializedViewsCache.putIfAbsent(this.defaultMV1, this.defaultMaterialization1);
        this.materializedViewsCache.remove(this.defaultMV1.getDbName(), this.defaultMV1.getTableName());
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMV1.getDbName(), this.defaultMV1.getTableName()), (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.get(this.defaultMaterialization1.getAst()).isEmpty(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.isEmpty(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)this.materializedViewsCache.values().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Disabled(value="Testing parallelism only")
    @Test
    void testParallelism() throws ParseException {
        HiveRelOptMaterialization materialization;
        Object table;
        int i;
        int ITERATIONS = 1000000;
        ArrayList<Pair> testData = new ArrayList<Pair>();
        for (i = 0; i < 10; ++i) {
            table = new Table(new org.apache.hadoop.hive.metastore.api.Table());
            table.setDbName("default");
            table.setTableName("mat" + i);
            table.setViewExpandedText("select col0 from t" + i);
            materialization = TestMaterializedViewsCache.createMaterialization((Table)table);
            testData.add(new Pair(table, (Object)materialization));
        }
        for (i = 0; i < 10; ++i) {
            table = new Table(new org.apache.hadoop.hive.metastore.api.Table());
            table.setDbName("db1");
            table.setTableName("mat" + i);
            table.setViewExpandedText("select col0 from t" + i);
            materialization = TestMaterializedViewsCache.createMaterialization((Table)table);
            testData.add(new Pair(table, (Object)materialization));
        }
        ArrayList<Callable<Void>> callableList = new ArrayList<Callable<Void>>();
        callableList.add(() -> {
            for (Pair entry : testData) {
                this.materializedViewsCache.refresh((Table)entry.left, (Table)entry.left, (HiveRelOptMaterialization)entry.right);
            }
            return null;
        });
        callableList.add(() -> {
            for (int j = 0; j < ITERATIONS; ++j) {
                for (Pair entry : testData) {
                    this.materializedViewsCache.remove((Table)entry.left);
                    this.materializedViewsCache.putIfAbsent((Table)entry.left, (HiveRelOptMaterialization)entry.right);
                }
            }
            return null;
        });
        for (Pair entry : testData) {
            callableList.add(() -> {
                for (int j = 0; j < ITERATIONS; ++j) {
                    this.materializedViewsCache.get(((HiveRelOptMaterialization)entry.right).getAst());
                }
                return null;
            });
        }
        callableList.add(() -> {
            for (int j = 0; j < ITERATIONS; ++j) {
                List list = this.materializedViewsCache.values();
            }
            return null;
        });
        ExecutorService executor = Executors.newFixedThreadPool(12);
        try {
            executor.invokeAll(callableList);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static class DummyRel
    implements RelNode {
        private final RelOptHiveTable dummyTable;

        public DummyRel(Table table) {
            this.dummyTable = new RelOptHiveTable(null, null, Collections.singletonList(table.getDbName() + "." + table.getTableName()), null, table, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null, null, null, null);
        }

        public RelOptTable getTable() {
            return this.dummyTable;
        }

        public Convention getConvention() {
            return null;
        }

        public String getCorrelVariable() {
            return null;
        }

        public RelNode getInput(int i) {
            return null;
        }

        public int getId() {
            return 0;
        }

        public String getDigest() {
            return null;
        }

        public RelDigest getRelDigest() {
            return null;
        }

        public RelTraitSet getTraitSet() {
            return null;
        }

        public RelDataType getRowType() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public RelDataType getExpectedInputRowType(int i) {
            return null;
        }

        public List<RelNode> getInputs() {
            return null;
        }

        public RelOptCluster getCluster() {
            return null;
        }

        public double estimateRowCount(RelMetadataQuery relMetadataQuery) {
            return 0.0;
        }

        public Set<CorrelationId> getVariablesSet() {
            return null;
        }

        public void collectVariablesUsed(Set<CorrelationId> set) {
        }

        public void collectVariablesSet(Set<CorrelationId> set) {
        }

        public void childrenAccept(RelVisitor relVisitor) {
        }

        public RelOptCost computeSelfCost(RelOptPlanner relOptPlanner, RelMetadataQuery relMetadataQuery) {
            return null;
        }

        public <M extends Metadata> M metadata(Class<M> aClass, RelMetadataQuery relMetadataQuery) {
            return null;
        }

        public void explain(RelWriter relWriter) {
        }

        public RelNode onRegister(RelOptPlanner relOptPlanner) {
            return null;
        }

        public void recomputeDigest() {
        }

        public boolean deepEquals(Object obj) {
            return false;
        }

        public int deepHashCode() {
            return 0;
        }

        public void replaceInput(int i, RelNode relNode) {
        }

        public String getRelTypeName() {
            return null;
        }

        public boolean isValid(Litmus litmus, RelNode.Context context) {
            return false;
        }

        public RelNode copy(RelTraitSet relTraitSet, List<RelNode> list) {
            return null;
        }

        public void register(RelOptPlanner relOptPlanner) {
        }

        public RelNode accept(RelShuttle relShuttle) {
            return null;
        }

        public RelNode accept(RexShuttle rexShuttle) {
            return null;
        }
    }
}

