/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.File;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.ql.TxnCommandsBaseForTests;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.junit.Assert;
import org.junit.Test;

public class TestMSCKRepairOnAcid
extends TxnCommandsBaseForTests {
    private static final String TEST_DATA_DIR = new File(System.getProperty("java.io.tmpdir") + File.separator + TestMSCKRepairOnAcid.class.getCanonicalName() + "-" + System.currentTimeMillis()).getPath().replaceAll("\\\\", "/");
    private final String acidTblPartMsck = "acidtblpartmsck";

    @Override
    protected String getTestDataDir() {
        return TEST_DATA_DIR;
    }

    @Test
    public void testAddPartitionDeltas() throws Exception {
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,2,'p1'),(2,3,'p1'),(3,4,'p1')");
        List<String> r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " where p='p1' order by a, b");
        int[][] expected = new int[][]{{1, 1}, {1, 2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("create table acidtblpartmsck (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p1"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileStatus[] fileStatuses = fs.listStatus(new Path(this.getWarehouseDir(), "acidtblpartmsck/p=p1"));
        Assert.assertEquals((long)2L, (long)fileStatuses.length);
        this.runStatementOnDriver("msck repair table acidtblpartmsck");
        r = this.runStatementOnDriver("select a, b from acidtblpartmsck where p='p1' order by a, b");
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
    }

    @Test
    public void testAddMultiPartitionDeltas() throws Exception {
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(4,4,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,2,'p2'),(2,3,'p2'),(3,4,'p2')");
        List<String> r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b");
        int[][] expected = new int[][]{{1, 1}, {1, 2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}, {4, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("create table acidtblpartmsck (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p1"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p2"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        this.runStatementOnDriver("msck repair table acidtblpartmsck");
        r = this.runStatementOnDriver("select a, b from acidtblpartmsck order by a, b");
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
    }

    @Test
    public void testAddPartitionHighWriteIdException() throws Exception {
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,2,'p2'),(2,3,'p2'),(3,4,'p2')");
        List<String> r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b");
        int[][] expected = new int[][]{{1, 1}, {1, 2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("create table acidtblpartmsck (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into acidtblpartmsck partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p2"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (boolean)false, (Configuration)this.hiveConf);
        FileStatus[] fileStatuses = fs.listStatus(new Path(this.getWarehouseDir(), "acidtblpartmsck"));
        Assert.assertEquals((long)2L, (long)fileStatuses.length);
        CommandProcessorException e = this.runStatementOnDriverNegative("msck repair table acidtblpartmsck");
        Assert.assertEquals((long)-1L, (long)e.getErrorCode());
        String expectedMessage = "The highest writeId [2] in the table 'acidtblpartmsck' is greater than the maximum writeId allocated in the metastore [1]";
        Assert.assertTrue((boolean)(e.getCause() instanceof MetaException));
        Assert.assertEquals((Object)expectedMessage, (Object)e.getCause().getMessage());
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
    }

    @Test
    public void testAddPartitionLowerWriteId() throws Exception {
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,2,'p2'),(2,3,'p2'),(3,4,'p2')");
        List<String> r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b");
        int[][] expected = new int[][]{{1, 1}, {1, 2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("create table acidtblpartmsck (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        this.runStatementOnDriver("insert into acidtblpartmsck partition(p) values(1,2,'p2'),(2,3,'p2'),(3,4,'p2')");
        this.runStatementOnDriver("insert into acidtblpartmsck partition(p) values(4,5,'p2')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p1"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (boolean)false, (Configuration)this.hiveConf);
        FileStatus[] fileStatuses = fs.listStatus(new Path(this.getWarehouseDir(), "acidtblpartmsck"));
        Assert.assertEquals((long)2L, (long)fileStatuses.length);
        this.runStatementOnDriver("msck repair table acidtblpartmsck");
        r = this.runStatementOnDriver("select a, b from acidtblpartmsck order by a, b");
        int[][] expected2 = new int[][]{{1, 1}, {1, 2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}, {4, 5}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected2), r);
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
    }

    @Test
    public void testAddPartitionMinorCompacted() throws Exception {
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(4,4,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,2,'p2'),(2,3,'p2'),(3,4,'p2')");
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition (p='p1') compact 'minor'");
        TestMSCKRepairOnAcid.runWorker(this.hiveConf);
        List<String> r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b");
        int[][] expected = new int[][]{{1, 1}, {1, 2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}, {4, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("create table acidtblpartmsck (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p1"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p2"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileStatus[] fileStatuses = fs.listStatus(new Path(this.getWarehouseDir(), "acidtblpartmsck/p=p1"));
        Assert.assertEquals((long)3L, (long)fileStatuses.length);
        this.runStatementOnDriver("msck repair table acidtblpartmsck");
        r = this.runStatementOnDriver("select a, b from acidtblpartmsck order by a, b");
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
    }

    @Test
    public void testAddPartitionMajorCompacted() throws Exception {
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(4,4,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,2,'p2'),(2,3,'p2'),(3,4,'p2')");
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition (p='p1') compact 'major'");
        TestMSCKRepairOnAcid.runWorker(this.hiveConf);
        List<String> r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b");
        int[][] expected = new int[][]{{1, 1}, {1, 2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}, {4, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("create table acidtblpartmsck (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p1"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p2"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileStatus[] fileStatuses = fs.listStatus(new Path(this.getWarehouseDir(), "acidtblpartmsck/p=p1"));
        Assert.assertEquals((long)3L, (long)fileStatuses.length);
        this.runStatementOnDriver("msck repair table acidtblpartmsck");
        r = this.runStatementOnDriver("select a, b from acidtblpartmsck order by a, b");
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
    }

    @Test
    public void testBackUpAndRestorePartition() throws Exception {
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(4,4,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,2,'p2'),(2,3,'p2'),(3,4,'p2')");
        List<String> r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b");
        int[][] expected = new int[][]{{1, 1}, {1, 2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}, {4, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        fs.mkdirs(new Path(this.getWarehouseDir(), "mybackup"));
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p1"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "mybackup"), (boolean)true, (Configuration)this.hiveConf);
        this.runStatementOnDriver("msck repair table " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " SYNC PARTITIONS");
        r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b");
        int[][] expected2 = new int[][]{{1, 2}, {2, 3}, {3, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected2), r);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/mybackup/p=p1"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase()), (boolean)true, (Configuration)this.hiveConf);
        this.runStatementOnDriver("msck repair table " + TxnCommandsBaseForTests.Table.ACIDTBLPART);
        r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b");
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
    }

    @Test
    public void testAddPartitionHighVisibilityId() throws Exception {
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(4,4,'p1')");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition(p) values(1,2,'p2'),(2,3,'p2'),(3,4,'p2')");
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " partition (p='p1') compact 'minor'");
        TestMSCKRepairOnAcid.runWorker(this.hiveConf);
        TestMSCKRepairOnAcid.runCleaner(this.hiveConf);
        List<String> r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBLPART + " order by a, b");
        int[][] expected = new int[][]{{1, 1}, {1, 2}, {2, 2}, {2, 3}, {3, 3}, {3, 4}, {4, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("create table acidtblpartmsck (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p1"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/" + TxnCommandsBaseForTests.Table.ACIDTBLPART.toString().toLowerCase() + "/p=p2"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileStatus[] fileStatuses = fs.listStatus(new Path(this.getWarehouseDir(), "acidtblpartmsck/p=p1"));
        Assert.assertEquals((long)1L, (long)fileStatuses.length);
        Path deltaDir = fileStatuses[0].getPath();
        AcidUtils.ParsedDeltaLight parsedDelta = AcidUtils.ParsedDeltaLight.parse((Path)deltaDir);
        long oldTxnId = parsedDelta.getVisibilityTxnId();
        String newDeltaDir = AcidUtils.addVisibilitySuffix((String)deltaDir.toString().substring(0, deltaDir.toString().length() - 9), (long)(oldTxnId + 100L));
        fs.rename(deltaDir, new Path(newDeltaDir));
        this.runStatementOnDriver("msck repair table acidtblpartmsck");
        Long nextTxnId = (Long)this.txnHandler.openTxns(new OpenTxnRequest(1, "localhost", "me")).getTxn_ids().get(0);
        Assert.assertTrue((String)"TxnId should be incremented", (nextTxnId > oldTxnId + 100L ? 1 : 0) != 0);
        this.txnHandler.abortTxn(new AbortTxnRequest(nextTxnId.longValue()));
        Thread.sleep(1000L);
        r = this.runStatementOnDriver("select a, b from acidtblpartmsck order by a, b");
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
    }

    @Test
    public void testAddPartitionMMInsertOverwrite() throws Exception {
        String mmTable = "mmtblpartmsck";
        String sourceTable = "nonacidpartmsck";
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("drop table if exists mmtblpartmsck");
        this.runStatementOnDriver("drop table if exists nonacidpartmsck");
        this.runStatementOnDriver("create table mmtblpartmsck(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
        this.runStatementOnDriver("create table nonacidpartmsck(a int, b int) partitioned by (p string) stored as orc TBLPROPERTIES ('transactional'='false')");
        this.runStatementOnDriver("insert into mmtblpartmsck partition(p) values(1,1,'p1'),(2,2,'p1'),(3,3,'p1')");
        this.runStatementOnDriver("insert into mmtblpartmsck partition(p) values(4,4,'p1')");
        this.runStatementOnDriver("insert into mmtblpartmsck partition(p) values(1,2,'p2'),(2,3,'p2'),(3,4,'p2')");
        this.runStatementOnDriver("insert into nonacidpartmsck partition(p) values(10,10,'p1'),(20,20,'p1'),(30,30,'p1')");
        this.runStatementOnDriver("insert into nonacidpartmsck partition(p) values(40,40,'p1')");
        this.runStatementOnDriver("insert overwrite table mmtblpartmsck PARTITION(p='p1')  select a,b from nonacidpartmsck where nonacidpartmsck.p='p1'");
        List<String> r = this.runStatementOnDriver("select a, b from mmtblpartmsck order by a, b");
        int[][] expected = new int[][]{{1, 2}, {2, 3}, {3, 4}, {10, 10}, {20, 20}, {30, 30}, {40, 40}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("create table acidtblpartmsck (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true', 'transactional_properties'='insert_only')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/mmtblpartmsck/p=p1"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileUtil.copy((FileSystem)fs, (Path)new Path(this.getWarehouseDir() + "/mmtblpartmsck/p=p2"), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), "acidtblpartmsck"), (boolean)false, (Configuration)this.hiveConf);
        FileStatus[] fileStatuses = fs.listStatus(new Path(this.getWarehouseDir(), "acidtblpartmsck/p=p1"));
        Assert.assertEquals((long)3L, (long)fileStatuses.length);
        this.runStatementOnDriver("msck repair table acidtblpartmsck");
        r = this.runStatementOnDriver("select a, b from acidtblpartmsck order by a, b");
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("drop table if exists mmtblpartmsck");
        this.runStatementOnDriver("drop table if exists nonacidpartmsck");
    }

    @Test
    public void testNonPartitionedTable() throws Exception {
        String acidTblMsck = "acidtblmsck";
        this.runStatementOnDriver("drop table if exists " + acidTblMsck);
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(1,1),(2,2),(3,3)");
        this.runStatementOnDriver("insert into " + TxnCommandsBaseForTests.Table.ACIDTBL + " values(4,4)");
        this.runStatementOnDriver("alter table " + TxnCommandsBaseForTests.Table.ACIDTBL + " compact 'minor'");
        TestMSCKRepairOnAcid.runWorker(this.hiveConf);
        List<String> r = this.runStatementOnDriver("select a, b from " + TxnCommandsBaseForTests.Table.ACIDTBL + " order by a, b");
        int[][] expected = new int[][]{{1, 1}, {2, 2}, {3, 3}, {4, 4}};
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("create table " + acidTblMsck + " (a int, b int) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        for (FileStatus status : fs.listStatus(new Path(this.getWarehouseDir(), TxnCommandsBaseForTests.Table.ACIDTBL.toString().toLowerCase()))) {
            FileUtil.copy((FileSystem)fs, (Path)status.getPath(), (FileSystem)fs, (Path)new Path(this.getWarehouseDir(), acidTblMsck), (boolean)false, (Configuration)this.hiveConf);
        }
        FileStatus[] fileStatuses = fs.listStatus(new Path(this.getWarehouseDir(), acidTblMsck));
        Assert.assertEquals((long)3L, (long)fileStatuses.length);
        this.runStatementOnDriver("msck repair table " + acidTblMsck);
        r = this.runStatementOnDriver("select a, b from " + acidTblMsck + " order by a, b");
        Assert.assertEquals(TestMSCKRepairOnAcid.stringifyValues(expected), r);
        this.runStatementOnDriver("drop table if exists " + acidTblMsck);
    }

    @Test
    public void testInvalidPartitionNameErrorMessage() throws Exception {
        this.runStatementOnDriver("drop table if exists acidtblpartmsck");
        this.runStatementOnDriver("create table acidtblpartmsck (a int, b int) partitioned by (p string) clustered by (a) into 2 buckets stored as orc TBLPROPERTIES ('transactional'='true')");
        FileSystem fs = FileSystem.get((Configuration)this.hiveConf);
        fs.mkdirs(new Path(this.getWarehouseDir(), "acidtblpartmsck/part"));
        try {
            this.runStatementOnDriver("msck repair table acidtblpartmsck");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"Error message did not match", (Object)true, (Object)e.getMessage().contains("Invalid partition name"));
        }
    }
}

