/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.TestHive;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestHiveRemote
extends TestHive {
    @BeforeClass
    public static void setUp() throws Exception {
        hiveConf = new HiveConf(TestHiveRemote.class);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE, "mr");
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        hiveConf.setBoolVar(HiveConf.ConfVars.FIRE_EVENTS_FOR_DML, true);
        MetastoreConf.setVar((Configuration)hiveConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_LISTENERS, (String)TestHive.DummyFireInsertListener.class.getName());
        MetaStoreTestUtils.startMetaStoreWithRetry((Configuration)hiveConf);
    }

    @Before
    public void before() throws Exception {
        SessionState.start((HiveConf)hiveConf);
        try {
            hm = Hive.get((HiveConf)hiveConf);
        }
        catch (Exception e) {
            System.err.println(StringUtils.stringifyException((Throwable)e));
            System.err.println("Unable to initialize Hive Metastore using configuration: \n " + hiveConf);
            throw e;
        }
    }

    @After
    public void after() throws IOException {
        SessionState.get().close();
        hm.close(false);
    }

    @Override
    public void testDropTableTrash() {
    }
}

