/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.TestHiveMetaStoreClient;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.thrift.TException;
import org.junit.Before;
import org.junit.Test;

public class TestHiveMetaStoreClientApiArgumentsChecker {
    private Hive hive;
    private IMetaStoreClient msc;
    private FileSystem fs;
    static final String DB_NAME = "db";
    static final String TABLE_NAME = "table";
    private IMetaStoreClient client;
    private Table t;
    protected static final String USER_NAME = "user0";

    @Before
    public void setUp() throws Exception {
        this.client = new TestHiveMetaStoreClient((Configuration)new HiveConf(Hive.class));
        this.hive = Hive.get((IMetaStoreClient)this.client);
        HiveConfForTest conf = new HiveConfForTest((Configuration)this.hive.getConf(), this.getClass());
        conf.set(MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT.getVarname(), "15");
        conf.set(MetastoreConf.ConfVars.MSCK_PATH_VALIDATION.getVarname(), "throw");
        this.msc = new HiveMetaStoreClient((Configuration)conf);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        conf.set("hive.txn.valid.txns", "1:");
        conf.set("hive.txn.valid.writeids", "table:1:");
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.TestTxnManager");
        conf.setIntVar(HiveConf.ConfVars.METASTORE_BATCH_RETRIEVE_MAX, 2);
        SessionState.start((HiveConf)conf);
        SessionState.get().initTxnMgr((HiveConf)conf);
        Context ctx = new Context((Configuration)conf);
        SessionState.get().getTxnMgr().openTxn(ctx, USER_NAME);
        this.t = new Table();
        org.apache.hadoop.hive.metastore.api.Table tTable = new org.apache.hadoop.hive.metastore.api.Table();
        tTable.setId(Long.MAX_VALUE);
        this.t.setTTable(tTable);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("transactional", "true");
        tTable.setParameters(parameters);
        tTable.setTableType(TableType.MANAGED_TABLE.toString());
        this.t.setTableName(TABLE_NAME);
        this.t.setDbName(DB_NAME);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema());
        this.t.setPartCols(partCols);
    }

    @Test
    public void testGetPartition() throws HiveException {
        this.hive.getPartition(this.t, DB_NAME, TABLE_NAME, null);
    }

    @Test
    public void testGetPartitions() throws HiveException {
        this.hive.getPartitions(this.t);
    }

    @Test
    public void testGetPartitionNames() throws HiveException {
        this.hive.getPartitionNames(DB_NAME, TABLE_NAME, null, (short)-1);
    }

    @Test
    public void testGetPartitionNames2() throws HiveException {
        this.hive.getPartitionNames(this.t, null, null, (short)-1);
    }

    @Test
    public void testGetPartitionsByNames1() throws HiveException {
        GetPartitionsByNamesRequest req = new GetPartitionsByNamesRequest();
        req.setDb_name(DB_NAME);
        req.setTbl_name(TABLE_NAME);
        this.hive.getPartitionsByNames(req, this.t);
    }

    @Test
    public void testGetPartitionsByNames2() throws HiveException {
        this.hive.getPartitionsByNames(DB_NAME, TABLE_NAME, null, this.t);
    }

    @Test
    public void testGetPartitionsByNames3() throws HiveException {
        this.hive.getPartitionsByNames(this.t, new ArrayList(), true);
    }

    @Test
    public void testGetPartitionsByNamesWithSingleBatch() throws HiveException {
        this.hive.getPartitionsByNames(this.t, Arrays.asList("Greece", "Italy"), true);
    }

    @Test
    public void testGetPartitionsByNamesWithMultipleEqualSizeBatches() throws HiveException {
        List<String> names = Arrays.asList("Greece", "Italy", "France", "Spain");
        this.hive.getPartitionsByNames(this.t, names, true);
    }

    @Test
    public void testGetPartitionsByNamesWithMultipleUnequalSizeBatches() throws HiveException {
        List<String> names = Arrays.asList("Greece", "Italy", "France", "Spain", "Hungary");
        this.hive.getPartitionsByNames(this.t, names, true);
    }

    @Test
    public void testGetPartitionsByExpr() throws HiveException, TException {
        ArrayList partitions = new ArrayList();
        ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "rid", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"f");
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List)children);
        this.hive.getPartitionsByExpr(this.t, (ExprNodeDesc)node, this.hive.getConf(), partitions);
    }
}

