/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.CheckResult;
import org.apache.hadoop.hive.metastore.HiveMetaStoreChecker;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetastoreException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHiveMetaStoreChecker {
    private Hive hive;
    private IMetaStoreClient msc;
    private FileSystem fs;
    private HiveMetaStoreChecker checker = null;
    private final String catName = "hive";
    private final String dbName = "testhivemetastorechecker_db";
    private final String tableName = "testhivemetastorechecker_table";
    private final String partDateName = "partdate";
    private final String partCityName = "partcity";
    private List<FieldSchema> partCols;
    private List<Map<String, String>> parts;

    @Before
    public void setUp() throws Exception {
        this.hive = Hive.get();
        HiveConfForTest conf = new HiveConfForTest((Configuration)this.hive.getConf(), this.getClass());
        conf.set(MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT.getVarname(), "15");
        conf.set(MetastoreConf.ConfVars.MSCK_PATH_VALIDATION.getVarname(), "throw");
        this.msc = new HiveMetaStoreClient((Configuration)conf);
        this.checker = new HiveMetaStoreChecker(this.msc, (Configuration)conf);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        SessionState ss = SessionState.start((HiveConf)conf);
        ss.initTxnMgr((HiveConf)conf);
        this.partCols = new ArrayList<FieldSchema>();
        this.partCols.add(new FieldSchema("partdate", "string", ""));
        this.partCols.add(new FieldSchema("partcity", "string", ""));
        this.parts = new ArrayList<Map<String, String>>();
        HashMap<String, String> part1 = new HashMap<String, String>();
        part1.put("partdate", "2008-01-01");
        part1.put("partcity", "london");
        this.parts.add(part1);
        HashMap<String, String> part2 = new HashMap<String, String>();
        part2.put("partdate", "2008-01-02");
        part2.put("partcity", "stockholm");
        this.parts.add(part2);
        this.dropDbTable();
    }

    private void dropDbTable() {
        try {
            this.msc.dropTable("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
            this.msc.dropDatabase("hive", "testhivemetastorechecker_db", true, true, true);
        }
        catch (TException tException) {
            // empty catch block
        }
    }

    @After
    public void tearDown() throws Exception {
        this.dropDbTable();
        Hive.closeCurrent();
    }

    @Test
    public void testTableCheck() throws HiveException, IOException, TException, MetastoreException, MetaException {
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", null, null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals((long)1L, (long)result.getTablesNotInMs().size());
        Assert.assertEquals((Object)"testhivemetastorechecker_table", result.getTablesNotInMs().iterator().next());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        Database db = new Database();
        db.setCatalogName("hive");
        db.setName("testhivemetastorechecker_db");
        this.msc.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        this.hive.createTable(table);
        Assert.assertTrue((boolean)table.getTTable().isSetId());
        table.getTTable().unsetId();
        result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", null, null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.fs = table.getPath().getFileSystem((Configuration)this.hive.getConf());
        this.fs.delete(table.getPath(), true);
        result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals((long)1L, (long)result.getTablesNotOnFs().size());
        Assert.assertEquals((Object)"testhivemetastorechecker_table", result.getTablesNotOnFs().iterator().next());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.fs.mkdirs(table.getPath());
        Path fakeTable = table.getPath().getParent().suffix("/faketable");
        this.fs.mkdirs(fakeTable);
        this.fs.deleteOnExit(fakeTable);
        result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", null, null, null);
        Assert.assertEquals((long)1L, (long)result.getTablesNotInMs().size());
        Assert.assertEquals((Object)fakeTable.getName(), Lists.newArrayList((Iterable)result.getTablesNotInMs()).get(0));
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setProperty("EXTERNAL", "TRUE");
        this.hive.createTable(table);
        result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", null, null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
    }

    @Test
    public void testAdditionalPartitionDirs() throws HiveException, AlreadyExistsException, IOException, MetastoreException {
        Table table = this.createTestTable(false);
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        this.addFolderToPath(this.fs, table.getDataLocation().toString(), "partdate=2017-01-01/partcity=paloalto/fakePartCol=fakepartValue");
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)1L, (long)result.getPartitionsNotInMs().size());
    }

    @Test(expected=MetastoreException.class)
    public void testInvalidPartitionKeyName() throws HiveException, AlreadyExistsException, IOException, MetastoreException {
        Table table = this.createTestTable(false);
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        this.addFolderToPath(this.fs, table.getDataLocation().toString(), "fakedate=2009-01-01/fakecity=sanjose");
        this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
    }

    @Test
    public void testSkipInvalidPartitionKeyName() throws HiveException, AlreadyExistsException, IOException, MetastoreException {
        this.hive.getConf().set(MetastoreConf.ConfVars.MSCK_PATH_VALIDATION.getVarname(), "skip");
        this.checker = new HiveMetaStoreChecker(this.msc, (Configuration)this.hive.getConf());
        Table table = this.createTestTable(false);
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        this.addFolderToPath(this.fs, table.getDataLocation().toString(), "fakedate=2009-01-01/fakecity=sanjose");
        this.createPartitionsDirectoriesOnFS(table, 2);
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)2L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testAddPartitionNormalDeltas() throws Exception {
        Table table = this.createTestTable(true);
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        Path newPart = this.addFolderToPath(this.fs, table.getDataLocation().toString(), "partdate=2017-01-01/partcity=paloalto");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000001_0000001_0000");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000010_0000010_0000");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000101_0000101_0000");
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)1L, (long)result.getPartitionsNotInMs().size());
        Assert.assertEquals((long)101L, (long)((CheckResult.PartitionResult)result.getPartitionsNotInMs().iterator().next()).getMaxWriteId());
        Assert.assertEquals((long)0L, (long)((CheckResult.PartitionResult)result.getPartitionsNotInMs().iterator().next()).getMaxTxnId());
    }

    @Test
    public void testAddPartitionCompactedDeltas() throws Exception {
        Table table = this.createTestTable(true);
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        Path newPart = this.addFolderToPath(this.fs, table.getDataLocation().toString(), "partdate=2017-01-01/partcity=paloalto");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000001_0000001_0000");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000010_0000015_v0000067");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000101_0000120_v0000087");
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)1L, (long)result.getPartitionsNotInMs().size());
        Assert.assertEquals((long)120L, (long)((CheckResult.PartitionResult)result.getPartitionsNotInMs().iterator().next()).getMaxWriteId());
        Assert.assertEquals((long)87L, (long)((CheckResult.PartitionResult)result.getPartitionsNotInMs().iterator().next()).getMaxTxnId());
    }

    @Test
    public void testAddPartitionCompactedBase() throws Exception {
        Table table = this.createTestTable(true);
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        Path newPart = this.addFolderToPath(this.fs, table.getDataLocation().toString(), "partdate=2017-01-01/partcity=paloalto");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000001_0000001_0000");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000002_0000002_0000");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000003_0000003_0000");
        this.addFolderToPath(this.fs, newPart.toString(), "base_0000003_v0000200");
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)1L, (long)result.getPartitionsNotInMs().size());
        Assert.assertEquals((long)3L, (long)((CheckResult.PartitionResult)result.getPartitionsNotInMs().iterator().next()).getMaxWriteId());
        Assert.assertEquals((long)200L, (long)((CheckResult.PartitionResult)result.getPartitionsNotInMs().iterator().next()).getMaxTxnId());
    }

    @Test
    public void testAddPartitionMMBase() throws Exception {
        Table table = this.createTestTable(true);
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        Path newPart = this.addFolderToPath(this.fs, table.getDataLocation().toString(), "partdate=2017-01-01/partcity=paloalto");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000001_0000001_0000");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000002_0000002_0000");
        this.addFolderToPath(this.fs, newPart.toString(), "delta_0000003_0000003_0000");
        this.addFolderToPath(this.fs, newPart.toString(), "base_0000004");
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)1L, (long)result.getPartitionsNotInMs().size());
        Assert.assertEquals((long)4L, (long)((CheckResult.PartitionResult)result.getPartitionsNotInMs().iterator().next()).getMaxWriteId());
        Assert.assertEquals((long)0L, (long)((CheckResult.PartitionResult)result.getPartitionsNotInMs().iterator().next()).getMaxTxnId());
    }

    @Test
    public void testNoNPartitionedTable() throws Exception {
        Table table = this.createNonPartitionedTable();
        this.fs = table.getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        Path tablePath = table.getDataLocation();
        this.addFolderToPath(this.fs, tablePath.toString(), "delta_0000001_0000001_0000");
        this.addFolderToPath(this.fs, tablePath.toString(), "delta_0000002_0000002_0000");
        this.addFolderToPath(this.fs, tablePath.toString(), "delta_0000003_0000003_0000");
        this.addFolderToPath(this.fs, tablePath.toString(), "base_0000003_v0000200");
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        Assert.assertEquals((long)3L, (long)result.getMaxWriteId());
        Assert.assertEquals((long)200L, (long)result.getMaxTxnId());
    }

    @Test
    public void testPartitionsCheck() throws HiveException, IOException, TException, MetastoreException {
        Table table = this.createTestTable(false);
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        Partition partToRemove = (Partition)partitions.get(0);
        Path partToRemovePath = partToRemove.getDataLocation().getParent();
        this.fs = partToRemovePath.getFileSystem((Configuration)this.hive.getConf());
        this.fs.delete(partToRemovePath, true);
        result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals((long)1L, (long)result.getPartitionsNotOnFs().size());
        Assert.assertEquals((Object)partToRemove.getName(), (Object)((CheckResult.PartitionResult)result.getPartitionsNotOnFs().iterator().next()).getPartitionName());
        Assert.assertEquals((Object)partToRemove.getTable().getTableName(), (Object)((CheckResult.PartitionResult)result.getPartitionsNotOnFs().iterator().next()).getTableName());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
        this.hive.createTable(table);
        result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", null, null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        System.err.println("Test completed - partition check");
    }

    @Test
    public void testDataDeletion() throws HiveException, IOException, TException {
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        table.setPartCols(this.partCols);
        this.hive.createTable(table);
        table = this.hive.getTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        Path fakeTable = table.getPath().getParent().suffix("/faketable");
        this.fs = fakeTable.getFileSystem((Configuration)this.hive.getConf());
        this.fs.mkdirs(fakeTable);
        this.fs.deleteOnExit(fakeTable);
        Path fakePart = new Path(table.getDataLocation().toString(), "fakepartition=fakevalue");
        this.fs.mkdirs(fakePart);
        this.fs.deleteOnExit(fakePart);
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
        Assert.assertFalse((boolean)this.fs.exists(fakePart));
        this.hive.dropDatabase("testhivemetastorechecker_db");
        Assert.assertFalse((boolean)this.fs.exists(fakeTable));
    }

    @Test
    public void testPartitionsNotInMs() throws Exception {
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)10L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testSingleThreadedCheckMetastore() throws Exception {
        this.hive.getConf().set(MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT.getVarname(), "0");
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)10L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testSingleThreadedDeeplyNestedTables() throws Exception {
        this.hive.getConf().set(MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT.getVarname(), "0");
        int poolSize = 2;
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", poolSize + 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)10L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testDeeplyNestedPartitionedTables() throws Exception {
        this.hive.getConf().set(MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT.getVarname(), "2");
        int poolSize = 2;
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", poolSize + 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)10L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testErrorForMissingPartitionColumn() throws Exception {
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        StringBuilder sb = new StringBuilder(testTable.getDataLocation().toString());
        sb.append("/");
        sb.append("dummyPart=error");
        this.createDirectory(sb.toString());
        Exception exception = null;
        try {
            this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertTrue((String)"Expected MetastoreException", (boolean)(exception instanceof MetastoreException));
        this.createFile(sb.toString(), "dummyFile");
        exception = null;
        try {
            this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertTrue((String)"Expected MetastoreException", (boolean)(exception instanceof MetastoreException));
    }

    @Test(expected=MetastoreException.class)
    public void testInvalidOrderForPartitionKeysOnFS() throws Exception {
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createInvalidPartitionDirsOnFS(testTable, 10);
        this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
    }

    @Test
    public void testSkipInvalidOrderForPartitionKeysOnFS() throws Exception {
        this.hive.getConf().set(MetastoreConf.ConfVars.MSCK_PATH_VALIDATION.getVarname(), "skip");
        this.checker = new HiveMetaStoreChecker(this.msc, (Configuration)this.hive.getConf());
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createInvalidPartitionDirsOnFS(testTable, 2);
        this.createPartitionsDirectoriesOnFS(testTable, 2);
        CheckResult result = this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)2L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testErrorForMissingPartitionsSingleThreaded() throws Exception {
        this.hive.getConf().set(MetastoreConf.ConfVars.FS_HANDLER_THREADS_COUNT.getVarname(), "0");
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        StringBuilder sb = new StringBuilder(testTable.getDataLocation().toString());
        sb.append("/");
        sb.append("dummyPart=error");
        this.createDirectory(sb.toString());
        Exception exception = null;
        try {
            this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertTrue((String)"Expected MetastoreException", (boolean)(exception instanceof MetastoreException));
        this.createFile(sb.toString(), "dummyFile");
        exception = null;
        try {
            this.checker.checkMetastore("hive", "testhivemetastorechecker_db", "testhivemetastorechecker_table", null, null);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertTrue((String)"Expected MetastoreException", (boolean)(exception instanceof MetastoreException));
    }

    private Table createPartitionedTestTable(String dbName, String tableName, int numOfPartKeys, int valuesPerPartition) throws Exception {
        Database db = new Database();
        db.setName(dbName);
        this.hive.createDatabase(db, true);
        Table table = new Table(dbName, tableName);
        table.setDbName(dbName);
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        ArrayList<FieldSchema> partKeys = new ArrayList<FieldSchema>();
        for (int i = 1; i <= numOfPartKeys; ++i) {
            String partName = "part" + i;
            partKeys.add(new FieldSchema(partName, "string", ""));
        }
        table.setPartCols(partKeys);
        this.hive.createTable(table, true);
        table = this.hive.getTable(dbName, tableName);
        if (valuesPerPartition == 0) {
            return table;
        }
        ArrayList partitionSpecs = new ArrayList();
        for (int partKeyIndex = 0; partKeyIndex < numOfPartKeys; ++partKeyIndex) {
            String string = ((FieldSchema)partKeys.get(partKeyIndex)).getName();
            HashMap<String, String> partMap = new HashMap<String, String>();
            for (int val = 1; val <= valuesPerPartition; ++val) {
                partMap.put(string, String.valueOf(val));
            }
            partitionSpecs.add(partMap);
        }
        for (Map map : partitionSpecs) {
            this.hive.createPartition(table, map);
        }
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)(numOfPartKeys * valuesPerPartition), (long)partitions.size());
        return table;
    }

    private void createPartitionsDirectoriesOnFS(Table table, int numPartitions, boolean reverseOrder) throws IOException {
        String path = table.getDataLocation().toString();
        this.fs = table.getPath().getFileSystem((Configuration)this.hive.getConf());
        int numPartKeys = table.getPartitionKeys().size();
        for (int i = 0; i < numPartitions; ++i) {
            StringBuilder partPath = new StringBuilder(path);
            partPath.append("/");
            if (!reverseOrder) {
                for (j = 0; j < numPartKeys; ++j) {
                    field = (FieldSchema)table.getPartitionKeys().get(j);
                    partPath.append(field.getName());
                    partPath.append('=');
                    partPath.append("val_");
                    partPath.append(i);
                    if (j >= numPartKeys - 1) continue;
                    partPath.append("/");
                }
            } else {
                for (j = numPartKeys - 1; j >= 0; --j) {
                    field = (FieldSchema)table.getPartitionKeys().get(j);
                    partPath.append(field.getName());
                    partPath.append('=');
                    partPath.append("val_");
                    partPath.append(i);
                    if (j <= 0) continue;
                    partPath.append("/");
                }
            }
            this.createDirectory(partPath.toString());
        }
    }

    private void createPartitionsDirectoriesOnFS(Table table, int numPartitions) throws IOException {
        this.createPartitionsDirectoriesOnFS(table, numPartitions, false);
    }

    private void createInvalidPartitionDirsOnFS(Table table, int numPartitions) throws IOException {
        this.createPartitionsDirectoriesOnFS(table, numPartitions, true);
    }

    private void createFile(String partPath, String filename) throws IOException {
        Path part = new Path(partPath);
        this.fs.mkdirs(part);
        this.fs.createNewFile(new Path(partPath + "/" + filename));
        this.fs.deleteOnExit(part);
    }

    private void createDirectory(String partPath) throws IOException {
        Path part = new Path(partPath);
        this.fs.mkdirs(part);
        this.fs.createNewFile(new Path(partPath + "/dummydata1"));
        this.fs.createNewFile(new Path(partPath + "/dummydata2"));
        this.fs.deleteOnExit(part);
    }

    private Path addFolderToPath(FileSystem fs, String rootPath, String folder) throws IOException {
        Path folderParth = new Path(rootPath, folder);
        fs.mkdirs(folderParth);
        fs.deleteOnExit(folderParth);
        return folderParth;
    }

    private Table createTestTable(boolean transactional) throws HiveException, AlreadyExistsException {
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db, true);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        if (transactional) {
            table.setInputFormatClass(OrcInputFormat.class);
            table.setOutputFormatClass(OrcOutputFormat.class);
        } else {
            table.setInputFormatClass(TextInputFormat.class);
            table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        }
        table.setPartCols(this.partCols);
        if (transactional) {
            table.setProperty("transactional", "true");
        }
        this.hive.createTable(table);
        table = this.hive.getTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        Assert.assertTrue((boolean)table.getTTable().isSetId());
        table.getTTable().unsetId();
        for (Map<String, String> partSpec : this.parts) {
            this.hive.createPartition(table, partSpec);
        }
        return table;
    }

    private Table createNonPartitionedTable() throws Exception {
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db, true);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(OrcInputFormat.class);
        table.setOutputFormatClass(OrcOutputFormat.class);
        table.setProperty("transactional", "true");
        this.hive.createTable(table);
        table = this.hive.getTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        Assert.assertTrue((boolean)table.getTTable().isSetId());
        table.getTTable().unsetId();
        return table;
    }
}

