/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class TestHiveLockObject {

    @RunWith(value=Parameterized.class)
    public static class TestHiveLockObjectParametrized {
        private final String data;
        private final String expectedQueryId;
        private final String expectedLockTime;
        private final String expectedLockMode;
        private final String expectedQueryStr;
        private final String expectedClientIp;

        public TestHiveLockObjectParametrized(String data, String expectedQueryId, String expectedLockTime, String expectedLockMode, String expectedQueryStr, String expectedClientIp) {
            this.data = data;
            this.expectedQueryId = expectedQueryId;
            this.expectedLockTime = expectedLockTime;
            this.expectedLockMode = expectedLockMode;
            this.expectedQueryStr = expectedQueryStr;
            this.expectedClientIp = expectedClientIp;
        }

        @Parameterized.Parameters
        public static Collection<Object[]> data() {
            return Arrays.asList({"query1:2025-03-31:EXPLICIT:SELECT * FROM table", "query1", "2025-03-31", "EXPLICIT", "SELECT * FROM table", null}, {"query2:2025-03-31:EXPLICIT:SELECT * FROM table:192.168.0.1", "query2", "2025-03-31", "EXPLICIT", "SELECT * FROM table", "192.168.0.1"}, {"query3:2025-03-31:EXPLICIT:SELECT * FROM table:2001:0db8:85a3:0000:0000:8a2e:0370:7334", "query3", "2025-03-31", "EXPLICIT", "SELECT * FROM table", "2001:0db8:85a3:0000:0000:8a2e:0370:7334"}, {"query5:2025-03-31:EXPLICIT:SELECT * FROM table:some.company.com", "query5", "2025-03-31", "EXPLICIT", "SELECT * FROM table", "some.company.com"});
        }

        @Test
        public void testConstructor() {
            HiveLockObject.HiveLockObjectData lockObjectData = new HiveLockObject.HiveLockObjectData(this.data);
            Assert.assertEquals((String)"queryId should match", (Object)this.expectedQueryId, (Object)lockObjectData.getQueryId());
            Assert.assertEquals((String)"lockTime should match", (Object)this.expectedLockTime, (Object)lockObjectData.getLockTime());
            Assert.assertEquals((String)"lockMode should match", (Object)this.expectedLockMode, (Object)lockObjectData.getLockMode());
            Assert.assertEquals((String)"queryStr should match", (Object)this.expectedQueryStr, (Object)lockObjectData.getQueryStr());
            Assert.assertEquals((String)"clientIp should match", (Object)this.expectedClientIp, (Object)lockObjectData.getClientIp());
        }
    }

    public static class TestHiveLockObjectNonParametrized {
        private final HiveConf conf = new HiveConf();

        @Test
        public void testEqualsAndHashCode() {
            HiveLockObject.HiveLockObjectData data1 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "select * from mytable", this.conf);
            HiveLockObject.HiveLockObjectData data2 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "select * from mytable", this.conf);
            Assert.assertEquals((Object)data1, (Object)data2);
            Assert.assertEquals((long)data1.hashCode(), (long)data2.hashCode());
            HiveLockObject obj1 = new HiveLockObject("mytable", data1);
            HiveLockObject obj2 = new HiveLockObject("mytable", data2);
            Assert.assertEquals((Object)obj1, (Object)obj2);
            Assert.assertEquals((long)obj1.hashCode(), (long)obj2.hashCode());
        }

        @Test
        public void testTruncate() {
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_LOCK_QUERY_STRING_MAX_LENGTH, 1000000);
            HiveLockObject.HiveLockObjectData data0 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "01234567890", this.conf);
            Assert.assertEquals((String)"With default settings query string should not be truncated", (long)11L, (long)data0.getQueryStr().length());
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_LOCK_QUERY_STRING_MAX_LENGTH, 10);
            HiveLockObject.HiveLockObjectData data1 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "01234567890", this.conf);
            HiveLockObject.HiveLockObjectData data2 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "0123456789", this.conf);
            HiveLockObject.HiveLockObjectData data3 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", "012345678", this.conf);
            HiveLockObject.HiveLockObjectData data4 = new HiveLockObject.HiveLockObjectData("ID1", "SHARED", "1997-07-01", null, this.conf);
            Assert.assertEquals((String)"Long string truncation failed", (long)10L, (long)data1.getQueryStr().length());
            Assert.assertEquals((String)"String truncation failed", (long)10L, (long)data2.getQueryStr().length());
            Assert.assertEquals((String)"Short string should not be truncated", (long)9L, (long)data3.getQueryStr().length());
            Assert.assertNull((String)"Null query string handling failed", (Object)data4.getQueryStr());
        }
    }
}

