/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.dbinstall.rules.DatabaseRule;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Derby;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Mariadb;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Mssql;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Mysql;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Oracle;
import org.apache.hadoop.hive.metastore.dbinstall.rules.Postgres;
import org.apache.hadoop.hive.ql.lockmgr.TestDbTxnManager2;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ITestDbTxnManager
extends TestDbTxnManager2 {
    private static final String SYS_PROP_METASTORE_DB = "test.metastore.db";
    private static final Logger LOG = LoggerFactory.getLogger(TestDbTxnManager2.class);
    private static DatabaseRule rule;

    @BeforeClass
    public static void setupDb() throws Exception {
        String metastoreType = System.getProperty(SYS_PROP_METASTORE_DB) == null ? "derby" : System.getProperty(SYS_PROP_METASTORE_DB).toLowerCase();
        rule = ITestDbTxnManager.getDatabaseRule(metastoreType).setVerbose(false);
        conf.setVar(HiveConf.ConfVars.METASTORE_DB_TYPE, metastoreType.toUpperCase());
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY, (String)rule.getJdbcUrl());
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_DRIVER, (String)rule.getJdbcDriver());
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECTION_USER_NAME, (String)rule.getHiveUser());
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PWD, (String)rule.getHivePassword());
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AUTO_CREATE_ALL, (boolean)false);
        DatabaseProduct.reset();
        LOG.info("Set metastore connection to url: {}", (Object)MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CONNECT_URL_KEY));
        rule.before();
        rule.install();
    }

    @AfterClass
    public static void tearDownDb() {
        rule.after();
    }

    private static DatabaseRule getDatabaseRule(String metastoreType) {
        switch (metastoreType) {
            case "postgres": {
                return new Postgres();
            }
            case "oracle": {
                return new Oracle();
            }
            case "mysql": {
                return new Mysql();
            }
            case "mariadb": {
                return new Mariadb();
            }
            case "mssql": {
                return new Mssql();
            }
        }
        return new Derby();
    }
}

