/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreClientWithLocalCache;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class DbTxnManagerEndToEndTestBase {
    protected static HiveConfForTest conf = new HiveConfForTest(DbTxnManagerEndToEndTestBase.class);
    protected HiveTxnManager txnMgr;
    protected Context ctx;
    protected Driver driver;
    protected Driver driver2;
    protected TxnStore txnHandler;

    public DbTxnManagerEndToEndTestBase() {
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, (String)"org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)false);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.TXN_MERGE_INSERT_X_LOCK, (boolean)true);
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.WAREHOUSE, (String)this.getWarehouseDir());
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_ON, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_CLEANER_ON, (boolean)true);
        TestTxnDbUtil.setConfValues((Configuration)conf);
    }

    @BeforeClass
    public static void setUpDB() throws Exception {
        TestTxnDbUtil.prepDb((Configuration)conf);
    }

    @Before
    public void setUp() throws Exception {
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MSC_CACHE_ENABLED)) {
            HiveMetaStoreClientWithLocalCache.init((Configuration)conf);
        }
        SessionState.start((HiveConf)conf);
        this.ctx = new Context((Configuration)conf);
        HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LOCKS_PARTITION_THRESHOLD, (int)-1);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED, (boolean)false);
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.TXN_WRITE_X_LOCK, (boolean)false);
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_USE_MIN_HISTORY_LEVEL, (boolean)true);
        this.driver = new Driver(new QueryState.Builder().withHiveConf((HiveConf)conf).nonIsolated().build());
        this.driver2 = new Driver(new QueryState.Builder().withHiveConf((HiveConf)conf).build());
        TestTxnDbUtil.cleanDb((Configuration)conf);
        SessionState ss = SessionState.get();
        ss.initTxnMgr((HiveConf)conf);
        this.txnMgr = ss.getTxnMgr();
        Assert.assertTrue((boolean)(this.txnMgr instanceof DbTxnManager));
        this.txnHandler = TxnUtils.getTxnStore((Configuration)conf);
        File f = new File(this.getWarehouseDir());
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(this.getWarehouseDir()).mkdirs()) {
            throw new RuntimeException("Could not create " + this.getWarehouseDir());
        }
    }

    @After
    public void tearDown() throws Exception {
        this.driver.close();
        conf.unset("hive.txn.valid.txns");
        this.driver2.close();
        if (this.txnMgr != null) {
            this.txnMgr.closeTxnManager();
        }
        FileUtils.deleteDirectory((File)new File(conf.getTestDataDir()));
    }

    protected String getWarehouseDir() {
        return conf.getTestDataDir() + "/warehouse";
    }
}

