/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.sarg;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetFilterPredicateConverter;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.ExpressionTree;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentImpl;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Test;

public class TestConvertAstToSearchArg {
    private final Configuration conf = new Configuration();

    private static void assertNoSharedNodes(ExpressionTree tree, Set<ExpressionTree> seen) throws Exception {
        if (seen.contains(tree) && tree.getOperator() != ExpressionTree.Operator.LEAF) {
            Assert.assertTrue((String)("repeated node in expression " + tree), (boolean)false);
        }
        seen.add(tree);
        if (tree.getChildren() != null) {
            for (ExpressionTree child : tree.getChildren()) {
                TestConvertAstToSearchArg.assertNoSharedNodes(child, seen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExprNodeGenericFuncDesc getFuncDesc(String xmlSerialized) {
        byte[] bytes = xmlSerialized.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        try (XMLDecoder decoder = new XMLDecoder(bais, null, null);){
            ExprNodeGenericFuncDesc exprNodeGenericFuncDesc = (ExprNodeGenericFuncDesc)decoder.readObject();
            return exprNodeGenericFuncDesc;
        }
    }

    @Test
    public void testExpression1() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                          <void property=\"children\"> \n                           <object class=\"java.util.ArrayList\"> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                              <void property=\"children\"> \n                               <object class=\"java.util.ArrayList\"> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                                  <void property=\"column\"> \n                                   <string>first_name</string> \n                                  </void> \n                                  <void property=\"tabAlias\"> \n                                   <string>orc_people</string> \n                                  </void> \n                                  <void property=\"typeInfo\"> \n                                   <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                                    <void property=\"typeName\"> \n                                     <string>string</string> \n                                    </void> \n                                   </object> \n                                  </void> \n                                 </object> \n                                </void> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                                  <void property=\"typeInfo\"> \n                                   <object idref=\"PrimitiveTypeInfo0\"/> \n                                  </void> \n                                  <void property=\"value\"> \n                                   <string>john</string> \n                                  </void> \n                                 </object> \n                                </void> \n                               </object> \n                              </void> \n                              <void property=\"genericUDF\"> \n                               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n                              </void> \n                              <void property=\"typeInfo\"> \n                               <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                                <void property=\"typeName\"> \n                                 <string>boolean</string> \n                                </void> \n                               </object> \n                              </void> \n                             </object> \n                            </void> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                              <void property=\"children\"> \n                               <object class=\"java.util.ArrayList\"> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                                  <void property=\"typeInfo\"> \n                                   <object idref=\"PrimitiveTypeInfo0\"/> \n                                  </void> \n                                  <void property=\"value\"> \n                                   <string>greg</string> \n                                  </void> \n                                 </object> \n                                </void> \n                                <void method=\"add\"> \n                                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                                  <void property=\"column\"> \n                                   <string>first_name</string> \n                                  </void> \n                                  <void property=\"tabAlias\"> \n                                   <string>orc_people</string> \n                                  </void> \n                                  <void property=\"typeInfo\"> \n                                   <object idref=\"PrimitiveTypeInfo0\"/> \n                                  </void> \n                                 </object> \n                                </void> \n                               </object> \n                              </void> \n                              <void property=\"genericUDF\"> \n                               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                              </void> \n                              <void property=\"typeInfo\"> \n                               <object idref=\"PrimitiveTypeInfo1\"/> \n                              </void> \n                             </object> \n                            </void> \n                           </object> \n                          </void> \n                          <void property=\"genericUDF\"> \n                           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo1\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                          <void property=\"children\"> \n                           <object class=\"java.util.ArrayList\"> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                              <void property=\"typeInfo\"> \n                               <object idref=\"PrimitiveTypeInfo0\"/> \n                              </void> \n                              <void property=\"value\"> \n                               <string>alan</string> \n                              </void> \n                             </object> \n                            </void> \n                            <void method=\"add\"> \n                             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                              <void property=\"column\"> \n                               <string>first_name</string> \n                              </void> \n                              <void property=\"tabAlias\"> \n                               <string>orc_people</string> \n                              </void> \n                              <void property=\"typeInfo\"> \n                               <object idref=\"PrimitiveTypeInfo0\"/> \n                              </void> \n                             </object> \n                            </void> \n                           </object> \n                          </void> \n                          <void property=\"genericUDF\"> \n                           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan\"/> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo1\"/> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                            <void property=\"typeName\"> \n                             <string>int</string> \n                            </void> \n                           </object> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo2\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>12</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>13</int> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>id</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <int>15</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <int>16</int> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <int>30</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <string>owen</string> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n";
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        Assert.assertFalse((boolean)result.isPartial());
        SearchArgumentImpl sarg = (SearchArgumentImpl)result.getSearchArgument();
        List leaves = sarg.getLeaves();
        Assert.assertEquals((long)9L, (long)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("id", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("first_name", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        Object[] conditions = new String[]{"eq(first_name, Binary{\"john\"})", "not(lteq(first_name, Binary{\"greg\"}))", "lt(first_name, Binary{\"alan\"})", "not(lteq(id, 12))", "not(lteq(id, 13))", "lt(id, 15)", "lt(id, 16)", "eq(id, 30)", "eq(first_name, Binary{\"owen\"})"};
        String expected = String.format("and(or(or(or(or(or(or(or(%1$s, %2$s), %3$s), %4$s), %5$s), %6$s), %7$s), %8$s), or(or(or(or(or(or(or(%1$s, %2$s), %3$s), %4$s), %5$s), %6$s), %7$s), %9$s))", conditions);
        Assert.assertEquals((Object)expected, (Object)p.toString());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"first_name", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)"john", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"first_name", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)"greg", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"first_name", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)"alan", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(3);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(4);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)13L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(5);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)15L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(6);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)16L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(7);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)30L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(8);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.NULL_SAFE_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"first_name", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)"owen", (Object)leaf.getLiteral());
        Assert.assertEquals((Object)"(and (or leaf-0 (not leaf-1) leaf-2 (not leaf-3) (not leaf-4) leaf-5 leaf-6 leaf-7) (or leaf-0 (not leaf-1) leaf-2 (not leaf-3) (not leaf-4) leaf-5 leaf-6 leaf-8))", (Object)sarg.getExpression().toOldString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
    }

    @Test
    public void testExpression2() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>first_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                    <void property=\"typeName\"> \n                     <string>string</string> \n                    </void> \n                   </object> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>boolean</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>first_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <string>sue</string> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>int</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <int>12</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n          <void property=\"value\"> \n           <int>4</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n";
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        Assert.assertFalse((boolean)result.isPartial());
        SearchArgumentImpl sarg = (SearchArgumentImpl)result.getSearchArgument();
        List leaves = sarg.getLeaves();
        Assert.assertEquals((long)4L, (long)leaves.size());
        Object[] conditions = new String[]{"eq(first_name, null)", "not(eq(first_name, Binary{\"sue\"}))", "not(lt(id, 12))", "lteq(id, 4)"};
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("id", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("first_name", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = String.format("or(or(or(%1$s, %2$s), %3$s), %4$s)", conditions);
        Assert.assertEquals((Object)expected, (Object)p.toString());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IS_NULL, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"first_name", (Object)leaf.getColumnName());
        Assert.assertEquals(null, (Object)leaf.getLiteral());
        Assert.assertEquals(null, (Object)leaf.getLiteralList());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"first_name", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)"sue", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(3);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN_EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)4L, (Object)leaf.getLiteral());
        Assert.assertEquals((Object)"(or leaf-0 (not leaf-1) (not leaf-2) leaf-3)", (Object)sarg.getExpression().toOldString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES_NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES_NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES_NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES_NULL, SearchArgument.TruthValue.YES_NO_NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO_NULL, SearchArgument.TruthValue.YES_NO_NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
    }

    @Test
    public void testExpression3() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>boolean</string> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"value\"> \n                       <boolean>false</boolean> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>int</string> \n                        </void> \n                       </object> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>23</int> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>45</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>first_name</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>string</string> \n                        </void> \n                       </object> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <string>alan</string> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo2\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <string>xxxxx</string> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>3</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n                    <void property=\"udfClassName\"> \n                     <string>org.apache.hadoop.hive.ql.udf.UDFSubstr</string> \n                    </void> \n                    <void property=\"udfName\"> \n                     <string>substr</string> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>first_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo2\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <string>smith</string> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>last_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n              <void property=\"value\"> \n               <int>3</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n            <void property=\"udfClassName\"> \n             <string>org.apache.hadoop.hive.ql.udf.UDFSubstr</string> \n            </void> \n            <void property=\"udfName\"> \n             <string>substr</string> \n            </void> \n           </object> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo2\"/> \n          </void> \n          <void property=\"value\"> \n           <string>yyy</string> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo0\"/> \n  </void> \n </object> \n</java> \n";
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        Assert.assertTrue((boolean)result.isPartial());
        SearchArgumentImpl sarg = (SearchArgumentImpl)result.getSearchArgument();
        List leaves = sarg.getLeaves();
        Assert.assertEquals((long)3L, (long)leaves.size());
        Object[] conditions = new String[]{"lteq(id, 45)", "not(lt(id, 23))", "eq(first_name, Binary{\"alan\"})", "eq(last_name, Binary{\"smith\"})"};
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; required binary last_name;}");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("id", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("first_name", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        columnTypes.put("last_name", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = String.format("and(and(and(%1$s, %2$s), %3$s), %4$s)", conditions);
        Assert.assertEquals((Object)expected, (Object)p.toString());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.BETWEEN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals(null, (Object)leaf.getLiteral());
        Assert.assertEquals((Object)23L, leaf.getLiteralList().get(0));
        Assert.assertEquals((Object)45L, leaf.getLiteralList().get(1));
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"first_name", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)"alan", (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"last_name", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)"smith", (Object)leaf.getLiteral());
        Assert.assertEquals((Object)"(and leaf-0 leaf-1 leaf-2)", (Object)sarg.getExpression().toOldString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
    }

    @Test
    public void testExpression4() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>int</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>12</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n            <void property=\"typeName\"> \n             <string>boolean</string> \n            </void> \n           </object> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo2\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>string</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <string>john</string> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo2\"/> \n              </void> \n              <void property=\"value\"> \n               <string>sue</string> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>34</int> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>50</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n\n";
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        Assert.assertFalse((boolean)result.isPartial());
        SearchArgumentImpl sarg = (SearchArgumentImpl)result.getSearchArgument();
        List leaves = sarg.getLeaves();
        Assert.assertEquals((long)3L, (long)leaves.size());
        Object[] conditions = new String[]{"not(eq(id, 12))", "or(eq(first_name, Binary{\"john\"}), eq(first_name, Binary{\"sue\"}))", "or(eq(id, 34), eq(id, 50))"};
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("id", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("first_name", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = String.format("and(and(%1$s, %2$s), %3$s)", conditions);
        Assert.assertEquals((Object)expected, (Object)p.toString());
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.EQUALS, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"first_name", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)"john", leaf.getLiteralList().get(0));
        Assert.assertEquals((Object)"sue", leaf.getLiteralList().get(1));
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.IN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)34L, leaf.getLiteralList().get(0));
        Assert.assertEquals((Object)50L, leaf.getLiteralList().get(1));
        Assert.assertEquals((Object)"(and (not leaf-0) leaf-1 leaf-2)", (Object)sarg.getExpression().toOldString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES_NULL, SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.NULL, SearchArgument.TruthValue.YES_NO_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO, SearchArgument.TruthValue.YES, SearchArgument.TruthValue.NO_NULL)));
    }

    @Test
    public void testExpression5() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>first_name</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                <void property=\"typeName\"> \n                 <string>string</string> \n                </void> \n               </object> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <string>owen</string> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n            <void property=\"typeName\"> \n             <string>boolean</string> \n            </void> \n           </object> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <string>foobar</string> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>last_name</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                    <void property=\"typeName\"> \n                     <string>int</string> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"value\"> \n                   <int>4</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n                <void property=\"udfClassName\"> \n                 <string>org.apache.hadoop.hive.ql.udf.UDFSubstr</string> \n                </void> \n                <void property=\"udfName\"> \n                 <string>substr</string> \n                </void> \n               </object> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n          <void property=\"value\"> \n           <boolean>false</boolean> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>first_name</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <string>david</string> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <string>greg</string> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java> \n";
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        Assert.assertTrue((boolean)result.isPartial());
        SearchArgumentImpl sarg = (SearchArgumentImpl)result.getSearchArgument();
        List leaves = sarg.getLeaves();
        Assert.assertEquals((long)1L, (long)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("id", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("first_name", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(lteq(first_name, Binary{\"greg\"}), not(lt(first_name, Binary{\"david\"})))";
        Assert.assertEquals((Object)p.toString(), (Object)expected);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)((PredicateLeaf)leaves.get(0)).getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.BETWEEN, (Object)((PredicateLeaf)leaves.get(0)).getOperator());
        Assert.assertEquals((Object)"first_name", (Object)((PredicateLeaf)leaves.get(0)).getColumnName());
        Assert.assertEquals((Object)"leaf-0", (Object)sarg.getExpression().toOldString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
    }

    @Test
    public void testExpression7() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                            <void property=\"typeName\"> \n                             <string>int</string> \n                            </void> \n                           </object> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>10</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n                        <void property=\"typeName\"> \n                         <string>boolean</string> \n                        </void> \n                       </object> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>11</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>12</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>13</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                      <void property=\"children\"> \n                       <object class=\"java.util.ArrayList\"> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                          <void property=\"column\"> \n                           <string>id</string> \n                          </void> \n                          <void property=\"tabAlias\"> \n                           <string>orc_people</string> \n                          </void> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                         </object> \n                        </void> \n                        <void method=\"add\"> \n                         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                          <void property=\"typeInfo\"> \n                           <object idref=\"PrimitiveTypeInfo0\"/> \n                          </void> \n                          <void property=\"value\"> \n                           <int>14</int> \n                          </void> \n                         </object> \n                        </void> \n                       </object> \n                      </void> \n                      <void property=\"genericUDF\"> \n                       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo1\"/> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n                  <void property=\"children\"> \n                   <object class=\"java.util.ArrayList\"> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                      <void property=\"column\"> \n                       <string>id</string> \n                      </void> \n                      <void property=\"tabAlias\"> \n                       <string>orc_people</string> \n                      </void> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                     </object> \n                    </void> \n                    <void method=\"add\"> \n                     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                      <void property=\"typeInfo\"> \n                       <object idref=\"PrimitiveTypeInfo0\"/> \n                      </void> \n                      <void property=\"value\"> \n                       <int>15</int> \n                      </void> \n                     </object> \n                    </void> \n                   </object> \n                  </void> \n                  <void property=\"genericUDF\"> \n                   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo1\"/> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>id</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <int>16</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n              <void property=\"children\"> \n               <object class=\"java.util.ArrayList\"> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n                  <void property=\"column\"> \n                   <string>id</string> \n                  </void> \n                  <void property=\"tabAlias\"> \n                   <string>orc_people</string> \n                  </void> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                 </object> \n                </void> \n                <void method=\"add\"> \n                 <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n                  <void property=\"typeInfo\"> \n                   <object idref=\"PrimitiveTypeInfo0\"/> \n                  </void> \n                  <void property=\"value\"> \n                   <int>17</int> \n                  </void> \n                 </object> \n                </void> \n               </object> \n              </void> \n              <void property=\"genericUDF\"> \n               <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo1\"/> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>18</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object>\n</java>";
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        Assert.assertFalse((boolean)result.isPartial());
        SearchArgumentImpl sarg = (SearchArgumentImpl)result.getSearchArgument();
        List leaves = sarg.getLeaves();
        Assert.assertEquals((long)9L, (long)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("id", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("first_name", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(and(and(and(and(and(and(and(and(and(and(and(and(and(and(and(or(or(or(lt(id, 18), lt(id, 10)), lt(id, 13)), lt(id, 16)), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 13)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 13)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 14)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 14)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 14)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 15)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 15)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 15)), lt(id, 16))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 13)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 13)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 13)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 14)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 14)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 14)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 10)), lt(id, 15)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 11)), lt(id, 15)), lt(id, 17))), or(or(or(lt(id, 18), lt(id, 12)), lt(id, 15)), lt(id, 17)))";
        Assert.assertEquals((Object)p.toString(), (Object)expected);
        PredicateLeaf leaf = (PredicateLeaf)leaves.get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)18L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)10L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(2);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)13L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(3);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)16L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(4);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)11L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(5);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)12L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(6);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)14L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(7);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)15L, (Object)leaf.getLiteral());
        leaf = (PredicateLeaf)leaves.get(8);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)leaf.getOperator());
        Assert.assertEquals((Object)"id", (Object)leaf.getColumnName());
        Assert.assertEquals((Object)17L, (Object)leaf.getLiteral());
        Assert.assertEquals((Object)"(and (or leaf-0 leaf-1 leaf-2 leaf-3) (or leaf-0 leaf-4 leaf-2 leaf-3) (or leaf-0 leaf-5 leaf-2 leaf-3) (or leaf-0 leaf-1 leaf-6 leaf-3) (or leaf-0 leaf-4 leaf-6 leaf-3) (or leaf-0 leaf-5 leaf-6 leaf-3) (or leaf-0 leaf-1 leaf-7 leaf-3) (or leaf-0 leaf-4 leaf-7 leaf-3) (or leaf-0 leaf-5 leaf-7 leaf-3) (or leaf-0 leaf-1 leaf-2 leaf-8) (or leaf-0 leaf-4 leaf-2 leaf-8) (or leaf-0 leaf-5 leaf-2 leaf-8) (or leaf-0 leaf-1 leaf-6 leaf-8) (or leaf-0 leaf-4 leaf-6 leaf-8) (or leaf-0 leaf-5 leaf-6 leaf-8) (or leaf-0 leaf-1 leaf-7 leaf-8) (or leaf-0 leaf-4 leaf-7 leaf-8) (or leaf-0 leaf-5 leaf-7 leaf-8))", (Object)sarg.getExpression().toOldString());
    }

    @Test
    public void testExpression8() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n      <void property=\"column\"> \n       <string>first_name</string> \n      </void> \n      <void property=\"tabAlias\"> \n       <string>orc_people</string> \n      </void> \n      <void property=\"typeInfo\"> \n       <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n        <void property=\"typeName\"> \n         <string>string</string> \n        </void> \n       </object> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n      <void property=\"column\"> \n       <string>last_name</string> \n      </void> \n      <void property=\"tabAlias\"> \n       <string>orc_people</string> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n    <void property=\"typeName\"> \n     <string>boolean</string> \n    </void> \n   </object> \n  </void> \n </object> \n</java> ";
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        Assert.assertTrue((boolean)result.isPartial());
        SearchArgumentImpl sarg = (SearchArgumentImpl)result.getSearchArgument();
        List leaves = sarg.getLeaves();
        Assert.assertEquals((long)0L, (long)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("id", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("first_name", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        Assert.assertNull((Object)p);
        Assert.assertEquals((Object)"YES_NO_NULL", (Object)sarg.getExpression().toString());
    }

    @Test
    public void testExpression9() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n      <void property=\"column\"> \n       <string>id</string> \n      </void> \n      <void property=\"tabAlias\"> \n       <string>orc_people</string> \n      </void> \n      <void property=\"typeInfo\"> \n       <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n        <void property=\"typeName\"> \n         <string>int</string> \n        </void> \n       </object> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>1</int> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>3</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n            <void property=\"operator\"> \n             <boolean>true</boolean> \n            </void> \n            <void property=\"udfClassName\"> \n             <string>org.apache.hadoop.hive.ql.udf.UDFOPPlus</string> \n            </void> \n            <void property=\"udfName\"> \n             <string>+</string> \n            </void> \n           </object> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>4</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge\"> \n        <void property=\"operator\"> \n         <boolean>true</boolean> \n        </void> \n        <void property=\"udfClassName\"> \n         <string>org.apache.hadoop.hive.ql.udf.UDFOPPlus</string> \n        </void> \n        <void property=\"udfName\"> \n         <string>+</string> \n        </void> \n       </object> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo0\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n    <void property=\"typeName\"> \n     <string>boolean</string> \n    </void> \n   </object> \n  </void> \n </object> \n</java> ";
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        Assert.assertFalse((boolean)result.isPartial());
        SearchArgumentImpl sarg = (SearchArgumentImpl)result.getSearchArgument();
        List leaves = sarg.getLeaves();
        Assert.assertEquals((long)0L, (long)leaves.size());
        Assert.assertEquals((Object)"YES_NO_NULL", (Object)sarg.getExpression().toString());
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(new SearchArgument.TruthValue[0])));
    }

    @Test
    public void testExpression10() throws Exception {
        String exprStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<java version=\"1.6.0_31\" class=\"java.beans.XMLDecoder\"> \n <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n  <void property=\"children\"> \n   <object class=\"java.util.ArrayList\"> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n          <void property=\"column\"> \n           <string>id</string> \n          </void> \n          <void property=\"tabAlias\"> \n           <string>orc_people</string> \n          </void> \n          <void property=\"typeInfo\"> \n           <object id=\"PrimitiveTypeInfo0\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n            <void property=\"typeName\"> \n             <string>int</string> \n            </void> \n           </object> \n          </void> \n         </object> \n        </void> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo0\"/> \n          </void> \n          <void property=\"value\"> \n           <int>10</int> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object id=\"PrimitiveTypeInfo1\" class=\"org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo\"> \n        <void property=\"typeName\"> \n         <string>boolean</string> \n        </void> \n       </object> \n      </void> \n     </object> \n    </void> \n    <void method=\"add\"> \n     <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n      <void property=\"children\"> \n       <object class=\"java.util.ArrayList\"> \n        <void method=\"add\"> \n         <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc\"> \n          <void property=\"children\"> \n           <object class=\"java.util.ArrayList\"> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc\"> \n              <void property=\"column\"> \n               <string>id</string> \n              </void> \n              <void property=\"tabAlias\"> \n               <string>orc_people</string> \n              </void> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n             </object> \n            </void> \n            <void method=\"add\"> \n             <object class=\"org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc\"> \n              <void property=\"typeInfo\"> \n               <object idref=\"PrimitiveTypeInfo0\"/> \n              </void> \n              <void property=\"value\"> \n               <int>10</int> \n              </void> \n             </object> \n            </void> \n           </object> \n          </void> \n          <void property=\"genericUDF\"> \n           <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan\"/> \n          </void> \n          <void property=\"typeInfo\"> \n           <object idref=\"PrimitiveTypeInfo1\"/> \n          </void> \n         </object> \n        </void> \n       </object> \n      </void> \n      <void property=\"genericUDF\"> \n       <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot\"/> \n      </void> \n      <void property=\"typeInfo\"> \n       <object idref=\"PrimitiveTypeInfo1\"/> \n      </void> \n     </object> \n    </void> \n   </object> \n  </void> \n  <void property=\"genericUDF\"> \n   <object class=\"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd\"/> \n  </void> \n  <void property=\"typeInfo\"> \n   <object idref=\"PrimitiveTypeInfo1\"/> \n  </void> \n </object> \n</java>";
        ConvertAstToSearchArg.Result result = ConvertAstToSearchArg.createSearchArgument((Configuration)this.conf, (ExprNodeGenericFuncDesc)this.getFuncDesc(exprStr));
        Assert.assertFalse((boolean)result.isPartial());
        SearchArgumentImpl sarg = (SearchArgumentImpl)result.getSearchArgument();
        List leaves = sarg.getLeaves();
        Assert.assertEquals((long)1L, (long)leaves.size());
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 id; required binary first_name; }");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("id", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("first_name", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(not(lt(id, 10)), not(lt(id, 10)))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)((PredicateLeaf)leaves.get(0)).getType());
        Assert.assertEquals((Object)PredicateLeaf.Operator.LESS_THAN, (Object)((PredicateLeaf)leaves.get(0)).getOperator());
        Assert.assertEquals((Object)"id", (Object)((PredicateLeaf)leaves.get(0)).getColumnName());
        Assert.assertEquals((Object)10L, (Object)((PredicateLeaf)leaves.get(0)).getLiteral());
        Assert.assertEquals((Object)"(and (not leaf-0) (not leaf-0))", (Object)sarg.getExpression().toOldString());
        TestConvertAstToSearchArg.assertNoSharedNodes(sarg.getExpression(), Sets.newIdentityHashSet());
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.NO_NULL)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES_NO)));
        Assert.assertEquals((Object)SearchArgument.TruthValue.YES_NO_NULL, (Object)sarg.evaluate(TestConvertAstToSearchArg.values(SearchArgument.TruthValue.YES_NO_NULL)));
    }

    private static SearchArgument.TruthValue[] values(SearchArgument.TruthValue ... vals) {
        return vals;
    }

    @Test
    public void testTimestampSarg() throws Exception {
        ExprNodeGenericFuncDesc node = this.getColumnEqualsConstantExpression((TypeInfo)TypeInfoFactory.timestampTypeInfo, "ts", Timestamp.ofEpochMilli((long)1426595696000L));
        String serialAst = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        ConvertAstToSearchArg convertAstToSearchArg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst));
        Assert.assertFalse((boolean)convertAstToSearchArg.isPartial());
        SearchArgument sarg = convertAstToSearchArg.buildSearchArgument();
        Assert.assertEquals((Object)"leaf-0", (Object)sarg.getExpression().toOldString());
        Assert.assertEquals((long)1L, (long)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.TIMESTAMP, (Object)leaf.getType());
        Assert.assertEquals((Object)"(EQUALS ts 2015-03-17 05:34:56.0)", (Object)leaf.toString());
    }

    @Test
    public void testDateSarg() throws Exception {
        ExprNodeGenericFuncDesc node = this.getColumnEqualsConstantExpression((TypeInfo)TypeInfoFactory.dateTypeInfo, "dt", "2015-05-05");
        String serialAst = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        ConvertAstToSearchArg convertAstToSearchArg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst));
        Assert.assertFalse((boolean)convertAstToSearchArg.isPartial());
        SearchArgument sarg = convertAstToSearchArg.buildSearchArgument();
        Assert.assertEquals((Object)"leaf-0", (Object)sarg.getExpression().toOldString());
        Assert.assertEquals((long)1L, (long)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.DATE, (Object)leaf.getType());
        Assert.assertEquals((Object)"(EQUALS dt 2015-05-05)", (Object)leaf.toString());
    }

    @Test
    public void testDecimalSarg() throws Exception {
        ExprNodeGenericFuncDesc node = this.getColumnEqualsConstantExpression((TypeInfo)TypeInfoFactory.decimalTypeInfo, "dec", 123);
        String serialAst = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        ConvertAstToSearchArg convertAstToSearchArg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst));
        Assert.assertFalse((boolean)convertAstToSearchArg.isPartial());
        SearchArgument sarg = convertAstToSearchArg.buildSearchArgument();
        Assert.assertEquals((Object)"leaf-0", (Object)sarg.getExpression().toOldString());
        Assert.assertEquals((long)1L, (long)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.DECIMAL, (Object)leaf.getType());
        Assert.assertEquals((Object)"(EQUALS dec 123)", (Object)leaf.toString());
    }

    @Test
    public void testCharSarg() throws Exception {
        ExprNodeGenericFuncDesc node = this.getColumnEqualsConstantExpression((TypeInfo)TypeInfoFactory.charTypeInfo, "ch", "char      ");
        String serialAst = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        ConvertAstToSearchArg convertAstToSearchArg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst));
        Assert.assertFalse((boolean)convertAstToSearchArg.isPartial());
        SearchArgument sarg = convertAstToSearchArg.buildSearchArgument();
        Assert.assertEquals((Object)"leaf-0", (Object)sarg.getExpression().toOldString());
        Assert.assertEquals((long)1L, (long)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)"(EQUALS ch char      )", (Object)leaf.toString());
    }

    @Test
    public void testVarcharSarg() throws Exception {
        ExprNodeGenericFuncDesc node = this.getColumnEqualsConstantExpression((TypeInfo)TypeInfoFactory.varcharTypeInfo, "vc", "variable");
        String serialAst = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        ConvertAstToSearchArg convertAstToSearchArg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst));
        Assert.assertFalse((boolean)convertAstToSearchArg.isPartial());
        SearchArgument sarg = convertAstToSearchArg.buildSearchArgument();
        Assert.assertEquals((Object)"leaf-0", (Object)sarg.getExpression().toOldString());
        Assert.assertEquals((long)1L, (long)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.STRING, (Object)leaf.getType());
        Assert.assertEquals((Object)"(EQUALS vc variable)", (Object)leaf.toString());
    }

    @Test
    public void testBigintSarg() throws Exception {
        ExprNodeGenericFuncDesc node = this.getColumnEqualsConstantExpression((TypeInfo)TypeInfoFactory.intTypeInfo, "bi", 12345);
        String serialAst = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        ConvertAstToSearchArg convertAstToSearchArg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst));
        Assert.assertFalse((boolean)convertAstToSearchArg.isPartial());
        SearchArgument sarg = convertAstToSearchArg.buildSearchArgument();
        Assert.assertEquals((Object)"leaf-0", (Object)sarg.getExpression().toOldString());
        Assert.assertEquals((long)1L, (long)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.LONG, (Object)leaf.getType());
        Assert.assertEquals((Object)"(EQUALS bi 12345)", (Object)leaf.toString());
    }

    @Test
    public void testBooleanSarg() throws Exception {
        ExprNodeColumnDesc column1 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, "b1", null, false);
        ExprNodeColumnDesc column2 = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, "b2", null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)true);
        ExprNodeGenericFuncDesc function1 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPEqual(), (List)Lists.newArrayList((Object[])new ExprNodeDesc[]{column1, constant}));
        ExprNodeGenericFuncDesc function2 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPEqual(), (List)Lists.newArrayList((Object[])new ExprNodeDesc[]{column2, constant}));
        ArrayList children = Lists.newArrayList();
        children.add(function1);
        children.add(function2);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List)children);
        String serialAst = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        ConvertAstToSearchArg convertAstToSearchArg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst));
        Assert.assertFalse((boolean)convertAstToSearchArg.isPartial());
        SearchArgument sarg = convertAstToSearchArg.buildSearchArgument();
        Assert.assertEquals((Object)"(and leaf-0 leaf-1)", (Object)sarg.getExpression().toOldString());
        Assert.assertEquals((long)2L, (long)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.BOOLEAN, (Object)leaf.getType());
        Assert.assertEquals((Object)"(EQUALS b1 true)", (Object)leaf.toString());
        leaf = (PredicateLeaf)sarg.getLeaves().get(1);
        Assert.assertEquals((Object)PredicateLeaf.Type.BOOLEAN, (Object)leaf.getType());
        Assert.assertEquals((Object)"(EQUALS b2 true)", (Object)leaf.toString());
    }

    @Test
    public void testFloatSarg() throws Exception {
        ExprNodeGenericFuncDesc node = this.getColumnEqualsConstantExpression((TypeInfo)TypeInfoFactory.floatTypeInfo, "flt", Float.valueOf(1.1f));
        String serialAst = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        ConvertAstToSearchArg convertAstToSearchArg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst));
        Assert.assertFalse((boolean)convertAstToSearchArg.isPartial());
        SearchArgument sarg = convertAstToSearchArg.buildSearchArgument();
        Assert.assertEquals((Object)"leaf-0", (Object)sarg.getExpression().toOldString());
        Assert.assertEquals((long)1L, (long)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.FLOAT, (Object)leaf.getType());
        Assert.assertEquals((Object)("(EQUALS flt " + ((Number)Float.valueOf(1.1f)).doubleValue() + ")"), (Object)leaf.toString());
    }

    @Test
    public void testDoubleSarg() throws Exception {
        ExprNodeGenericFuncDesc node = this.getColumnEqualsConstantExpression((TypeInfo)TypeInfoFactory.doubleTypeInfo, "dbl", 2.2);
        String serialAst = SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)node);
        ConvertAstToSearchArg convertAstToSearchArg = new ConvertAstToSearchArg(this.conf, SerializationUtilities.deserializeExpression((String)serialAst));
        Assert.assertFalse((boolean)convertAstToSearchArg.isPartial());
        SearchArgument sarg = convertAstToSearchArg.buildSearchArgument();
        Assert.assertEquals((Object)"leaf-0", (Object)sarg.getExpression().toOldString());
        Assert.assertEquals((long)1L, (long)sarg.getLeaves().size());
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(0);
        Assert.assertEquals((Object)PredicateLeaf.Type.FLOAT, (Object)leaf.getType());
        Assert.assertEquals((Object)"(EQUALS dbl 2.2)", (Object)leaf.toString());
    }

    private ExprNodeGenericFuncDesc getColumnEqualsConstantExpression(TypeInfo typeInfo, String columnName, Object value) {
        ExprNodeColumnDesc column = new ExprNodeColumnDesc(typeInfo, columnName, null, false);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc(typeInfo, value);
        ArrayList children = Lists.newArrayList();
        children.add(column);
        children.add(constant);
        ExprNodeGenericFuncDesc node = new ExprNodeGenericFuncDesc(typeInfo, (GenericUDF)new GenericUDFOPEqual(), (List)children);
        return node;
    }
}

