/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import com.google.common.base.Strings;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import jodd.time.JulianDate;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.junit.Assert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestParquetTimestampsHive2Compatibility {
    private static final long NANOS_PER_HOUR = TimeUnit.HOURS.toNanos(1L);
    private static final long NANOS_PER_MINUTE = TimeUnit.MINUTES.toNanos(1L);
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final long NANOS_PER_DAY = TimeUnit.DAYS.toNanos(1L);

    TestParquetTimestampsHive2Compatibility() {
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"generateTimestamps"})
    void testWriteHive2ReadHive2(String timestampString) {
        NanoTime nt = TestParquetTimestampsHive2Compatibility.writeHive2(timestampString);
        Timestamp ts = TestParquetTimestampsHive2Compatibility.readHive2(nt);
        Assert.assertEquals((Object)timestampString, (Object)ts.toString());
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"generateTimestamps"})
    void testWriteHive2ReadHive4UsingLegacyConversion(String timestampString) {
        NanoTime nt = TestParquetTimestampsHive2Compatibility.writeHive2(timestampString);
        org.apache.hadoop.hive.common.type.Timestamp ts = TestParquetTimestampsHive2Compatibility.readHive4(nt, TimeZone.getDefault().getID(), true);
        Assert.assertEquals((Object)timestampString, (Object)ts.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}")
    @MethodSource(value={"generateTimestamps"})
    void testWriteHive2ReadHive4UsingLegacyConversionWithZone(String timestampString) {
        TimeZone original = TimeZone.getDefault();
        try {
            String zoneId = "US/Pacific";
            TimeZone.setDefault(TimeZone.getTimeZone(zoneId));
            NanoTime nt = TestParquetTimestampsHive2Compatibility.writeHive2(timestampString);
            org.apache.hadoop.hive.common.type.Timestamp ts = TestParquetTimestampsHive2Compatibility.readHive4(nt, zoneId, true);
            Assert.assertEquals((Object)timestampString, (Object)ts.toString());
        }
        finally {
            TimeZone.setDefault(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}")
    @MethodSource(value={"generateTimestampsAndZoneIds"})
    void testWriteHive2ReadHive4UsingLegacyConversionWithJulianLeapYears(String timestampString, String zoneId) {
        TimeZone original = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone(zoneId));
            NanoTime nt = TestParquetTimestampsHive2Compatibility.writeHive2(timestampString);
            org.apache.hadoop.hive.common.type.Timestamp ts = TestParquetTimestampsHive2Compatibility.readHive4(nt, zoneId, true);
            Assert.assertEquals((Object)timestampString, (Object)ts.toString());
        }
        finally {
            TimeZone.setDefault(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{0}")
    @MethodSource(value={"generateTimestampsAndZoneIds28thFeb"})
    void testWriteHive2ReadHive4UsingLegacyConversionWithJulianLeapYearsFor28thFeb(String timestampString, String zoneId) {
        TimeZone original = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone(zoneId));
            NanoTime nt = TestParquetTimestampsHive2Compatibility.writeHive2(timestampString);
            org.apache.hadoop.hive.common.type.Timestamp ts = TestParquetTimestampsHive2Compatibility.readHive4(nt, zoneId, true);
            Assert.assertEquals((Object)timestampString, (Object)ts.toString());
        }
        finally {
            TimeZone.setDefault(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name=" - From: Zone {0}, timestamp: {2}, To: Zone:{1}, expected Timestamp {3}")
    @MethodSource(value={"julianLeapYearEdgeCases"})
    void testWriteHive2ReadHive4UsingLegacyConversionWithJulianLeapYearsEdgeCase(String fromZoneId, String toZoneId, String timestampString, String expected) {
        TimeZone original = TimeZone.getDefault();
        try {
            TimeZone.setDefault(TimeZone.getTimeZone(fromZoneId));
            NanoTime nt = TestParquetTimestampsHive2Compatibility.writeHive2(timestampString);
            org.apache.hadoop.hive.common.type.Timestamp ts = TestParquetTimestampsHive2Compatibility.readHive4(nt, toZoneId, true);
            Assert.assertEquals((Object)expected, (Object)ts.toString());
        }
        finally {
            TimeZone.setDefault(original);
        }
    }

    private static Stream<Arguments> julianLeapYearEdgeCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"GMT-12:00", "GMT+14:00", "0200-02-27 22:00:00.000000001", "0200-03-01 00:00:00.000000001"}), Arguments.of((Object[])new Object[]{"GMT+14:00", "GMT-12:00", "0200-03-01 00:00:00.000000001", "0200-02-27 22:00:00.000000001"}), Arguments.of((Object[])new Object[]{"GMT+14:00", "GMT-12:00", "0200-03-02 00:00:00.000000001", "0200-02-28 22:00:00.000000001"}), Arguments.of((Object[])new Object[]{"GMT-12:00", "GMT+14:00", "0200-03-02 00:00:00.000000001", "0200-03-03 02:00:00.000000001"}), Arguments.of((Object[])new Object[]{"GMT-12:00", "GMT+12:00", "0200-02-28 00:00:00.000000001", "0200-03-01 00:00:00.000000001"}), Arguments.of((Object[])new Object[]{"GMT+12:00", "GMT-12:00", "0200-03-01 00:00:00.000000001", "0200-02-28 00:00:00.000000001"}), Arguments.of((Object[])new Object[]{"Asia/Singapore", "Asia/Singapore", "0200-03-01 00:00:00.000000001", "0200-03-01 00:00:00.000000001"}));
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"generateTimestamps"})
    void testWriteHive4ReadHive4UsingLegacyConversion(String timestampString) {
        String zoneId = "US/Pacific";
        NanoTime nt = TestParquetTimestampsHive2Compatibility.writeHive4(timestampString, zoneId, true);
        org.apache.hadoop.hive.common.type.Timestamp ts = TestParquetTimestampsHive2Compatibility.readHive4(nt, zoneId, true);
        Assert.assertEquals((Object)timestampString, (Object)ts.toString());
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"generateTimestamps"})
    void testWriteHive4ReadHive4UsingNewConversion(String timestampString) {
        String zoneId = "US/Pacific";
        NanoTime nt = TestParquetTimestampsHive2Compatibility.writeHive4(timestampString, zoneId, false);
        org.apache.hadoop.hive.common.type.Timestamp ts = TestParquetTimestampsHive2Compatibility.readHive4(nt, zoneId, false);
        Assert.assertEquals((Object)timestampString, (Object)ts.toString());
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"generateTimestamps"})
    void testWriteHive4UsingLegacyConversionReadHive2(String timestampString) {
        NanoTime nt = TestParquetTimestampsHive2Compatibility.writeHive4(timestampString, TimeZone.getDefault().getID(), true);
        Timestamp ts = TestParquetTimestampsHive2Compatibility.readHive2(nt);
        Assert.assertEquals((Object)timestampString, (Object)ts.toString());
    }

    private static Stream<String> generateTimestamps() {
        return Stream.concat(Stream.generate(new Supplier<String>(){
            int i = 0;

            @Override
            public String get() {
                StringBuilder sb = new StringBuilder(29);
                int year = this.i % 9999 + 1;
                sb.append(TestParquetTimestampsHive2Compatibility.zeros(4 - TestParquetTimestampsHive2Compatibility.digits(year)));
                sb.append(year);
                sb.append('-');
                int month = this.i % 12 + 1;
                sb.append(TestParquetTimestampsHive2Compatibility.zeros(2 - TestParquetTimestampsHive2Compatibility.digits(month)));
                sb.append(month);
                sb.append('-');
                int day = this.i % 28 + 1;
                sb.append(TestParquetTimestampsHive2Compatibility.zeros(2 - TestParquetTimestampsHive2Compatibility.digits(day)));
                sb.append(day);
                sb.append(' ');
                int hour = this.i % 24;
                sb.append(TestParquetTimestampsHive2Compatibility.zeros(2 - TestParquetTimestampsHive2Compatibility.digits(hour)));
                sb.append(hour);
                sb.append(':');
                int minute = this.i % 60;
                sb.append(TestParquetTimestampsHive2Compatibility.zeros(2 - TestParquetTimestampsHive2Compatibility.digits(minute)));
                sb.append(minute);
                sb.append(':');
                int second = this.i % 60;
                sb.append(TestParquetTimestampsHive2Compatibility.zeros(2 - TestParquetTimestampsHive2Compatibility.digits(second)));
                sb.append(second);
                sb.append('.');
                int nano = this.i % 1000000000 | 1;
                sb.append(TestParquetTimestampsHive2Compatibility.zeros(9 - TestParquetTimestampsHive2Compatibility.digits(nano)));
                sb.append(nano);
                ++this.i;
                return sb.toString();
            }
        }).filter(s -> !s.startsWith("1582-10")).limit(3000L), Stream.of("9999-12-31 23:59:59.999"));
    }

    private static Stream<Arguments> generateTimestampsAndZoneIds() {
        return TestParquetTimestampsHive2Compatibility.generateJulianLeapYearTimestamps().flatMap(timestampString -> Stream.of("Asia/Singapore", "Pacific/Kiritimati", "Etc/GMT+12", "Pacific/Niue").map(zoneId -> Arguments.of((Object[])new Object[]{timestampString, zoneId})));
    }

    private static Stream<Arguments> generateTimestampsAndZoneIds28thFeb() {
        return TestParquetTimestampsHive2Compatibility.generateJulianLeapYearTimestamps28thFeb().flatMap(timestampString -> Stream.of("Asia/Singapore", "Pacific/Kiritimati", "Etc/GMT+12", "Pacific/Niue").map(zoneId -> Arguments.of((Object[])new Object[]{timestampString, zoneId})));
    }

    private static Stream<String> generateJulianLeapYearTimestamps() {
        return IntStream.range(1, 100).mapToObj(value -> Strings.padStart((String)String.valueOf(value * 100), (int)4, (char)'0')).map(value -> value + "-03-01 00:00:00.000000001");
    }

    private static Stream<String> generateJulianLeapYearTimestamps28thFeb() {
        return IntStream.range(1, 100).mapToObj(value -> Strings.padStart((String)String.valueOf(value * 100), (int)4, (char)'0')).map(value -> value + "-02-28 00:00:00.000000001");
    }

    private static int digits(int number) {
        int digits = 0;
        do {
            ++digits;
        } while ((number /= 10) != 0);
        return digits;
    }

    private static char[] zeros(int len) {
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = 48;
        }
        return array;
    }

    private static Timestamp toTimestampHive2(String s) {
        Timestamp result;
        int periodIdx = (s = s.trim()).indexOf(".");
        if (periodIdx != -1 && s.length() - periodIdx > 9) {
            s = s.substring(0, periodIdx + 10);
        }
        if (s.indexOf(32) < 0) {
            s = s.concat(" 00:00:00");
        }
        try {
            result = Timestamp.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        return result;
    }

    private static NanoTime writeHive2(String str) {
        Timestamp ts = TestParquetTimestampsHive2Compatibility.toTimestampHive2(str);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneId.of("GMT")));
        calendar.setTime(ts);
        int year = calendar.get(1);
        if (calendar.get(0) == 0) {
            year = 1 - year;
        }
        JulianDate jDateTime = JulianDate.of((int)year, (int)(calendar.get(2) + 1), (int)calendar.get(5), (int)0, (int)0, (int)0, (int)0);
        int days = jDateTime.getJulianDayNumber();
        long hour = calendar.get(11);
        long minute = calendar.get(12);
        long second = calendar.get(13);
        long nanos = ts.getNanos();
        long nanosOfDay = nanos + NANOS_PER_SECOND * second + NANOS_PER_MINUTE * minute + NANOS_PER_HOUR * hour;
        return new NanoTime(days, nanosOfDay);
    }

    private static Timestamp readHive2(NanoTime nt) {
        long nanosOfDay;
        int julianDay = nt.getJulianDay();
        long remainder = nanosOfDay = nt.getTimeOfDayNanos();
        julianDay = (int)((long)julianDay + remainder / NANOS_PER_DAY);
        if ((remainder %= NANOS_PER_DAY) < 0L) {
            remainder += NANOS_PER_DAY;
            --julianDay;
        }
        JulianDate jDateTime = JulianDate.of((double)julianDay);
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneId.of("GMT")));
        calendar.set(1, jDateTime.toLocalDateTime().getYear());
        calendar.set(2, jDateTime.toLocalDateTime().getMonthValue() - 1);
        calendar.set(5, jDateTime.toLocalDateTime().getDayOfMonth());
        int hour = (int)(remainder / NANOS_PER_HOUR);
        int minutes = (int)((remainder %= NANOS_PER_HOUR) / NANOS_PER_MINUTE);
        int seconds = (int)((remainder %= NANOS_PER_MINUTE) / NANOS_PER_SECOND);
        long nanos = remainder % NANOS_PER_SECOND;
        calendar.set(11, hour);
        calendar.set(12, minutes);
        calendar.set(13, seconds);
        Timestamp ts = new Timestamp(calendar.getTimeInMillis());
        ts.setNanos((int)nanos);
        return ts;
    }

    private static NanoTime writeHive4(String str, String sourceZone, boolean legacyConversion) {
        org.apache.hadoop.hive.common.type.Timestamp newTs = PrimitiveObjectInspectorUtils.getTimestampFromString((String)str);
        return NanoTimeUtils.getNanoTime((org.apache.hadoop.hive.common.type.Timestamp)newTs, (ZoneId)ZoneId.of(sourceZone), (boolean)legacyConversion);
    }

    private static org.apache.hadoop.hive.common.type.Timestamp readHive4(NanoTime nt, String targetZone, boolean legacyConversion) {
        return NanoTimeUtils.getTimestamp((NanoTime)nt, (ZoneId)ZoneId.of(targetZone), (boolean)legacyConversion);
    }
}

