/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveArrayInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestParquetHiveArrayInspector {
    private ParquetHiveArrayInspector inspector;

    @Before
    public void setUp() {
        this.inspector = new ParquetHiveArrayInspector((ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
    }

    @Test
    public void testNullArray() {
        Assert.assertEquals((String)"Wrong size", (long)-1L, (long)this.inspector.getListLength(null));
        Assert.assertNull((String)"Should be null", (Object)this.inspector.getList(null));
        Assert.assertNull((String)"Should be null", (Object)this.inspector.getListElement(null, 0));
    }

    @Test
    public void testNullContainer() {
        ArrayWritable list = new ArrayWritable(ArrayWritable.class, null);
        Assert.assertEquals((String)"Wrong size", (long)-1L, (long)this.inspector.getListLength((Object)list));
        Assert.assertNull((String)"Should be null", (Object)this.inspector.getList((Object)list));
        Assert.assertNull((String)"Should be null", (Object)this.inspector.getListElement((Object)list, 0));
    }

    @Test
    public void testEmptyContainer() {
        ArrayWritable list = new ArrayWritable(ArrayWritable.class, (Writable[])new ArrayWritable[0]);
        Assert.assertEquals((String)"Wrong size", (long)0L, (long)this.inspector.getListLength((Object)list));
        Assert.assertNotNull((String)"Should not be null", (Object)this.inspector.getList((Object)list));
        Assert.assertNull((String)"Should be null", (Object)this.inspector.getListElement((Object)list, 0));
    }

    @Test
    public void testRegularList() {
        ArrayWritable list = new ArrayWritable(Writable.class, new Writable[]{new IntWritable(3), new IntWritable(5), new IntWritable(1)});
        ArrayList<IntWritable> expected = new ArrayList<IntWritable>();
        expected.add(new IntWritable(3));
        expected.add(new IntWritable(5));
        expected.add(new IntWritable(1));
        Assert.assertEquals((String)"Wrong size", (long)3L, (long)this.inspector.getListLength((Object)list));
        Assert.assertEquals((String)"Wrong result of inspection", expected, (Object)this.inspector.getList((Object)list));
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals((String)"Wrong result of inspection", expected.get(i), (Object)this.inspector.getListElement((Object)list, i));
        }
        Assert.assertNull((String)"Should be null", (Object)this.inspector.getListElement((Object)list, 3));
    }
}

