/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.HashMap;
import org.apache.hadoop.hive.ql.io.parquet.serde.DeepParquetHiveMapInspector;
import org.apache.hadoop.hive.ql.io.parquet.serde.primitive.ParquetPrimitiveInspectorFactory;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDeepParquetHiveMapInspector {
    private DeepParquetHiveMapInspector inspector;

    @Before
    public void setUp() {
        this.inspector = new DeepParquetHiveMapInspector((ObjectInspector)ParquetPrimitiveInspectorFactory.parquetShortInspector, (ObjectInspector)PrimitiveObjectInspectorFactory.javaIntObjectInspector);
    }

    @Test
    public void testNullMap() {
        Assert.assertNull((String)"Should be null", (Object)this.inspector.getMapValueElement(null, (Object)new ShortWritable(0)));
    }

    @Test
    public void testNullContainer() {
        ArrayWritable map = new ArrayWritable(ArrayWritable.class, null);
        Assert.assertNull((String)"Should be null", (Object)this.inspector.getMapValueElement((Object)map, (Object)new ShortWritable(0)));
    }

    @Test
    public void testEmptyContainer() {
        ArrayWritable map = new ArrayWritable(ArrayWritable.class, (Writable[])new ArrayWritable[0]);
        Assert.assertNull((String)"Should be null", (Object)this.inspector.getMapValueElement((Object)map, (Object)new ShortWritable(0)));
    }

    @Test
    public void testRegularMap() {
        Writable[] entry1 = new Writable[]{new IntWritable(0), new IntWritable(1)};
        Writable[] entry2 = new Writable[]{new IntWritable(2), new IntWritable(3)};
        ArrayWritable map = new ArrayWritable(ArrayWritable.class, new Writable[]{new ArrayWritable(Writable.class, entry1), new ArrayWritable(Writable.class, entry2)});
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(1), (Object)this.inspector.getMapValueElement((Object)map, (Object)new IntWritable(0)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(3), (Object)this.inspector.getMapValueElement((Object)map, (Object)new IntWritable(2)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(1), (Object)this.inspector.getMapValueElement((Object)map, (Object)new ShortWritable(0)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(3), (Object)this.inspector.getMapValueElement((Object)map, (Object)new ShortWritable(2)));
    }

    @Test
    public void testHashMap() {
        HashMap<IntWritable, IntWritable> map = new HashMap<IntWritable, IntWritable>();
        map.put(new IntWritable(0), new IntWritable(1));
        map.put(new IntWritable(2), new IntWritable(3));
        map.put(new IntWritable(4), new IntWritable(5));
        map.put(new IntWritable(6), new IntWritable(7));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(1), (Object)this.inspector.getMapValueElement(map, (Object)new IntWritable(0)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(3), (Object)this.inspector.getMapValueElement(map, (Object)new IntWritable(2)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(5), (Object)this.inspector.getMapValueElement(map, (Object)new IntWritable(4)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(7), (Object)this.inspector.getMapValueElement(map, (Object)new IntWritable(6)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(1), (Object)this.inspector.getMapValueElement(map, (Object)new ShortWritable(0)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(3), (Object)this.inspector.getMapValueElement(map, (Object)new ShortWritable(2)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(5), (Object)this.inspector.getMapValueElement(map, (Object)new ShortWritable(4)));
        Assert.assertEquals((String)"Wrong result of inspection", (Object)new IntWritable(7), (Object)this.inspector.getMapValueElement(map, (Object)new ShortWritable(6)));
    }
}

