/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.io.parquet.LeafFilterFactory;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetFilterPredicateConverter;
import org.apache.hadoop.hive.ql.io.sarg.PredicateLeaf;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgumentFactory;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;

public class TestParquetFilterPredicate {
    @Test
    public void testFilterColumnsThatDoNoExistOnSchema() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 a; required binary stinger; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("a", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.LONG, (Object)10L, (Object)20L).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("stinger", PredicateLeaf.Type.STRING, (Object)"stinger").end().end().build();
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("y", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("z", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("stinger", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(not(eq(a, null)), not(eq(stinger, Binary{\"stinger\"})))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterColumnsThatDoNoExistOnSchemaHighOrder1() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 a; required int32 b; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startOr().startAnd().equals("a", PredicateLeaf.Type.LONG, (Object)1L).equals("none", PredicateLeaf.Type.LONG, (Object)1L).end().startAnd().equals("a", PredicateLeaf.Type.LONG, (Object)999L).equals("none", PredicateLeaf.Type.LONG, (Object)999L).end().end().build();
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("none", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "or(eq(a, 1), eq(a, 999))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterColumnsThatDoNoExistOnSchemaHighOrder2() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 a; required int32 b; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().startOr().equals("a", PredicateLeaf.Type.LONG, (Object)1L).equals("b", PredicateLeaf.Type.LONG, (Object)1L).end().startOr().equals("a", PredicateLeaf.Type.LONG, (Object)999L).equals("none", PredicateLeaf.Type.LONG, (Object)999L).end().end().build();
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("b", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("none", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "or(eq(a, 1), eq(b, 1))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterFloatColumns() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {  required float a; required int32 b; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("a", PredicateLeaf.Type.FLOAT).between("a", PredicateLeaf.Type.FLOAT, (Object)10.2, (Object)20.3).in("b", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).end().end().build();
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        columnTypes.put("b", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(not(eq(a, null)), not(and(lteq(a, 20.3), not(lt(a, 10.2))))), not(or(or(eq(b, 1), eq(b, 2)), eq(b, 3))))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterBetween() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {  required int32 bCol; }");
        SearchArgument sarg = SearchArgumentFactory.newBuilder().between("bCol", PredicateLeaf.Type.LONG, (Object)1L, (Object)5L).build();
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("bCol", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(lteq(bCol, 5), not(lt(bCol, 1)))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
        sarg = SearchArgumentFactory.newBuilder().between("bCol", PredicateLeaf.Type.LONG, (Object)5L, (Object)1L).build();
        p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        expected = "and(lteq(bCol, 1), not(lt(bCol, 5)))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
        sarg = SearchArgumentFactory.newBuilder().between("bCol", PredicateLeaf.Type.LONG, (Object)1L, (Object)1L).build();
        p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        expected = "and(lteq(bCol, 1), not(lt(bCol, 1)))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterBetweenForTimestamp() {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().between("bCol", PredicateLeaf.Type.TIMESTAMP, (Object)new Timestamp(1667586661L), (Object)new Timestamp(1667932199L)).build();
        this.testFilterBetweenHelper(sarg, PredicateLeaf.Type.TIMESTAMP);
    }

    @Test
    public void testFilterBetweenForDecimal() {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().between("bCol", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("12.21"), (Object)new HiveDecimalWritable(1667932199L)).build();
        this.testFilterBetweenHelper(sarg, PredicateLeaf.Type.DECIMAL);
    }

    @Test
    public void testFilterBetweenForDate() {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().between("bCol", PredicateLeaf.Type.DATE, (Object)new Date(1667586661L), (Object)new Date(1667932199L)).build();
        this.testFilterBetweenHelper(sarg, PredicateLeaf.Type.DATE);
    }

    private void testFilterBetweenHelper(SearchArgument sarg, PredicateLeaf.Type type) {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {  required int32 bCol; }");
        LeafFilterFactory leafFilterFactory = new LeafFilterFactory();
        PredicateLeaf leaf = (PredicateLeaf)sarg.getLeaves().get(sarg.getExpression().getLeaf());
        Type parquetType = schema.getType(leaf.getColumnName());
        HiveException exception = (HiveException)Assert.assertThrows(HiveException.class, () -> leafFilterFactory.getLeafFilterBuilderByType(leaf.getType(), parquetType));
        Assert.assertEquals((Object)String.format("The conversion to Parquet FilterPredicate is not supported for %s. Please try to set the following configurations at the session level\n set hive.optimize.index.filter=false;\n set hive.optimize.ppd=false;\n", type), (Object)exception.getMessage());
    }

    @Test
    public void testFilter() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.LONG, (Object)10L, (Object)20L).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)"stinger").end().end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { optional int32 x; required int32 y; required int32 z; optional binary a;}");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("x", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("y", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("z", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("a", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(and(not(eq(x, null)), not(and(lteq(y, 20), not(lt(y, 10))))), not(or(or(eq(z, 1), eq(z, 2)), eq(z, 3)))), not(eq(a, Binary{\"stinger\"})))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterComplexTypes() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.DATE, (Object)Date.valueOf("1970-1-11")).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("1.0")).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 x; required binary y; required binary z;}");
        HashMap<String, Object> columnTypes = new HashMap<String, Object>();
        columnTypes.put("x", TypeInfoFactory.getPrimitiveTypeInfo((String)"date"));
        columnTypes.put("y", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("z", TypeInfoFactory.getDecimalTypeInfo((int)4, (int)2));
        Assert.assertEquals(null, (Object)ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes));
        sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("10"), (Object)new HiveDecimalWritable("20.0")).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("stinger", 100).toString()).end().end().build();
        schema = MessageTypeParser.parseMessageType((String)"message test { optional int32 x; required binary y; required int32 z; optional binary a;}");
        columnTypes = new HashMap();
        columnTypes.put("x", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("y", TypeInfoFactory.getDecimalTypeInfo((int)4, (int)2));
        columnTypes.put("z", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("z", TypeInfoFactory.getCharTypeInfo((int)100));
        Assert.assertEquals(null, (Object)ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes));
    }

    @Test
    public void testFilterComplexTypes2() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.DATE, (Object)Date.valueOf("2005-3-12")).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("1.0")).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 x; required binary y; required binary z;}");
        HashMap<String, Object> columnTypes = new HashMap<String, Object>();
        columnTypes.put("x", TypeInfoFactory.getPrimitiveTypeInfo((String)"date"));
        columnTypes.put("y", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("z", TypeInfoFactory.getDecimalTypeInfo((int)4, (int)2));
        Assert.assertEquals(null, (Object)ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes));
        sarg = SearchArgumentFactory.newBuilder().startNot().startOr().isNull("x", PredicateLeaf.Type.LONG).between("y", PredicateLeaf.Type.DECIMAL, (Object)new HiveDecimalWritable("10"), (Object)new HiveDecimalWritable("20.0")).in("z", PredicateLeaf.Type.LONG, new Object[]{1L, 2L, 3L}).nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("stinger", 100).toString()).end().end().build();
        schema = MessageTypeParser.parseMessageType((String)"message test { optional int32 x; required binary y; required int32 z; optional binary a;}");
        columnTypes = new HashMap();
        columnTypes.put("x", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("y", TypeInfoFactory.getDecimalTypeInfo((int)4, (int)2));
        columnTypes.put("z", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)100));
        Assert.assertEquals(null, (Object)ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes));
    }

    @Test
    public void testFilterFloatColumn() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("x", PredicateLeaf.Type.LONG, (Object)22L).lessThan("x1", PredicateLeaf.Type.LONG, (Object)22L).lessThanEquals("y", PredicateLeaf.Type.STRING, (Object)new HiveChar("hi", 10).toString()).equals("z", PredicateLeaf.Type.FLOAT, (Object)0.22).equals("z1", PredicateLeaf.Type.FLOAT, (Object)0.22).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required int32 x; required int32 x1; required binary y; required float z; required float z1;}");
        HashMap<String, Object> columnTypes = new HashMap<String, Object>();
        columnTypes.put("x", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("x1", TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        columnTypes.put("y", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("z", TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        columnTypes.put("z1", TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(and(and(lt(x, 22), lt(x1, 22)), lteq(y, Binary{\"hi\"})), eq(z, 0.22)), eq(z1, 0.22))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnLessThan() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().lessThan("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("apple", 10).toString()).build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {required binary a;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "lt(a, Binary{\"apple\"})";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnLessThanEquals() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().lessThanEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("apple", 10).toString()).build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {required binary a;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "lteq(a, Binary{\"apple\"})";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnEquals() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().equals("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("apple", 10).toString()).build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {required binary a;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "eq(a, Binary{\"apple\"})";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnNullSafeEquals() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().nullSafeEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("apple", 10).toString()).build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {required binary a;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "eq(a, Binary{\"apple\"})";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnIn() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().in("a", PredicateLeaf.Type.STRING, new Object[]{new HiveChar("cherry", 10).toString(), new HiveChar("orange", 10).toString()}).build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {required binary a;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "or(eq(a, Binary{\"cherry\"}), eq(a, Binary{\"orange\"}))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnBetween() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().between("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("apple", 10).toString(), (Object)new HiveChar("pear", 10).toString()).build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {required binary a;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(lteq(a, Binary{\"pear\"}), not(lt(a, Binary{\"apple\"})))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnIsNull() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().isNull("a", PredicateLeaf.Type.STRING).build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {required binary a;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "eq(a, null)";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnGreaterThan() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startNot().lessThanEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("apple", 10).toString()).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {required binary a;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "not(lteq(a, Binary{\"apple\"}))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnWhiteSpacePrefix() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("  apple", 10).toString()).lessThanEquals("b", PredicateLeaf.Type.STRING, (Object)new HiveChar("  pear", 10).toString()).equals("c", PredicateLeaf.Type.STRING, (Object)new HiveChar("  orange", 10).toString()).nullSafeEquals("d", PredicateLeaf.Type.STRING, (Object)new HiveChar(" pineapple", 10).toString()).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary a; required binary b; required binary c; required binary d;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("b", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("c", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("d", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(and(lt(a, Binary{\"  apple\"}), lteq(b, Binary{\"  pear\"})), eq(c, Binary{\"  orange\"})), eq(d, Binary{\" pineapple\"}))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterCharColumnWhiteSpacePostfix() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("apple  ", 10).toString()).lessThanEquals("b", PredicateLeaf.Type.STRING, (Object)new HiveChar("pear  ", 10).toString()).equals("c", PredicateLeaf.Type.STRING, (Object)new HiveChar("orange  ", 10).toString()).nullSafeEquals("d", PredicateLeaf.Type.STRING, (Object)new HiveChar("pineapple ", 10).toString()).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary a; required binary b; required binary c; required binary d;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("b", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("c", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("d", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(and(lt(a, Binary{\"apple\"}), lteq(b, Binary{\"pear\"})), eq(c, Binary{\"orange\"})), eq(d, Binary{\"pineapple\"}))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterMoreComplexCharColumn() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().startAnd().startOr().equals("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("pear", 10).toString()).lessThanEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveChar("cherry", 10).toString()).end().equals("b", PredicateLeaf.Type.STRING, (Object)new HiveChar("orange", 10).toString()).end().startOr().equals("c", PredicateLeaf.Type.STRING, (Object)new HiveChar("banana", 10).toString()).lessThan("d", PredicateLeaf.Type.STRING, (Object)new HiveChar("cherry", 10).toString()).end().end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary a; required binary b; required binary c; required binary d;}");
        HashMap<String, CharTypeInfo> columnTypes = new HashMap<String, CharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("b", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("c", TypeInfoFactory.getCharTypeInfo((int)10));
        columnTypes.put("d", TypeInfoFactory.getCharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(or(eq(a, Binary{\"pear\"}), lteq(a, Binary{\"cherry\"})), eq(b, Binary{\"orange\"})), or(eq(c, Binary{\"banana\"}), lt(d, Binary{\"cherry\"})))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterVarCharColumn() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("apple", 10).toString()).lessThanEquals("b", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("pear", 10).toString()).equals("c", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("orange", 10).toString()).nullSafeEquals("d", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("pineapple", 9).toString()).in("e", PredicateLeaf.Type.STRING, new Object[]{new HiveVarchar("cherry", 10).toString(), new HiveVarchar("orange", 10).toString()}).between("f", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("apple", 10).toString(), (Object)new HiveVarchar("pear", 10).toString()).isNull("g", PredicateLeaf.Type.STRING).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary a; required binary b; required binary c; required binary d; required binary e; required binary f; required binary g;}");
        HashMap<String, VarcharTypeInfo> columnTypes = new HashMap<String, VarcharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("b", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("c", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("d", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("e", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("f", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("g", TypeInfoFactory.getVarcharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(and(and(and(and(lt(a, Binary{\"apple\"}), lteq(b, Binary{\"pear\"})), eq(c, Binary{\"orange\"})), eq(d, Binary{\"pineapple\"})), or(eq(e, Binary{\"cherry\"}), eq(e, Binary{\"orange\"}))), and(lteq(f, Binary{\"pear\"}), not(lt(f, Binary{\"apple\"})))), eq(g, null))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterVarCharColumnWithWhiteSpaces() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar(" apple  ", 10).toString()).lessThanEquals("b", PredicateLeaf.Type.STRING, (Object)new HiveVarchar(" pear", 10).toString()).equals("c", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("orange ", 10).toString()).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary a; required binary b; required binary c;}");
        HashMap<String, VarcharTypeInfo> columnTypes = new HashMap<String, VarcharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("b", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("c", TypeInfoFactory.getVarcharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(lt(a, Binary{\" apple  \"}), lteq(b, Binary{\" pear\"})), eq(c, Binary{\"orange \"}))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterStringColumnWithWhiteSpaces() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().lessThan("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar(" apple  ", 10).toString()).lessThanEquals("b", PredicateLeaf.Type.STRING, (Object)new HiveVarchar(" pear", 10).toString()).equals("c", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("orange ", 10).toString()).end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary a; required binary b; required binary c;}");
        HashMap<String, PrimitiveTypeInfo> columnTypes = new HashMap<String, PrimitiveTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        columnTypes.put("b", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        columnTypes.put("c", TypeInfoFactory.getPrimitiveTypeInfo((String)"string"));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(lt(a, Binary{\" apple  \"}), lteq(b, Binary{\" pear\"})), eq(c, Binary{\"orange \"}))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }

    @Test
    public void testFilterMoreComplexVarCharColumn() throws Exception {
        SearchArgument sarg = SearchArgumentFactory.newBuilder().startAnd().startAnd().startOr().equals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("pear", 10).toString()).lessThanEquals("a", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("cherry", 10).toString()).end().equals("b", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("orange", 10).toString()).end().startOr().equals("c", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("banana", 10).toString()).lessThan("d", PredicateLeaf.Type.STRING, (Object)new HiveVarchar("cherry", 10).toString()).end().end().build();
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary a; required binary b; required binary c; required binary d;}");
        HashMap<String, VarcharTypeInfo> columnTypes = new HashMap<String, VarcharTypeInfo>();
        columnTypes.put("a", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("b", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("c", TypeInfoFactory.getVarcharTypeInfo((int)10));
        columnTypes.put("d", TypeInfoFactory.getVarcharTypeInfo((int)10));
        FilterPredicate p = ParquetFilterPredicateConverter.toFilterPredicate((SearchArgument)sarg, (MessageType)schema, columnTypes);
        String expected = "and(and(or(eq(a, Binary{\"pear\"}), lteq(a, Binary{\"cherry\"})), eq(b, Binary{\"orange\"})), or(eq(c, Binary{\"banana\"}), lt(d, Binary{\"cherry\"})))";
        Assert.assertEquals((Object)expected, (Object)p.toString());
    }
}

