/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.convert.ETypeConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveCollectionConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveGroupConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveStructConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.MyConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestETypeConverter {
    @Test
    public void testGetDecimalConverter() throws Exception {
        DecimalTypeInfo hiveTypeInfo = new DecimalTypeInfo(7, 2);
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromBinaryConverter((TypeInfo)hiveTypeInfo, primitiveType, Binary.fromString((String)"155"));
        HiveDecimalWritable decimalWritable = (HiveDecimalWritable)writable;
        Assert.assertEquals((long)2L, (long)decimalWritable.getScale());
    }

    @Test
    public void testGetDecimalConverterIntHiveType() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("int"), primitiveType, 2200);
        IntWritable intWritable = (IntWritable)writable;
        Assert.assertEquals((long)22L, (long)intWritable.get());
    }

    @Test
    public void testGetDecimalConverterBigIntHiveType() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("bigint"), primitiveType, 2200);
        LongWritable longWritable = (LongWritable)writable;
        Assert.assertEquals((long)22L, (long)longWritable.get());
    }

    @Test
    public void testGetDecimalConverterFloatHiveType() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("float"), primitiveType, 2200);
        FloatWritable floatWritable = (FloatWritable)writable;
        Assert.assertEquals((long)22L, (long)((int)floatWritable.get()));
    }

    @Test
    public void testGetDecimalConverterDoubleHiveType() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)7))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("double"), primitiveType, 2200);
        DoubleWritable doubleWritable = (DoubleWritable)writable;
        Assert.assertEquals((long)22L, (long)((int)doubleWritable.get()));
    }

    @Test
    public void testGetInt64TimestampConverterTinyIntHiveType() {
        this.testGetInt64TimestampConverterNumericHiveType("1970-01-01 00:00:00.005", "tinyint", 5);
    }

    @Test
    public void testGetInt64TimestampConverterSmallIntHiveType() {
        this.testGetInt64TimestampConverterNumericHiveType("1970-01-01 00:00:00.005", "smallint", 5);
    }

    @Test
    public void testGetInt64TimestampConverterIntHiveType() {
        this.testGetInt64TimestampConverterNumericHiveType("1970-01-01 00:00:00.005", "int", 5);
    }

    @Test
    public void testGetInt64TimestampConverterBigIntHiveType() {
        this.testGetInt64TimestampConverterNumericHiveType("1998-10-03 09:58:31.231", "bigint", 907408711231L);
    }

    @Test
    public void testGetInt64TimestampConverterFloatHiveType() {
        this.testGetInt64TimestampConverterNumericHiveType("1970-01-01 00:00:00.005", "float", Float.valueOf(5.0f));
    }

    @Test
    public void testGetInt64TimestampConverterDoubleHiveType() {
        this.testGetInt64TimestampConverterNumericHiveType("1970-01-01 00:00:00.005", "double", 5.0);
    }

    @Test
    public void testGetInt64TimestampConverterDecimalHiveType() {
        this.testGetInt64TimestampConverterNumericHiveType("1970-01-01 00:00:00.005", "decimal(1,0)", HiveDecimal.create((int)5));
    }

    @Test
    public void testGetInt64TimestampConverterNoHiveType() {
        Timestamp ts = Timestamp.valueOf((String)"2022-10-24 11:35:00.005");
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.MILLIS);
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, ts.toEpochMilli());
        Assert.assertEquals((Object)"2022-10-24 11:35:00.005", (Object)((TimestampWritableV2)writable).getTimestamp().toString());
    }

    @Test(expected=IllegalStateException.class)
    public void testGetInt64NoLogicalAnnotationTimestampHiveType() {
        Timestamp ts = Timestamp.valueOf((String)"2022-10-24 11:43:00.005");
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("int64");
        this.getWritableFromPrimitiveConverter((TypeInfo)TypeInfoFactory.timestampTypeInfo, primitiveType, ts.toEpochMilli());
    }

    private void testGetInt64TimestampConverterNumericHiveType(String timestamp, String type, Object expected) {
        Timestamp ts = Timestamp.valueOf((String)timestamp);
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.MILLIS);
        PrimitiveTypeInfo info = TypeInfoFactory.getPrimitiveTypeInfo((String)type);
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)info, primitiveType, ts.toEpochMilli());
        Assert.assertEquals((Object)expected, (Object)(switch (info.getPrimitiveCategory()) {
            case PrimitiveObjectInspector.PrimitiveCategory.BYTE, PrimitiveObjectInspector.PrimitiveCategory.SHORT, PrimitiveObjectInspector.PrimitiveCategory.INT -> Integer.valueOf(((IntWritable)writable).get());
            case PrimitiveObjectInspector.PrimitiveCategory.LONG -> Long.valueOf(((LongWritable)writable).get());
            case PrimitiveObjectInspector.PrimitiveCategory.FLOAT -> Float.valueOf(((FloatWritable)writable).get());
            case PrimitiveObjectInspector.PrimitiveCategory.DOUBLE -> Double.valueOf(((DoubleWritable)writable).get());
            case PrimitiveObjectInspector.PrimitiveCategory.DECIMAL -> ((HiveDecimalWritable)writable).getHiveDecimal();
            default -> throw new IllegalStateException(info.toString());
        }));
    }

    @Test
    public void testGetInt96TimestampConverterBigIntHiveType() {
        Timestamp timestamp = Timestamp.valueOf((String)"1998-10-03 09:58:31.231");
        NanoTime nanoTime = NanoTimeUtils.getNanoTime((Timestamp)timestamp, (ZoneId)ZoneOffset.UTC, (boolean)false);
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("value");
        Writable writable = this.getWritableFromBinaryConverter((TypeInfo)this.createHiveTypeInfo("bigint"), primitiveType, nanoTime.toBinary());
        LongWritable longWritable = (LongWritable)writable;
        Assert.assertEquals((long)nanoTime.getTimeOfDayNanos(), (long)longWritable.get());
    }

    @Test
    public void testGetTimestampConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"2018-06-15 15:12:20.0");
        NanoTime nanoTime = NanoTimeUtils.getNanoTime((Timestamp)timestamp, (ZoneId)ZoneOffset.UTC, (boolean)false);
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("value");
        Writable writable = this.getWritableFromBinaryConverter(null, primitiveType, nanoTime.toBinary());
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetTimestampProlepticConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"1572-06-15 15:12:20.0");
        NanoTime nanoTime = NanoTimeUtils.getNanoTime((Timestamp)timestamp, (ZoneId)ZoneOffset.UTC, (boolean)false);
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("value");
        Writable writable = this.getWritableFromBinaryConverter(null, primitiveType, nanoTime.toBinary());
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetInt64MillisTimestampConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"2018-07-15 15:12:20.112");
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.MILLIS);
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, timestamp.toEpochMilli());
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
    }

    @Test
    public void testGetInt64MillisTimestampProlepticConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"1572-07-15 15:12:20.112");
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.MILLIS);
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, timestamp.toEpochMilli());
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
    }

    @Test
    public void testGetInt64MicrosTimestampConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"2018-07-15 15:12:20.112233");
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.MICROS);
        long time = timestamp.toEpochSecond() * 1000000L + (long)(timestamp.getNanos() / 1000);
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, time);
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetInt64NanosTimestampConverter() throws Exception {
        Timestamp timestamp = Timestamp.valueOf((String)"2018-07-15 15:12:20.11223344");
        PrimitiveType primitiveType = this.createInt64TimestampType(false, LogicalTypeAnnotation.TimeUnit.NANOS);
        long time = timestamp.toEpochSecond() * 1000000000L + (long)timestamp.getNanos();
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, time);
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetInt64NanosAdjustedToUTCTimestampConverter() throws Exception {
        ZoneId zone = ZoneId.systemDefault();
        Timestamp timestamp = Timestamp.valueOf((String)"2018-07-15 15:12:20.11223344");
        PrimitiveType primitiveType = this.createInt64TimestampType(true, LogicalTypeAnnotation.TimeUnit.NANOS);
        long time = timestamp.toEpochSecond() * 1000000000L + (long)timestamp.getNanos();
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, time);
        TimestampWritableV2 timestampWritable = (TimestampWritableV2)writable;
        timestamp = Timestamp.ofEpochSecond((long)timestamp.toEpochSecond(), (long)timestamp.getNanos(), (ZoneId)zone);
        Assert.assertEquals((long)timestamp.toEpochMilli(), (long)timestampWritable.getTimestamp().toEpochMilli());
        Assert.assertEquals((long)timestamp.getNanos(), (long)timestampWritable.getNanos());
    }

    @Test
    public void testGetTextConverterForString() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value");
        String value = "this_is_a_value";
        Text textWritable = (Text)this.getWritableFromBinaryConverter((TypeInfo)TypeInfoFactory.stringTypeInfo, primitiveType, Binary.fromString((String)value));
        Assert.assertEquals((Object)value, (Object)textWritable.toString());
    }

    @Test
    public void testGetTextConverterForCharPadsValueWithSpacesTillLen() {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value");
        String value = "this_is_a_value";
        HiveCharWritable textWritable = (HiveCharWritable)this.getWritableFromBinaryConverter((TypeInfo)new CharTypeInfo(value.length() + 2), primitiveType, Binary.fromString((String)value));
        Assert.assertEquals((Object)(value + "  "), (Object)textWritable.toString());
    }

    @Test
    public void testGetTextConverterForCharTruncatesValueExceedingLen() {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value");
        String value = "this_is_a_value";
        HiveCharWritable textWritable = (HiveCharWritable)this.getWritableFromBinaryConverter((TypeInfo)new CharTypeInfo(6), primitiveType, Binary.fromString((String)value));
        Assert.assertEquals((Object)value.substring(0, 6), (Object)textWritable.toString());
    }

    @Test
    public void testGetTextConverterForVarcharTruncatesValueExceedingLen() {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value");
        String value = "this_is_a_value";
        HiveVarcharWritable textWritable = (HiveVarcharWritable)this.getWritableFromBinaryConverter((TypeInfo)new VarcharTypeInfo(6), primitiveType, Binary.fromString((String)value));
        Assert.assertEquals((Object)value.substring(0, 6), (Object)textWritable.toString());
    }

    @Test
    public void testGetTextConverterForVarchar() {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value");
        String value = "this_is_a_value";
        HiveVarcharWritable textWritable = (HiveVarcharWritable)this.getWritableFromBinaryConverter((TypeInfo)new VarcharTypeInfo(34), primitiveType, Binary.fromString((String)value));
        Assert.assertEquals((Object)value, (Object)textWritable.toString());
    }

    @Test
    public void testGetTextConverterNoHiveTypeInfo() {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("value");
        String value = "this_is_a_value";
        Text textWritable = (Text)this.getWritableFromBinaryConverter(null, primitiveType, Binary.fromString((String)value));
        Assert.assertEquals((Object)value, (Object)textWritable.toString());
    }

    @Test
    public void testGetIntConverterForTinyInt() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)false))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("tinyint"), primitiveType, 125);
        IntWritable intWritable = (IntWritable)writable;
        Assert.assertEquals((long)125L, (long)intWritable.get());
    }

    @Test
    public void testGetIntConverterForFloat() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("float"), primitiveType, 22225);
        FloatWritable floatWritable = (FloatWritable)writable;
        Assert.assertEquals((float)22225.0f, (float)floatWritable.get(), (float)0.0f);
    }

    @Test
    public void testGetIntConverterForBigint() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("bigint"), primitiveType, 22225);
        LongWritable longWritable = (LongWritable)writable;
        Assert.assertEquals((long)22225L, (long)longWritable.get());
    }

    @Test
    public void testGetIntConverterForDouble() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("double"), primitiveType, 22225);
        DoubleWritable doubleWritable = (DoubleWritable)writable;
        Assert.assertEquals((double)22225.0, (double)doubleWritable.get(), (double)0.0);
    }

    @Test
    public void testGetIntConverterForSmallint() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)false))).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter((TypeInfo)this.createHiveTypeInfo("smallint"), primitiveType, 32766);
        IntWritable intWritable = (IntWritable)writable;
        Assert.assertEquals((long)32766L, (long)intWritable.get());
    }

    @Test
    public void testGetIntConverterNoHiveTypeInfo() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("value");
        Writable writable = this.getWritableFromPrimitiveConverter(null, primitiveType, 12225);
        IntWritable intWritable = (IntWritable)writable;
        Assert.assertEquals((long)12225L, (long)intWritable.get());
    }

    @Test
    public void testGetDoubleConverter() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, null);
        converter.addDouble(3276.0);
        Writable writable = converterParent.getValue();
        DoubleWritable doubleWritable = (DoubleWritable)writable;
        Assert.assertEquals((double)3276.0, (double)doubleWritable.get(), (double)0.0);
    }

    @Test
    public void testGetBooleanConverter() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BOOLEAN).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, null);
        converter.addBoolean(true);
        Writable writable = converterParent.getValue();
        BooleanWritable booleanWritable = (BooleanWritable)writable;
        Assert.assertEquals((Object)true, (Object)booleanWritable.get());
    }

    @Test
    public void testGetFloatConverter() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, null);
        converter.addFloat(3276.0f);
        Writable writable = converterParent.getValue();
        FloatWritable floatWritable = (FloatWritable)writable;
        Assert.assertEquals((float)3276.0f, (float)floatWritable.get(), (float)0.0f);
    }

    @Test
    public void testGetFloatConverterForDouble() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FLOAT).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, (TypeInfo)this.createHiveTypeInfo("double"));
        converter.addFloat(3276.0f);
        Writable writable = converterParent.getValue();
        DoubleWritable doubleWritable = (DoubleWritable)writable;
        Assert.assertEquals((double)3276.0, (double)doubleWritable.get(), (double)0.0);
    }

    @Test
    public void testGetBinaryConverter() throws Exception {
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("value");
        Writable writable = this.getWritableFromBinaryConverter(null, primitiveType, Binary.fromString((String)"this_is_a_value"));
        BytesWritable byteWritable = (BytesWritable)writable;
        Assert.assertEquals((Object)"this_is_a_value", (Object)new String(byteWritable.getBytes()));
    }

    @Test
    public void testGetLongConverter() throws Exception {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveType primitiveType = (PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("value");
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, null);
        converter.addLong(12225L);
        Writable writable = converterParent.getValue();
        LongWritable longWritable = (LongWritable)writable;
        Assert.assertEquals((long)12225L, (long)longWritable.get());
    }

    @Test
    public void testGetConverterForList() {
        MyConverterParent converterParent = new MyConverterParent();
        GroupType type = (GroupType)Types.optionalList().element((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("value")).named("array");
        HiveGroupConverter f = HiveGroupConverter.getConverterFromDescription((GroupType)type, (int)1, (ConverterParent)converterParent, null);
        Assert.assertTrue((boolean)(f instanceof HiveCollectionConverter));
    }

    @Test
    public void testGetConverterForMap() {
        MyConverterParent converterParent = new MyConverterParent();
        GroupType type = (GroupType)((Types.MapBuilder)((Types.MapBuilder)Types.optionalMap().key((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("key"))).value((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("value"))).named("map");
        HiveGroupConverter f = HiveGroupConverter.getConverterFromDescription((GroupType)type, (int)1, (ConverterParent)converterParent, null);
        Assert.assertTrue((boolean)(f instanceof HiveCollectionConverter));
    }

    @Test
    public void testGetConverterForStruct() {
        MyConverterParent converterParent = new MyConverterParent();
        GroupType type = (GroupType)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).named("struct");
        HiveGroupConverter f = HiveGroupConverter.getConverterFromDescription((GroupType)type, (int)1, (ConverterParent)converterParent, null);
        Assert.assertTrue((boolean)(f instanceof HiveStructConverter));
    }

    private Writable getWritableFromBinaryConverter(TypeInfo hiveTypeInfo, PrimitiveType primitiveType, Binary valueToAdd) {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, (TypeInfo)hiveTypeInfo);
        ((ETypeConverter.BinaryConverter)converter).addBinary(valueToAdd);
        return converterParent.getValue();
    }

    private Writable getWritableFromPrimitiveConverter(TypeInfo hiveTypeInfo, PrimitiveType primitiveType, Integer valueToAdd) {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, (TypeInfo)hiveTypeInfo);
        converter.addInt(valueToAdd.intValue());
        return converterParent.getValue();
    }

    private Writable getWritableFromPrimitiveConverter(TypeInfo hiveTypeInfo, PrimitiveType primitiveType, Long valueToAdd) {
        MyConverterParent converterParent = new MyConverterParent();
        PrimitiveConverter converter = ETypeConverter.getNewConverter((PrimitiveType)primitiveType, (int)1, (ConverterParent)converterParent, (TypeInfo)hiveTypeInfo);
        converter.addLong(valueToAdd.longValue());
        return converterParent.getValue();
    }

    private PrimitiveTypeInfo createHiveTypeInfo(String typeName) {
        PrimitiveTypeInfo hiveTypeInfo = new PrimitiveTypeInfo();
        hiveTypeInfo.setTypeName(typeName);
        return hiveTypeInfo;
    }

    private PrimitiveType createInt64TimestampType(boolean isAdjustedToUTC, LogicalTypeAnnotation.TimeUnit unit) {
        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation logicalType = LogicalTypeAnnotation.TimestampLogicalTypeAnnotation.timestampType((boolean)isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)unit);
        PrimitiveType primitiveType = (PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)logicalType)).named("value");
        return primitiveType;
    }
}

