/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.VectorizedColumnReaderTestBase;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedParquetRecordReader;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestVectorizedColumnReader
extends VectorizedColumnReaderTestBase {
    static boolean isDictionaryEncoding = false;

    @BeforeClass
    public static void setup() throws IOException {
        TestVectorizedColumnReader.removeFile();
        TestVectorizedColumnReader.writeData(TestVectorizedColumnReader.initWriterFromFile(), isDictionaryEncoding);
    }

    @AfterClass
    public static void cleanup() throws IOException {
        TestVectorizedColumnReader.removeFile();
    }

    @Test
    public void testIntRead() throws Exception {
        this.intRead(isDictionaryEncoding);
        this.longReadInt(isDictionaryEncoding);
        this.floatReadInt(isDictionaryEncoding);
        this.doubleReadInt(isDictionaryEncoding);
    }

    @Test
    public void testLongRead() throws Exception {
        this.longRead(isDictionaryEncoding);
        this.floatReadLong(isDictionaryEncoding);
        this.doubleReadLong(isDictionaryEncoding);
    }

    @Test
    public void testTimestamp() throws Exception {
        this.timestampRead(isDictionaryEncoding);
        this.stringReadTimestamp(isDictionaryEncoding);
    }

    @Test
    public void testDoubleRead() throws Exception {
        this.doubleRead(isDictionaryEncoding);
        this.stringReadDouble(isDictionaryEncoding);
    }

    @Test
    public void testFloatRead() throws Exception {
        this.floatRead(isDictionaryEncoding);
        this.doubleReadFloat(isDictionaryEncoding);
    }

    @Test
    public void testBooleanRead() throws Exception {
        this.booleanRead();
        this.stringReadBoolean();
    }

    @Test
    public void testBinaryRead() throws Exception {
        this.binaryRead(isDictionaryEncoding);
    }

    @Test
    public void testStructRead() throws Exception {
        this.structRead(isDictionaryEncoding);
    }

    @Test
    public void testNestedStructRead() throws Exception {
        this.nestedStructRead0(isDictionaryEncoding);
        this.nestedStructRead1(isDictionaryEncoding);
    }

    @Test
    public void structReadSomeNull() throws Exception {
        this.structReadSomeNull(isDictionaryEncoding);
    }

    @Test
    public void decimalRead() throws Exception {
        this.decimalRead(isDictionaryEncoding);
        this.stringReadDecimal(isDictionaryEncoding);
    }

    @Override
    @Test
    public void verifyBatchOffsets() throws Exception {
        super.verifyBatchOffsets();
    }

    @Test
    public void testNullSplitForParquetReader() throws Exception {
        Configuration conf = new Configuration();
        conf.set("columns", "int32_field");
        conf.set("columns.types", "int");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        conf.set("parquet.read.schema", "message test { required int32 int32_field;}");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)true);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.PLAN, (String)"//tmp");
        Job vectorJob = new Job(conf, "read vector");
        ParquetInputFormat.setInputPaths((Job)vectorJob, (Path[])new Path[]{file});
        TestVectorizedColumnReader.initialVectorizedRowBatchCtx(conf);
        FileSplit fsplit = TestVectorizedColumnReader.getFileSplit(vectorJob);
        JobConf jobConf = new JobConf(conf);
        TestVectorizedParquetRecordReader testReader = new TestVectorizedParquetRecordReader((InputSplit)fsplit, jobConf);
        Assert.assertNull((String)"Test should return null split from getSplit() method", (Object)testReader.getSplit(null));
    }

    private class TestVectorizedParquetRecordReader
    extends VectorizedParquetRecordReader {
        public TestVectorizedParquetRecordReader(InputSplit oldInputSplit, JobConf conf) throws IOException {
            super(oldInputSplit, conf);
        }

        protected ParquetInputSplit getSplit(JobConf conf) throws IOException {
            return null;
        }
    }
}

