/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.AbstractTestParquetDirect;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestArrayCompatibility
extends AbstractTestParquetDirect {
    @Test
    public void testUnannotatedListOfPrimitives() throws Exception {
        MessageType fileSchema = (MessageType)((Types.GroupBuilder)Types.buildMessage().repeated(PrimitiveType.PrimitiveTypeName.INT32).named("list_of_ints")).named("UnannotatedListOfPrimitives");
        Path test = this.writeDirect("UnannotatedListOfPrimitives", fileSchema, new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_ints", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("list_of_ints", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{new IntWritable(34), new IntWritable(35), new IntWritable(36)});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testUnannotatedListOfGroups() throws Exception {
        Path test = this.writeDirect("UnannotatedListOfGroups", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().repeatedGroup().required(PrimitiveType.PrimitiveTypeName.FLOAT).named("x")).required(PrimitiveType.PrimitiveTypeName.FLOAT).named("y")).named("list_of_points")).named("UnannotatedListOfGroups"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_points", 0);
                rc.startGroup();
                rc.startField("x", 0);
                rc.addFloat(1.0f);
                rc.endField("x", 0);
                rc.startField("y", 1);
                rc.addFloat(1.0f);
                rc.endField("y", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("x", 0);
                rc.addFloat(2.0f);
                rc.endField("x", 0);
                rc.startField("y", 1);
                rc.addFloat(2.0f);
                rc.endField("y", 1);
                rc.endGroup();
                rc.endField("list_of_points", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{TestArrayCompatibility.record(new Writable[]{new FloatWritable(1.0f), new FloatWritable(1.0f)}), TestArrayCompatibility.record(new Writable[]{new FloatWritable(2.0f), new FloatWritable(2.0f)})});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testThriftPrimitiveInList() throws Exception {
        Path test = this.writeDirect("ThriftPrimitiveInList", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().requiredGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).repeated(PrimitiveType.PrimitiveTypeName.INT32).named("list_of_ints_tuple")).named("list_of_ints")).named("ThriftPrimitiveInList"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_ints", 0);
                rc.startGroup();
                rc.startField("list_of_ints_tuple", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("list_of_ints_tuple", 0);
                rc.endGroup();
                rc.endField("list_of_ints", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{new IntWritable(34), new IntWritable(35), new IntWritable(36)});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testThriftSingleFieldGroupInList() throws Exception {
        Path test = this.writeDirect("ThriftSingleFieldGroupInList", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.INT64).named("count")).named("single_element_groups_tuple")).named("single_element_groups")).named("ThriftSingleFieldGroupInList"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("single_element_groups", 0);
                rc.startGroup();
                rc.startField("single_element_groups_tuple", 0);
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(1234L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(2345L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.endField("single_element_groups_tuple", 0);
                rc.endGroup();
                rc.endField("single_element_groups", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{TestArrayCompatibility.record(new Writable[]{new LongWritable(1234L)}), TestArrayCompatibility.record(new Writable[]{new LongWritable(2345L)})});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testAvroPrimitiveInList() throws Exception {
        Path test = this.writeDirect("AvroPrimitiveInList", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().requiredGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).repeated(PrimitiveType.PrimitiveTypeName.INT32).named("array")).named("list_of_ints")).named("AvroPrimitiveInList"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("list_of_ints", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.addInteger(34);
                rc.addInteger(35);
                rc.addInteger(36);
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("list_of_ints", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{new IntWritable(34), new IntWritable(35), new IntWritable(36)});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testAvroSingleFieldGroupInList() throws Exception {
        Path test = this.writeDirect("AvroSingleFieldGroupInList", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.INT64).named("count")).named("array")).named("single_element_groups")).named("AvroSingleFieldGroupInList"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("single_element_groups", 0);
                rc.startGroup();
                rc.startField("array", 0);
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(1234L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(2345L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.endField("array", 0);
                rc.endGroup();
                rc.endField("single_element_groups", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{TestArrayCompatibility.record(new Writable[]{new LongWritable(1234L)}), TestArrayCompatibility.record(new Writable[]{new LongWritable(2345L)})});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testAmbiguousSingleFieldGroupInList() throws Exception {
        Path test = this.writeDirect("SingleFieldGroupInList", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.INT64).named("count")).named("single_element_group")).named("single_element_groups")).named("SingleFieldGroupInList"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("single_element_groups", 0);
                rc.startGroup();
                rc.startField("single_element_group", 0);
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(1234L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("count", 0);
                rc.addLong(2345L);
                rc.endField("count", 0);
                rc.endGroup();
                rc.endField("single_element_group", 0);
                rc.endGroup();
                rc.endField("single_element_groups", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{new LongWritable(1234L), new LongWritable(2345L)});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testMultiFieldGroupInList() throws Exception {
        Path test = this.writeDirect("MultiFieldGroupInList", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).repeatedGroup().required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("latitude")).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("longitude")).named("element")).named("locations")).named("MultiFieldGroupInList"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{TestArrayCompatibility.record(new Writable[]{new DoubleWritable(0.0), new DoubleWritable(0.0)}), TestArrayCompatibility.record(new Writable[]{new DoubleWritable(0.0), new DoubleWritable(180.0)})});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testNewOptionalGroupInList() throws Exception {
        Path test = this.writeDirect("NewOptionalGroupInList", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).repeatedGroup().optionalGroup().required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("latitude")).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("longitude")).named("element")).named("list")).named("locations")).named("NewOptionalGroupInList"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{TestArrayCompatibility.record(new Writable[]{new DoubleWritable(0.0), new DoubleWritable(0.0)}), null, TestArrayCompatibility.record(new Writable[]{new DoubleWritable(0.0), new DoubleWritable(180.0)})});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testNewRequiredGroupInList() throws Exception {
        Path test = this.writeDirect("NewRequiredGroupInList", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).repeatedGroup().requiredGroup().required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("latitude")).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("longitude")).named("element")).named("list")).named("locations")).named("NewRequiredGroupInList"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("list", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("list", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{TestArrayCompatibility.record(new Writable[]{new DoubleWritable(0.0), new DoubleWritable(180.0)}), TestArrayCompatibility.record(new Writable[]{new DoubleWritable(0.0), new DoubleWritable(0.0)})});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }

    @Test
    public void testHiveRequiredGroupInList() throws Exception {
        Path test = this.writeDirect("HiveRequiredGroupInList", (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().optionalGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.listType())).repeatedGroup().requiredGroup().required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("latitude")).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("longitude")).named("element")).named("bag")).named("locations")).named("HiveRequiredGroupInList"), new AbstractTestParquetDirect.DirectWriter(){

            @Override
            public void write(RecordConsumer rc) {
                rc.startMessage();
                rc.startField("locations", 0);
                rc.startGroup();
                rc.startField("bag", 0);
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(180.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.startGroup();
                rc.startField("element", 0);
                rc.startGroup();
                rc.startField("latitude", 0);
                rc.addDouble(0.0);
                rc.endField("latitude", 0);
                rc.startField("longitude", 1);
                rc.addDouble(0.0);
                rc.endField("longitude", 1);
                rc.endGroup();
                rc.endField("element", 0);
                rc.endGroup();
                rc.endField("bag", 0);
                rc.endGroup();
                rc.endField("locations", 0);
                rc.endMessage();
            }
        });
        ArrayWritable expected = TestArrayCompatibility.list(new Writable[]{TestArrayCompatibility.record(new Writable[]{new DoubleWritable(0.0), new DoubleWritable(180.0)}), TestArrayCompatibility.record(new Writable[]{new DoubleWritable(0.0), new DoubleWritable(0.0)})});
        List<ArrayWritable> records = TestArrayCompatibility.read(test);
        Assert.assertEquals((String)"Should have only one record", (long)1L, (long)records.size());
        TestArrayCompatibility.assertEquals("Should match expected record", expected, records.get(0));
    }
}

