/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractTestParquetDirect {
    public static FileSystem localFS = null;
    @Rule
    public final TemporaryFolder tempDir = new TemporaryFolder();
    private static final Joiner COMMA = Joiner.on((String)",");

    @BeforeClass
    public static void initializeFS() throws IOException {
        localFS = FileSystem.getLocal((Configuration)new Configuration());
    }

    public Path writeDirect(String name, MessageType type, DirectWriter writer) throws IOException {
        File temp = this.tempDir.newFile(name + ".parquet");
        temp.deleteOnExit();
        temp.delete();
        Path path = new Path(temp.getPath());
        ParquetWriter parquetWriter = new ParquetWriter(path, (WriteSupport)new DirectWriteSupport(type, writer, new HashMap<String, String>()));
        parquetWriter.write(null);
        parquetWriter.close();
        return path;
    }

    public static ArrayWritable record(Writable ... fields) {
        return new ArrayWritable(Writable.class, fields);
    }

    public static ArrayWritable list(Writable ... elements) {
        return new ArrayWritable(ArrayWritable.class, (Writable[])new ArrayWritable[]{new ArrayWritable(Writable.class, elements)});
    }

    public static String toString(ArrayWritable arrayWritable) {
        Writable[] writables = arrayWritable.get();
        Object[] strings = new String[writables.length];
        for (int i = 0; i < writables.length; ++i) {
            strings[i] = writables[i] instanceof ArrayWritable ? AbstractTestParquetDirect.toString((ArrayWritable)writables[i]) : String.valueOf(writables[i]);
        }
        return Arrays.toString(strings);
    }

    public static void assertEquals(String message, ArrayWritable expected, ArrayWritable actual) {
        Assert.assertEquals((String)message, (Object)AbstractTestParquetDirect.toString(expected), (Object)AbstractTestParquetDirect.toString(actual));
    }

    public static List<ArrayWritable> read(Path parquetFile) throws IOException {
        ArrayList<ArrayWritable> records = new ArrayList<ArrayWritable>();
        RecordReader reader = new MapredParquetInputFormat().getRecordReader((InputSplit)new FileSplit(parquetFile, 0L, AbstractTestParquetDirect.fileLength(parquetFile), (String[])null), new JobConf(), null);
        NullWritable alwaysNull = (NullWritable)reader.createKey();
        ArrayWritable record = (ArrayWritable)reader.createValue();
        while (reader.next((Object)alwaysNull, (Object)record)) {
            records.add(record);
            record = (ArrayWritable)reader.createValue();
        }
        return records;
    }

    public static long fileLength(Path localFile) throws IOException {
        return localFS.getFileStatus(localFile).getLen();
    }

    public void deserialize(Writable record, List<String> columnNames, List<String> columnTypes) throws Exception {
        ParquetHiveSerDe serde = new ParquetHiveSerDe();
        Properties props = new Properties();
        props.setProperty("columns", COMMA.join(columnNames));
        props.setProperty("columns.types", COMMA.join(columnTypes));
        serde.initialize(null, props, null);
        serde.deserialize(record);
    }

    public static class DirectWriteSupport
    extends WriteSupport<Void> {
        private RecordConsumer recordConsumer;
        private final MessageType type;
        private final DirectWriter writer;
        private final Map<String, String> metadata;

        private DirectWriteSupport(MessageType type, DirectWriter writer, Map<String, String> metadata) {
            this.type = type;
            this.writer = writer;
            this.metadata = metadata;
        }

        public WriteSupport.WriteContext init(Configuration configuration) {
            return new WriteSupport.WriteContext(this.type, this.metadata);
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.recordConsumer = recordConsumer;
        }

        public void write(Void record) {
            this.writer.write(this.recordConsumer);
        }
    }

    public static interface DirectWriter {
        public void write(RecordConsumer var1);
    }
}

