/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSplit;
import org.apache.hadoop.hive.ql.io.orc.TestOrcFile;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.OrcConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOrcSplit {
    private JobConf conf;
    private FileSystem fs;
    private Path root;
    private ObjectInspector inspector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setup() throws Exception {
        this.conf = new JobConf();
        this.conf.set("transactional", "true");
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_TRANSACTIONAL_TABLE_SCAN.varname, true);
        this.conf.set("transactional_properties", "default");
        this.conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        this.conf.set("schema.evolution.columns", DummyRow.getColumnNamesProperty());
        this.conf.set("schema.evolution.columns.types", DummyRow.getColumnTypesProperty());
        this.conf.setBoolean(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED.varname, true);
        this.conf.set(HiveConf.ConfVars.HIVE_ORC_SPLIT_STRATEGY.varname, "BI");
        OrcConf.ROWS_BETWEEN_CHECKS.setLong((Configuration)this.conf, 1L);
        Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
        this.root = new Path(workDir, "TestOrcSplit.testDump");
        this.fs = this.root.getFileSystem((Configuration)this.conf);
        this.root = this.fs.makeQualified(this.root);
        this.fs.delete(this.root, true);
        Class<TestOrcFile> clazz = TestOrcFile.class;
        synchronized (TestOrcFile.class) {
            this.inspector = ObjectInspectorFactory.getReflectionObjectInspector(DummyRow.class, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private List<OrcInputFormat.SplitStrategy<?>> getSplitStrategies() throws Exception {
        this.conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        OrcInputFormat.Context context = new OrcInputFormat.Context((Configuration)this.conf);
        OrcInputFormat.FileGenerator gen = new OrcInputFormat.FileGenerator(context, () -> this.fs, this.root, false, null);
        AcidUtils.Directory adi = gen.call();
        return OrcInputFormat.determineSplitStrategies(null, (OrcInputFormat.Context)context, (FileSystem)adi.getFs(), (Path)adi.getPath(), (List)adi.getFiles(), (List)adi.getDeleteDeltas(), null, null, (boolean)true);
    }

    @Test
    public void testDeleteDeltasFiltering() throws Exception {
        int bucket = 0;
        AcidOutputFormat.Options options = new AcidOutputFormat.Options((Configuration)this.conf).filesystem(this.fs).bucket(bucket).writingBase(false).minimumWriteId(1L).maximumWriteId(1L).inspector(this.inspector).reporter(Reporter.NULL).recordIdColumn(1).finalDestination(this.root);
        OrcRecordUpdater updater = new OrcRecordUpdater(this.root, options);
        for (int i = 1; i <= 5; i += 2) {
            options.minimumWriteId((long)i).maximumWriteId((long)i);
            updater = new OrcRecordUpdater(this.root, options);
            updater.insert(options.getMinimumWriteId(), (Object)new DummyRow(i, 0L, options.getMinimumWriteId(), bucket));
            updater.close(false);
            options.minimumWriteId((long)(i + 1)).maximumWriteId((long)(i + 1));
            updater = new OrcRecordUpdater(this.root, options);
            updater.delete(options.getMinimumWriteId(), (Object)new DummyRow(-1L, 0L, i, bucket));
            updater.close(false);
        }
        this.conf.set("hive.txn.valid.txns", new ValidReadTxnList(new long[0], new BitSet(), 1000L, Long.MAX_VALUE).writeToString());
        this.conf.set("hive.txn.valid.writeids", "tbl:6:9223372036854775807::");
        List<OrcInputFormat.SplitStrategy<?>> splitStrategies = this.getSplitStrategies();
        Assert.assertEquals((long)1L, (long)splitStrategies.size());
        List splits = ((OrcInputFormat.ACIDSplitStrategy)splitStrategies.get(0)).getSplits();
        Assert.assertEquals((long)3L, (long)splits.size());
        Assert.assertEquals((long)3L, (long)((OrcSplit)splits.get(0)).getDeltas().size());
        Assert.assertEquals((long)2L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(0)).getDeltas().get(0)).getMinWriteId());
        Assert.assertEquals((long)2L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(0)).getDeltas().get(0)).getMaxWriteId());
        Assert.assertEquals((long)4L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(0)).getDeltas().get(1)).getMinWriteId());
        Assert.assertEquals((long)4L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(0)).getDeltas().get(1)).getMaxWriteId());
        Assert.assertEquals((long)6L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(0)).getDeltas().get(2)).getMinWriteId());
        Assert.assertEquals((long)6L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(0)).getDeltas().get(2)).getMaxWriteId());
        Assert.assertEquals((long)2L, (long)((OrcSplit)splits.get(1)).getDeltas().size());
        Assert.assertEquals((long)4L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(1)).getDeltas().get(0)).getMinWriteId());
        Assert.assertEquals((long)4L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(1)).getDeltas().get(0)).getMaxWriteId());
        Assert.assertEquals((long)6L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(1)).getDeltas().get(1)).getMinWriteId());
        Assert.assertEquals((long)6L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(1)).getDeltas().get(1)).getMaxWriteId());
        Assert.assertEquals((long)1L, (long)((OrcSplit)splits.get(2)).getDeltas().size());
        Assert.assertEquals((long)6L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(2)).getDeltas().get(0)).getMinWriteId());
        Assert.assertEquals((long)6L, (long)((AcidInputFormat.DeltaMetaData)((OrcSplit)splits.get(2)).getDeltas().get(0)).getMaxWriteId());
    }

    public static class DummyRow {
        LongWritable field;
        RecordIdentifier ROW__ID;

        DummyRow(long val, long rowId, long origTxn, int bucket) {
            this.field = new LongWritable(val);
            bucket = BucketCodec.V1.encode(new AcidOutputFormat.Options(null).bucket(bucket));
            this.ROW__ID = new RecordIdentifier(origTxn, bucket, rowId);
        }

        static String getColumnNamesProperty() {
            return "field";
        }

        static String getColumnTypesProperty() {
            return "bigint";
        }
    }
}

