/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.FixAcidKeyIndex;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.orc.OrcFile;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFixAcidKeyIndex {
    public static final Logger LOG = LoggerFactory.getLogger(TestFixAcidKeyIndex.class);
    @Rule
    public TestName testCaseName = new TestName();
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target/tmp"));
    Configuration conf;
    Path testFilePath;
    FileSystem fs;

    @Before
    public void openFileSystem() throws Exception {
        this.conf = new Configuration();
        this.fs = FileSystem.getLocal((Configuration)this.conf);
        this.testFilePath = new Path(this.workDir, "TestFixAcidKeyIndex." + this.testCaseName.getMethodName() + ".orc");
        this.fs.delete(this.testFilePath, false);
    }

    void createTestAcidFile(Path path, int numRows, TestKeyIndexBuilder indexBuilder) throws Exception {
        FileSystem fs = path.getFileSystem(this.conf);
        fs.delete(path, true);
        String typeStr = "struct<operation:int,originalTransaction:bigint,bucket:int,rowId:bigint,currentTransaction:bigint,row:struct<a:int,b:struct<c:int>,d:string>>";
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeStr);
        Writer writer = OrcFile.createWriter((Path)path, (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)this.conf).fileSystem(fs).inspector(OrcStruct.createObjectInspector((TypeInfo)typeInfo)).compress(CompressionKind.NONE).callback((OrcFile.WriterCallback)indexBuilder).stripeSize(128L));
        OrcStruct row = new OrcStruct(6);
        row.setFieldValue(0, (Object)new IntWritable(0));
        row.setFieldValue(1, (Object)new LongWritable(1L));
        row.setFieldValue(2, (Object)new IntWritable(0));
        LongWritable rowId = new LongWritable();
        row.setFieldValue(3, (Object)rowId);
        row.setFieldValue(4, (Object)new LongWritable(1L));
        OrcStruct rowField = new OrcStruct(3);
        row.setFieldValue(5, (Object)rowField);
        IntWritable a = new IntWritable();
        rowField.setFieldValue(0, (Object)a);
        OrcStruct b = new OrcStruct(1);
        rowField.setFieldValue(1, (Object)b);
        IntWritable c = new IntWritable();
        b.setFieldValue(0, (Object)c);
        Text d = new Text();
        rowField.setFieldValue(2, (Object)d);
        for (int r = 0; r < numRows; ++r) {
            rowId.set((long)r);
            a.set(r * 42);
            c.set(r * 10001);
            d.set(Integer.toHexString(r));
            indexBuilder.addKey(0, 1L, 0, rowId.get());
            writer.addRow((Object)row);
        }
        indexBuilder.stopWritingKeyIndex();
        writer.close();
    }

    void runIndexCheck(Path orcFile, File outFile) throws Exception {
        PrintStream origOut = System.out;
        FileOutputStream myOut = new FileOutputStream(outFile);
        System.setOut(new PrintStream(myOut));
        String[] checkArgs = new String[]{"--check-only", orcFile.toString()};
        FixAcidKeyIndex.main((String[])checkArgs);
        System.out.flush();
        System.setOut(origOut);
    }

    void checkValidKeyIndex(Path orcFile) throws Exception {
        String outputFilename = "fixAcidKeyIndex.out";
        File outFile = new File(this.workDir.toString(), outputFilename);
        this.runIndexCheck(orcFile, outFile);
        String outputAsString = FileUtils.readFileToString((File)outFile);
        System.out.println(outputAsString);
        Assert.assertTrue((boolean)outputAsString.contains("acid key index is valid"));
    }

    void checkInvalidKeyIndex(Path orcFile) throws Exception {
        String outputFilename = "fixAcidKeyIndex.out";
        File outFile = new File(this.workDir.toString(), outputFilename);
        this.runIndexCheck(orcFile, outFile);
        String outputAsString = FileUtils.readFileToString((File)outFile);
        System.out.println(outputAsString);
        Assert.assertTrue((boolean)outputAsString.contains("acid key index is invalid"));
    }

    void runFixIndex(Path orcFile, File outFile) throws Exception {
        PrintStream origOut = System.out;
        FileOutputStream myOut = new FileOutputStream(outFile);
        System.setOut(new PrintStream(myOut));
        String[] checkArgs = new String[]{"--recover", orcFile.toString()};
        FixAcidKeyIndex.main((String[])checkArgs);
        System.out.flush();
        System.setOut(origOut);
    }

    void fixInvalidIndex(Path orcFile) throws Exception {
        String outputFilename = "fixAcidKeyIndex.out";
        File outFile = new File(this.workDir.toString(), outputFilename);
        this.runFixIndex(orcFile, outFile);
        String outputAsString = FileUtils.readFileToString((File)outFile);
        System.out.println(outputAsString);
        Assert.assertTrue((boolean)outputAsString.contains("Fixed acid key index"));
    }

    void fixValidIndex(Path orcFile) throws Exception {
        String outputFilename = "fixAcidKeyIndex.out";
        File outFile = new File(this.workDir.toString(), outputFilename);
        this.runFixIndex(orcFile, outFile);
        String outputAsString = FileUtils.readFileToString((File)outFile);
        System.out.println(outputAsString);
        Assert.assertTrue((boolean)outputAsString.contains("No need to recover"));
    }

    @Test
    public void testValidKeyIndex() throws Exception {
        this.createTestAcidFile(this.testFilePath, 0, new GoodKeyIndexBuilder());
        this.checkValidKeyIndex(this.testFilePath);
        this.fixValidIndex(this.testFilePath);
        this.createTestAcidFile(this.testFilePath, 100, new GoodKeyIndexBuilder());
        this.checkValidKeyIndex(this.testFilePath);
        this.fixValidIndex(this.testFilePath);
        this.createTestAcidFile(this.testFilePath, 12000, new GoodKeyIndexBuilder());
        this.checkValidKeyIndex(this.testFilePath);
        this.fixValidIndex(this.testFilePath);
    }

    @Test
    public void testInvalidKeyIndex() throws Exception {
        this.createTestAcidFile(this.testFilePath, 100, new BadKeyIndexBuilder());
        this.checkInvalidKeyIndex(this.testFilePath);
        this.fixInvalidIndex(this.testFilePath);
        this.createTestAcidFile(this.testFilePath, 12000, new BadKeyIndexBuilder());
        this.checkInvalidKeyIndex(this.testFilePath);
        this.fixInvalidIndex(this.testFilePath);
        this.createTestAcidFile(this.testFilePath, 12000, new FaultyKeyIndexBuilder());
        this.checkInvalidKeyIndex(this.testFilePath);
        this.fixInvalidIndex(this.testFilePath);
    }

    @Test
    public void testMissingKeyIndex() throws Exception {
        this.createTestAcidFile(this.testFilePath, 100, new MissingKeyIndexBuilder());
        this.checkInvalidKeyIndex(this.testFilePath);
        this.fixInvalidIndex(this.testFilePath);
        this.createTestAcidFile(this.testFilePath, 12000, new MissingKeyIndexBuilder());
        this.checkInvalidKeyIndex(this.testFilePath);
        this.fixInvalidIndex(this.testFilePath);
    }

    @Test
    public void testNonAcidOrcFile() throws Exception {
        Path baseSrcDir = new Path(System.getProperty("basedir")).getParent();
        Path dataFilesPath = new Path(new Path(baseSrcDir, "data"), "files");
        File origOrcFile = new File(dataFilesPath.toString(), "alltypesorc");
        File testOrcFile = new File(this.workDir.toString(), "alltypesorc");
        FileUtils.copyFile((File)origOrcFile, (File)testOrcFile);
        String outputFilename = "fixAcidKeyIndex.out";
        File outFile = new File(this.workDir.toString(), outputFilename);
        this.runIndexCheck(new Path(testOrcFile.getPath()), outFile);
        String outputAsString = FileUtils.readFileToString((File)outFile);
        System.out.println(outputAsString);
        Assert.assertTrue((boolean)outputAsString.contains("is not an acid file"));
    }

    static abstract class TestKeyIndexBuilder
    extends OrcRecordUpdater.KeyIndexBuilder
    implements OrcFile.WriterCallback {
        TestKeyIndexBuilder() {
        }

        abstract void stopWritingKeyIndex();
    }

    static class GoodKeyIndexBuilder
    extends TestKeyIndexBuilder {
        GoodKeyIndexBuilder() {
        }

        @Override
        public void stopWritingKeyIndex() {
        }
    }

    static class BadKeyIndexBuilder
    extends TestKeyIndexBuilder {
        boolean writeAcidIndexInfo = true;

        BadKeyIndexBuilder() {
        }

        @Override
        public void stopWritingKeyIndex() {
            LOG.info("*** Stop writing index!");
            this.writeAcidIndexInfo = false;
        }

        public void preStripeWrite(OrcFile.WriterContext context) throws IOException {
            LOG.info("*** writeAcidIndexInfo: " + this.writeAcidIndexInfo);
            if (!this.writeAcidIndexInfo) {
                return;
            }
            super.preStripeWrite(context);
        }
    }

    static class FaultyKeyIndexBuilder
    extends TestKeyIndexBuilder {
        FaultyKeyIndexBuilder() {
        }

        public void preStripeWrite(OrcFile.WriterContext context) throws IOException {
            this.lastRowId -= 5L;
            super.preStripeWrite(context);
        }

        @Override
        void stopWritingKeyIndex() {
        }
    }

    static class MissingKeyIndexBuilder
    extends TestKeyIndexBuilder {
        MissingKeyIndexBuilder() {
        }

        @Override
        public void stopWritingKeyIndex() {
        }

        public void preFooterWrite(OrcFile.WriterContext context) throws IOException {
            if (this.numKeysCurrentStripe > 0L) {
                this.preStripeWrite(context);
            }
            context.getWriter().addUserMetadata("hive.acid.stats", StandardCharsets.UTF_8.encode(this.acidStats.serialize()));
        }
    }
}

