/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.filter;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.filter.FilterContext;
import org.junit.Assert;
import org.junit.Test;

public class TestFilterContext {
    private int[] makeValidSelected() {
        int[] selected = new int[512];
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = i * 2;
        }
        return selected;
    }

    private int[] makeInvalidSelected() {
        int[] selected = new int[512];
        Arrays.fill(selected, 1);
        return selected;
    }

    @Test
    public void testInitFilterContext() {
        VectorizedRowBatch mutableFilterContext = new VectorizedRowBatch(0);
        int[] selected = this.makeValidSelected();
        mutableFilterContext.setFilterContext(true, selected, selected.length);
        FilterContext filterContext = mutableFilterContext.immutable();
        Assert.assertEquals((Object)true, (Object)filterContext.isSelectedInUse());
        Assert.assertEquals((long)512L, (long)filterContext.getSelectedSize());
        Assert.assertEquals((long)512L, (long)filterContext.getSelected().length);
    }

    @Test
    public void testResetFilterContext() {
        VectorizedRowBatch mutableFilterContext = new VectorizedRowBatch(0);
        int[] selected = this.makeValidSelected();
        mutableFilterContext.setFilterContext(true, selected, selected.length);
        FilterContext filterContext = mutableFilterContext.immutable();
        Assert.assertEquals((Object)true, (Object)filterContext.isSelectedInUse());
        Assert.assertEquals((long)512L, (long)filterContext.getSelectedSize());
        Assert.assertEquals((long)512L, (long)filterContext.getSelected().length);
        filterContext.reset();
        Assert.assertEquals((Object)false, (Object)filterContext.isSelectedInUse());
        Assert.assertEquals((long)0L, (long)filterContext.getSelectedSize());
    }

    @Test(expected=AssertionError.class)
    public void testInitInvalidFilterContext() {
        VectorizedRowBatch mutableFilterContext = new VectorizedRowBatch(0);
        int[] selected = this.makeInvalidSelected();
        mutableFilterContext.setFilterContext(true, selected, selected.length);
    }

    @Test
    public void testBorrowSelected() {
        VectorizedRowBatch mutableFilterContext = new VectorizedRowBatch(0);
        mutableFilterContext.setFilterContext(true, new int[]{100, 200}, 2);
        int[] borrowedSelected = mutableFilterContext.updateSelected(1);
        Assert.assertEquals((long)2L, (long)borrowedSelected.length);
        Assert.assertEquals((long)100L, (long)borrowedSelected[0]);
        Assert.assertEquals((long)200L, (long)borrowedSelected[1]);
        borrowedSelected = mutableFilterContext.updateSelected(3);
        Assert.assertEquals((long)3L, (long)borrowedSelected.length);
        Assert.assertEquals((long)0L, (long)borrowedSelected[0]);
        Assert.assertEquals((long)0L, (long)borrowedSelected[1]);
        Assert.assertEquals((long)0L, (long)borrowedSelected[2]);
    }
}

