/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.esriJson;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.esriJson.UnenclosedGeoJsonRecordReader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.Assert;
import org.junit.Test;

public class TestUnenclosedGeoJsonRecordReader {
    private TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taid) throws Exception {
        try {
            return (TaskAttemptContext)TaskAttemptContext.class.getConstructor(Configuration.class, TaskAttemptID.class).newInstance(conf, taid);
        }
        catch (Exception e) {
            Class<?> clazz = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
            return (TaskAttemptContext)clazz.getConstructor(Configuration.class, TaskAttemptID.class).newInstance(conf, taid);
        }
    }

    private UnenclosedGeoJsonRecordReader getReader() throws IOException {
        return new UnenclosedGeoJsonRecordReader();
    }

    int[] getRecordIndexesInFile(String resource, int start, int end) throws Exception {
        return this.getRecordIndexesInFile(this.getReader(), resource, start, end, false);
    }

    int[] getRecordIndexesInFile(String resource, int start, int end, boolean flag) throws Exception {
        return this.getRecordIndexesInFile(this.getReader(), resource, start, end, flag);
    }

    int[] getRecordIndexesInFile(UnenclosedGeoJsonRecordReader reader, String resource, int start, int end, boolean flag) throws Exception {
        Path path = new Path(this.getClass().getResource("/json/" + resource).getFile());
        FileSplit split = new FileSplit(path, (long)start, (long)(end - start), new String[0]);
        try {
            TaskAttemptContext tac = this.createTaskAttemptContext(new Configuration(), new TaskAttemptID());
            reader.initialize((InputSplit)split, tac);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        LinkedList<Integer> linesList = new LinkedList<Integer>();
        LongWritable key = null;
        Text value = null;
        try {
            while (reader.nextKeyValue()) {
                key = reader.getCurrentKey();
                value = reader.getCurrentValue();
                int line = flag ? (int)key.get() : value.toString().charAt(40) - 48;
                linesList.add(line);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        int[] lines = new int[linesList.size()];
        for (int i = 0; i < linesList.size(); ++i) {
            lines[i] = (Integer)linesList.get(i);
        }
        return lines;
    }

    @Test
    public void TestArbitrarySplitLocations() throws Exception {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 0, 57));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 0, 58));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 0, 59));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 56, 191));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 37, 191));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 57, 191));
        Assert.assertArrayEquals((int[])new int[]{2, 3}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 58, 191));
        Assert.assertArrayEquals((int[])new int[]{6, 7, 8}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 342, 493));
        Assert.assertArrayEquals((int[])new int[]{9}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 506, 585));
        Assert.assertArrayEquals((int[])new int[]{9}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 507, 585));
        Assert.assertArrayEquals((int[])new int[]{9}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-simple.json", 508, 585));
    }

    @Test
    public void TestTypeAttribute() throws Exception {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-type.json", 0, 71, true));
        Assert.assertArrayEquals((int[])new int[]{74}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-type.json", 71, 148, true));
        Assert.assertArrayEquals((int[])new int[]{148, 222}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-type.json", 148, 223, true));
        Assert.assertArrayEquals((int[])new int[]{296}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-type.json", 223, 298, true));
        Assert.assertArrayEquals((int[])new int[]{370}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-type.json", 298, 401, true));
        Assert.assertArrayEquals((int[])new int[]{444}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-type.json", 401, 518, true));
        Assert.assertArrayEquals((int[])new int[]{518}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-type.json", 518, 593, true));
    }

    @Test
    public void TestEscape() throws Exception {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 0, 61));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 0, 62));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 60, 200));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 35, 200));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 61, 200));
        Assert.assertArrayEquals((int[])new int[]{2, 3}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 62, 200));
        Assert.assertArrayEquals((int[])new int[]{4, 5, 6}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 249, 407));
        Assert.assertArrayEquals((int[])new int[]{7, 8}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 414, 565));
        Assert.assertArrayEquals((int[])new int[]{8}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 474, 565));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 31, 62));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 39, 62));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 40, 62));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 41, 62));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 42, 62));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 61, 102));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInFile("unenclosed-geojs-escape.json", 61, 103));
    }
}

