/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.esriJson;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.esriJson.UnenclosedEsriJsonRecordReader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TestUnenclosedEsriJsonRecordMrv1 {
    private UnenclosedEsriJsonRecordReader getReaderFor(String resource, int start, int end) throws IOException {
        Path path = new Path(this.getClass().getResource("/json/" + resource).getFile());
        JobConf conf = new JobConf();
        FileSplit split = new FileSplit(path, (long)start, (long)(end - start), new String[0]);
        return new UnenclosedEsriJsonRecordReader((InputSplit)split, (Configuration)conf);
    }

    int[] getRecordIndexesInReader(UnenclosedEsriJsonRecordReader reader) throws IOException {
        return this.getRecordIndexesInReader(reader, false);
    }

    int[] getRecordIndexesInReader(UnenclosedEsriJsonRecordReader reader, boolean flag) throws IOException {
        LinkedList<Integer> linesList = new LinkedList<Integer>();
        LongWritable key = reader.createKey();
        Text value = reader.createValue();
        while (reader.next(key, value)) {
            int line = flag ? (int)key.get() : value.toString().charAt(23) - 48;
            linesList.add(line);
        }
        int[] lines = new int[linesList.size()];
        for (int i = 0; i < linesList.size(); ++i) {
            lines[i] = (Integer)linesList.get(i);
        }
        return lines;
    }

    @Test
    public void TestArbitrarySplitLocations() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 0, 40)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 0, 41)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 0, 42)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 39, 123)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 20, 123)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 40, 123)));
        Assert.assertArrayEquals((int[])new int[]{2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 41, 123)));
        Assert.assertArrayEquals((int[])new int[]{6, 7, 8}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 240, 340)));
        Assert.assertArrayEquals((int[])new int[]{9}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 353, 415)));
        Assert.assertArrayEquals((int[])new int[]{9}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 354, 415)));
        Assert.assertArrayEquals((int[])new int[]{9}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 355, 415)));
    }

    @Test
    public void TestEachOnce() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 0, 63)));
        Assert.assertArrayEquals((int[])new int[]{2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 63, 121)));
        Assert.assertArrayEquals((int[])new int[]{4}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 121, 187)));
        Assert.assertArrayEquals((int[])new int[]{5, 6}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 187, 264)));
        Assert.assertArrayEquals((int[])new int[]{7, 8}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 264, 352)));
        Assert.assertArrayEquals((int[])new int[]{9}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 352, 412)));
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 0, 23)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-simple.json", 23, 41)));
    }

    @Test
    public void TestWhitespace() throws IOException {
        int[] rslt = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-return.json", 0, 222), true);
        Assert.assertEquals((long)4L, (long)rslt.length);
        int[] before = null;
        int[] after = null;
        before = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-return.json", 0, 56), true);
        after = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-return.json", 56, 222), true);
        Assert.assertEquals((long)4L, (long)(before.length + after.length));
        before = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-return.json", 0, 57), true);
        after = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-return.json", 57, 222), true);
        Assert.assertEquals((long)4L, (long)(before.length + after.length));
        before = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-return.json", 0, 58), true);
        after = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-return.json", 58, 222), true);
        Assert.assertEquals((long)4L, (long)(before.length + after.length));
    }

    @Ignore
    public void TestComma() throws IOException {
        int[] rslt = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-comma.json", 0, 222), true);
        Assert.assertEquals((long)4L, (long)rslt.length);
        int[] before = null;
        int[] after = null;
        before = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-comma.json", 0, 56), true);
        after = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-comma.json", 56, 222), true);
        Assert.assertEquals((long)4L, (long)(before.length + after.length));
        before = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-comma.json", 0, 57), true);
        after = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-comma.json", 57, 222), true);
        Assert.assertEquals((long)4L, (long)(before.length + after.length));
        before = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-comma.json", 0, 58), true);
        after = this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-comma.json", 58, 222), true);
        Assert.assertEquals((long)4L, (long)(before.length + after.length));
    }

    @Test
    public void TestEscape() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 0, 44)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 0, 45)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 0, 46)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 43, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 19, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 44, 140)));
        Assert.assertArrayEquals((int[])new int[]{2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 45, 140)));
        Assert.assertArrayEquals((int[])new int[]{4, 5, 6}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 181, 289)));
        Assert.assertArrayEquals((int[])new int[]{8}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 336, 400)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 14, 45)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 22, 45)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 23, 45)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 24, 45)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 25, 45)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 44, 68)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-escape.json", 44, 69)));
    }

    @Test
    public void TestEscQuoteLast() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc1.json", 0, 44)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc1.json", 0, 45)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc1.json", 0, 46)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc1.json", 19, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc1.json", 25, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc1.json", 44, 140)));
    }

    @Test
    public void TestEscAposLast() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc2.json", 0, 44)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc2.json", 0, 45)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc2.json", 0, 46)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc2.json", 19, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc2.json", 26, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc2.json", 43, 140)));
    }

    @Test
    public void TestEscSlashLast() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc3.json", 0, 44)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc3.json", 0, 45)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc3.json", 0, 46)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc3.json", 19, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc3.json", 26, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc3.json", 44, 140)));
    }

    @Test
    public void TestEscCloseLast() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc4.json", 0, 44)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc4.json", 0, 45)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc4.json", 0, 46)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc4.json", 19, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc4.json", 25, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc4.json", 44, 140)));
    }

    @Test
    public void TestEscOpenLast() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc5.json", 0, 44)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc5.json", 0, 45)));
        Assert.assertArrayEquals((int[])new int[]{0, 1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc5.json", 0, 46)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc5.json", 19, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc5.json", 26, 140)));
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc5.json", 44, 140)));
        Assert.assertArrayEquals((int[])new int[]{6}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc5.json", 268, 280)));
    }

    @Test
    public void TestEscPoints() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc-points.json", 0, 74), true));
        Assert.assertArrayEquals((int[])new int[]{0, 75}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc-points.json", 0, 76), true));
        Assert.assertArrayEquals((int[])new int[]{75, 146}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-esc-points.json", 70, 148), true));
    }

    @Test
    public void TestCharacters() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-chars.json", 0, 42), true));
        Assert.assertArrayEquals((int[])new int[]{0, 42}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-chars.json", 0, 43), true));
        Assert.assertArrayEquals((int[])new int[]{42}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-chars.json", 38, 43), true));
        Assert.assertArrayEquals((int[])new int[]{42}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-chars.json", 39, 43), true));
        Assert.assertArrayEquals((int[])new int[]{84, 126, 168}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-chars.json", 43, 200), true));
        Assert.assertArrayEquals((int[])new int[]{210, 252, 294, 336}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-chars.json", 200, 400), true));
    }

    @Test
    public void TestGeomFirst() throws IOException {
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-geom-first.json", 32, 54)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-geom-first.json", 48, 54)));
        Assert.assertArrayEquals((int[])new int[]{1}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-geom-first.json", 49, 54)));
        Assert.assertArrayEquals((int[])new int[]{0}, (int[])this.getRecordIndexesInReader(this.getReaderFor("unenclosed-json-geom-first.json", 0, 52), true));
    }
}

