/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.esriJson;

import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.esriJson.EnclosedEsriJsonRecordReader;
import org.apache.hadoop.hive.ql.io.esriJson.EnclosedGeoJsonRecordReader;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.Assert;
import org.junit.Test;

public class TestEnclosedGeoJsonRecordReader {
    private TaskAttemptContext createTaskAttemptContext(Configuration conf, TaskAttemptID taid) throws Exception {
        try {
            return (TaskAttemptContext)TaskAttemptContext.class.getConstructor(Configuration.class, TaskAttemptID.class).newInstance(conf, taid);
        }
        catch (Exception e) {
            Class<?> clazz = Class.forName("org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl");
            return (TaskAttemptContext)clazz.getConstructor(Configuration.class, TaskAttemptID.class).newInstance(conf, taid);
        }
    }

    long[] getRecordIndexesInFile(String resource, int start, int end) throws Exception {
        EnclosedGeoJsonRecordReader reader = new EnclosedGeoJsonRecordReader();
        Path path = new Path(this.getClass().getResource("/json/" + resource).getFile());
        FileSplit split = new FileSplit(path, (long)start, (long)(end - start), new String[0]);
        try {
            TaskAttemptContext tac = this.createTaskAttemptContext(new Configuration(), new TaskAttemptID());
            reader.initialize((InputSplit)split, tac);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        LinkedList<Long> linesList = new LinkedList<Long>();
        LongWritable key = null;
        try {
            while (reader.nextKeyValue()) {
                key = reader.getCurrentKey();
                linesList.add(key.get());
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        long[] offsets = new long[linesList.size()];
        for (int i = 0; i < linesList.size(); ++i) {
            offsets[i] = (Long)linesList.get(i);
        }
        reader.close();
        return offsets;
    }

    @Test
    public void TestArbitrarySplitLocations() throws Exception {
        long[] rslt = this.getRecordIndexesInFile("sample-geojs-area.json", 0, 208);
        Assert.assertEquals((long)1L, (long)rslt.length);
    }

    @Test
    public void TestMrv1() throws Exception {
        Path path = new Path(this.getClass().getResource("/json/sample-geojs-area.json").getFile());
        JobConf conf = new JobConf();
        org.apache.hadoop.mapred.FileSplit split = new org.apache.hadoop.mapred.FileSplit(path, 0L, 208L, new String[0]);
        EnclosedEsriJsonRecordReader reader = new EnclosedEsriJsonRecordReader((org.apache.hadoop.mapred.InputSplit)split, (Configuration)conf);
        LongWritable key = reader.createKey();
        Text value = reader.createValue();
        while (reader.next(key, value)) {
        }
        reader.close();
    }
}

