/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.SkippingTextInputFormat;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSkippingTextInputFormat {
    private Configuration conf;
    private JobConf job;
    private FileSystem fileSystem;
    private Path testDir;
    Reporter reporter;
    private Path dataDir;
    private CompressionCodecFactory compressionCodecs = null;
    private CompressionCodec codec;

    @Before
    public void setUp() throws IOException {
        this.conf = new Configuration();
        this.job = new JobConf(this.conf);
        TableDesc tblDesc = Utilities.defaultTd;
        PartitionDesc partDesc = new PartitionDesc(tblDesc, null);
        LinkedHashMap<Path, PartitionDesc> pt = new LinkedHashMap<Path, PartitionDesc>();
        pt.put(new Path("/tmp/testfolder"), partDesc);
        MapredWork mrwork = new MapredWork();
        mrwork.getMapWork().setPathToPartitionInfo(pt);
        Utilities.setMapRedWork((Configuration)this.job, (MapredWork)mrwork, (Path)new Path("/tmp/" + System.getProperty("user.name"), "hive"));
        this.fileSystem = FileSystem.getLocal((Configuration)this.conf);
        this.testDir = new Path(System.getProperty("test.tmp.dir", System.getProperty("user.dir", new File(".").getAbsolutePath())) + "/TestSkippingTextInputFormat");
        this.reporter = Reporter.NULL;
        this.fileSystem.delete(this.testDir, true);
        this.dataDir = new Path(this.testDir, "datadir");
        this.fileSystem.mkdirs(this.dataDir);
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystem.delete(this.testDir, true);
    }

    @Test
    public void testSkipFileSplits() throws Exception {
        FileSystem fs = this.dataDir.getFileSystem((Configuration)this.job);
        FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{this.dataDir});
        Path dir1_file1 = new Path(this.dataDir, "skipfile1.csv");
        this.writeTextFile(dir1_file1, "dir1_header\ndir1_file1_line1\ndir1_file1_line2\ndir1_footer");
        SkippingTextInputFormat inputFormat = new SkippingTextInputFormat();
        inputFormat.configure(this.job, 1, 1);
        FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{dir1_file1});
        InputSplit[] splits = inputFormat.getSplits(this.job, 2);
        Assert.assertTrue((splits.length == 2 ? 1 : 0) != 0);
        ArrayList<String> received = new ArrayList<String>();
        for (int i = 0; i < splits.length; ++i) {
            RecordReader reader = inputFormat.getRecordReader(splits[i], this.job, this.reporter);
            HiveInputFormat.HiveInputSplit hiveInputSplit = new HiveInputFormat.HiveInputSplit(splits[i], inputFormat.getClass().getName());
            Assert.assertTrue((hiveInputSplit.getInputSplit().getClass() == FileSplit.class ? 1 : 0) != 0);
            LongWritable key = (LongWritable)reader.createKey();
            Text value = (Text)reader.createValue();
            while (reader.next((Object)key, (Object)value)) {
                received.add(value.toString());
            }
            reader.close();
        }
        Assert.assertTrue((received.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((!((String)received.get(0)).contains("header") ? 1 : 0) != 0);
        Assert.assertTrue((!((String)received.get(received.size() - 1)).contains("footer") ? 1 : 0) != 0);
    }

    @Test
    public void testSkipCompressedFileSplits() throws Exception {
        FileSystem fs = this.dataDir.getFileSystem((Configuration)this.job);
        FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{this.dataDir});
        Path dir1_file1 = new Path(this.dataDir, "skipfile1.csv.bz2");
        this.writeTextFile(dir1_file1, "dir1_header\ndir1_file1_line1\ndir1_file1_line2\ndir1_footer");
        SkippingTextInputFormat inputFormat = new SkippingTextInputFormat();
        inputFormat.configure(this.job, 1, 1);
        this.compressionCodecs = new CompressionCodecFactory(this.conf);
        this.codec = this.compressionCodecs.getCodec(dir1_file1);
        System.out.println("Codec: " + this.codec);
        FileInputFormat.setInputPaths((JobConf)this.job, (Path[])new Path[]{dir1_file1});
        InputSplit[] splits = inputFormat.getSplits(this.job, 1);
        Assert.assertTrue((splits.length == 1 ? 1 : 0) != 0);
        ArrayList<String> received = new ArrayList<String>();
        for (int i = 0; i < splits.length; ++i) {
            RecordReader reader = inputFormat.getRecordReader(splits[i], this.job, this.reporter);
            HiveInputFormat.HiveInputSplit hiveInputSplit = new HiveInputFormat.HiveInputSplit(splits[i], inputFormat.getClass().getName());
            System.out.println(hiveInputSplit.getInputSplit().getClass());
            Assert.assertTrue((FileSplit.class == hiveInputSplit.getInputSplit().getClass() ? 1 : 0) != 0);
            System.out.println("Split: [" + i + "] " + hiveInputSplit.getStart() + " => " + hiveInputSplit.getLength());
            LongWritable key = (LongWritable)reader.createKey();
            Text value = (Text)reader.createValue();
            while (reader.next((Object)key, (Object)value)) {
                System.out.println("Splits:" + i + " Val: " + value);
                received.add(value.toString());
            }
            reader.close();
        }
    }

    private void writeTextFile(Path file, String content) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.fileSystem.create(file));
        writer.write(content);
        writer.close();
    }
}

