/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Scanner;
import java.util.ServiceLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.SingleFileSystem;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestSingleFileSystem {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private File f1;
    private String f1path;
    private FileSystem fs;

    @Test
    public void testAllRegistered() {
        ServiceLoader<FileSystem> fs = ServiceLoader.load(FileSystem.class);
        HashSet knownFileSystems = new HashSet();
        for (FileSystem fileSystem : fs) {
            knownFileSystems.add(fileSystem.getClass());
        }
        for (Class<?> sfsClass : SingleFileSystem.class.getDeclaredClasses()) {
            if (!SingleFileSystem.class.isAssignableFrom(sfsClass) || knownFileSystems.contains(sfsClass)) continue;
            Assert.fail((String)(sfsClass + " is not registered!"));
        }
    }

    @Before
    public void before() throws Exception {
        this.f1 = this.folder.newFile("f1");
        Files.write((CharSequence)"asd", (File)this.f1, (Charset)Charsets.ISO_8859_1);
        this.f1path = this.f1.toURI().toString();
        Path p = new Path("sfs+" + this.f1path);
        this.fs = p.getFileSystem(new Configuration());
    }

    @Test
    public void testGetFileStatus() throws Exception {
        this.assertSfsDir(this.fs.getFileStatus(new Path("sfs+" + this.folder.getRoot().toURI())));
        this.assertSfsDir(this.fs.getFileStatus(new Path("sfs+" + this.f1path)));
        this.assertSfsDir(this.fs.getFileStatus(new Path("sfs+" + this.f1path + "/#SINGLEFILE#")));
        this.assertSfsFile(this.fs.getFileStatus(new Path("sfs+" + this.f1path + "/#SINGLEFILE#/f1")));
    }

    @Test(expected=FileNotFoundException.class)
    public void testGetFileStatusOfUnknown() throws Exception {
        this.assertSfsFile(this.fs.getFileStatus(new Path("sfs+" + this.f1path + "/#SINGLEFILE#/unknown")));
    }

    @Test
    public void testListStatusSingleFileDir() throws Exception {
        String targetSfsPath = "sfs+" + this.f1path + "/#SINGLEFILE#";
        FileStatus[] list = this.fs.listStatus(new Path(targetSfsPath));
        Assert.assertEquals((long)1L, (long)list.length);
        Assert.assertEquals((Object)(targetSfsPath + "/f1"), (Object)list[0].getPath().toString());
    }

    @Test
    public void testListStatusSingleFileDirEndingInSlash() throws Exception {
        String targetSfsPath = "sfs+" + this.f1path + "/#SINGLEFILE#/";
        FileStatus[] list = this.fs.listStatus(new Path(targetSfsPath));
        Assert.assertEquals((long)1L, (long)list.length);
        Assert.assertEquals((Object)(targetSfsPath + "f1"), (Object)list[0].getPath().toString());
    }

    @Test(expected=FileNotFoundException.class)
    public void testListSingleFileDirOfNonExistentFile() throws Exception {
        String targetSfsPath = "sfs+" + this.f1path + "nonExistent/#SINGLEFILE#/";
        this.fs.listStatus(new Path(targetSfsPath));
    }

    @Test
    public void testListStatusTargetFile() throws Exception {
        String targetSfsPath = "sfs+" + this.f1path + "/#SINGLEFILE#/f1";
        FileStatus[] list = this.fs.listStatus(new Path(targetSfsPath));
        Assert.assertEquals((long)1L, (long)list.length);
        Assert.assertEquals((Object)targetSfsPath, (Object)list[0].getPath().toString());
    }

    @Test(expected=FileNotFoundException.class)
    public void testListStatusNonTargetFile() throws Exception {
        String targetSfsPath = "sfs+" + this.f1path + "/#SINGLEFILE#/unknown";
        this.fs.listStatus(new Path(targetSfsPath));
    }

    @Test
    public void testListStatusFile() throws Exception {
        String targetSfsPath = "sfs+" + this.f1path;
        FileStatus[] list = this.fs.listStatus(new Path(targetSfsPath));
        Assert.assertEquals((long)1L, (long)list.length);
        Assert.assertEquals((Object)(targetSfsPath + "/#SINGLEFILE#"), (Object)list[0].getPath().toString());
    }

    @Test
    public void testListStatusRoot() throws Exception {
        this.folder.newFolder("folder");
        String targetSfsPath = "sfs+" + this.folder.getRoot().toURI().toString();
        FileStatus[] list = this.fs.listStatus(new Path(targetSfsPath));
        Assert.assertEquals((long)2L, (long)list.length);
        HashSet<CallSite> expectedPaths = new HashSet<CallSite>();
        expectedPaths.add((CallSite)((Object)(targetSfsPath + "f1")));
        expectedPaths.add((CallSite)((Object)(targetSfsPath + "folder")));
        HashSet<String> paths = new HashSet<String>();
        for (FileStatus fileStatus : list) {
            paths.add(fileStatus.getPath().toString());
        }
        Assert.assertEquals(expectedPaths, paths);
    }

    @Test
    public void testOpenTargetFile() throws Exception {
        try (FSDataInputStream ret = this.fs.open(new Path("sfs+" + this.f1path + "/#SINGLEFILE#/f1"));
             Scanner sc = new Scanner((InputStream)ret);){
            String line = sc.nextLine();
            Assert.assertEquals((Object)"asd", (Object)line);
        }
    }

    @Test(expected=FileNotFoundException.class)
    public void testOpenUnknownFileInSingleFileDir() throws Exception {
        this.fs.open(new Path("sfs+" + this.f1path + "/#SINGLEFILE#/unknown"));
    }

    @Test(expected=IOException.class)
    public void testOpenSinglefileDir() throws Exception {
        this.fs.open(new Path("sfs+" + this.f1path + "/#SINGLEFILE#/"));
    }

    @Test(expected=IOException.class)
    public void testOpenRealTargetFile() throws Exception {
        this.fs.open(new Path("sfs+" + this.f1path));
    }

    private void assertSfsDir(FileStatus fileStatus) {
        Assert.assertTrue((boolean)fileStatus.isDirectory());
        Assert.assertTrue((boolean)fileStatus.getPath().toUri().getScheme().startsWith("sfs+"));
    }

    private void assertSfsFile(FileStatus fileStatus) {
        Assert.assertTrue((!fileStatus.isDirectory() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)fileStatus.getPath().toUri().getScheme().startsWith("sfs+"));
    }
}

