/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.BucketCodec;
import org.junit.Assert;
import org.junit.Test;

public class TestBucketCodec {
    @Test(expected=IllegalArgumentException.class)
    public void testGetBucketCodecInvalidVersion() {
        BucketCodec.getCodec((int)4);
    }

    @Test
    public void testGetBucketCodecVersion0() {
        BucketCodec codec = BucketCodec.getCodec((int)0);
        Assert.assertEquals((Object)BucketCodec.V0, (Object)codec);
        Assert.assertEquals((long)0L, (long)codec.getVersion());
        Assert.assertEquals((long)7L, (long)codec.decodeWriterId(7));
        Assert.assertEquals((long)0L, (long)codec.decodeStatementId(100));
        Assert.assertEquals((long)0L, (long)codec.decodeStatementId(-10));
        AcidOutputFormat.Options options = new AcidOutputFormat.Options(null).bucket(7);
        Assert.assertEquals((long)7L, (long)codec.encode(options));
    }

    @Test
    public void testGetBucketCodecVersion1() {
        BucketCodec codec = BucketCodec.getCodec((int)1);
        Assert.assertEquals((Object)BucketCodec.V1, (Object)codec);
        Assert.assertEquals((long)1L, (long)codec.getVersion());
        Assert.assertEquals((long)2748L, (long)codec.decodeWriterId(180092928));
        Assert.assertEquals((long)2748L, (long)codec.decodeStatementId(2748));
        AcidOutputFormat.Options options = new AcidOutputFormat.Options(null).bucket(7).statementId(16);
        Assert.assertEquals((long)537329680L, (long)codec.encode(options));
        AcidOutputFormat.Options optionsNeg = new AcidOutputFormat.Options(null).bucket(7).statementId(-1);
        AcidOutputFormat.Options optionsZero = new AcidOutputFormat.Options(null).bucket(7).statementId(0);
        Assert.assertEquals((long)codec.encode(optionsZero), (long)codec.encode(optionsNeg));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetBucketCodecVersion1EncodeNegativeBucketId() {
        BucketCodec.getCodec((int)1).encode(new AcidOutputFormat.Options(null).bucket(-1).statementId(16));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetBucketCodecVersion1EncodeMaxBucketId() {
        BucketCodec.getCodec((int)1).encode(new AcidOutputFormat.Options(null).bucket(4096).statementId(16));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetBucketCodecVersion1EncodeNegativeStatementId() {
        BucketCodec.getCodec((int)1).encode(new AcidOutputFormat.Options(null).bucket(7).statementId(-2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetBucketCodecVersion1EncodeMaxStatementId() {
        BucketCodec.getCodec((int)1).encode(new AcidOutputFormat.Options(null).bucket(7).statementId(4096));
    }

    @Test
    public void testBucketIdTakesExtra8BitsFromStmtId() {
        AcidOutputFormat.Options options = new AcidOutputFormat.Options(null).bucket(5000).statementId(12).maxStmtId(100);
        int encode = BucketCodec.getCodec((int)1).encode(options);
        Assert.assertEquals((Object)"10001100", (Object)Integer.toString(BucketCodec.V1.decodeStatementId(encode), 2));
        Assert.assertEquals((Object)"1110001000", (Object)Integer.toString(BucketCodec.V1.decodeWriterId(encode), 2));
    }

    @Test
    public void testBucketIdTakesExtra4BitsFromStmtId() {
        AcidOutputFormat.Options options = new AcidOutputFormat.Options(null).bucket(65535).statementId(150).maxStmtId(150);
        int encode = BucketCodec.getCodec((int)1).encode(options);
        Assert.assertEquals((Object)"111110010110", (Object)Integer.toString(BucketCodec.V1.decodeStatementId(encode), 2));
        Assert.assertEquals((Object)"111111111111", (Object)Integer.toString(BucketCodec.V1.decodeWriterId(encode), 2));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoRoomToOverflowBucketId() {
        BucketCodec.getCodec((int)1).encode(new AcidOutputFormat.Options(null).bucket(65536).statementId(1).maxStmtId(150));
    }

    @Test
    public void testBucketIdRollOver() {
        for (int i = 0; i < 16384; ++i) {
            int encode = BucketCodec.getCodec((int)1).encode(new AcidOutputFormat.Options(null).bucket(i).statementId(10).maxStmtId(512));
            Assert.assertEquals((long)(i % 4096), (long)BucketCodec.getCodec((int)1).decodeWriterId(encode));
            if (i < 4096) {
                Assert.assertEquals((long)10L, (long)BucketCodec.getCodec((int)1).decodeStatementId(encode));
                continue;
            }
            if (i < 8192) {
                Assert.assertEquals((long)1034L, (long)BucketCodec.getCodec((int)1).decodeStatementId(encode));
                continue;
            }
            if (i < 12288) {
                Assert.assertEquals((long)2058L, (long)BucketCodec.getCodec((int)1).decodeStatementId(encode));
                continue;
            }
            Assert.assertEquals((long)3082L, (long)BucketCodec.getCodec((int)1).decodeStatementId(encode));
        }
    }
}

