/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.ptf.BufferedVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorCountStar;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFGroupBatches;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFOperator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorPTFDesc;
import org.apache.hadoop.hive.ql.plan.VectorPTFInfo;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorPTFGroupBatches {
    private Configuration getConf(int batchSize) {
        HiveConf hconf = new HiveConf();
        HiveConf.setIntVar((Configuration)hconf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_TESTING_REDUCER_BATCH_SIZE, (int)batchSize);
        return hconf;
    }

    @Test
    public void testTestForwardIterationWithSpill() throws HiveException {
        int numberedOfBufferedBatches = 1;
        int batchSize = 2;
        Configuration hconf = this.getConf(batchSize);
        VectorPTFGroupBatches groupBatches = new VectorPTFGroupBatches(hconf, numberedOfBufferedBatches);
        AtomicLong rowindex = new AtomicLong(-1L);
        this.init(groupBatches);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        Assert.assertEquals((long)numberedOfBufferedBatches, (long)groupBatches.bufferedBatches.size());
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{0L, 1L}});
        Assert.assertEquals((long)2L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertTrue((boolean)groupBatches.blocks.get((int)0).didSpillToDisk);
        Assert.assertEquals((long)batchSize, (long)groupBatches.blocks.get((int)0).spillRowCount);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.get((int)0).startBatchIndex);
        Assert.assertEquals((long)numberedOfBufferedBatches, (long)groupBatches.bufferedBatches.size());
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{2L, 3L}});
        Assert.assertEquals((long)4L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertTrue((boolean)groupBatches.blocks.get((int)1).didSpillToDisk);
        Assert.assertEquals((long)batchSize, (long)groupBatches.blocks.get((int)1).spillRowCount);
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.get((int)1).startBatchIndex);
        Assert.assertEquals((long)numberedOfBufferedBatches, (long)groupBatches.bufferedBatches.size());
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertTrue((boolean)groupBatches.blocks.get((int)2).didSpillToDisk);
        Assert.assertEquals((long)batchSize, (long)groupBatches.blocks.get((int)2).spillRowCount);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)2).startBatchIndex);
        Assert.assertEquals((long)numberedOfBufferedBatches, (long)groupBatches.bufferedBatches.size());
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{6L, 7L}});
        Assert.assertEquals((long)8L, (long)groupBatches.size());
    }

    @Test
    public void testTestForwardBackwardIterationWithSpill() throws HiveException {
        int numberedOfBufferedBatches = 1;
        int batchSize = 2;
        Configuration hconf = this.getConf(batchSize);
        VectorPTFGroupBatches groupBatches = new VectorPTFGroupBatches(hconf, numberedOfBufferedBatches);
        AtomicLong rowindex = new AtomicLong(-1L);
        this.init(groupBatches);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        Assert.assertEquals((long)numberedOfBufferedBatches, (long)groupBatches.bufferedBatches.size());
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        boolean hasMoved = groupBatches.previousBlock();
        Assert.assertTrue((String)"previousBlock should have returned true while moving to M[[2,3]]", (boolean)hasMoved);
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        Assert.assertTrue((boolean)groupBatches.blocks.get((int)0).didSpillToDisk);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)0).spillRowCount);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.get((int)0).startBatchIndex);
        Assert.assertTrue((boolean)groupBatches.blocks.get((int)1).didSpillToDisk);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)1).spillRowCount);
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.get((int)1).startBatchIndex);
        Assert.assertTrue((boolean)groupBatches.blocks.get((int)2).didSpillToDisk);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)2).spillRowCount);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)2).startBatchIndex);
        Assert.assertEquals((long)numberedOfBufferedBatches, (long)groupBatches.bufferedBatches.size());
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{2L, 3L}});
        hasMoved = groupBatches.nextBlock();
        Assert.assertTrue((String)"nextBlock should have returned true while moving to M[[4,5]]", (boolean)hasMoved);
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        Assert.assertEquals((long)numberedOfBufferedBatches, (long)groupBatches.bufferedBatches.size());
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        hasMoved = groupBatches.nextBlock();
        Assert.assertFalse((String)"nextBlock should have returned false, cannot move forward", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        hasMoved = groupBatches.previousBlock();
        Assert.assertTrue((String)"previousBlock should have returned true while moving to M[[2,3]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{2L, 3L}});
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        hasMoved = groupBatches.previousBlock();
        Assert.assertTrue((String)"previousBlock should have returned true while moving to M[[0,1]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{0L, 1L}});
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        hasMoved = groupBatches.previousBlock();
        Assert.assertFalse((String)"previousBlock should have returned false, cannot move backward", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{0L, 1L}});
        Assert.assertEquals((long)6L, (long)groupBatches.size());
    }

    @Test
    public void testRandomBlockJump() throws HiveException {
        int numberedOfBufferedBatches = 1;
        int batchSize = 2;
        Configuration hconf = this.getConf(batchSize);
        VectorPTFGroupBatches groupBatches = new VectorPTFGroupBatches(hconf, numberedOfBufferedBatches);
        AtomicLong rowindex = new AtomicLong(-1L);
        this.init(groupBatches);
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.size());
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        groupBatches.jumpToFirstBlock();
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{0L, 1L}});
        Assert.assertEquals((long)3L, (long)groupBatches.blocks.size());
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        groupBatches.jumpToLastBlock();
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)6L, (long)groupBatches.size());
    }

    @Test
    public void testJumpToLastWithUnspilledBatches() throws HiveException {
        int numberedOfBufferedBatches = 1;
        int batchSize = 2;
        Configuration hconf = this.getConf(batchSize);
        VectorPTFGroupBatches groupBatches = new VectorPTFGroupBatches(hconf, numberedOfBufferedBatches);
        AtomicLong rowindex = new AtomicLong(-1L);
        this.init(groupBatches);
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.size());
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        groupBatches.jumpToLastBlock();
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)3L, (long)groupBatches.blocks.size());
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        groupBatches.jumpToFirstBlock();
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{0L, 1L}});
        Assert.assertEquals((long)3L, (long)groupBatches.blocks.size());
        Assert.assertEquals((long)6L, (long)groupBatches.size());
    }

    @Test
    public void testWithNonSingleBatchBlocks() throws HiveException {
        int numberedOfBufferedBatches = 2;
        int batchSize = 2;
        Configuration hconf = this.getConf(batchSize);
        VectorPTFGroupBatches groupBatches = new VectorPTFGroupBatches(hconf, numberedOfBufferedBatches);
        AtomicLong rowindex = new AtomicLong(-1L);
        this.init(groupBatches);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{0L, 1L}});
        Assert.assertEquals((long)2L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        this.assertBufferedBatchValues(groupBatches, {0L, 1L}, {2L, 3L});
        Assert.assertEquals((long)4L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.size());
        Assert.assertTrue((boolean)groupBatches.blocks.get((int)0).didSpillToDisk);
        Assert.assertEquals((long)(batchSize * numberedOfBufferedBatches), (long)groupBatches.blocks.get((int)0).spillRowCount);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.get((int)0).startBatchIndex);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)0).spillBatchCount);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        boolean hasMoved = groupBatches.previousBlock();
        Assert.assertTrue((String)"previousBlock should have returned true while moving to M[[0,1],[2,3]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, {0L, 1L}, {2L, 3L});
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.size());
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.get((int)1).spillBatchCount);
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        hasMoved = groupBatches.nextBlock();
        Assert.assertTrue((String)"nextBlock should have returned true while moving to M[[4,5]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)0).spillBatchCount);
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.get((int)1).spillBatchCount);
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        hasMoved = groupBatches.nextBlock();
        Assert.assertFalse((String)"nextBlock should have returned false while staying on M[[4,5]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)0).spillBatchCount);
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.get((int)1).spillBatchCount);
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, {4L, 5L}, {6L, 7L});
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)0).spillBatchCount);
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.get((int)1).spillBatchCount);
        Assert.assertEquals((long)8L, (long)groupBatches.size());
        hasMoved = groupBatches.previousBlock();
        Assert.assertTrue((String)"previousBlock should have returned true while moving to M[[0,1],[2,3]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, {0L, 1L}, {2L, 3L});
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)0).spillBatchCount);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)1).spillBatchCount);
        Assert.assertEquals((long)8L, (long)groupBatches.size());
        hasMoved = groupBatches.nextBlock();
        Assert.assertTrue((String)"nextBlock should have returned true while moving to M[[4,5],[6,7]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, {4L, 5L}, {6L, 7L});
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)0).spillBatchCount);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)1).spillBatchCount);
        Assert.assertEquals((long)8L, (long)groupBatches.size());
    }

    @Test
    public void testWithNonSingleBatchAndSingleRowBatches() throws HiveException {
        int numberedOfBufferedBatches = 2;
        int batchSize = 2;
        Configuration hconf = this.getConf(batchSize);
        VectorPTFGroupBatches groupBatches = new VectorPTFGroupBatches(hconf, numberedOfBufferedBatches);
        AtomicLong rowindex = new AtomicLong(-1L);
        this.init(groupBatches);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{0L, 1L}});
        Assert.assertEquals((long)2L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        this.assertBufferedBatchValues(groupBatches, {0L, 1L}, {2L, 3L});
        Assert.assertEquals((long)4L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(1, rowindex), false);
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.size());
        Assert.assertTrue((boolean)groupBatches.blocks.get((int)0).didSpillToDisk);
        Assert.assertEquals((long)(batchSize * numberedOfBufferedBatches), (long)groupBatches.blocks.get((int)0).spillRowCount);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.get((int)0).startBatchIndex);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)0).spillBatchCount);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L}});
        Assert.assertEquals((long)5L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(1, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, {4L}, {5L});
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(1, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{6L}});
        Assert.assertEquals((long)7L, (long)groupBatches.size());
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.get((int)0).startBatchIndex);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.get((int)0).startRowIndex[0]);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)0).spillBatchCount);
        Assert.assertEquals((long)4L, (long)groupBatches.blocks.get((int)0).spillRowCount);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)1).startBatchIndex);
        Assert.assertEquals((long)4L, (long)groupBatches.blocks.get((int)1).startRowIndex[0]);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)1).spillBatchCount);
        Assert.assertEquals((long)2L, (long)groupBatches.blocks.get((int)1).spillRowCount);
        groupBatches.jumpToFirstBlock();
        Assert.assertEquals((long)4L, (long)groupBatches.blocks.get((int)2).startBatchIndex);
        Assert.assertEquals((long)6L, (long)groupBatches.blocks.get((int)2).startRowIndex[0]);
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.get((int)2).spillBatchCount);
        Assert.assertEquals((long)1L, (long)groupBatches.blocks.get((int)2).spillRowCount);
        groupBatches.jumpToLastBlock();
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{6L}});
        Assert.assertEquals((long)2L, (long)groupBatches.bufferedBatches.size());
        Assert.assertEquals((long)1L, (long)groupBatches.currentBufferedBatchCount);
        this.assertBufferedBatchValues(groupBatches, {6L}, {2L, 3L});
        groupBatches.previousBlock();
        this.assertBufferedBatchValues(groupBatches, {4L}, {5L});
        Assert.assertEquals((long)2L, (long)groupBatches.bufferedBatches.size());
    }

    @Test
    public void testIterateOverBatches() throws HiveException {
        int numberedOfBufferedBatches = 2;
        int batchSize = 2;
        Configuration hconf = this.getConf(batchSize);
        VectorPTFGroupBatches groupBatches = new VectorPTFGroupBatches(hconf, numberedOfBufferedBatches);
        AtomicLong rowindex = new AtomicLong(-1L);
        this.init(groupBatches);
        Assert.assertEquals((long)0L, (long)groupBatches.blocks.size());
        Assert.assertEquals((long)0L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{0L, 1L}});
        Assert.assertEquals((long)2L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, {0L, 1L}, {2L, 3L});
        Assert.assertEquals((long)4L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{4L, 5L}});
        Assert.assertEquals((long)6L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, {4L, 5L}, {6L, 7L});
        Assert.assertEquals((long)8L, (long)groupBatches.size());
        groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{8L, 9L}});
        Assert.assertEquals((long)10L, (long)groupBatches.size());
        groupBatches.jumpToFirstBlock();
        this.assertBufferedBatchValues(groupBatches, {0L, 1L}, {2L, 3L});
        Assert.assertEquals((long)10L, (long)groupBatches.size());
        boolean hasMoved = groupBatches.nextBlock();
        Assert.assertTrue((String)"nextBlock should have returned true while moving to M[[4,5]] M[[6,7]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, {4L, 5L}, {6L, 7L});
        Assert.assertEquals((long)10L, (long)groupBatches.size());
        hasMoved = groupBatches.nextBlock();
        Assert.assertTrue((String)"nextBlock should have returned true while moving to M[[8,9]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{8L, 9L}});
        Assert.assertEquals((long)10L, (long)groupBatches.size());
        hasMoved = groupBatches.nextBlock();
        Assert.assertFalse((String)"nextBlock should have returned false while staying on  M[[8,9]]", (boolean)hasMoved);
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{8L, 9L}});
        Assert.assertEquals((long)10L, (long)groupBatches.size());
        groupBatches.jumpToFirstBlock();
        this.assertBufferedBatchValues(groupBatches, {0L, 1L}, {2L, 3L});
        Assert.assertEquals((long)10L, (long)groupBatches.size());
        while (groupBatches.nextBlock()) {
        }
        this.assertBufferedBatchValues(groupBatches, new Long[][]{{8L, 9L}});
        Assert.assertEquals((long)10L, (long)groupBatches.size());
    }

    @Test
    public void testFindInmemoryBatchIndex() {
        VectorPTFGroupBatches batches = new VectorPTFGroupBatches(new Configuration(), 2);
        batches.currentBufferedBatchCount = 2;
        batches.inMemoryStartRowIndex = Arrays.asList(7, 9, 10);
        Assert.assertEquals((long)-1L, (long)batches.findInMemoryBatchIndex(0));
        Assert.assertEquals((long)-1L, (long)batches.findInMemoryBatchIndex(1));
        Assert.assertEquals((long)-1L, (long)batches.findInMemoryBatchIndex(6));
        Assert.assertEquals((long)0L, (long)batches.findInMemoryBatchIndex(7));
        Assert.assertEquals((long)0L, (long)batches.findInMemoryBatchIndex(8));
        Assert.assertEquals((long)1L, (long)batches.findInMemoryBatchIndex(9));
        Assert.assertEquals((long)2L, (long)batches.findInMemoryBatchIndex(10));
    }

    @Test
    public void testGetAt() {
        for (int i = 1; i < 20; ++i) {
            int j = 1;
            while (j < 20) {
                int numberOfBufferedBatches = i;
                int batchSize = j++;
                try {
                    this.runTestGetAt(batchSize, numberOfBufferedBatches);
                    this.runTestGetAtRandomBatchSize(batchSize, numberOfBufferedBatches);
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failed while testing getAt for batchSize: %d, numberOfBufferedBatches: %d", batchSize, numberOfBufferedBatches), t);
                }
            }
        }
    }

    private void runTestGetAt(int batchSize, int numberOfBufferedBatches) throws HiveException {
        Configuration hconf = this.getConf(batchSize);
        VectorPTFGroupBatches groupBatches = new VectorPTFGroupBatches(hconf, numberOfBufferedBatches);
        AtomicLong rowindex = new AtomicLong(-1L);
        this.init(groupBatches);
        for (int b = 0; b < 20; ++b) {
            groupBatches.bufferGroupBatch(this.createNewBatch(batchSize, rowindex), false);
        }
        groupBatches.preFinishPartition();
        Assert.assertEquals((long)(20 * batchSize), (long)groupBatches.size());
        for (int i = 0; i < groupBatches.size(); ++i) {
            Assert.assertEquals((String)("failed to assert at index: " + i), (Object)i, (Object)groupBatches.getAt(i)[0]);
        }
    }

    private void runTestGetAtRandomBatchSize(int maxBatchSize, int numberOfBufferedBatches) throws HiveException {
        Configuration hconf = this.getConf(maxBatchSize);
        VectorPTFGroupBatches groupBatches = new VectorPTFGroupBatches(hconf, numberOfBufferedBatches);
        AtomicLong rowindex = new AtomicLong(-1L);
        Random random = new Random();
        int allSize = 0;
        this.init(groupBatches);
        for (int b = 0; b < 20; ++b) {
            int size = Math.min(maxBatchSize, random.nextInt(maxBatchSize) + 1);
            allSize += size;
            groupBatches.bufferGroupBatch(this.createNewBatch(size, rowindex), false);
        }
        groupBatches.preFinishPartition();
        Assert.assertEquals((long)allSize, (long)groupBatches.size());
        for (int i = 0; i < groupBatches.size(); ++i) {
            Assert.assertEquals((Object)i, (Object)groupBatches.getAt(i)[0]);
        }
    }

    private void assertBufferedBatchValues(VectorPTFGroupBatches groupBatches, Long[] ... longs) {
        for (int b = 0; b < longs.length; ++b) {
            for (int s = 0; s < longs[b].length; ++s) {
                Assert.assertEquals((long)longs[b][s], (long)((LongColumnVector)((BufferedVectorizedRowBatch)groupBatches.bufferedBatches.get((int)b)).cols[0]).vector[s]);
            }
        }
    }

    private void init(VectorPTFGroupBatches groupBatches) throws HiveException {
        int[] outputProjectionColumnMap = new int[]{3, 4, 0, 2, 1};
        TypeInfo[] outputTypeInfos = new TypeInfo[]{this.getTypeInfo("bigint"), this.getTypeInfo("bigint"), this.getTypeInfo("string"), this.getTypeInfo("string"), this.getTypeInfo("int")};
        groupBatches.init(new VectorPTFEvaluatorBase[]{new VectorPTFEvaluatorCountStar(new WindowFrameDef(WindowingSpec.WindowType.RANGE, new BoundaryDef(WindowingSpec.Direction.PRECEDING, 1), new BoundaryDef(WindowingSpec.Direction.CURRENT, 0)), null, 2), new VectorPTFEvaluatorCountStar(new WindowFrameDef(WindowingSpec.WindowType.RANGE, new BoundaryDef(WindowingSpec.Direction.PRECEDING, 3), new BoundaryDef(WindowingSpec.Direction.CURRENT, 0)), null, 3)}, outputProjectionColumnMap, new int[]{1, 2}, new TypeInfo[]{this.getTypeInfo("int"), this.getTypeInfo("string")}, new int[]{1}, new int[]{0}, this.getFakeOperator().setupOverflowBatch(3, new String[]{"bigint", "bigint"}, outputProjectionColumnMap, outputTypeInfos));
    }

    private VectorPTFOperator getFakeOperator() throws HiveException {
        VectorPTFDesc vectorPTFDesc = new VectorPTFDesc();
        vectorPTFDesc.setVectorPTFInfo(new VectorPTFInfo());
        vectorPTFDesc.setOutputColumnNames(new String[0]);
        vectorPTFDesc.setEvaluatorFunctionNames(new String[0]);
        return new VectorPTFOperator(new CompilationOpContext(), (OperatorDesc)new PTFDesc(), new VectorizationContext("fake"), (VectorDesc)vectorPTFDesc);
    }

    private VectorizedRowBatch createNewBatch(int size, AtomicLong rowIndex) {
        VectorizedRowBatch batch = new VectorizedRowBatch(5, size);
        batch.cols[0] = this.createStringColumnVector(this.getRepeatingString("Manufacturer#1", size));
        batch.cols[1] = this.createLongColumnVector(this.getIncreasingLong(rowIndex, size));
        batch.cols[2] = this.createStringColumnVector(this.getRepeatingString("almond aquamarine rose maroon antique", size));
        batch.cols[3] = VectorizedBatchUtil.createColumnVector((String)"bigint");
        batch.cols[4] = VectorizedBatchUtil.createColumnVector((String)"bigint");
        return batch;
    }

    private String[] getRepeatingString(String string, int occurrences) {
        Object[] strings = new String[occurrences];
        Arrays.fill(strings, string);
        return strings;
    }

    private Long[] getIncreasingLong(AtomicLong rowIndex, int occurrences) {
        Long[] longs = new Long[occurrences];
        for (int i = 0; i < occurrences; ++i) {
            longs[i] = rowIndex.incrementAndGet();
        }
        return longs;
    }

    private ColumnVector createStringColumnVector(String[] strings) {
        BytesColumnVector vector = (BytesColumnVector)VectorizedBatchUtil.createColumnVector((String)"string");
        vector.init();
        int i = 0;
        for (String string : strings) {
            vector.setVal(i, string.getBytes());
            ++i;
        }
        return vector;
    }

    private ColumnVector createLongColumnVector(Long[] longs) {
        LongColumnVector vector = (LongColumnVector)VectorizedBatchUtil.createColumnVector((String)"int");
        vector.init();
        int i = 0;
        for (Long l : longs) {
            vector.vector[i] = l;
            ++i;
        }
        return vector;
    }

    private TypeInfo getTypeInfo(String typeString) {
        return TypeInfoUtils.getTypeInfoFromTypeString((String)typeString);
    }
}

