/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastRowHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTableContainerBase;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMapContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMapContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashMapContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VerifyFastRow;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.junit.Before;
import org.junit.Test;

public class TestVectorMapJoinFastRowHashMap
extends CommonFastHashTable {
    public static final Properties ANY_TABLE_PROPERTIES = new Properties();
    private static TableDesc tableDesc = new TableDesc();

    @Before
    public void setUp() throws Exception {
        tableDesc.setProperties(ANY_TABLE_PROPERTIES);
    }

    private void addAndVerifyRows(VectorRandomRowSource valueSource, Object[][] rows, VectorMapJoinFastHashTableContainerBase map, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, CheckFastRowHashMap.VerifyFastRowHashMap verifyTable, String[] keyTypeNames, boolean doClipping, boolean useExactBytes) throws HiveException, IOException {
        int keyCount = keyTypeNames.length;
        PrimitiveTypeInfo[] keyPrimitiveTypeInfos = new PrimitiveTypeInfo[keyCount];
        PrimitiveObjectInspector.PrimitiveCategory[] keyPrimitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[keyCount];
        ArrayList<AbstractPrimitiveWritableObjectInspector> keyPrimitiveObjectInspectorList = new ArrayList<AbstractPrimitiveWritableObjectInspector>(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
            PrimitiveTypeInfo primitiveTypeInfo;
            keyPrimitiveTypeInfos[i] = primitiveTypeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)keyTypeNames[i]);
            keyPrimitiveCategories[i] = primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
            keyPrimitiveObjectInspectorList.add(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo));
        }
        boolean[] keyColumnSortOrderIsDesc = new boolean[keyCount];
        Arrays.fill(keyColumnSortOrderIsDesc, false);
        byte[] keyColumnNullMarker = new byte[keyCount];
        Arrays.fill(keyColumnNullMarker, (byte)0);
        byte[] keyColumnNotNullMarker = new byte[keyCount];
        Arrays.fill(keyColumnNotNullMarker, (byte)1);
        BinarySortableSerializeWrite keySerializeWrite = new BinarySortableSerializeWrite(keyColumnSortOrderIsDesc, keyColumnNullMarker, keyColumnNotNullMarker);
        TypeInfo[] valueTypeInfos = valueSource.typeInfos();
        int columnCount = valueTypeInfos.length;
        LazyBinarySerializeWrite valueSerializeWrite = new LazyBinarySerializeWrite(columnCount);
        for (Object[] valueRow : rows) {
            byte[] key;
            ByteStream.Output valueOutput = new ByteStream.Output();
            valueSerializeWrite.set(valueOutput);
            for (int index = 0; index < columnCount; ++index) {
                VerifyFastRow.serializeWrite((SerializeWrite)valueSerializeWrite, valueTypeInfos[index], valueRow[index]);
            }
            byte[] value = Arrays.copyOf(valueOutput.getData(), valueOutput.getLength());
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                Object[] keyRow = VectorRandomRowSource.randomWritablePrimitiveRow(keyCount, random, keyPrimitiveTypeInfos);
                ByteStream.Output keyOutput = new ByteStream.Output();
                keySerializeWrite.set(keyOutput);
                for (int index = 0; index < keyCount; ++index) {
                    VerifyFastRow.serializeWrite((SerializeWrite)keySerializeWrite, (TypeInfo)keyPrimitiveTypeInfos[index], keyRow[index]);
                }
                key = Arrays.copyOf(keyOutput.getData(), keyOutput.getLength());
                verifyTable.add(key, keyRow, value, valueRow);
            } else {
                key = verifyTable.addRandomExisting(value, valueRow, random);
            }
            BytesWritable keyWritable = new BytesWritable(key);
            BytesWritable valueWritable = new BytesWritable(value);
            long hashcode = map.getHashCode(keyWritable);
            map.putRow(hashcode, keyWritable, valueWritable);
        }
        verifyTable.verify(map, hashTableKeyType, valueTypeInfos, doClipping, useExactBytes, random);
    }

    @Test
    public void testBigIntRows() throws Exception {
        random = new Random(927337L);
        VectorMapJoinFastLongHashMapContainer map = new VectorMapJoinFastLongHashMapContainer(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.LONG, verifyTable, new String[]{"bigint"}, false, false);
    }

    @Test
    public void testIntRows() throws Exception {
        random = new Random(927337L);
        VectorMapJoinFastLongHashMapContainer map = new VectorMapJoinFastLongHashMapContainer(false, false, VectorMapJoinDesc.HashTableKeyType.INT, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.INT, verifyTable, new String[]{"int"}, false, false);
    }

    @Test
    public void testStringRows() throws Exception {
        random = new Random(927337L);
        VectorMapJoinFastStringHashMapContainer map = new VectorMapJoinFastStringHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.STRING, verifyTable, new String[]{"string"}, false, false);
    }

    @Test
    public void testMultiKeyRows1() throws Exception {
        random = new Random(833L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"int", "int"}, false, false);
    }

    @Test
    public void testMultiKeyRows2() throws Exception {
        random = new Random(833099L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"string", "string"}, false, false);
    }

    @Test
    public void testMultiKeyRows3() throws Exception {
        random = new Random(833099L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"bigint", "timestamp", "double"}, false, false);
    }

    @Test
    public void testBigIntRowsClipped() throws Exception {
        random = new Random(326232L);
        VectorMapJoinFastLongHashMapContainer map = new VectorMapJoinFastLongHashMapContainer(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.LONG, verifyTable, new String[]{"bigint"}, true, false);
    }

    @Test
    public void testIntRowsClipped() throws Exception {
        random = new Random(326232L);
        VectorMapJoinFastLongHashMapContainer map = new VectorMapJoinFastLongHashMapContainer(false, false, VectorMapJoinDesc.HashTableKeyType.INT, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.INT, verifyTable, new String[]{"int"}, true, false);
    }

    @Test
    public void testStringRowsClipped() throws Exception {
        random = new Random(326232L);
        VectorMapJoinFastStringHashMapContainer map = new VectorMapJoinFastStringHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.STRING, verifyTable, new String[]{"string"}, true, false);
    }

    @Test
    public void testMultiKeyRowsClipped1() throws Exception {
        random = new Random(2331L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"varchar(20)", "date", "interval_day_time"}, true, false);
    }

    @Test
    public void testMultiKeyRowsClipped2() throws Exception {
        random = new Random(7403L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"varchar(20)", "varchar(40)"}, true, false);
    }

    @Test
    public void testMultiKeyRowsClipped3() throws Exception {
        random = new Random(99L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"float", "tinyint"}, true, false);
    }

    @Test
    public void testBigIntRowsExact() throws Exception {
        random = new Random(27722L);
        VectorMapJoinFastLongHashMapContainer map = new VectorMapJoinFastLongHashMapContainer(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.LONG, verifyTable, new String[]{"bigint"}, false, true);
    }

    @Test
    public void testIntRowsExact() throws Exception {
        random = new Random(8238383L);
        VectorMapJoinFastLongHashMapContainer map = new VectorMapJoinFastLongHashMapContainer(false, false, VectorMapJoinDesc.HashTableKeyType.INT, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.INT, verifyTable, new String[]{"int"}, false, true);
    }

    @Test
    public void testStringRowsExact() throws Exception {
        random = new Random(8235L);
        VectorMapJoinFastStringHashMapContainer map = new VectorMapJoinFastStringHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.STRING, verifyTable, new String[]{"string"}, false, true);
    }

    @Test
    public void testMultiKeyRowsExact1() throws Exception {
        random = new Random(8235L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"string", "string", "string", "string"}, false, true);
    }

    @Test
    public void testMultiKeyRowsExact2() throws Exception {
        random = new Random(8235L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"smallint"}, false, true);
    }

    @Test
    public void testMultiKeyRowsExact3() throws Exception {
        random = new Random(8235L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"int", "binary"}, false, true);
    }

    @Test
    public void testBigIntRowsClippedExact() throws Exception {
        random = new Random(2122L);
        VectorMapJoinFastLongHashMapContainer map = new VectorMapJoinFastLongHashMapContainer(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.LONG, verifyTable, new String[]{"bigint"}, true, true);
    }

    @Test
    public void testIntRowsClippedExact() throws Exception {
        random = new Random(7520L);
        VectorMapJoinFastLongHashMapContainer map = new VectorMapJoinFastLongHashMapContainer(false, false, VectorMapJoinDesc.HashTableKeyType.INT, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.INT, verifyTable, new String[]{"int"}, true, true);
    }

    @Test
    public void testStringRowsClippedExact() throws Exception {
        random = new Random(7539L);
        VectorMapJoinFastStringHashMapContainer map = new VectorMapJoinFastStringHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, tableDesc, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.STRING, verifyTable, new String[]{"string"}, true, true);
    }

    @Test
    public void testMultiKeyRowsClippedExact1() throws Exception {
        random = new Random(13L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"interval_year_month", "decimal(12,8)"}, true, true);
    }

    @Test
    public void testMultiKeyRowsClippedExact2() throws Exception {
        random = new Random(12L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"bigint", "string", "int"}, true, true);
    }

    @Test
    public void testMultiKeyRowsClippedExact3() throws Exception {
        random = new Random(7L);
        VectorMapJoinFastMultiKeyHashMapContainer map = new VectorMapJoinFastMultiKeyHashMapContainer(false, 0x800000, 0.75f, 0x100000, -1L, 4);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random, VectorRandomRowSource.SupportedTypes.ALL, 4, false, false);
        int rowCount = 1000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTableContainerBase)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"bigint", "string", "varchar(5000)"}, true, true);
    }
}

