/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMapContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMapContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashMapContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hive.common.util.HashCodeUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorMapJoinFastHashMapContainerNonMatched {
    private static final int numHashTable = 2;
    private static final int initialCapacity = 8;
    private static final float loadFactor = 0.9f;
    private static final int writeBufferSize = 0x100000;
    private static final int estimatedKeyCount = -1;

    private BytesWritable serializeLong(long value, Properties properties) throws Exception {
        BinarySortableSerializeWrite serializeWrite = BinarySortableSerializeWrite.with((Properties)properties, (int)1);
        ByteStream.Output output = new ByteStream.Output();
        serializeWrite.set(output);
        serializeWrite.writeLong(value);
        BytesWritable writable = new BytesWritable();
        writable.set(output.getData(), 0, output.getLength());
        return writable;
    }

    private void addToHashMap(VectorMapJoinFastLongHashMapContainer hashMap, long value, Properties properties) throws Exception {
        BytesWritable keyWritable = this.serializeLong(value, properties);
        BytesWritable valueWritable = new BytesWritable(keyWritable.copyBytes());
        hashMap.putRow((long)HashCodeUtil.calculateLongHashCode((long)value), keyWritable, valueWritable);
    }

    private long getHashCode(String key) {
        Text keyWritable = new Text(key);
        return HashCodeUtil.murmurHash((byte[])keyWritable.getBytes(), (int)0, (int)keyWritable.getLength());
    }

    private BytesWritable serializeString(String value, Properties properties) throws Exception {
        BinarySortableSerializeWrite serializeWrite = BinarySortableSerializeWrite.with((Properties)properties, (int)1);
        ByteStream.Output output = new ByteStream.Output();
        serializeWrite.set(output);
        Text text = new Text(value);
        serializeWrite.writeString(text.getBytes(), 0, text.getLength());
        BytesWritable writable = new BytesWritable();
        writable.set(output.getData(), 0, output.getLength());
        return writable;
    }

    private void addToHashMap(VectorMapJoinFastStringHashMapContainer hashMap, String value, Properties properties) throws Exception {
        BytesWritable keyWritable = this.serializeString(value, properties);
        BytesWritable valueWritable = new BytesWritable(keyWritable.copyBytes());
        hashMap.putRow(this.getHashCode(value), keyWritable, valueWritable);
    }

    private BytesWritable createRandomMultiKey(Random random, BinarySortableSerializeWrite serializeWrite) throws Exception {
        ByteStream.Output output = new ByteStream.Output();
        serializeWrite.set(output);
        serializeWrite.writeLong(random.nextLong());
        serializeWrite.writeLong(random.nextLong());
        BytesWritable writable = new BytesWritable();
        writable.set(output.getData(), 0, output.getLength());
        return writable;
    }

    private long getHashCode(BytesWritable key) {
        return HashCodeUtil.murmurHash((byte[])key.getBytes(), (int)0, (int)key.getLength());
    }

    private void addToHashMap(VectorMapJoinFastMultiKeyHashMapContainer hashMap, BytesWritable key) throws Exception {
        BytesWritable value = new BytesWritable(key.copyBytes());
        hashMap.putRow(this.getHashCode(key), key, value);
    }

    @Test
    public void testLongHashMapContainer() throws Exception {
        Random random = new Random();
        long keyA = random.nextLong();
        while ((HashCodeUtil.calculateLongHashCode((long)keyA) & 7) != 0) {
            keyA = random.nextLong();
        }
        long keyB = random.nextLong();
        while ((HashCodeUtil.calculateLongHashCode((long)keyB) & 7) != 0 || keyB == keyA) {
            keyB = random.nextLong();
        }
        long keyC = random.nextLong();
        while ((HashCodeUtil.calculateLongHashCode((long)keyC) & 7) != 1) {
            keyC = random.nextLong();
        }
        TableDesc tableDesc = new TableDesc();
        Properties properties = new Properties();
        tableDesc.setProperties(properties);
        VectorMapJoinFastLongHashMapContainer hashMapContainer = new VectorMapJoinFastLongHashMapContainer(true, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.9f, 0x100000, -1L, tableDesc, 2);
        this.addToHashMap(hashMapContainer, keyA, properties);
        this.addToHashMap(hashMapContainer, keyB, properties);
        this.addToHashMap(hashMapContainer, keyC, properties);
        MatchTracker matchTracker = hashMapContainer.createMatchTracker();
        VectorMapJoinHashMapResult hashMapResult = hashMapContainer.createHashMapResult();
        hashMapContainer.lookup(keyB, hashMapResult, matchTracker);
        VectorMapJoinNonMatchedIterator nonMatchedIterator = hashMapContainer.createNonMatchedIterator(matchTracker);
        nonMatchedIterator.init();
        ArrayList<Long> nonMatchedList = new ArrayList<Long>();
        while (nonMatchedIterator.findNextNonMatched()) {
            boolean isNull = !nonMatchedIterator.readNonMatchedLongKey();
            Assert.assertFalse((boolean)isNull);
            long key = nonMatchedIterator.getNonMatchedLongKey();
            nonMatchedList.add(key);
        }
        Assert.assertEquals((long)2L, (long)nonMatchedList.size());
        Assert.assertTrue((boolean)nonMatchedList.contains(keyA));
        Assert.assertTrue((boolean)nonMatchedList.contains(keyC));
    }

    @Test
    public void testStringHashMapContainer() throws Exception {
        Random random = new Random();
        String keyA = VectorRandomRowSource.getRandString(random, 5, false);
        while ((this.getHashCode(keyA) & 7L) != 0L) {
            keyA = VectorRandomRowSource.getRandString(random, 5, false);
        }
        String keyB = VectorRandomRowSource.getRandString(random, 5, false);
        while ((this.getHashCode(keyB) & 7L) != 0L || keyB.equals(keyA)) {
            keyB = VectorRandomRowSource.getRandString(random, 5, false);
        }
        String keyC = VectorRandomRowSource.getRandString(random, 5, false);
        while ((this.getHashCode(keyC) & 7L) != 1L) {
            keyC = VectorRandomRowSource.getRandString(random, 5, false);
        }
        TableDesc tableDesc = new TableDesc();
        Properties properties = new Properties();
        tableDesc.setProperties(properties);
        VectorMapJoinFastStringHashMapContainer hashMapContainer = new VectorMapJoinFastStringHashMapContainer(true, 8, 0.9f, 0x100000, -1L, tableDesc, 2);
        this.addToHashMap(hashMapContainer, keyA, properties);
        this.addToHashMap(hashMapContainer, keyB, properties);
        this.addToHashMap(hashMapContainer, keyC, properties);
        MatchTracker matchTracker = hashMapContainer.createMatchTracker();
        VectorMapJoinHashMapResult hashMapResult = hashMapContainer.createHashMapResult();
        Text keyTextB = new Text(keyB);
        hashMapContainer.lookup(keyTextB.getBytes(), 0, keyTextB.getLength(), hashMapResult, matchTracker);
        VectorMapJoinNonMatchedIterator nonMatchedIterator = hashMapContainer.createNonMatchedIterator(matchTracker);
        nonMatchedIterator.init();
        ArrayList<String> nonMatchedList = new ArrayList<String>();
        while (nonMatchedIterator.findNextNonMatched()) {
            boolean isNull = !nonMatchedIterator.readNonMatchedBytesKey();
            Assert.assertFalse((boolean)isNull);
            byte[] keyBytes = nonMatchedIterator.getNonMatchedBytes();
            int keyOffset = nonMatchedIterator.getNonMatchedBytesOffset();
            int keyLength = nonMatchedIterator.getNonMatchedBytesLength();
            byte[] array = new byte[keyLength];
            System.arraycopy(keyBytes, keyOffset, array, 0, keyLength);
            Text key = new Text(array);
            nonMatchedList.add(key.toString());
        }
        Assert.assertEquals((long)2L, (long)nonMatchedList.size());
        Assert.assertTrue((boolean)nonMatchedList.contains(keyA));
        Assert.assertTrue((boolean)nonMatchedList.contains(keyC));
    }

    @Test
    public void testMultiKeyHashMapContainer() throws Exception {
        Random random = new Random();
        BinarySortableSerializeWrite serializeWrite = BinarySortableSerializeWrite.with((Properties)new Properties(), (int)2);
        BytesWritable keyA = this.createRandomMultiKey(random, serializeWrite);
        while ((this.getHashCode(keyA) & 7L) != 0L) {
            keyA = this.createRandomMultiKey(random, serializeWrite);
        }
        BytesWritable keyB = this.createRandomMultiKey(random, serializeWrite);
        while ((this.getHashCode(keyB) & 7L) != 0L || keyB == keyA) {
            keyB = this.createRandomMultiKey(random, serializeWrite);
        }
        BytesWritable keyC = this.createRandomMultiKey(random, serializeWrite);
        while ((this.getHashCode(keyC) & 7L) != 1L) {
            keyC = this.createRandomMultiKey(random, serializeWrite);
        }
        VectorMapJoinFastMultiKeyHashMapContainer hashMapContainer = new VectorMapJoinFastMultiKeyHashMapContainer(true, 8, 0.9f, 0x100000, -1L, 2);
        this.addToHashMap(hashMapContainer, keyA);
        this.addToHashMap(hashMapContainer, keyB);
        this.addToHashMap(hashMapContainer, keyC);
        MatchTracker matchTracker = hashMapContainer.createMatchTracker();
        VectorMapJoinHashMapResult hashMapResult = hashMapContainer.createHashMapResult();
        hashMapContainer.lookup(keyB.getBytes(), 0, keyB.getLength(), hashMapResult, matchTracker);
        VectorMapJoinNonMatchedIterator nonMatchedIterator = hashMapContainer.createNonMatchedIterator(matchTracker);
        nonMatchedIterator.init();
        ArrayList<byte[]> nonMatchedList = new ArrayList<byte[]>();
        while (nonMatchedIterator.findNextNonMatched()) {
            boolean isNull = !nonMatchedIterator.readNonMatchedBytesKey();
            Assert.assertFalse((boolean)isNull);
            byte[] keyBytes = nonMatchedIterator.getNonMatchedBytes();
            int keyOffset = nonMatchedIterator.getNonMatchedBytesOffset();
            int keyLength = nonMatchedIterator.getNonMatchedBytesLength();
            byte[] array = new byte[keyLength];
            System.arraycopy(keyBytes, keyOffset, array, 0, keyLength);
            nonMatchedList.add(array);
        }
        BytesWritable finalKeyA = keyA;
        BytesWritable finalKeyC = keyC;
        Assert.assertEquals((long)2L, (long)nonMatchedList.size());
        Assert.assertTrue((boolean)nonMatchedList.stream().anyMatch(arr -> Arrays.equals(arr, finalKeyA.copyBytes())));
        Assert.assertTrue((boolean)nonMatchedList.stream().anyMatch(arr -> Arrays.equals(arr, finalKeyC.copyBytes())));
    }
}

