/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorMapJoinFastBytesHashMultiSet
extends CommonFastHashTable {
    @Test
    public void testOneKey() throws Exception {
        random = new Random(5255L);
        VectorMapJoinFastMultiKeyHashMultiSet map = new VectorMapJoinFastMultiKeyHashMultiSet(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashMultiSet();
        byte[] key = new byte[random.nextInt(100)];
        random.nextBytes(key);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify((VectorMapJoinFastBytesHashMultiSet)map);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify((VectorMapJoinFastBytesHashMultiSet)map);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify((VectorMapJoinFastBytesHashMultiSet)map);
    }

    @Test
    public void testMultipleKeysSingleValue() throws Exception {
        random = new Random(2374L);
        VectorMapJoinFastMultiKeyHashMultiSet map = new VectorMapJoinFastMultiKeyHashMultiSet(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashMultiSet();
        int keyCount = 100 + random.nextInt(1000);
        for (int i = 0; i < keyCount; ++i) {
            byte[] key = new byte[random.nextInt(100)];
            random.nextBytes(key);
            if (!verifyTable.contains(key)) break;
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashMultiSet)map);
    }

    @Test
    public void testGetNonExistent() throws Exception {
        random = new Random(98222L);
        VectorMapJoinFastMultiKeyHashMultiSet map = new VectorMapJoinFastMultiKeyHashMultiSet(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashMultiSet();
        byte[] key1 = new byte[random.nextInt(100)];
        random.nextBytes(key1);
        map.testPutRow(key1);
        verifyTable.add(key1);
        verifyTable.verify((VectorMapJoinFastBytesHashMultiSet)map);
        byte[] key2 = new byte[random.nextInt(100)];
        random.nextBytes(key2);
        VectorMapJoinHashMultiSetResult hashMultiSetResult = map.createHashMultiSetResult();
        JoinUtil.JoinResult joinResult = map.contains(key2, 0, key2.length, hashMultiSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        map.testPutRow(key2);
        verifyTable.add(key2);
        verifyTable.verify((VectorMapJoinFastBytesHashMultiSet)map);
        byte[] key3 = new byte[random.nextInt(100)];
        random.nextBytes(key3);
        hashMultiSetResult = map.createHashMultiSetResult();
        joinResult = map.contains(key3, 0, key3.length, hashMultiSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        Assert.assertEquals((long)hashMultiSetResult.count(), (long)0L);
    }

    @Test
    public void testFullMap() throws Exception {
        byte[] anotherKey;
        random = new Random(9024L);
        VectorMapJoinFastMultiKeyHashMultiSet map = new VectorMapJoinFastMultiKeyHashMultiSet(false, 8, 1.0f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashMultiSet();
        for (int i = 0; i < 8; ++i) {
            byte[] key;
            do {
                key = new byte[random.nextInt(100)];
                random.nextBytes(key);
            } while (verifyTable.contains(key));
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashMultiSet)map);
        do {
            anotherKey = new byte[random.nextInt(100)];
            random.nextBytes(anotherKey);
        } while (verifyTable.contains(anotherKey));
        VectorMapJoinHashMultiSetResult hashMultiSetResult = map.createHashMultiSetResult();
        JoinUtil.JoinResult joinResult = map.contains(anotherKey, 0, anotherKey.length, hashMultiSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testExpand() throws Exception {
        random = new Random(2933L);
        VectorMapJoinFastMultiKeyHashMultiSet map = new VectorMapJoinFastMultiKeyHashMultiSet(false, 1, 1.0E-7f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashMultiSet();
        for (int i = 0; i < 6; ++i) {
            byte[] key;
            do {
                key = new byte[random.nextInt(100)];
                random.nextBytes(key);
            } while (verifyTable.contains(key));
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashMultiSet)map);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastMultiKeyHashMultiSet map, CheckFastHashTable.VerifyFastBytesHashMultiSet verifyTable) throws HiveException, IOException {
        for (int i = 0; i < keyCount; ++i) {
            byte[] value = new byte[TestVectorMapJoinFastBytesHashMultiSet.generateLargeCount() - 1];
            random.nextBytes(value);
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                byte[] key;
                do {
                    key = new byte[random.nextInt(100)];
                    random.nextBytes(key);
                } while (verifyTable.contains(key));
                map.testPutRow(key);
                verifyTable.add(key);
                continue;
            }
            byte[] randomExistingKey = verifyTable.addRandomExisting(value, random);
            map.testPutRow(randomExistingKey);
        }
        verifyTable.verify((VectorMapJoinFastBytesHashMultiSet)map);
    }

    @Test
    public void testMultipleKeysMultipleValue() throws Exception {
        random = new Random(5445L);
        VectorMapJoinFastMultiKeyHashMultiSet map = new VectorMapJoinFastMultiKeyHashMultiSet(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastHashTable.VerifyFastBytesHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashMultiSet();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Test
    public void testLargeAndExpand() throws Exception {
        random = new Random(5637L);
        VectorMapJoinFastMultiKeyHashMultiSet map = new VectorMapJoinFastMultiKeyHashMultiSet(false, 512, 0.75f, 8192, -1L);
        CheckFastHashTable.VerifyFastBytesHashMultiSet verifyTable = new CheckFastHashTable.VerifyFastBytesHashMultiSet();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }
}

