/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMap;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Test;

public class TestVectorMapJoinFastBytesHashMapNonMatched
extends CommonFastHashTable {
    @Test
    public void testOneKey() throws Exception {
        random = new Random(82733L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        byte[] key = new byte[random.nextInt(100)];
        random.nextBytes(key);
        byte[] value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        value = new byte[random.nextInt(1000)];
        random.nextBytes(value);
        map.testPutRow(key, value);
        verifyTable.add(key, value);
        verifyTable.verifyNonMatched((VectorMapJoinFastBytesHashMap)map, random);
    }

    @Test
    public void testMultipleKeysSingleValue() throws Exception {
        random = new Random(29383L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        int keyCount = 100 + random.nextInt(1000);
        for (int i = 0; i < keyCount; ++i) {
            byte[] key = new byte[random.nextInt(100)];
            random.nextBytes(key);
            if (!verifyTable.contains(key)) break;
            byte[] value = new byte[random.nextInt(1000)];
            random.nextBytes(value);
            map.testPutRow(key, value);
            verifyTable.add(key, value);
        }
        verifyTable.verifyNonMatched((VectorMapJoinFastBytesHashMap)map, random);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastMultiKeyHashMap map, CheckFastHashTable.VerifyFastBytesHashMap verifyTable) throws HiveException, IOException {
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable, 100, -1);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastMultiKeyHashMap map, CheckFastHashTable.VerifyFastBytesHashMap verifyTable, int maxKeyLength, int fixedValueLength) throws HiveException, IOException {
        for (int i = 0; i < keyCount; ++i) {
            byte[] value = fixedValueLength == -1 ? new byte[TestVectorMapJoinFastBytesHashMapNonMatched.generateLargeCount() - 1] : new byte[fixedValueLength];
            random.nextBytes(value);
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                byte[] key;
                do {
                    key = new byte[random.nextInt(maxKeyLength)];
                    random.nextBytes(key);
                } while (verifyTable.contains(key));
                map.testPutRow(key, value);
                verifyTable.add(key, value);
                continue;
            }
            byte[] randomExistingKey = verifyTable.addRandomExisting(value, random);
            map.testPutRow(randomExistingKey, value);
        }
        verifyTable.verifyNonMatched((VectorMapJoinFastBytesHashMap)map, random);
    }

    @Test
    public void testMultipleKeysMultipleValue() throws Exception {
        random = new Random(9332L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        int keyCount = 100;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Test
    public void testReallyBig() throws Exception {
        random = new Random(42662L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 8192, -1L);
        CheckFastHashTable.VerifyFastBytesHashMap verifyTable = new CheckFastHashTable.VerifyFastBytesHashMap();
        int keyCount = 100;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }
}

