/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjects;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestDescription;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class MapJoinTestData {
    final Random random;
    final List<VectorRandomRowSource.GenerationSpec> generationSpecList;
    final VectorRandomRowSource bigTableRowSource;
    final Object[][] bigTableRandomRows;
    final VectorRandomBatchSource bigTableBatchSource;
    public final VectorizedRowBatch bigTableBatch;
    final MapJoinTestDescription.SmallTableGenerationParameters smallTableGenerationParameters;
    HashMap<RowTestObjects, Integer> smallTableKeyHashMap;
    List<RowTestObjects> fullOuterAdditionalSmallTableKeys;
    ArrayList<Integer> smallTableValueCounts;
    ArrayList<ArrayList<RowTestObjects>> smallTableValues;

    public MapJoinTestData(int rowCount, MapJoinTestDescription testDesc, long randomSeed) throws HiveException {
        int s;
        this.random = new Random(randomSeed);
        boolean isOuterJoin = testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.OUTER || testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER;
        this.generationSpecList = MapJoinTestData.generationSpecListFromTypeInfos(testDesc.bigTableTypeInfos, testDesc.bigTableKeyColumnNums.length, isOuterJoin);
        this.bigTableRowSource = new VectorRandomRowSource();
        this.bigTableRowSource.initGenerationSpecSchema(this.random, this.generationSpecList, 0, true, true, null);
        this.bigTableRandomRows = this.bigTableRowSource.randomRows(10);
        this.bigTableBatchSource = VectorRandomBatchSource.createInterestingBatches(this.random, this.bigTableRowSource, this.bigTableRandomRows, null);
        this.bigTableBatch = this.createBigTableBatch(testDesc);
        int smallTableRetainKeySize = isOuterJoin ? testDesc.smallTableRetainKeyColumnNums.length : 0;
        ColumnVector[] newCols = new ColumnVector[this.bigTableBatch.cols.length + smallTableRetainKeySize + testDesc.smallTableValueTypeInfos.length];
        System.arraycopy(this.bigTableBatch.cols, 0, newCols, 0, this.bigTableBatch.cols.length);
        int colIndex = this.bigTableBatch.cols.length;
        if (isOuterJoin) {
            for (s = 0; s < smallTableRetainKeySize; ++s) {
                int smallTableKeyColumnNum = testDesc.smallTableRetainKeyColumnNums[s];
                newCols[colIndex++] = VectorizedBatchUtil.createColumnVector((TypeInfo)testDesc.smallTableKeyTypeInfos[smallTableKeyColumnNum]);
            }
        }
        for (s = 0; s < testDesc.smallTableValueTypeInfos.length; ++s) {
            newCols[colIndex++] = VectorizedBatchUtil.createColumnVector((TypeInfo)testDesc.smallTableValueTypeInfos[s]);
        }
        this.bigTableBatch.cols = newCols;
        this.bigTableBatch.numCols = newCols.length;
        VectorExtractRow keyVectorExtractRow = new VectorExtractRow();
        keyVectorExtractRow.init(testDesc.bigTableKeyTypeInfos, testDesc.bigTableKeyColumnNums);
        this.smallTableGenerationParameters = testDesc.getSmallTableGenerationParameters();
        HashMap<RowTestObjects, Integer> bigTableKeyHashMap = new HashMap<RowTestObjects, Integer>();
        this.smallTableKeyHashMap = new HashMap();
        MapJoinTestDescription.SmallTableGenerationParameters.ValueOption valueOption = this.smallTableGenerationParameters.getValueOption();
        if (valueOption != MapJoinTestDescription.SmallTableGenerationParameters.ValueOption.NO_REGULAR_SMALL_KEYS) {
            int keyOutOfAThousand = this.smallTableGenerationParameters.getKeyOutOfAThousand();
            this.bigTableBatchSource.resetBatchIteration();
            while (this.bigTableBatchSource.fillNextBatch(this.bigTableBatch)) {
                int size = this.bigTableBatch.size;
                for (int logical = 0; logical < size; ++logical) {
                    int batchIndex = this.bigTableBatch.selectedInUse ? this.bigTableBatch.selected[logical] : logical;
                    RowTestObjects testKey = this.getTestKey(this.bigTableBatch, batchIndex, keyVectorExtractRow, testDesc.bigTableKeyTypeInfos.length, testDesc.bigTableObjectInspectors);
                    bigTableKeyHashMap.put((RowTestObjects)testKey.clone(), -1);
                    if (this.random.nextInt(1000) > keyOutOfAThousand || valueOption == MapJoinTestDescription.SmallTableGenerationParameters.ValueOption.ONLY_ONE && this.smallTableKeyHashMap.containsKey(testKey)) continue;
                    this.smallTableKeyHashMap.put((RowTestObjects)testKey.clone(), -1);
                }
            }
        }
        this.fullOuterAdditionalSmallTableKeys = new ArrayList<RowTestObjects>();
        VectorRandomRowSource altBigTableRowSource = new VectorRandomRowSource();
        altBigTableRowSource.initGenerationSpecSchema(this.random, this.generationSpecList, 0, true, true, null);
        Object[][] altBigTableRandomRows = altBigTableRowSource.randomRows(10000);
        VectorRandomBatchSource altBigTableBatchSource = VectorRandomBatchSource.createInterestingBatches(this.random, altBigTableRowSource, altBigTableRandomRows, null);
        altBigTableBatchSource.resetBatchIteration();
        while (altBigTableBatchSource.fillNextBatch(this.bigTableBatch)) {
            int size = this.bigTableBatch.size;
            for (int logical = 0; logical < size; ++logical) {
                int batchIndex = this.bigTableBatch.selectedInUse ? this.bigTableBatch.selected[logical] : logical;
                RowTestObjects testKey = this.getTestKey(this.bigTableBatch, batchIndex, keyVectorExtractRow, testDesc.bigTableKeyTypeInfos.length, testDesc.bigTableObjectInspectors);
                if (bigTableKeyHashMap.containsKey(testKey) || this.smallTableKeyHashMap.containsKey(testKey)) continue;
                RowTestObjects testKeyClone = (RowTestObjects)testKey.clone();
                this.smallTableKeyHashMap.put(testKeyClone, -1);
                this.fullOuterAdditionalSmallTableKeys.add(testKeyClone);
            }
        }
        Object[] nullKeyRowObjects = new Object[testDesc.bigTableKeyTypeInfos.length];
        RowTestObjects nullTestKey = new RowTestObjects(nullKeyRowObjects);
        if (!this.smallTableKeyHashMap.containsKey(nullTestKey)) {
            this.smallTableKeyHashMap.put(nullTestKey, -1);
            this.fullOuterAdditionalSmallTableKeys.add(nullTestKey);
        }
        int addCount = 0;
        for (Map.Entry<RowTestObjects, Integer> testRowEntry : this.smallTableKeyHashMap.entrySet()) {
            testRowEntry.setValue(addCount++);
        }
        MapJoinTestData.generateVariationData(this, testDesc, this.random);
    }

    public VectorRandomBatchSource getBigTableBatchSource() {
        return this.bigTableBatchSource;
    }

    public VectorizedRowBatch getBigTableBatch() {
        return this.bigTableBatch;
    }

    public VectorizedRowBatch createBigTableBatch(MapJoinTestDescription testDesc) {
        int bigTableColumnCount = testDesc.bigTableTypeInfos.length;
        VectorizedRowBatch batch = new VectorizedRowBatch(bigTableColumnCount);
        for (int i = 0; i < bigTableColumnCount; ++i) {
            batch.cols[i] = VectorizedBatchUtil.createColumnVector((TypeInfo)testDesc.bigTableTypeInfos[i]);
        }
        return batch;
    }

    private RowTestObjects getTestKey(VectorizedRowBatch bigTableBatch, int batchIndex, VectorExtractRow vectorExtractRow, int columnCount, ObjectInspector[] objectInspectors) {
        Object[] rowObjects = new Object[columnCount];
        vectorExtractRow.extractRow(bigTableBatch, batchIndex, rowObjects);
        for (int c = 0; c < rowObjects.length; ++c) {
            rowObjects[c] = ((PrimitiveObjectInspector)objectInspectors[c]).copyObject(rowObjects[c]);
        }
        return new RowTestObjects(rowObjects);
    }

    public static void driveBigTableData(MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinOperator operator) throws HiveException {
        VectorExtractRow vectorExtractRow = new VectorExtractRow();
        vectorExtractRow.init(testDesc.bigTableTypeInfos);
        for (Object[] row : testData.bigTableRandomRows) {
            operator.process((Object)row, 0);
        }
        operator.close(false);
    }

    public static void driveVectorBigTableData(MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinOperator operator) throws HiveException {
        testData.bigTableBatchSource.resetBatchIteration();
        while (testData.bigTableBatchSource.fillNextBatch(testData.bigTableBatch)) {
            operator.process((Object)testData.bigTableBatch, 0);
        }
        operator.close(false);
    }

    public static void generateVariationData(MapJoinTestData testData, MapJoinTestDescription testDesc, Random random) {
        switch (testDesc.vectorMapJoinVariation) {
            case INNER_BIG_ONLY: 
            case LEFT_SEMI: 
            case LEFT_ANTI: {
                testData.generateRandomSmallTableCounts(testDesc, random);
                break;
            }
            case INNER: 
            case OUTER: 
            case FULL_OUTER: {
                testData.generateRandomSmallTableCounts(testDesc, random);
                testData.generateRandomSmallTableValues(testDesc, random);
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator variation " + testDesc.vectorMapJoinVariation);
            }
        }
    }

    private static RowTestObjects generateRandomSmallTableValueRow(MapJoinTestDescription testDesc, Random random) {
        int columnCount = testDesc.smallTableValueTypeInfos.length;
        PrimitiveTypeInfo[] primitiveTypeInfos = new PrimitiveTypeInfo[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            primitiveTypeInfos[i] = (PrimitiveTypeInfo)testDesc.smallTableValueTypeInfos[i];
        }
        Object[] smallTableValueRow = VectorRandomRowSource.randomWritablePrimitiveRow(columnCount, random, primitiveTypeInfos);
        for (int c = 0; c < smallTableValueRow.length; ++c) {
            smallTableValueRow[c] = ((PrimitiveObjectInspector)testDesc.smallTableValueObjectInspectors[c]).copyObject(smallTableValueRow[c]);
        }
        return new RowTestObjects(smallTableValueRow);
    }

    private void generateRandomSmallTableCounts(MapJoinTestDescription testDesc, Random random) {
        this.smallTableValueCounts = new ArrayList();
        for (Map.Entry<RowTestObjects, Integer> testKeyEntry : this.smallTableKeyHashMap.entrySet()) {
            int valueCount = 1 + random.nextInt(3);
            this.smallTableValueCounts.add(valueCount);
        }
    }

    private void generateRandomSmallTableValues(MapJoinTestDescription testDesc, Random random) {
        this.smallTableValues = new ArrayList();
        for (Map.Entry<RowTestObjects, Integer> testKeyEntry : this.smallTableKeyHashMap.entrySet()) {
            ArrayList<RowTestObjects> valueList = new ArrayList<RowTestObjects>();
            this.smallTableValues.add(valueList);
            int valueCount = this.smallTableValueCounts.get(testKeyEntry.getValue());
            for (int v = 0; v < valueCount; ++v) {
                valueList.add(MapJoinTestData.generateRandomSmallTableValueRow(testDesc, random));
            }
        }
    }

    private static List<VectorRandomRowSource.GenerationSpec> generationSpecListFromTypeInfos(TypeInfo[] typeInfos, int keyCount, boolean isOuterJoin) {
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        int size = typeInfos.length;
        for (int i = 0; i < size; ++i) {
            TypeInfo typeInfo = typeInfos[i];
            boolean columnAllowNulls = i >= keyCount ? true : isOuterJoin;
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(typeInfo, columnAllowNulls));
        }
        return generationSpecList;
    }
}

