/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.CountCollectorTestOperator;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.RowCollectorTestOperator;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.RowCollectorTestOperatorBase;
import org.apache.hadoop.hive.ql.exec.util.collectoroperator.RowVectorCollectorTestOperator;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjects;
import org.apache.hadoop.hive.ql.exec.util.rowobjects.RowTestObjectsMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnOutputMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSourceMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinBaseOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOuterFilteredOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestData;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.MapJoinTestDescription;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.NoOpExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinCommonOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinFullOuterLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinFullOuterMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinFullOuterStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VerifyFastRow;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.apache.hadoop.hive.ql.plan.VectorSelectDesc;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.common.util.ReflectionUtil;

public class MapJoinTestConfig {
    public static boolean isVectorOutput(MapJoinTestImplementation mapJoinImplementation) {
        return mapJoinImplementation != MapJoinTestImplementation.ROW_MODE_HASH_MAP && mapJoinImplementation != MapJoinTestImplementation.ROW_MODE_OPTIMIZED;
    }

    public static MapJoinDesc createMapJoinDesc(MapJoinTestDescription testDesc) {
        return MapJoinTestConfig.createMapJoinDesc(testDesc, false);
    }

    public static MapJoinDesc createMapJoinDesc(MapJoinTestDescription testDesc, boolean isFullOuterIntersect) {
        MapJoinDesc mapJoinDesc = new MapJoinDesc();
        mapJoinDesc.setPosBigTable(0);
        ArrayList<ExprNodeColumnDesc> bigTableKeyExpr = new ArrayList<ExprNodeColumnDesc>();
        for (int i = 0; i < testDesc.bigTableKeyColumnNums.length; ++i) {
            bigTableKeyExpr.add(new ExprNodeColumnDesc(testDesc.bigTableKeyTypeInfos[i], testDesc.bigTableKeyColumnNames[i], "B", false));
        }
        HashMap keyMap = new HashMap();
        keyMap.put((byte)0, bigTableKeyExpr);
        ArrayList<ExprNodeColumnDesc> bigTableExpr = new ArrayList<ExprNodeColumnDesc>();
        for (int i = 0; i < testDesc.bigTableColumnNames.length; ++i) {
            bigTableExpr.add(new ExprNodeColumnDesc(testDesc.bigTableTypeInfos[i], testDesc.bigTableColumnNames[i], "B", false));
        }
        HashMap exprMap = new HashMap();
        exprMap.put((byte)0, bigTableExpr);
        ArrayList<ExprNodeColumnDesc> smallTableKeyExpr = new ArrayList<ExprNodeColumnDesc>();
        for (int i = 0; i < testDesc.smallTableKeyTypeInfos.length; ++i) {
            ExprNodeColumnDesc exprNodeColumnDesc = new ExprNodeColumnDesc(testDesc.smallTableKeyTypeInfos[i], testDesc.smallTableKeyColumnNames[i], "S", false);
            smallTableKeyExpr.add(exprNodeColumnDesc);
        }
        ArrayList<ExprNodeColumnDesc> smallTableExpr = new ArrayList<ExprNodeColumnDesc>();
        int smallTableRetainKeySize = testDesc.smallTableRetainKeyColumnNums.length;
        for (int i = 0; i < smallTableRetainKeySize; ++i) {
            int smallTableKeyColumnNum = testDesc.smallTableRetainKeyColumnNums[i];
            smallTableExpr.add(new ExprNodeColumnDesc(testDesc.smallTableTypeInfos[smallTableKeyColumnNum], testDesc.smallTableColumnNames[smallTableKeyColumnNum], "S", false));
        }
        int smallTableRetainValueSize = testDesc.smallTableRetainValueColumnNums.length;
        for (int i = 0; i < smallTableRetainValueSize; ++i) {
            int smallTableValueColumnNum = smallTableRetainKeySize + testDesc.smallTableRetainValueColumnNums[i];
            smallTableExpr.add(new ExprNodeColumnDesc(testDesc.smallTableTypeInfos[smallTableValueColumnNum], testDesc.smallTableColumnNames[smallTableValueColumnNum], "S", false));
        }
        keyMap.put((byte)1, smallTableKeyExpr);
        exprMap.put((byte)1, smallTableExpr);
        mapJoinDesc.setKeys(keyMap);
        mapJoinDesc.setExprs(exprMap);
        Byte[] order = new Byte[]{(byte)0, (byte)1};
        mapJoinDesc.setTagOrder(order);
        mapJoinDesc.setNoOuterJoin(testDesc.vectorMapJoinVariation != VectorMapJoinDesc.VectorMapJoinVariation.OUTER && testDesc.vectorMapJoinVariation != VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER);
        HashMap filterMap = new HashMap();
        filterMap.put((byte)0, new ArrayList());
        mapJoinDesc.setFilters(filterMap);
        List<Integer> bigTableRetainColumnNumsList = MapJoinTestConfig.intArrayToList(testDesc.bigTableRetainColumnNums);
        HashMap<Byte, List<Integer>> retainListMap = new HashMap<Byte, List<Integer>>();
        retainListMap.put((byte)0, bigTableRetainColumnNumsList);
        if (testDesc.smallTableRetainKeyColumnNums.length == 0) {
            List<Integer> smallTableValueRetainColumnNumsList = MapJoinTestConfig.intArrayToList(testDesc.smallTableRetainValueColumnNums);
            retainListMap.put((byte)1, smallTableValueRetainColumnNumsList);
        } else {
            int i;
            ArrayList<Integer> smallTableValueIndicesNumsList = new ArrayList<Integer>();
            for (i = 0; i < testDesc.smallTableRetainKeyColumnNums.length; ++i) {
                smallTableValueIndicesNumsList.add(testDesc.smallTableRetainKeyColumnNums[i]);
            }
            for (i = 0; i < testDesc.smallTableRetainValueColumnNums.length; ++i) {
                smallTableValueIndicesNumsList.add(-testDesc.smallTableRetainValueColumnNums[i] - 1);
            }
            int[] smallTableValueIndicesNums = ArrayUtils.toPrimitive((Integer[])smallTableValueIndicesNumsList.toArray(new Integer[0]));
            HashMap<Byte, int[]> valueIndicesMap = new HashMap<Byte, int[]>();
            valueIndicesMap.put((byte)1, smallTableValueIndicesNums);
            mapJoinDesc.setValueIndices(valueIndicesMap);
        }
        mapJoinDesc.setRetainList(retainListMap);
        switch (testDesc.mapJoinPlanVariation) {
            case DYNAMIC_PARTITION_HASH_JOIN: {
                mapJoinDesc.setDynamicPartitionHashJoin(true);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected map join plan variation " + testDesc.mapJoinPlanVariation);
            }
        }
        JoinCondDesc[] conds = new JoinCondDesc[]{new JoinCondDesc(0, 1, switch (testDesc.vectorMapJoinVariation) {
            case VectorMapJoinDesc.VectorMapJoinVariation.INNER, VectorMapJoinDesc.VectorMapJoinVariation.INNER_BIG_ONLY -> 0;
            case VectorMapJoinDesc.VectorMapJoinVariation.LEFT_SEMI -> 5;
            case VectorMapJoinDesc.VectorMapJoinVariation.LEFT_ANTI -> 6;
            case VectorMapJoinDesc.VectorMapJoinVariation.OUTER -> 1;
            case VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER -> 3;
            default -> throw new RuntimeException("unknown operator variation " + testDesc.vectorMapJoinVariation);
        })};
        mapJoinDesc.setConds(conds);
        TableDesc keyTableDesc = PlanUtils.getMapJoinKeyTableDesc((Configuration)testDesc.hiveConf, (List)PlanUtils.getFieldSchemasFromColumnList(smallTableKeyExpr, (String)""));
        mapJoinDesc.setKeyTblDesc(keyTableDesc);
        ArrayList<ExprNodeColumnDesc> smallTableValueExpr = new ArrayList<ExprNodeColumnDesc>();
        for (int i = 0; i < testDesc.smallTableValueColumnNames.length; ++i) {
            smallTableValueExpr.add(new ExprNodeColumnDesc(testDesc.smallTableValueTypeInfos[i], testDesc.smallTableValueColumnNames[i], "S", false));
        }
        TableDesc valueTableDesc = PlanUtils.getMapJoinValueTableDesc((List)PlanUtils.getFieldSchemasFromColumnList(smallTableValueExpr, (String)""));
        ArrayList<TableDesc> valueTableDescsList = new ArrayList<TableDesc>();
        valueTableDescsList.add(null);
        valueTableDescsList.add(valueTableDesc);
        mapJoinDesc.setValueTblDescs(valueTableDescsList);
        mapJoinDesc.setValueFilteredTblDescs(valueTableDescsList);
        mapJoinDesc.setOutputColumnNames(Arrays.asList(testDesc.outputColumnNames));
        return mapJoinDesc;
    }

    public static VectorMapJoinDesc createVectorMapJoinDesc(MapJoinTestDescription testDesc) {
        VectorMapJoinDesc vectorDesc = new VectorMapJoinDesc();
        vectorDesc.setHashTableImplementationType(VectorMapJoinDesc.HashTableImplementationType.FAST);
        vectorDesc.setHashTableKind(switch (testDesc.vectorMapJoinVariation) {
            case VectorMapJoinDesc.VectorMapJoinVariation.INNER -> VectorMapJoinDesc.HashTableKind.HASH_MAP;
            case VectorMapJoinDesc.VectorMapJoinVariation.INNER_BIG_ONLY -> VectorMapJoinDesc.HashTableKind.HASH_MULTISET;
            case VectorMapJoinDesc.VectorMapJoinVariation.LEFT_SEMI, VectorMapJoinDesc.VectorMapJoinVariation.LEFT_ANTI -> VectorMapJoinDesc.HashTableKind.HASH_SET;
            case VectorMapJoinDesc.VectorMapJoinVariation.OUTER, VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER -> VectorMapJoinDesc.HashTableKind.HASH_MAP;
            default -> throw new RuntimeException("unknown operator variation " + testDesc.vectorMapJoinVariation);
        });
        VectorMapJoinDesc.HashTableKeyType hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.MULTI_KEY;
        if (testDesc.bigTableKeyTypeInfos.length == 1) {
            switch (((PrimitiveTypeInfo)testDesc.bigTableKeyTypeInfos[0]).getPrimitiveCategory()) {
                case BOOLEAN: {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BOOLEAN;
                    break;
                }
                case BYTE: {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BYTE;
                    break;
                }
                case SHORT: {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.SHORT;
                    break;
                }
                case INT: {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.INT;
                    break;
                }
                case LONG: {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.LONG;
                    break;
                }
                case STRING: {
                    hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.STRING;
                    break;
                }
            }
        }
        vectorDesc.setHashTableKeyType(hashTableKeyType);
        vectorDesc.setVectorMapJoinVariation(testDesc.vectorMapJoinVariation);
        vectorDesc.setMinMaxEnabled(false);
        VectorMapJoinInfo vectorMapJoinInfo = new VectorMapJoinInfo();
        vectorMapJoinInfo.setBigTableKeyColumnMap(testDesc.bigTableKeyColumnNums);
        vectorMapJoinInfo.setBigTableKeyColumnNames(testDesc.bigTableKeyColumnNames);
        vectorMapJoinInfo.setBigTableKeyTypeInfos(testDesc.bigTableKeyTypeInfos);
        vectorMapJoinInfo.setSlimmedBigTableKeyExpressions(null);
        vectorDesc.setAllBigTableKeyExpressions(null);
        vectorMapJoinInfo.setBigTableValueColumnMap(testDesc.bigTableColumnNums);
        vectorMapJoinInfo.setBigTableValueColumnNames(testDesc.bigTableColumnNames);
        vectorMapJoinInfo.setBigTableValueTypeInfos(testDesc.bigTableTypeInfos);
        vectorMapJoinInfo.setSlimmedBigTableValueExpressions(null);
        vectorDesc.setAllBigTableValueExpressions(null);
        vectorMapJoinInfo.setBigTableFilterExpressions(new VectorExpression[0]);
        VectorColumnOutputMapping bigTableRetainMapping = new VectorColumnOutputMapping("Big Table Retain Mapping");
        VectorColumnOutputMapping nonOuterSmallTableKeyMapping = new VectorColumnOutputMapping("Non Outer Small Table Key Key Mapping");
        VectorColumnOutputMapping outerSmallTableKeyMapping = new VectorColumnOutputMapping("Outer Small Table Key Mapping");
        VectorColumnSourceMapping fullOuterSmallTableKeyMapping = new VectorColumnSourceMapping("Full Outer Small Table Key Mapping");
        VectorColumnSourceMapping projectionMapping = new VectorColumnSourceMapping("Projection Mapping");
        int nextOutputColumn = 0;
        int bigTableRetainedSize = testDesc.bigTableRetainColumnNums.length;
        for (int i = 0; i < bigTableRetainedSize; ++i) {
            int batchColumnIndex = testDesc.bigTableRetainColumnNums[i];
            TypeInfo typeInfo = testDesc.bigTableTypeInfos[i];
            projectionMapping.add(nextOutputColumn, batchColumnIndex, typeInfo);
            if (!bigTableRetainMapping.containsOutputColumn(batchColumnIndex)) {
                bigTableRetainMapping.add(batchColumnIndex, batchColumnIndex, typeInfo);
            }
            ++nextOutputColumn;
        }
        boolean isOuterJoin = testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.OUTER || testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER;
        int emulateScratchColumn = testDesc.bigTableTypeInfos.length;
        VectorColumnOutputMapping smallTableKeyOutputMapping = new VectorColumnOutputMapping("Small Table Key Output Mapping");
        int smallTableKeyRetainSize = testDesc.smallTableRetainKeyColumnNums.length;
        for (int i = 0; i < testDesc.smallTableRetainKeyColumnNums.length; ++i) {
            int smallTableKeyColumnNum = testDesc.smallTableRetainKeyColumnNums[i];
            int bigTableKeyColumnNum = testDesc.bigTableKeyColumnNums[smallTableKeyColumnNum];
            TypeInfo keyTypeInfo = testDesc.smallTableKeyTypeInfos[smallTableKeyColumnNum];
            if (!isOuterJoin) {
                projectionMapping.add(nextOutputColumn, bigTableKeyColumnNum, keyTypeInfo);
                if (!bigTableRetainMapping.containsOutputColumn(bigTableKeyColumnNum)) {
                    nonOuterSmallTableKeyMapping.add(bigTableKeyColumnNum, bigTableKeyColumnNum, keyTypeInfo);
                }
            } else {
                outerSmallTableKeyMapping.add(bigTableKeyColumnNum, emulateScratchColumn, keyTypeInfo);
                projectionMapping.add(nextOutputColumn, emulateScratchColumn, keyTypeInfo);
                fullOuterSmallTableKeyMapping.add(smallTableKeyColumnNum, emulateScratchColumn, keyTypeInfo);
                ++emulateScratchColumn;
            }
            ++nextOutputColumn;
        }
        VectorColumnSourceMapping smallTableValueMapping = new VectorColumnSourceMapping("Small Table Value Mapping");
        for (int i = 0; i < testDesc.smallTableValueTypeInfos.length; ++i) {
            smallTableValueMapping.add(i, emulateScratchColumn, testDesc.smallTableValueTypeInfos[i]);
            projectionMapping.add(nextOutputColumn, emulateScratchColumn, testDesc.smallTableValueTypeInfos[i]);
            ++emulateScratchColumn;
            ++nextOutputColumn;
        }
        bigTableRetainMapping.finalize();
        vectorMapJoinInfo.setBigTableRetainColumnMap(bigTableRetainMapping.getOutputColumns());
        vectorMapJoinInfo.setBigTableRetainTypeInfos(bigTableRetainMapping.getTypeInfos());
        nonOuterSmallTableKeyMapping.finalize();
        vectorMapJoinInfo.setNonOuterSmallTableKeyColumnMap(nonOuterSmallTableKeyMapping.getOutputColumns());
        vectorMapJoinInfo.setNonOuterSmallTableKeyTypeInfos(nonOuterSmallTableKeyMapping.getTypeInfos());
        outerSmallTableKeyMapping.finalize();
        fullOuterSmallTableKeyMapping.finalize();
        vectorMapJoinInfo.setOuterSmallTableKeyMapping(outerSmallTableKeyMapping);
        vectorMapJoinInfo.setFullOuterSmallTableKeyMapping(fullOuterSmallTableKeyMapping);
        smallTableValueMapping.finalize();
        vectorMapJoinInfo.setSmallTableValueMapping(smallTableValueMapping);
        projectionMapping.finalize();
        assert (projectionMapping.isSourceSequenceGood());
        vectorMapJoinInfo.setProjectionMapping(projectionMapping);
        if (projectionMapping.getCount() != testDesc.outputColumnNames.length) {
            throw new RuntimeException();
        }
        vectorDesc.setVectorMapJoinInfo(vectorMapJoinInfo);
        return vectorDesc;
    }

    public static VectorMapJoinCommonOperator createNativeVectorMapJoinOperator(VectorMapJoinDesc.VectorMapJoinVariation VectorMapJoinVariation2, MapJoinDesc mapJoinDesc, VectorMapJoinDesc vectorDesc, VectorizationContext vContext) throws HiveException {
        VectorMapJoinInnerLongOperator operator;
        block0 : switch (vectorDesc.getHashTableKeyType()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                switch (VectorMapJoinVariation2) {
                    case INNER: {
                        operator = new VectorMapJoinInnerLongOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case INNER_BIG_ONLY: {
                        operator = new VectorMapJoinInnerBigOnlyLongOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case LEFT_SEMI: {
                        operator = new VectorMapJoinLeftSemiLongOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case OUTER: {
                        operator = new VectorMapJoinOuterLongOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case FULL_OUTER: {
                        operator = new VectorMapJoinFullOuterLongOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                }
                throw new RuntimeException("unknown operator variation " + VectorMapJoinVariation2);
            }
            case STRING: {
                switch (VectorMapJoinVariation2) {
                    case INNER: {
                        operator = new VectorMapJoinInnerStringOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case INNER_BIG_ONLY: {
                        operator = new VectorMapJoinInnerBigOnlyStringOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case LEFT_SEMI: {
                        operator = new VectorMapJoinLeftSemiStringOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case OUTER: {
                        operator = new VectorMapJoinOuterStringOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                    }
                    case FULL_OUTER: {
                        operator = new VectorMapJoinFullOuterStringOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                }
                throw new RuntimeException("unknown operator variation " + VectorMapJoinVariation2);
            }
            case MULTI_KEY: {
                switch (VectorMapJoinVariation2) {
                    case INNER: {
                        operator = new VectorMapJoinInnerMultiKeyOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case INNER_BIG_ONLY: {
                        operator = new VectorMapJoinInnerBigOnlyMultiKeyOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case LEFT_SEMI: {
                        operator = new VectorMapJoinLeftSemiMultiKeyOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case OUTER: {
                        operator = new VectorMapJoinOuterMultiKeyOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                    case FULL_OUTER: {
                        operator = new VectorMapJoinFullOuterMultiKeyOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorDesc);
                        break block0;
                    }
                }
                throw new RuntimeException("unknown operator variation " + VectorMapJoinVariation2);
            }
            default: {
                throw new RuntimeException("Unknown hash table key type " + vectorDesc.getHashTableKeyType());
            }
        }
        System.out.println("*BENCHMARK* createNativeVectorMapJoinOperator " + operator.getClass().getSimpleName());
        return operator;
    }

    public static VectorizationContext createVectorizationContext(MapJoinTestDescription testDesc) throws HiveException {
        int i;
        boolean isOuterJoin;
        VectorizationContext vContext = new VectorizationContext("test", testDesc.bigTableColumnNameList);
        boolean bl = isOuterJoin = testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.OUTER || testDesc.vectorMapJoinVariation == VectorMapJoinDesc.VectorMapJoinVariation.FULL_OUTER;
        if (isOuterJoin) {
            for (i = 0; i < testDesc.smallTableRetainKeyColumnNums.length; ++i) {
                int smallTableKeyRetainColumnNum = testDesc.smallTableRetainKeyColumnNums[i];
                vContext.allocateScratchColumn(testDesc.smallTableKeyTypeInfos[smallTableKeyRetainColumnNum]);
            }
        }
        for (i = 0; i < testDesc.smallTableRetainValueColumnNums.length; ++i) {
            vContext.allocateScratchColumn(testDesc.smallTableValueTypeInfos[i]);
        }
        return vContext;
    }

    private static boolean hasFilter(MapJoinDesc mapJoinDesc, int alias) {
        int[][] filterMaps = mapJoinDesc.getFilterMap();
        return filterMaps != null && filterMaps[alias] != null;
    }

    public static MapJoinTableContainerSerDe createMapJoinTableContainerSerDe(MapJoinDesc mapJoinDesc) throws SerDeException {
        Byte smallTablePos = 1;
        TableDesc keyTableDesc = mapJoinDesc.getKeyTblDesc();
        AbstractSerDe keySerializer = (AbstractSerDe)ReflectionUtil.newInstance(BinarySortableSerDe.class, null);
        keySerializer.initialize(null, keyTableDesc.getProperties(), null);
        MapJoinObjectSerDeContext keyContext = new MapJoinObjectSerDeContext(keySerializer, false);
        List valueTableDescList = mapJoinDesc.getNoOuterJoin() ? mapJoinDesc.getValueTblDescs() : mapJoinDesc.getValueFilteredTblDescs();
        TableDesc valueTableDesc = (TableDesc)valueTableDescList.get(smallTablePos.byteValue());
        AbstractSerDe valueSerDe = (AbstractSerDe)ReflectionUtil.newInstance((Class)valueTableDesc.getSerDeClass(), null);
        valueSerDe.initialize(null, valueTableDesc.getProperties(), null);
        MapJoinObjectSerDeContext valueContext = new MapJoinObjectSerDeContext(valueSerDe, MapJoinTestConfig.hasFilter(mapJoinDesc, smallTablePos.byteValue()));
        MapJoinTableContainerSerDe mapJoinTableContainerSerDe = new MapJoinTableContainerSerDe(keyContext, valueContext);
        return mapJoinTableContainerSerDe;
    }

    public static void connectOperators(Operator<? extends OperatorDesc> operator, Operator<? extends OperatorDesc> childOperator) throws HiveException {
        List<Operator<? extends OperatorDesc>> newParentOperators = MapJoinTestConfig.newOperatorList();
        newParentOperators.addAll(childOperator.getParentOperators());
        newParentOperators.add(operator);
        childOperator.setParentOperators(newParentOperators);
        List<Operator<? extends OperatorDesc>> newChildOperators = MapJoinTestConfig.newOperatorList();
        newChildOperators.addAll(operator.getChildOperators());
        newChildOperators.add(childOperator);
        operator.setChildOperators(newChildOperators);
    }

    private static List<Integer> intArrayToList(int[] intArray) {
        ArrayList<Integer> intList = new ArrayList<Integer>(intArray.length);
        for (int i = 0; i < intArray.length; ++i) {
            intList.add(intArray[i]);
        }
        return intList;
    }

    private static void loadTableContainerData(MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinTableContainer mapJoinTableContainer) throws IOException, SerDeException, HiveException {
        LazyBinarySerializeWrite valueSerializeWrite = null;
        ByteStream.Output valueOutput = null;
        if (testData.smallTableValues != null) {
            valueSerializeWrite = new LazyBinarySerializeWrite(testDesc.smallTableValueTypeInfos.length);
            valueOutput = new ByteStream.Output();
        }
        BytesWritable valueBytesWritable = new BytesWritable();
        BytesWritable keyBytesWritable = new BytesWritable();
        BinarySortableSerializeWrite keySerializeWrite = new BinarySortableSerializeWrite(testDesc.bigTableKeyTypeInfos.length);
        ByteStream.Output keyOutput = new ByteStream.Output();
        int round = 0;
        boolean atLeastOneValueAdded = false;
        while (true) {
            for (Map.Entry<RowTestObjects, Integer> testRowEntry : testData.smallTableKeyHashMap.entrySet()) {
                int smallTableKeyIndex = testRowEntry.getValue();
                int valueCount = testData.smallTableValueCounts.get(smallTableKeyIndex);
                boolean addEntry = round + 1 <= valueCount;
                if (!addEntry) continue;
                atLeastOneValueAdded = true;
                RowTestObjects valueRow = null;
                if (testData.smallTableValues != null) {
                    ArrayList<RowTestObjects> valueList = testData.smallTableValues.get(smallTableKeyIndex);
                    valueRow = valueList.get(round);
                }
                Object[] smallTableKey = testRowEntry.getKey().getRow();
                keyOutput.reset();
                keySerializeWrite.set(keyOutput);
                for (int index = 0; index < testDesc.bigTableKeyTypeInfos.length; ++index) {
                    Writable keyWritable = (Writable)smallTableKey[index];
                    VerifyFastRow.serializeWrite((SerializeWrite)keySerializeWrite, (TypeInfo)((PrimitiveTypeInfo)testDesc.bigTableKeyTypeInfos[index]), keyWritable);
                }
                keyBytesWritable.set(keyOutput.getData(), 0, keyOutput.getLength());
                if (valueRow == null) {
                    mapJoinTableContainer.putRow((Writable)keyBytesWritable, (Writable)valueBytesWritable);
                    continue;
                }
                Object[] smallTableValue = valueRow.getRow();
                valueOutput.reset();
                valueSerializeWrite.set(valueOutput);
                for (int index = 0; index < testDesc.smallTableValueTypeInfos.length; ++index) {
                    Writable valueWritable = (Writable)smallTableValue[index];
                    VerifyFastRow.serializeWrite((SerializeWrite)valueSerializeWrite, (TypeInfo)((PrimitiveTypeInfo)testDesc.smallTableValueTypeInfos[index]), valueWritable);
                }
                valueBytesWritable.set(valueOutput.getData(), 0, valueOutput.getLength());
                mapJoinTableContainer.putRow((Writable)keyBytesWritable, (Writable)valueBytesWritable);
            }
            if (testData.smallTableValues == null || !atLeastOneValueAdded) break;
            ++round;
            atLeastOneValueAdded = false;
        }
        mapJoinTableContainer.seal();
    }

    public static CreateMapJoinResult createMapJoin(MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinDesc mapJoinDesc, boolean isVectorMapJoin, boolean isOriginalMapJoin, MapJoinTableContainer shareMapJoinTableContainer) throws SerDeException, IOException, HiveException {
        Object operator;
        Byte bigTablePos = 0;
        MapJoinTableContainerSerDe mapJoinTableContainerSerDe = MapJoinTestConfig.createMapJoinTableContainerSerDe(mapJoinDesc);
        MapJoinObjectSerDeContext valCtx = mapJoinTableContainerSerDe.getValueContext();
        HashMapWrapper mapJoinTableContainer = isOriginalMapJoin ? new HashMapWrapper((Configuration)testDesc.hiveConf, -1L) : new MapJoinBytesTableContainer((Configuration)testDesc.hiveConf, valCtx, (long)testData.smallTableKeyHashMap.size(), 0L);
        mapJoinTableContainer.setSerde(mapJoinTableContainerSerDe.getKeyContext(), mapJoinTableContainerSerDe.getValueContext());
        MapJoinTestConfig.loadTableContainerData(testDesc, testData, (MapJoinTableContainer)mapJoinTableContainer);
        if (!isVectorMapJoin) {
            operator = new MapJoinOperator(new CompilationOpContext());
            operator.setConf((OperatorDesc)mapJoinDesc);
        } else {
            VectorizationContext vContext = new VectorizationContext("test", testDesc.bigTableColumnNameList);
            VectorMapJoinDesc vectorMapJoinDesc = new VectorMapJoinDesc();
            byte posBigTable = (byte)mapJoinDesc.getPosBigTable();
            VectorExpression[] allBigTableKeyExpressions = vContext.getVectorExpressions((List)mapJoinDesc.getKeys().get(posBigTable));
            vectorMapJoinDesc.setAllBigTableKeyExpressions(allBigTableKeyExpressions);
            Map exprs = mapJoinDesc.getExprs();
            VectorExpression[] allBigTableValueExpressions = vContext.getVectorExpressions((List)exprs.get(posBigTable));
            vectorMapJoinDesc.setAllBigTableValueExpressions(allBigTableValueExpressions);
            List bigTableFilters = (List)mapJoinDesc.getFilters().get(bigTablePos);
            boolean isOuterAndFiltered = !mapJoinDesc.isNoOuterJoin() && bigTableFilters.size() > 0;
            operator = !isOuterAndFiltered ? new VectorMapJoinOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorMapJoinDesc) : new VectorMapJoinOuterFilteredOperator(new CompilationOpContext(), (OperatorDesc)mapJoinDesc, vContext, (VectorDesc)vectorMapJoinDesc);
        }
        HiveConf.setBoolVar((Configuration)testDesc.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAPJOIN_TESTING_NO_HASH_TABLE_LOAD, (boolean)true);
        return new CreateMapJoinResult((MapJoinOperator)operator, (MapJoinTableContainer)mapJoinTableContainer, mapJoinTableContainerSerDe);
    }

    public static CreateMapJoinResult createNativeVectorMapJoin(MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinDesc mapJoinDesc, VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType, MapJoinTableContainer shareMapJoinTableContainer) throws SerDeException, IOException, HiveException {
        MapJoinBytesTableContainer mapJoinTableContainer;
        VectorMapJoinDesc vectorDesc = MapJoinTestConfig.createVectorMapJoinDesc(testDesc);
        mapJoinDesc.setVectorDesc((VectorDesc)vectorDesc);
        vectorDesc.setHashTableImplementationType(hashTableImplementationType);
        VectorMapJoinInfo vectorMapJoinInfo = vectorDesc.getVectorMapJoinInfo();
        MapJoinTableContainerSerDe mapJoinTableContainerSerDe = null;
        switch (vectorDesc.getHashTableImplementationType()) {
            case OPTIMIZED: {
                mapJoinTableContainer = new MapJoinBytesTableContainer((Configuration)testDesc.hiveConf, null, (long)testData.smallTableKeyHashMap.size(), 0L);
                mapJoinTableContainerSerDe = MapJoinTestConfig.createMapJoinTableContainerSerDe(mapJoinDesc);
                mapJoinTableContainer.setSerde(mapJoinTableContainerSerDe.getKeyContext(), mapJoinTableContainerSerDe.getValueContext());
                break;
            }
            case FAST: {
                mapJoinTableContainer = new VectorMapJoinFastTableContainer(mapJoinDesc, (Configuration)testDesc.hiveConf, (long)testData.smallTableKeyHashMap.size(), 1);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected hash table implementation type " + vectorDesc.getHashTableImplementationType());
            }
        }
        MapJoinTestConfig.loadTableContainerData(testDesc, testData, (MapJoinTableContainer)mapJoinTableContainer);
        VectorizationContext vContext = MapJoinTestConfig.createVectorizationContext(testDesc);
        byte posBigTable = (byte)mapJoinDesc.getPosBigTable();
        VectorExpression[] slimmedBigTableKeyExpressions = vContext.getVectorExpressions((List)mapJoinDesc.getKeys().get(posBigTable));
        vectorMapJoinInfo.setSlimmedBigTableKeyExpressions(slimmedBigTableKeyExpressions);
        Map exprs = mapJoinDesc.getExprs();
        VectorExpression[] slimmedBigTableValueExpressions = vContext.getVectorExpressions((List)exprs.get(posBigTable));
        vectorMapJoinInfo.setSlimmedBigTableValueExpressions(slimmedBigTableValueExpressions);
        VectorMapJoinCommonOperator operator = MapJoinTestConfig.createNativeVectorMapJoinOperator(testDesc.vectorMapJoinVariation, mapJoinDesc, vectorDesc, vContext);
        HiveConf.setBoolVar((Configuration)testDesc.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAPJOIN_TESTING_NO_HASH_TABLE_LOAD, (boolean)true);
        return new CreateMapJoinResult((MapJoinOperator)operator, (MapJoinTableContainer)mapJoinTableContainer, mapJoinTableContainerSerDe);
    }

    public static CreateMapJoinResult createMapJoinImplementation(MapJoinTestImplementation mapJoinImplementation, MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinDesc mapJoinDesc) throws SerDeException, IOException, HiveException {
        return MapJoinTestConfig.createMapJoinImplementation(mapJoinImplementation, testDesc, testData, mapJoinDesc, null);
    }

    public static CreateMapJoinResult createMapJoinImplementation(MapJoinTestImplementation mapJoinImplementation, MapJoinTestDescription testDesc, MapJoinTestData testData, MapJoinDesc mapJoinDesc, MapJoinTableContainer shareMapJoinTableContainer) throws SerDeException, IOException, HiveException {
        return switch (mapJoinImplementation) {
            case MapJoinTestImplementation.ROW_MODE_HASH_MAP -> MapJoinTestConfig.createMapJoin(testDesc, testData, mapJoinDesc, false, true, shareMapJoinTableContainer);
            case MapJoinTestImplementation.ROW_MODE_OPTIMIZED -> MapJoinTestConfig.createMapJoin(testDesc, testData, mapJoinDesc, false, false, shareMapJoinTableContainer);
            case MapJoinTestImplementation.VECTOR_PASS_THROUGH -> MapJoinTestConfig.createMapJoin(testDesc, testData, mapJoinDesc, true, false, shareMapJoinTableContainer);
            case MapJoinTestImplementation.NATIVE_VECTOR_OPTIMIZED -> MapJoinTestConfig.createNativeVectorMapJoin(testDesc, testData, mapJoinDesc, VectorMapJoinDesc.HashTableImplementationType.OPTIMIZED, shareMapJoinTableContainer);
            case MapJoinTestImplementation.NATIVE_VECTOR_FAST -> MapJoinTestConfig.createNativeVectorMapJoin(testDesc, testData, mapJoinDesc, VectorMapJoinDesc.HashTableImplementationType.FAST, shareMapJoinTableContainer);
            default -> throw new RuntimeException("Unexpected MapJoin Operator Implementation " + mapJoinImplementation);
        };
    }

    private static Operator<SelectDesc> makeInterceptSelectOperator(MapJoinOperator mapJoinOperator, int bigTableKeySize, int bigTableRetainSize, String[] outputColumnNames, TypeInfo[] outputTypeInfos) {
        MapJoinDesc mapJoinDesc = (MapJoinDesc)mapJoinOperator.getConf();
        ArrayList<Object> selectExprList = new ArrayList<Object>();
        ArrayList<String> selectOutputColumnNameList = new ArrayList<String>();
        for (int i = 0; i < bigTableRetainSize; ++i) {
            String selectOutputColumnName = HiveConf.getColumnInternalName((int)i);
            selectOutputColumnNameList.add(selectOutputColumnName);
            TypeInfo outputTypeInfo = outputTypeInfos[i];
            if (i < bigTableKeySize) {
                ExprNodeColumnDesc keyColumnExpr = new ExprNodeColumnDesc(outputTypeInfo, outputColumnNames[i], "test", false);
                selectExprList.add(keyColumnExpr);
                continue;
            }
            ExprNodeConstantDesc nullExtraColumnExpr = new ExprNodeConstantDesc(outputTypeInfo, null);
            nullExtraColumnExpr.setFoldedFromCol(outputColumnNames[i]);
            selectExprList.add(nullExtraColumnExpr);
        }
        SelectDesc selectDesc = new SelectDesc(selectExprList, selectOutputColumnNameList);
        Operator selectOperator = OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), (OperatorDesc)selectDesc);
        return selectOperator;
    }

    private static Operator<SelectDesc> vectorizeInterceptSelectOperator(MapJoinOperator mapJoinOperator, int bigTableKeySize, int bigTableRetainSize, Operator<SelectDesc> selectOperator) throws HiveException {
        MapJoinDesc mapJoinDesc = (MapJoinDesc)mapJoinOperator.getConf();
        VectorizationContext vOutContext = ((VectorizationContextRegion)mapJoinOperator).getOutputVectorizationContext();
        SelectDesc selectDesc = (SelectDesc)selectOperator.getConf();
        List selectExprs = selectDesc.getColList();
        Object[] selectVectorExpr = new VectorExpression[bigTableRetainSize];
        for (int i = 0; i < bigTableRetainSize; ++i) {
            TypeInfo typeInfo = ((ExprNodeDesc)selectExprs.get(i)).getTypeInfo();
            if (i < bigTableKeySize) {
                selectVectorExpr[i] = vOutContext.getVectorExpression((ExprNodeDesc)selectExprs.get(i));
                continue;
            }
            NoOpExpression noOpExpression = new NoOpExpression(i);
            noOpExpression.setInputTypeInfos(new TypeInfo[]{typeInfo});
            noOpExpression.setInputDataTypePhysicalVariations(new DataTypePhysicalVariation[]{DataTypePhysicalVariation.NONE});
            noOpExpression.setOutputTypeInfo(typeInfo);
            noOpExpression.setOutputDataTypePhysicalVariation(DataTypePhysicalVariation.NONE);
            selectVectorExpr[i] = noOpExpression;
        }
        System.out.println("*BENCHMARK* VectorSelectOperator selectVectorExpr " + Arrays.toString(selectVectorExpr));
        int[] projectedColumns = ArrayUtils.toPrimitive((Integer[])vOutContext.getProjectedColumns().subList(0, bigTableRetainSize).toArray(new Integer[0]));
        System.out.println("*BENCHMARK* VectorSelectOperator projectedColumns " + Arrays.toString(projectedColumns));
        VectorSelectDesc vectorSelectDesc = new VectorSelectDesc();
        vectorSelectDesc.setSelectExpressions((VectorExpression[])selectVectorExpr);
        vectorSelectDesc.setProjectedOutputColumns(projectedColumns);
        Operator vectorSelectOperator = OperatorFactory.getVectorOperator((CompilationOpContext)selectOperator.getCompilationOpContext(), (OperatorDesc)selectDesc, (VectorizationContext)vOutContext, (VectorDesc)vectorSelectDesc);
        return vectorSelectOperator;
    }

    public static CountCollectorTestOperator addFullOuterIntercept(MapJoinTestImplementation mapJoinImplementation, MapJoinTestDescription testDesc, RowTestObjectsMultiSet outputTestRowMultiSet, MapJoinTestData testData, MapJoinOperator mapJoinOperator, MapJoinTableContainer mapJoinTableContainer, MapJoinTableContainerSerDe mapJoinTableContainerSerDe) throws SerDeException, IOException, HiveException {
        RowCollectorTestOperatorBase interceptTestCollectorOperator;
        MapJoinDesc mapJoinDesc = (MapJoinDesc)mapJoinOperator.getConf();
        Map keyMap = mapJoinDesc.getKeys();
        List bigTableKeyExprs = (List)keyMap.get((byte)0);
        int bigTableKeySize = bigTableKeyExprs.size();
        Map retainMap = mapJoinDesc.getRetainList();
        List bigTableRetainList = (List)retainMap.get((byte)0);
        int bigTableRetainSize = bigTableRetainList.size();
        List outputColumnNameList = mapJoinDesc.getOutputColumnNames();
        String[] mapJoinOutputColumnNames = outputColumnNameList.toArray(new String[0]);
        TypeInfo[] mapJoinOutputTypeInfos = VectorMapJoinBaseOperator.getOutputTypeInfos((MapJoinDesc)mapJoinDesc);
        boolean isVectorOutput = MapJoinTestConfig.isVectorOutput(mapJoinImplementation);
        Operator<SelectDesc> selectOperator = MapJoinTestConfig.makeInterceptSelectOperator(mapJoinOperator, bigTableKeySize, bigTableRetainSize, mapJoinOutputColumnNames, mapJoinOutputTypeInfos);
        List selectOutputColumnNameList = ((SelectDesc)selectOperator.getConf()).getOutputColumnNames();
        String[] selectOutputColumnNames = selectOutputColumnNameList.toArray(new String[0]);
        if (isVectorOutput) {
            selectOperator = MapJoinTestConfig.vectorizeInterceptSelectOperator(mapJoinOperator, bigTableKeySize, bigTableRetainSize, selectOperator);
        }
        MapJoinTestDescription interceptTestDesc = new MapJoinTestDescription(testDesc.hiveConf, testDesc.vectorMapJoinVariation, selectOutputColumnNames, Arrays.copyOf(mapJoinOutputTypeInfos, bigTableRetainSize), testDesc.bigTableKeyColumnNums, testDesc.smallTableValueTypeInfos, testDesc.smallTableRetainKeyColumnNums, testDesc.smallTableGenerationParameters, testDesc.mapJoinPlanVariation);
        MapJoinDesc intersectMapJoinDesc = MapJoinTestConfig.createMapJoinDesc(interceptTestDesc, true);
        CreateMapJoinResult interceptCreateMapJoinResult = MapJoinTestConfig.createMapJoinImplementation(mapJoinImplementation, interceptTestDesc, testData, intersectMapJoinDesc);
        MapJoinOperator intersectMapJoinOperator = interceptCreateMapJoinResult.mapJoinOperator;
        MapJoinTableContainer intersectMapJoinTableContainer = interceptCreateMapJoinResult.mapJoinTableContainer;
        MapJoinTableContainerSerDe interceptMapJoinTableContainerSerDe = interceptCreateMapJoinResult.mapJoinTableContainerSerDe;
        MapJoinTestConfig.connectOperators((Operator<? extends OperatorDesc>)mapJoinOperator, selectOperator);
        MapJoinTestConfig.connectOperators(selectOperator, (Operator<? extends OperatorDesc>)intersectMapJoinOperator);
        if (!isVectorOutput) {
            interceptTestCollectorOperator = new TestMultiSetCollectorOperator(interceptTestDesc.outputObjectInspectors, outputTestRowMultiSet);
        } else {
            VectorizationContext vContext = ((VectorizationContextRegion)intersectMapJoinOperator).getOutputVectorizationContext();
            int[] intersectProjectionColumns = ArrayUtils.toPrimitive((Integer[])vContext.getProjectedColumns().toArray(new Integer[0]));
            interceptTestCollectorOperator = new TestMultiSetVectorCollectorOperator(intersectProjectionColumns, interceptTestDesc.outputTypeInfos, interceptTestDesc.outputObjectInspectors, outputTestRowMultiSet);
        }
        MapJoinTestConfig.connectOperators((Operator<? extends OperatorDesc>)intersectMapJoinOperator, interceptTestCollectorOperator);
        intersectMapJoinOperator.setInputObjInspectors(interceptTestDesc.inputObjectInspectors);
        mapJoinOperator.initialize((Configuration)testDesc.hiveConf, testDesc.inputObjectInspectors);
        mapJoinOperator.setTestMapJoinTableContainer(1, mapJoinTableContainer, mapJoinTableContainerSerDe);
        intersectMapJoinOperator.setTestMapJoinTableContainer(1, intersectMapJoinTableContainer, interceptMapJoinTableContainerSerDe);
        return interceptTestCollectorOperator;
    }

    private static List<Operator<? extends OperatorDesc>> newOperatorList() {
        return new ArrayList<Operator<? extends OperatorDesc>>();
    }

    public static enum MapJoinTestImplementation {
        ROW_MODE_HASH_MAP,
        ROW_MODE_OPTIMIZED,
        VECTOR_PASS_THROUGH,
        NATIVE_VECTOR_OPTIMIZED,
        NATIVE_VECTOR_FAST;

    }

    public static class CreateMapJoinResult {
        public final MapJoinOperator mapJoinOperator;
        public final MapJoinTableContainer mapJoinTableContainer;
        public final MapJoinTableContainerSerDe mapJoinTableContainerSerDe;

        public CreateMapJoinResult(MapJoinOperator mapJoinOperator, MapJoinTableContainer mapJoinTableContainer, MapJoinTableContainerSerDe mapJoinTableContainerSerDe) {
            this.mapJoinOperator = mapJoinOperator;
            this.mapJoinTableContainer = mapJoinTableContainer;
            this.mapJoinTableContainerSerDe = mapJoinTableContainerSerDe;
        }
    }

    public static class TestMultiSetCollectorOperator
    extends RowCollectorTestOperator {
        private final RowTestObjectsMultiSet testRowMultiSet;

        public TestMultiSetCollectorOperator(ObjectInspector[] outputObjectInspectors, RowTestObjectsMultiSet testRowMultiSet) {
            super(outputObjectInspectors);
            this.testRowMultiSet = testRowMultiSet;
        }

        public RowTestObjectsMultiSet getTestRowMultiSet() {
            return this.testRowMultiSet;
        }

        @Override
        public void nextTestRow(RowTestObjects testRow) {
            this.testRowMultiSet.add(testRow, RowTestObjectsMultiSet.RowFlag.NONE);
        }

        @Override
        public String getName() {
            return TestMultiSetCollectorOperator.class.getSimpleName();
        }
    }

    public static class TestMultiSetVectorCollectorOperator
    extends RowVectorCollectorTestOperator {
        private final RowTestObjectsMultiSet testRowMultiSet;

        public RowTestObjectsMultiSet getTestRowMultiSet() {
            return this.testRowMultiSet;
        }

        public TestMultiSetVectorCollectorOperator(TypeInfo[] outputTypeInfos, ObjectInspector[] outputObjectInspectors, RowTestObjectsMultiSet testRowMultiSet) throws HiveException {
            super(outputTypeInfos, outputObjectInspectors);
            this.testRowMultiSet = testRowMultiSet;
        }

        public TestMultiSetVectorCollectorOperator(int[] outputProjectionColumnNums, TypeInfo[] outputTypeInfos, ObjectInspector[] outputObjectInspectors, RowTestObjectsMultiSet testRowMultiSet) throws HiveException {
            super(outputProjectionColumnNums, outputTypeInfos, outputObjectInspectors);
            this.testRowMultiSet = testRowMultiSet;
        }

        @Override
        public void nextTestRow(RowTestObjects testRow) {
            this.testRowMultiSet.add(testRow, RowTestObjectsMultiSet.RowFlag.NONE);
        }

        @Override
        public String getName() {
            return TestMultiSetVectorCollectorOperator.class.getSimpleName();
        }
    }
}

