/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.exceptions.CsvException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampString;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestVectorUDFUnixTimeStampString {
    private final String value;
    private final String zone;
    private final String formatter;
    private final Long expectedResult;

    public TestVectorUDFUnixTimeStampString(String value, String zone, String formatter, String expectedResult) {
        this.value = value;
        this.zone = zone;
        this.formatter = formatter;
        this.expectedResult = expectedResult.equals("null") ? null : Long.valueOf(Long.parseLong(expectedResult));
    }

    @Parameterized.Parameters(name="('{0}'), zone={1}, parserLegacy={2}")
    public static Collection<String[]> readInputs() throws IOException, CsvException {
        CSVParser parser = new CSVParserBuilder().withSeparator(';').withIgnoreQuotations(true).build();
        try (InputStream in = TestVectorUDFUnixTimeStampString.class.getResourceAsStream("TestVectorUnixTimeStampString.csv");){
            List list;
            block12: {
                Objects.requireNonNull(in);
                CSVReader reader = new CSVReaderBuilder((Reader)new InputStreamReader(in)).withCSVParser((ICSVParser)parser).build();
                try {
                    list = reader.readAll();
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return list;
        }
    }

    @Test
    public void testEvaluate() throws HiveException, InterruptedException, CharacterCodingException {
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        conf.setVar(HiveConf.ConfVars.HIVE_DATETIME_FORMATTER, this.formatter);
        conf.setVar(HiveConf.ConfVars.HIVE_LOCAL_TIME_ZONE, this.zone);
        SessionState state = SessionState.start((HiveConf)conf);
        VectorUDFUnixTimeStampString udf = new VectorUDFUnixTimeStampString(0, 1);
        udf.setInputTypeInfos(new TypeInfo[]{TypeInfoFactory.stringTypeInfo});
        udf.transientInit((Configuration)conf);
        VectorizedRowBatch batch = TestVectorUDFUnixTimeStampString.singleElementRowBatch(this.value);
        udf.evaluate(batch);
        LongColumnVector result = (LongColumnVector)batch.cols[1];
        if (this.expectedResult == null) {
            Assert.assertTrue((String)this.udfDisplayWithInputs(), (boolean)result.isNull[0]);
        } else {
            Assert.assertEquals((String)this.udfDisplayWithInputs(), (long)this.expectedResult, (long)result.vector[0]);
        }
        SessionState.endStart((SessionState)state);
    }

    private String udfDisplayWithInputs() {
        return "unix_timestamp(" + this.value + ") sessionZone=" + this.zone + ", legacy=" + this.formatter;
    }

    private static VectorizedRowBatch singleElementRowBatch(String e) throws CharacterCodingException {
        BytesColumnVector bcv = new BytesColumnVector();
        byte[] encoded = Text.encode((String)e).array();
        bcv.vector[0] = encoded;
        bcv.start[0] = 0;
        bcv.length[0] = encoded.length;
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        batch.cols[0] = bcv;
        batch.cols[1] = new LongColumnVector();
        batch.size = 1;
        return batch;
    }
}

