/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDatetimeLegacyHybridCalendarDate;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDatetimeLegacyHybridCalendarTimestamp;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDatetimeLegacyHybridCalendar;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorUDFDatetimeLegacyHybridCalendar {
    @Test
    public void testVectorUDFDatetimeLegacyHybridCalendarTimestamp() throws HiveException {
        VectorizedRowBatch batch = this.getFreshBatchOfTimestamps(1024);
        Assert.assertTrue((boolean)((TimestampColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((TimestampColumnVector)batch.cols[1]).isRepeating);
        this.verifyVectorUDFDatetimeLegacyHybridCalendarTimestamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyVectorUDFDatetimeLegacyHybridCalendarTimestamp(batch);
        batch = this.getFreshBatchOfTimestamps(1);
        batch.cols[0].isRepeating = true;
        this.verifyVectorUDFDatetimeLegacyHybridCalendarTimestamp(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyVectorUDFDatetimeLegacyHybridCalendarTimestamp(batch);
        batch = this.getFreshBatchOfTimestamps(3);
        batch.cols[0].isRepeating = false;
        batch.selectedInUse = true;
        batch.selected = new int[]{0, 1, 2};
        this.verifyVectorUDFDatetimeLegacyHybridCalendarTimestamp(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyVectorUDFDatetimeLegacyHybridCalendarTimestamp(batch);
    }

    private VectorizedRowBatch getFreshBatchOfTimestamps(int size) {
        return this.getVectorizedRowBatch(new Timestamp[]{new Timestamp(org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)"0001-01-01 00:00:00").toEpochMilli()), new Timestamp(org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)"1400-01-01 00:30:00.123456").toEpochMilli()), new Timestamp(org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)"1500-01-01 00:30:00").toEpochMilli()), new Timestamp(org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)"1583-01-01 00:30:00.123").toEpochMilli())}, size);
    }

    private VectorizedRowBatch getVectorizedRowBatch(Timestamp[] inputs, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        TimestampColumnVector inputCol = new TimestampColumnVector(size);
        for (int i = 0; i < size; ++i) {
            inputCol.set(i, inputs[i % inputs.length]);
        }
        batch.cols[0] = inputCol;
        batch.cols[1] = new TimestampColumnVector(size);
        batch.size = size;
        return batch;
    }

    private void verifyVectorUDFDatetimeLegacyHybridCalendarTimestamp(VectorizedRowBatch batch) throws HiveException {
        GenericUDFDatetimeLegacyHybridCalendar genUdf = new GenericUDFDatetimeLegacyHybridCalendar();
        genUdf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableTimestampObjectInspector});
        VectorUDFDatetimeLegacyHybridCalendarTimestamp vecUdf = new VectorUDFDatetimeLegacyHybridCalendarTimestamp(0, 1);
        vecUdf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                Timestamp input = ((TimestampColumnVector)batch.cols[0]).asScratchTimestamp(i);
                Timestamp result = ((TimestampColumnVector)batch.cols[1]).asScratchTimestamp(i);
                this.compareToUDFDatetimeLegacyHybridCalendar((GenericUDF)genUdf, input, result);
                continue;
            }
            Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
        }
    }

    private void compareToUDFDatetimeLegacyHybridCalendar(GenericUDF udf, Timestamp in, Timestamp out) throws HiveException {
        TimestampWritableV2 tswInput = new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)in.getTime(), (int)in.getNanos()));
        TimestampWritableV2 tswOutput = (TimestampWritableV2)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)tswInput)});
        Assert.assertEquals((Object)tswOutput.getTimestamp(), (Object)org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)out.getTime()));
        Assert.assertEquals((long)tswOutput.getNanos(), (long)out.getNanos());
    }

    @Test
    public void testVectorUDFDatetimeLegacyHybridCalendarDate() throws HiveException {
        VectorizedRowBatch batch = this.getFreshBatchOfDates(1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyVectorUDFDatetimeLegacyHybridCalendarDate(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyVectorUDFDatetimeLegacyHybridCalendarDate(batch);
        batch = this.getFreshBatchOfDates(1);
        batch.cols[0].isRepeating = true;
        this.verifyVectorUDFDatetimeLegacyHybridCalendarDate(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyVectorUDFDatetimeLegacyHybridCalendarDate(batch);
        batch = this.getFreshBatchOfDates(3);
        batch.cols[0].isRepeating = false;
        batch.selectedInUse = true;
        batch.selected = new int[]{0, 1, 2};
        this.verifyVectorUDFDatetimeLegacyHybridCalendarDate(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyVectorUDFDatetimeLegacyHybridCalendarDate(batch);
    }

    private VectorizedRowBatch getFreshBatchOfDates(int size) {
        return this.getVectorizedRowBatch(new Long[]{Date.valueOf((String)"0001-01-01").toEpochDay(), Date.valueOf((String)"1400-01-01").toEpochDay(), Date.valueOf((String)"1500-01-01").toEpochDay(), Date.valueOf((String)"1583-01-01").toEpochDay()}, size);
    }

    private VectorizedRowBatch getVectorizedRowBatch(Long[] inputs, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        LongColumnVector inputCol = new LongColumnVector(size);
        for (int i = 0; i < size; ++i) {
            inputCol.vector[i] = inputs[i % inputs.length];
        }
        batch.cols[0] = inputCol;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private void verifyVectorUDFDatetimeLegacyHybridCalendarDate(VectorizedRowBatch batch) throws HiveException {
        GenericUDFDatetimeLegacyHybridCalendar genUdf = new GenericUDFDatetimeLegacyHybridCalendar();
        genUdf.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDateObjectInspector});
        VectorUDFDatetimeLegacyHybridCalendarDate vecUdf = new VectorUDFDatetimeLegacyHybridCalendarDate(0, 1);
        vecUdf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                long input = ((LongColumnVector)batch.cols[0]).vector[i];
                long output = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFDatetimeLegacyHybridCalendar((GenericUDF)genUdf, input, output);
                continue;
            }
            Assert.assertEquals((Object)batch.cols[1].isNull[i], (Object)batch.cols[0].isNull[i]);
        }
    }

    private void compareToUDFDatetimeLegacyHybridCalendar(GenericUDF udf, long in, long out) throws HiveException {
        DateWritableV2 dateWInput = new DateWritableV2((int)in);
        DateWritableV2 dateWOutput = (DateWritableV2)udf.evaluate(new GenericUDF.DeferredObject[]{new GenericUDF.DeferredJavaObject((Object)dateWInput)});
        Assert.assertEquals((Object)dateWOutput.get(), (Object)Date.ofEpochDay((int)((int)out)));
    }
}

