/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastDateToStringWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToDateWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastStringToTimestampWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.CastTimestampToStringWithFormat;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TestVectorMathFunctions;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorTypeCastsWithFormat {
    @Test
    public void testCastDateToStringWithFormat() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDateInStringOutFormatted();
        BytesColumnVector resultV = (BytesColumnVector)b.cols[1];
        CastDateToStringWithFormat expr = new CastDateToStringWithFormat(0, "yyyy".getBytes(), 1);
        expr.evaluate(b);
        this.verifyString(0, "2019", resultV);
        this.verifyString(1, "1776", resultV);
        this.verifyString(2, "2012", resultV);
        this.verifyString(3, "1580", resultV);
        this.verifyString(4, "0005", resultV);
        this.verifyString(5, "9999", resultV);
        expr = new CastDateToStringWithFormat(0, "MM".getBytes(), 1);
        resultV = new BytesColumnVector();
        b.cols[1] = resultV;
        expr.evaluate(b);
        this.verifyString(0, "12", resultV);
        this.verifyString(1, "07", resultV);
        this.verifyString(2, "02", resultV);
        this.verifyString(3, "08", resultV);
        this.verifyString(4, "01", resultV);
        this.verifyString(5, "12", resultV);
    }

    @Test
    public void testCastTimestampToStringWithFormat() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchTimestampInStringOutFormatted();
        BytesColumnVector resultV = (BytesColumnVector)b.cols[1];
        CastTimestampToStringWithFormat expr = new CastTimestampToStringWithFormat(0, "yyyy".getBytes(), 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)"2019", (Object)this.getStringFromBytesColumnVector(resultV, 0));
        Assert.assertEquals((Object)"1776", (Object)this.getStringFromBytesColumnVector(resultV, 1));
        Assert.assertEquals((Object)"2012", (Object)this.getStringFromBytesColumnVector(resultV, 2));
        Assert.assertEquals((Object)"1580", (Object)this.getStringFromBytesColumnVector(resultV, 3));
        Assert.assertEquals((Object)"0005", (Object)this.getStringFromBytesColumnVector(resultV, 4));
        Assert.assertEquals((Object)"9999", (Object)this.getStringFromBytesColumnVector(resultV, 5));
        resultV = new BytesColumnVector();
        b.cols[1] = resultV;
        expr = new CastTimestampToStringWithFormat(0, "HH24".getBytes(), 1);
        expr.evaluate(b);
        Assert.assertEquals((Object)"19", (Object)this.getStringFromBytesColumnVector(resultV, 0));
        Assert.assertEquals((Object)"17", (Object)this.getStringFromBytesColumnVector(resultV, 1));
        Assert.assertEquals((Object)"23", (Object)this.getStringFromBytesColumnVector(resultV, 2));
        Assert.assertEquals((Object)"00", (Object)this.getStringFromBytesColumnVector(resultV, 3));
        Assert.assertEquals((Object)"00", (Object)this.getStringFromBytesColumnVector(resultV, 4));
        Assert.assertEquals((Object)"23", (Object)this.getStringFromBytesColumnVector(resultV, 5));
    }

    @Test
    public void testCastStringToTimestampWithFormat() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchStringInTimestampOutFormatted();
        TimestampColumnVector resultV = new TimestampColumnVector();
        b.cols[1] = resultV;
        CastStringToTimestampWithFormat expr = new CastStringToTimestampWithFormat(0, "yyyy.mm.dd HH24.mi.ss.ff".getBytes(), 1);
        expr.evaluate(b);
        this.verifyTimestamp("2019-12-31 00:00:00.999999999", resultV, 0);
        this.verifyTimestamp("1776-07-04 17:07:06.177617761", resultV, 1);
        this.verifyTimestamp("2012-02-29 23:59:59.999999999", resultV, 2);
        this.verifyTimestamp("1580-08-08 00:00:00", resultV, 3);
        this.verifyTimestamp("0005-01-01 00:00:00", resultV, 4);
        this.verifyTimestamp("9999-12-31 23:59:59.999999999", resultV, 5);
    }

    private void verifyTimestamp(String tsString, TimestampColumnVector resultV, int index) {
        Assert.assertEquals((long)Timestamp.valueOf((String)tsString).toEpochMilli(), (long)resultV.time[index]);
        Assert.assertEquals((long)Timestamp.valueOf((String)tsString).getNanos(), (long)resultV.nanos[index]);
    }

    @Test
    public void testCastStringToDateWithFormat() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchStringInDateOutFormatted();
        LongColumnVector resultV = new LongColumnVector();
        b.cols[1] = resultV;
        CastStringToDateWithFormat expr = new CastStringToDateWithFormat(0, "yyyy.mm.dd".getBytes(), 1);
        expr.evaluate(b);
        Assert.assertEquals((long)Date.valueOf((String)"2019-12-31").toEpochDay(), (long)resultV.vector[0]);
        Assert.assertEquals((long)Date.valueOf((String)"1776-07-04").toEpochDay(), (long)resultV.vector[1]);
        Assert.assertEquals((long)Date.valueOf((String)"2012-02-29").toEpochDay(), (long)resultV.vector[2]);
        Assert.assertEquals((long)Date.valueOf((String)"1580-08-08").toEpochDay(), (long)resultV.vector[3]);
        Assert.assertEquals((long)Date.valueOf((String)"0005-01-01").toEpochDay(), (long)resultV.vector[4]);
        Assert.assertEquals((long)Date.valueOf((String)"9999-12-31").toEpochDay(), (long)resultV.vector[5]);
    }

    private void verifyString(int resultIndex, String expected, BytesColumnVector resultV) {
        String result = this.getStringFromBytesColumnVector(resultV, resultIndex);
        Assert.assertEquals((Object)expected, (Object)result);
    }

    private String getStringFromBytesColumnVector(BytesColumnVector resultV, int i) {
        byte[] resultBytes = Arrays.copyOfRange(resultV.vector[i], resultV.start[i], resultV.start[i] + resultV.length[i]);
        String result = new String(resultBytes, StandardCharsets.UTF_8);
        return result;
    }
}

