/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorNull {
    @Test
    public void testIsNull() throws Exception {
        Random random = new Random(5371L);
        this.doNull(random, "isnull");
    }

    @Test
    public void testIsNotNull() throws Exception {
        Random random = new Random(2772L);
        this.doNull(random, "isnotnull");
    }

    @Test
    public void testNot() throws Exception {
        Random random = new Random(2772L);
        this.doNull(random, "not");
    }

    private void doNull(Random random, String functionName) throws Exception {
        this.doIsNullOnRandomDataType(random, functionName, true);
        this.doIsNullOnRandomDataType(random, functionName, true);
        this.doIsNullOnRandomDataType(random, functionName, true);
        this.doIsNullOnRandomDataType(random, functionName, false);
        this.doIsNullOnRandomDataType(random, functionName, false);
        this.doIsNullOnRandomDataType(random, functionName, false);
    }

    private boolean doIsNullOnRandomDataType(Random random, String functionName, boolean isFilter) throws Exception {
        int i;
        String typeName;
        if (functionName.equals("not")) {
            typeName = "boolean";
        } else {
            typeName = VectorRandomRowSource.getRandomTypeName(random, VectorRandomRowSource.SupportedTypes.ALL, null);
            typeName = VectorRandomRowSource.getDecoratedTypeName(random, typeName, VectorRandomRowSource.SupportedTypes.ALL, null, 0, 2);
        }
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
        VectorRandomRowSource.GenerationSpec generationSpec = VectorRandomRowSource.GenerationSpec.createSameType(typeInfo);
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        generationSpecList.add(generationSpec);
        explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("col1");
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(typeInfo, "col1", "table", false);
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        String[] columnNames = columns.toArray(new String[0]);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        GenericUDFOPNull udf = switch (functionName) {
            case "isnull" -> new GenericUDFOPNull();
            case "isnotnull" -> new GenericUDFOPNotNull();
            case "not" -> new GenericUDFOPNot();
            default -> throw new RuntimeException("Unexpected function name " + functionName);
        };
        ObjectInspector[] argumentOIs = new ObjectInspector[]{objectInspector};
        ObjectInspector outputObjectInspector = udf.initialize(argumentOIs);
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)udf, children);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[NullTestMode.count][];
        block14: for (i = 0; i < NullTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            NullTestMode nullTestMode = NullTestMode.values()[i];
            switch (nullTestMode) {
                case ROW_MODE: {
                    if (this.doRowCastTest(typeInfo, isFilter, columns, children, (GenericUDF)udf, exprDesc, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), resultObjects)) continue block14;
                    return false;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    if (this.doVectorCastTest(typeInfo, isFilter, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, (GenericUDF)udf, exprDesc, nullTestMode, batchSource, exprDesc.getWritableObjectInspector(), outputTypeInfo, resultObjects)) continue block14;
                    return false;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + nullTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < NullTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                NullTestMode nullTestMode = NullTestMode.values()[v];
                if (isFilter && expectedResult == null && vectorResult != null) {
                    boolean vectorBoolean = ((BooleanWritable)vectorResult).get();
                    if (!vectorBoolean) continue;
                    Assert.fail((String)("Row " + i + " typeName " + typeName + " outputTypeName " + outputTypeInfo.getTypeName() + " isFilter " + isFilter + " " + nullTestMode + " result is NOT NULL and true does not match row-mode expected result is NULL which means false here row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
                    continue;
                }
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " sourceTypeName " + typeName + " isFilter " + isFilter + " " + nullTestMode + " result is NULL " + (String)(vectorResult == null ? "YES" : "NO result " + vectorResult.toString()) + " does not match row-mode expected result is NULL " + (String)(expectedResult == null ? "YES" : "NO result " + expectedResult.toString()) + " row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " sourceTypeName " + typeName + " isFilter " + isFilter + " " + nullTestMode + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
            }
        }
        return true;
    }

    private boolean doRowCastTest(TypeInfo typeInfo, boolean isFilter, List<String> columns, List<ExprNodeDesc> children, GenericUDF udf, ExprNodeGenericFuncDesc exprDesc, Object[][] randomRows, ObjectInspector rowInspector, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        try {
            evaluator.initialize(rowInspector);
        }
        catch (HiveException e) {
            return false;
        }
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result = evaluator.evaluate((Object)row);
            resultObjects[i] = copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)PrimitiveObjectInspectorFactory.writableBooleanObjectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
        return true;
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private boolean doVectorCastTest(TypeInfo typeInfo, boolean isFilter, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, GenericUDF udf, ExprNodeGenericFuncDesc exprDesc, NullTestMode nullTestMode, VectorRandomBatchSource batchSource, ObjectInspector objectInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (nullTestMode == NullTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc, isFilter ? VectorExpressionDescriptor.Mode.FILTER : VectorExpressionDescriptor.Mode.PROJECTION);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (nullTestMode == NullTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo " + typeInfo.toString() + " nullTestMode " + nullTestMode + " isFilter " + isFilter + " vectorExpression " + vectorExpression.toString());
        }
        VectorRandomRowSource rowSource = batchSource.getRowSource();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, vectorizationContext.getScratchColumnTypeNames(), vectorizationContext.getScratchDataTypePhysicalVariations());
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = null;
        Object[] scrqtchRow = null;
        if (!isFilter) {
            resultVectorExtractRow = new VectorExtractRow();
            int outputColumnNum = vectorExpression.getOutputColumnNum();
            resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{outputColumnNum});
            scrqtchRow = new Object[1];
        }
        boolean copySelectedInUse = false;
        int[] copySelected = new int[1024];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            int originalBatchSize = batch.size;
            if (isFilter) {
                copySelectedInUse = batch.selectedInUse;
                if (batch.selectedInUse) {
                    System.arraycopy(batch.selected, 0, copySelected, 0, originalBatchSize);
                }
            }
            vectorExpression.evaluate(batch);
            if (!isFilter) {
                this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            } else {
                int currentBatchSize = batch.size;
                if (copySelectedInUse && batch.selectedInUse) {
                    selectIndex = 0;
                    for (i = 0; i < originalBatchSize; ++i) {
                        boolean booleanResult;
                        int originalBatchIndex = copySelected[i];
                        if (selectIndex < currentBatchSize && batch.selected[selectIndex] == originalBatchIndex) {
                            booleanResult = true;
                            ++selectIndex;
                        } else {
                            booleanResult = false;
                        }
                        resultObjects[rowIndex + i] = new BooleanWritable(booleanResult);
                    }
                } else if (batch.selectedInUse) {
                    selectIndex = 0;
                    for (i = 0; i < originalBatchSize; ++i) {
                        boolean booleanResult;
                        if (selectIndex < currentBatchSize && batch.selected[selectIndex] == i) {
                            booleanResult = true;
                            ++selectIndex;
                        } else {
                            booleanResult = false;
                        }
                        resultObjects[rowIndex + i] = new BooleanWritable(booleanResult);
                    }
                } else if (currentBatchSize == 0) {
                    for (i = 0; i < originalBatchSize; ++i) {
                        resultObjects[rowIndex + i] = new BooleanWritable(false);
                    }
                } else {
                    for (i = 0; i < originalBatchSize; ++i) {
                        resultObjects[rowIndex + i] = new BooleanWritable(true);
                    }
                }
            }
            rowIndex += originalBatchSize;
        }
        return true;
    }

    public static enum NullTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = NullTestMode.values().length;
        }
    }
}

