/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorNegative {
    private static TypeInfo[] integerTypeInfos = new TypeInfo[]{TypeInfoFactory.byteTypeInfo, TypeInfoFactory.shortTypeInfo, TypeInfoFactory.intTypeInfo, TypeInfoFactory.longTypeInfo};
    private static TypeInfo[] floatingTypeInfos = new TypeInfo[]{TypeInfoFactory.floatTypeInfo, TypeInfoFactory.doubleTypeInfo};
    private static TypeInfo[] decimalTypeInfos = new TypeInfo[]{new DecimalTypeInfo(38, 18), new DecimalTypeInfo(25, 2), new DecimalTypeInfo(19, 4), new DecimalTypeInfo(18, 10), new DecimalTypeInfo(17, 3), new DecimalTypeInfo(12, 2), new DecimalTypeInfo(7, 1)};

    public TestVectorNegative() {
        SessionState ss = new SessionState(new HiveConf());
        ss.getConf().setVar(HiveConf.ConfVars.HIVE_COMPAT, "latest");
        SessionState.setCurrentSessionState((SessionState)ss);
    }

    @Test
    public void testInteger() throws Exception {
        Random random = new Random(7743L);
        this.doIntegerTests(random);
    }

    @Test
    public void testFloating() throws Exception {
        Random random = new Random(7743L);
        this.doFloatingTests(random);
    }

    @Test
    public void testDecimal() throws Exception {
        Random random = new Random(7743L);
        this.doDecimalTests(random);
    }

    private void doIntegerTests(Random random) throws Exception {
        for (TypeInfo typeInfo : integerTypeInfos) {
            this.doTests(random, typeInfo);
        }
    }

    private void doIntegerFloatingTests(Random random) throws Exception {
        for (TypeInfo typeInfo : integerTypeInfos) {
            this.doTests(random, typeInfo);
        }
    }

    private void doFloatingTests(Random random) throws Exception {
        for (TypeInfo typeInfo : floatingTypeInfos) {
            this.doTests(random, typeInfo);
        }
    }

    private void doDecimalTests(Random random) throws Exception {
        for (TypeInfo typeInfo : decimalTypeInfos) {
            this.doTests(random, typeInfo);
        }
    }

    private TypeInfo getOutputTypeInfo(GenericUDF genericUdfClone, List<ObjectInspector> objectInspectorList) throws HiveException {
        ObjectInspector[] array = objectInspectorList.toArray(new ObjectInspector[objectInspectorList.size()]);
        ObjectInspector outputObjectInspector = genericUdfClone.initialize(array);
        return TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
    }

    private void doTests(Random random, TypeInfo typeInfo) throws Exception {
        int i;
        String typeName = typeInfo.getTypeName();
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory1 = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        int columnNum = 1;
        generationSpecList.add(VectorRandomRowSource.GenerationSpec.createSameType(typeInfo));
        explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        String columnName = "col" + columnNum++;
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(typeInfo, columnName, "table", false);
        columns.add(columnName);
        ArrayList<ObjectInspector> objectInspectorList = new ArrayList<ObjectInspector>();
        objectInspectorList.add(VectorRandomRowSource.getObjectInspector(typeInfo));
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        String[] columnNames = columns.toArray(new String[0]);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, true, explicitDataTypePhysicalVariationList);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        GenericUDFOPNegative genericUdf = new GenericUDFOPNegative();
        ObjectInspector[] objectInspectors = objectInspectorList.toArray(new ObjectInspector[objectInspectorList.size()]);
        ObjectInspector outputObjectInspector = null;
        try {
            outputObjectInspector = genericUdf.initialize(objectInspectors);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(outputTypeInfo, (GenericUDF)genericUdf, children);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[NegativeTestMode.count][];
        block6: for (i = 0; i < NegativeTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            NegativeTestMode negativeTestMode = NegativeTestMode.values()[i];
            switch (negativeTestMode) {
                case ROW_MODE: {
                    this.doRowArithmeticTest(typeInfo, columns, children, exprDesc, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), outputTypeInfo, resultObjects);
                    continue block6;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    this.doVectorArithmeticTest(typeInfo, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, exprDesc, negativeTestMode, batchSource, exprDesc.getWritableObjectInspector(), outputTypeInfo, resultObjects);
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unexpected Negative operator test mode " + negativeTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < NegativeTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " typeName " + typeName + " outputTypeName " + outputTypeInfo.getTypeName() + " " + NegativeTestMode.values()[v] + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null) + " row values " + Arrays.toString(randomRows[i])));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " typeName " + typeName + " outputTypeName " + outputTypeInfo.getTypeName() + " " + NegativeTestMode.values()[v] + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i])));
            }
        }
    }

    private void doRowArithmeticTest(TypeInfo typeInfo, List<String> columns, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, Object[][] randomRows, ObjectInspector rowInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)outputTypeInfo);
        for (Object[] row : randomRows) {
            Object result = evaluator.evaluate((Object)row);
            Object copyResult = null;
            try {
                copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            }
            catch (Exception e) {
                System.out.println("here");
            }
            resultObjects[i] = copyResult;
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private void doVectorArithmeticTest(TypeInfo typeInfo, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, ExprNodeGenericFuncDesc exprDesc, NegativeTestMode negativeTestMode, VectorRandomBatchSource batchSource, ObjectInspector objectInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (negativeTestMode == NegativeTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (negativeTestMode == NegativeTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo " + typeInfo.toString() + " negativeTestMode " + negativeTestMode + " vectorExpression " + vectorExpression.toString());
        }
        String[] outputScratchTypeNames = vectorizationContext.getScratchColumnTypeNames();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, typeInfos, dataTypePhysicalVariations, null, 0, 0, null, outputScratchTypeNames, null);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{vectorExpression.getOutputColumnNum()});
        Object[] scrqtchRow = new Object[1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            rowIndex += batch.size;
        }
    }

    public static enum NegativeTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = NegativeTestMode.values().length;
        }
    }
}

