/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncBin;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncHex;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncLogWithBaseDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncPowerDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncRand;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FuncRandNoSeed;
import org.apache.hadoop.hive.ql.exec.vector.expressions.PosModDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.PosModLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.RoundWithNumDigitsDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringHex;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncACosDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncASinDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncATanDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncAbsDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncAbsLongToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCeilDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCosDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncDegreesDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncExpDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncFloorDoubleToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLnDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLnLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog10DoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog10LongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog2DoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLog2LongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncRadiansDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncRoundDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSignDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSignLongToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSinDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSqrtDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncTanDoubleToDouble;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.RandomTypeUtil;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorMathFunctions {
    private HiveConf hiveConf = new HiveConf();
    private static final double eps = 1.0E-7;
    private static final int DAYS_LIMIT = 3649635;
    private static final int SMALLEST_EPOCH_DAY = -718685;
    static long SECONDS_LIMIT = 5255474400L;

    private static boolean equalsWithinTolerance(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    @Test
    public void testVectorRound() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        FuncRoundDoubleToDouble expr = new FuncRoundDoubleToDouble(0, 1);
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr.evaluate(b);
        Assert.assertEquals((double)-2.0, (double)resultV.vector[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)-1.0, (double)resultV.vector[1], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)0.0, (double)resultV.vector[2], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)0.0, (double)resultV.vector[3], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)1.0, (double)resultV.vector[4], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)1.0, (double)resultV.vector[5], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)2.0, (double)resultV.vector[6], (double)Double.MIN_VALUE);
        b.cols[0].noNulls = false;
        b.cols[0].isNull[3] = true;
        resultV.noNulls = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)true, (Object)resultV.isNull[3]);
        Assert.assertEquals((Object)false, (Object)resultV.noNulls);
        b.cols[0].isRepeating = true;
        resultV.isRepeating = false;
        expr.evaluate(b);
        Assert.assertEquals((double)-2.0, (double)resultV.vector[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((Object)true, (Object)resultV.isRepeating);
        resultV.isRepeating = false;
        b.cols[0].noNulls = true;
        expr.evaluate(b);
        Assert.assertEquals((double)-2.0, (double)resultV.vector[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((Object)true, (Object)resultV.isRepeating);
    }

    @Test
    public void testRoundToDecimalPlaces() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        RoundWithNumDigitsDoubleToDouble expr = new RoundWithNumDigitsDoubleToDouble(0, 4L, 1);
        expr.evaluate(b);
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        Assert.assertEquals((double)1.2346, (double)resultV.vector[7], (double)Double.MIN_VALUE);
    }

    public static VectorizedRowBatch getVectorizedRowBatchDateInTimestampOut(int[] intValues) {
        Random r = new Random(12099L);
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        LongColumnVector inV = new LongColumnVector(intValues.length);
        TimestampColumnVector outV = new TimestampColumnVector(intValues.length);
        for (int i = 0; i < intValues.length; ++i) {
            intValues[i] = -718685 + r.nextInt() % 3649635;
            inV.vector[i] = intValues[i];
        }
        batch.cols[0] = inV;
        batch.cols[1] = outV;
        batch.size = intValues.length;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchDateInStringOut(int[] intValues) {
        VectorizedRowBatch batch = TestVectorMathFunctions.getVectorizedRowBatchDateInTimestampOut(intValues);
        BytesColumnVector outV = new BytesColumnVector(intValues.length);
        batch.cols[1] = outV;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchDateInStringOutFormatted() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        LongColumnVector dateColumnV = new LongColumnVector();
        BytesColumnVector stringColumnV = new BytesColumnVector();
        dateColumnV.vector[0] = Date.valueOf((String)"2019-12-31").toEpochDay();
        dateColumnV.vector[1] = Date.valueOf((String)"1776-07-04").toEpochDay();
        dateColumnV.vector[2] = Date.valueOf((String)"2012-02-29").toEpochDay();
        dateColumnV.vector[3] = Date.valueOf((String)"1580-08-08").toEpochDay();
        dateColumnV.vector[4] = Date.valueOf((String)"0005-01-01").toEpochDay();
        dateColumnV.vector[5] = Date.valueOf((String)"9999-12-31").toEpochDay();
        batch.cols[0] = dateColumnV;
        batch.cols[1] = stringColumnV;
        batch.size = 6;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchDoubleInLongOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        LongColumnVector lcv = new LongColumnVector();
        DoubleColumnVector dcv = new DoubleColumnVector();
        dcv.vector[0] = -1.5;
        dcv.vector[1] = -0.5;
        dcv.vector[2] = -0.1;
        dcv.vector[3] = 0.0;
        dcv.vector[4] = 0.5;
        dcv.vector[5] = 0.7;
        dcv.vector[6] = 1.5;
        batch.cols[0] = dcv;
        batch.cols[1] = lcv;
        batch.size = 7;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchDoubleInTimestampOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        TimestampColumnVector tcv = new TimestampColumnVector();
        DoubleColumnVector dcv = new DoubleColumnVector();
        dcv.vector[0] = -1.5;
        dcv.vector[1] = -0.5;
        dcv.vector[2] = -0.1;
        dcv.vector[3] = 0.0;
        dcv.vector[4] = 0.5;
        dcv.vector[5] = 0.7;
        dcv.vector[6] = 1.5;
        batch.cols[0] = dcv;
        batch.cols[1] = tcv;
        batch.size = 7;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchDoubleInDoubleOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        DoubleColumnVector outV = new DoubleColumnVector();
        DoubleColumnVector inV = new DoubleColumnVector();
        inV.vector[0] = -1.5;
        inV.vector[1] = -0.5;
        inV.vector[2] = -0.1;
        inV.vector[3] = 0.0;
        inV.vector[4] = 0.5;
        inV.vector[5] = 0.7;
        inV.vector[6] = 1.5;
        inV.vector[7] = 1.2345678;
        batch.cols[0] = inV;
        batch.cols[1] = outV;
        batch.size = 8;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchLongInDoubleOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        LongColumnVector lcv = new LongColumnVector();
        DoubleColumnVector dcv = new DoubleColumnVector();
        lcv.vector[0] = -2L;
        lcv.vector[1] = -1L;
        lcv.vector[2] = 0L;
        lcv.vector[3] = 1L;
        lcv.vector[4] = 2L;
        batch.cols[0] = lcv;
        batch.cols[1] = dcv;
        batch.size = 5;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchTimestampInDoubleOut(double[] doubleValues) {
        Random r = new Random(45993L);
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        TimestampColumnVector tcv = new TimestampColumnVector(doubleValues.length);
        DoubleColumnVector dcv = new DoubleColumnVector(doubleValues.length);
        for (int i = 0; i < doubleValues.length; ++i) {
            doubleValues[i] = r.nextDouble() % (double)SECONDS_LIMIT;
            dcv.vector[i] = doubleValues[i];
        }
        batch.cols[0] = tcv;
        batch.cols[1] = dcv;
        batch.size = doubleValues.length;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchLongInLongOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        LongColumnVector inV = new LongColumnVector();
        LongColumnVector outV = new LongColumnVector();
        inV.vector[0] = -2L;
        inV.vector[1] = 2L;
        batch.cols[0] = inV;
        batch.cols[1] = outV;
        batch.size = 2;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchStringInLongOut() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        BytesColumnVector inV = new BytesColumnVector();
        LongColumnVector outV = new LongColumnVector();
        inV.initBuffer();
        inV.setVal(0, StandardCharsets.UTF_8.encode("true").array());
        inV.setVal(1, StandardCharsets.UTF_8.encode("TRUE").array());
        inV.setVal(2, StandardCharsets.UTF_8.encode("TrUe").array());
        inV.setVal(3, StandardCharsets.UTF_8.encode("false").array());
        inV.setVal(4, StandardCharsets.UTF_8.encode("FALSE").array());
        inV.setVal(5, StandardCharsets.UTF_8.encode("FaLsE").array());
        inV.setVal(6, StandardCharsets.UTF_8.encode("").array());
        inV.setVal(7, StandardCharsets.UTF_8.encode("Other").array());
        batch.cols[0] = inV;
        batch.cols[1] = outV;
        batch.size = 8;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchStringInTimestampOutFormatted() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        BytesColumnVector inV = new BytesColumnVector();
        inV.initBuffer();
        inV.setVal(0, StandardCharsets.UTF_8.encode("2019-12-31 00:00:00.999999999").array());
        inV.setVal(1, StandardCharsets.UTF_8.encode("1776-07-04 17:07:06.177617761").array());
        inV.setVal(2, StandardCharsets.UTF_8.encode("2012-02-29 23:59:59.999999999").array());
        inV.setVal(3, StandardCharsets.UTF_8.encode("1580-08-08 00:00:00.0").array());
        inV.setVal(4, StandardCharsets.UTF_8.encode("0005-01-01 00:00:00.0").array());
        inV.setVal(5, StandardCharsets.UTF_8.encode("9999-12-31 23:59:59.999999999").array());
        batch.cols[0] = inV;
        batch.size = 6;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchStringInDateOutFormatted() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        BytesColumnVector inV = new BytesColumnVector();
        inV.initBuffer();
        inV.setVal(0, StandardCharsets.UTF_8.encode("19/12/31").array());
        inV.setVal(1, StandardCharsets.UTF_8.encode("1776--07--04").array());
        inV.setVal(2, StandardCharsets.UTF_8.encode("2012/02/29").array());
        inV.setVal(3, StandardCharsets.UTF_8.encode("1580/08/08").array());
        inV.setVal(4, StandardCharsets.UTF_8.encode("0005/01/01").array());
        inV.setVal(5, StandardCharsets.UTF_8.encode("9999/12/31").array());
        batch.cols[0] = inV;
        batch.size = 6;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchTimestampInLongOut(long[] longValues) {
        Random r = new Random(345L);
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        TimestampColumnVector inV = new TimestampColumnVector(longValues.length);
        LongColumnVector outV = new LongColumnVector(longValues.length);
        for (int i = 0; i < longValues.length; ++i) {
            org.apache.hadoop.hive.common.type.Timestamp randTimestamp = RandomTypeUtil.getRandTimestamp((Random)r);
            longValues[i] = TimestampWritableV2.getLong((org.apache.hadoop.hive.common.type.Timestamp)randTimestamp);
            inV.set(0, randTimestamp.toSqlTimestamp());
        }
        batch.cols[0] = inV;
        batch.cols[1] = outV;
        batch.size = longValues.length;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchTimestampInStringOut(long[] epochSecondValues, int[] nanoValues) {
        Random r = new Random(345L);
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        batch.size = epochSecondValues.length;
        TimestampColumnVector inV = new TimestampColumnVector(batch.size);
        BytesColumnVector outV = new BytesColumnVector(batch.size);
        for (int i = 0; i < batch.size; ++i) {
            org.apache.hadoop.hive.common.type.Timestamp randTimestamp = RandomTypeUtil.getRandTimestamp((Random)r);
            epochSecondValues[i] = randTimestamp.toEpochSecond();
            nanoValues[i] = randTimestamp.getNanos();
            inV.set(i, randTimestamp.toSqlTimestamp());
        }
        batch.cols[0] = inV;
        batch.cols[1] = outV;
        return batch;
    }

    public static VectorizedRowBatch getVectorizedRowBatchTimestampInStringOutFormatted() {
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        TimestampColumnVector timestampColumnV = new TimestampColumnVector();
        BytesColumnVector stringColumnV = new BytesColumnVector();
        timestampColumnV.set(0, TestVectorMathFunctions.getSqlTimestamp("2019-12-31 19:20:21.999999999"));
        timestampColumnV.set(1, TestVectorMathFunctions.getSqlTimestamp("1776-07-04 17:07:06.177617761"));
        timestampColumnV.set(2, TestVectorMathFunctions.getSqlTimestamp("2012-02-29 23:59:59.999999999"));
        timestampColumnV.set(3, TestVectorMathFunctions.getSqlTimestamp("1580-08-08 00:00:00"));
        timestampColumnV.set(4, TestVectorMathFunctions.getSqlTimestamp("0005-01-01 00:00:00"));
        timestampColumnV.set(5, TestVectorMathFunctions.getSqlTimestamp("9999-12-31 23:59:59.999999999"));
        batch.cols[0] = timestampColumnV;
        batch.cols[1] = stringColumnV;
        batch.size = 6;
        return batch;
    }

    private static Timestamp getSqlTimestamp(String s) {
        return org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)s).toSqlTimestamp();
    }

    public static VectorizedRowBatch getVectorizedRowBatchLongInTimestampOut(long[] longValues) {
        Random r = new Random(12099L);
        VectorizedRowBatch batch = new VectorizedRowBatch(2);
        LongColumnVector inV = new LongColumnVector();
        TimestampColumnVector outV = new TimestampColumnVector();
        for (int i = 0; i < longValues.length; ++i) {
            longValues[i] = r.nextLong() % SECONDS_LIMIT;
            inV.vector[i] = longValues[i];
        }
        batch.cols[0] = inV;
        batch.cols[1] = outV;
        batch.size = longValues.length;
        return batch;
    }

    public static VectorizedRowBatch getBatchForStringMath() {
        VectorizedRowBatch batch = new VectorizedRowBatch(3);
        LongColumnVector inL = new LongColumnVector();
        BytesColumnVector inS = new BytesColumnVector();
        BytesColumnVector outS = new BytesColumnVector();
        inL.vector[0] = 0L;
        inL.vector[1] = 255L;
        inL.vector[2] = 0L;
        inS.initBuffer();
        inS.setVal(0, "00".getBytes(StandardCharsets.UTF_8), 0, 2);
        inS.setVal(1, "3232".getBytes(StandardCharsets.UTF_8), 0, 4);
        byte[] bad = "bad data".getBytes(StandardCharsets.UTF_8);
        inS.setVal(2, bad, 0, bad.length);
        batch.cols[0] = inS;
        batch.cols[1] = inL;
        batch.cols[2] = outS;
        batch.size = 3;
        return batch;
    }

    @Test
    public void testVectorSin() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncSinDoubleToDouble expr = new FuncSinDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.sin(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorCos() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncCosDoubleToDouble expr = new FuncCosDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.cos(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorTan() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncTanDoubleToDouble expr = new FuncTanDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.tan(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorASin() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncASinDoubleToDouble expr = new FuncASinDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.asin(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorACos() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncACosDoubleToDouble expr = new FuncACosDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.acos(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorATan() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncATanDoubleToDouble expr = new FuncATanDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.atan(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorDegrees() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncDegreesDoubleToDouble expr = new FuncDegreesDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.toDegrees(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorRadians() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncRadiansDoubleToDouble expr = new FuncRadiansDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.toRadians(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorFloor() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncFloorDoubleToLong expr = new FuncFloorDoubleToLong(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)-2L, (long)resultV.vector[0]);
        Assert.assertEquals((long)1L, (long)resultV.vector[6]);
    }

    @Test
    public void testVectorCeil() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector resultV = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncCeilDoubleToLong expr = new FuncCeilDoubleToLong(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)-1L, (long)resultV.vector[0]);
        Assert.assertEquals((long)2L, (long)resultV.vector[6]);
    }

    @Test
    public void testVectorExp() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncExpDoubleToDouble expr = new FuncExpDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.exp(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorLn() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncLnDoubleToDouble expr = new FuncLnDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.log(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncLnLongToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.log(2.0), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorLog2() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncLog2DoubleToDouble expr = new FuncLog2DoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)(Math.log(0.5) / Math.log(2.0)), (double)resultV.vector[4], (double)Double.MIN_VALUE);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncLog2LongToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)(Math.log(1.0) / Math.log(2.0)), (double)resultV.vector[3], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorLog10() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncLog10DoubleToDouble expr = new FuncLog10DoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertTrue((boolean)TestVectorMathFunctions.equalsWithinTolerance(Math.log(0.5) / Math.log(10.0), resultV.vector[4]));
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncLog10LongToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)(Math.log(1.0) / Math.log(10.0)), (double)resultV.vector[3], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorRand() throws HiveException {
        VectorizedRowBatch b = new VectorizedRowBatch(1);
        DoubleColumnVector v = new DoubleColumnVector();
        b.cols[0] = v;
        int n = b.size = 1024;
        v.noNulls = true;
        FuncRandNoSeed expr = new FuncRandNoSeed(0);
        expr.evaluate(b);
        double sum = 0.0;
        for (int i = 0; i != n; ++i) {
            sum += v.vector[i];
            Assert.assertTrue((v.vector[i] >= 0.0 && v.vector[i] <= 1.0 ? 1 : 0) != 0);
        }
        double avg = sum / (double)n;
        Assert.assertTrue((avg > 0.3 && avg < 0.7 ? 1 : 0) != 0);
        Arrays.fill(v.vector, 0.0);
        expr = new FuncRand(99999L, 0);
        expr.evaluate(b);
        sum = 0.0;
        for (int i = 0; i != n; ++i) {
            sum += v.vector[i];
            Assert.assertTrue((v.vector[i] >= 0.0 && v.vector[i] <= 1.0 ? 1 : 0) != 0);
        }
        avg = sum / (double)n;
        Assert.assertTrue((avg > 0.3 && avg < 0.7 ? 1 : 0) != 0);
    }

    @Test
    public void testVectorLogBase() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncLogWithBaseDoubleToDouble expr = new FuncLogWithBaseDoubleToDouble(10.0, 0, 1);
        expr.evaluate(b);
        Assert.assertTrue((boolean)TestVectorMathFunctions.equalsWithinTolerance(Math.log(0.5) / Math.log(10.0), resultV.vector[4]));
    }

    @Test
    public void testVectorPosMod() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector inV = (DoubleColumnVector)b.cols[0];
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        inV.vector[4] = -4.0;
        PosModDoubleToDouble expr = new PosModDoubleToDouble(0, 0.3, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"double"));
        expr.evaluate(b);
        Assert.assertTrue((boolean)TestVectorMathFunctions.equalsWithinTolerance(0.19999999999999984, resultV.vector[4]));
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector resV2 = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new PosModLongToLong(0, 3L, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"tinyint"));
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)resV2.vector[0]);
        expr = new PosModLongToLong(0, 3L, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"smallint"));
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)resV2.vector[0]);
        expr = new PosModLongToLong(0, 3L, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"int"));
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)resV2.vector[0]);
        expr = new PosModLongToLong(0, 3L, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"bigint"));
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)resV2.vector[0]);
    }

    @Test
    public void testVectorPosModWithFloatOutputType() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector inV = (DoubleColumnVector)b.cols[0];
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        inV.vector[4] = -4.0;
        PosModDoubleToDouble expr = new PosModDoubleToDouble(0, 0.3, 1);
        expr.setOutputTypeInfo((TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)"float"));
        expr.evaluate(b);
        Assert.assertTrue((boolean)TestVectorMathFunctions.equalsWithinTolerance(0.20000016689300537, resultV.vector[4]));
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector resV2 = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new PosModLongToLong(0, 3L, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)resV2.vector[0]);
    }

    @Test
    public void testVectorPower() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncPowerDoubleToDouble expr = new FuncPowerDoubleToDouble(0, 2.0, 1);
        expr.evaluate(b);
        Assert.assertTrue((boolean)TestVectorMathFunctions.equalsWithinTolerance(0.25, resultV.vector[4]));
    }

    @Test
    public void testVectorSqrt() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncSqrtDoubleToDouble expr = new FuncSqrtDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)Math.sqrt(0.5), (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorAbs() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncAbsDoubleToDouble expr = new FuncAbsDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)1.5, (double)resultV.vector[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)0.5, (double)resultV.vector[4], (double)Double.MIN_VALUE);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector resultVLong = (LongColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncAbsLongToLong(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((long)2L, (long)resultVLong.vector[0]);
        Assert.assertEquals((long)2L, (long)resultVLong.vector[1]);
    }

    @Test
    public void testVectorSign() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInDoubleOut();
        DoubleColumnVector resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        FuncSignDoubleToDouble expr = new FuncSignDoubleToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)-1.0, (double)resultV.vector[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)1.0, (double)resultV.vector[4], (double)Double.MIN_VALUE);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInDoubleOut();
        resultV = (DoubleColumnVector)b.cols[1];
        b.cols[0].noNulls = true;
        expr = new FuncSignLongToDouble(0, 1);
        expr.evaluate(b);
        Assert.assertEquals((double)-1.0, (double)resultV.vector[0], (double)Double.MIN_VALUE);
        Assert.assertEquals((double)1.0, (double)resultV.vector[4], (double)Double.MIN_VALUE);
    }

    @Test
    public void testVectorBin() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getBatchForStringMath();
        BytesColumnVector resultV = (BytesColumnVector)b.cols[2];
        b.cols[0].noNulls = true;
        FuncBin expr = new FuncBin(1, 2);
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(b);
        String s = new String(resultV.vector[1], resultV.start[1], resultV.length[1]);
        Assert.assertEquals((Object)"11111111", (Object)s);
    }

    @Test
    public void testVectorHex() throws HiveException {
        VectorizedRowBatch b = TestVectorMathFunctions.getBatchForStringMath();
        BytesColumnVector resultV = (BytesColumnVector)b.cols[2];
        b.cols[1].noNulls = true;
        FuncHex expr = new FuncHex(1, 2);
        expr.transientInit((Configuration)this.hiveConf);
        expr.evaluate(b);
        String s = new String(resultV.vector[1], resultV.start[1], resultV.length[1]);
        Assert.assertEquals((Object)"FF", (Object)s);
        b = TestVectorMathFunctions.getBatchForStringMath();
        resultV = (BytesColumnVector)b.cols[2];
        b.cols[0].noNulls = true;
        expr = new StringHex(0, 2);
        expr.evaluate(b);
        s = new String(resultV.vector[1], resultV.start[1], resultV.length[1]);
        Assert.assertEquals((Object)"33323332", (Object)s);
    }
}

