/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIndex;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorIndex {
    private static TypeInfo[] decimalTypeInfos = new TypeInfo[]{new DecimalTypeInfo(38, 18), new DecimalTypeInfo(25, 2), new DecimalTypeInfo(19, 4), new DecimalTypeInfo(18, 10), new DecimalTypeInfo(17, 3), new DecimalTypeInfo(12, 2), new DecimalTypeInfo(7, 1)};

    @Test
    public void testListIndex() throws Exception {
        Random random = new Random(241L);
        this.doIndex(random, true, null, true);
    }

    @Test
    public void testMapIndex() throws Exception {
        Random random = new Random(233L);
        this.doIndex(random, false, "int", true);
        this.doIndex(random, false, "bigint", false);
        this.doIndex(random, false, "double", false);
        this.doIndex(random, false, "string", false);
        for (TypeInfo typeInfo : decimalTypeInfos) {
            this.doIndex(random, false, typeInfo.getTypeName(), false);
        }
    }

    private void doIndex(Random random, boolean isList, String keyTypeName, boolean isFullElementTypeGamut) throws Exception {
        String oneElementRootTypeName = "bigint";
        this.doIndexOnRandomDataType(random, isList, keyTypeName, oneElementRootTypeName, true, false);
        this.doIndexOnRandomDataType(random, isList, keyTypeName, oneElementRootTypeName, true, true);
        this.doIndexOnRandomDataType(random, isList, keyTypeName, oneElementRootTypeName, false, false);
        this.doIndexOnRandomDataType(random, isList, keyTypeName, oneElementRootTypeName, false, true);
        if (!isFullElementTypeGamut) {
            return;
        }
        ArrayList<String> elementRootTypeNameList = new ArrayList<String>();
        elementRootTypeNameList.add("int");
        elementRootTypeNameList.add("bigint");
        elementRootTypeNameList.add("double");
        elementRootTypeNameList.add("string");
        elementRootTypeNameList.add("char");
        elementRootTypeNameList.add("varchar");
        elementRootTypeNameList.add("date");
        elementRootTypeNameList.add("timestamp");
        elementRootTypeNameList.add("binary");
        elementRootTypeNameList.add("decimal");
        elementRootTypeNameList.add("interval_day_time");
        for (String elementRootTypeName : elementRootTypeNameList) {
            this.doIndexOnRandomDataType(random, isList, keyTypeName, elementRootTypeName, true, false);
        }
    }

    private boolean doIndexOnRandomDataType(Random random, boolean isList, String keyTypeName, String elementRootTypeName, boolean allowNulls, boolean isScalarIndex) throws Exception {
        int i;
        ExprNodeConstantDesc keyColExpr;
        String columnName;
        ListTypeInfo typeInfo;
        String elementTypeName = VectorRandomRowSource.getDecoratedTypeName(random, elementRootTypeName, VectorRandomRowSource.SupportedTypes.ALL, null, 0, 3);
        TypeInfo elementTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)elementTypeName);
        ObjectInspector elementObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)elementTypeInfo);
        Object keyTypeInfo = isList ? TypeInfoFactory.intTypeInfo : TypeInfoUtils.getTypeInfoFromTypeString((String)keyTypeName);
        ObjectInspector keyObjectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)keyTypeInfo);
        Object exampleObject = isList ? ((WritableIntObjectInspector)keyObjectInspector).create(0) : VectorRandomRowSource.randomWritable(random, (TypeInfo)keyTypeInfo, keyObjectInspector, DataTypePhysicalVariation.NONE, false);
        WritableComparator writableComparator = WritableComparator.get(exampleObject.getClass());
        int allKeyCount = 10 + random.nextInt(10);
        int keyCount = 5 + random.nextInt(allKeyCount / 2);
        ArrayList<Object> allKeyList = new ArrayList<Object>(allKeyCount);
        TreeSet<Object> allKeyTreeSet = new TreeSet<Object>((Comparator<Object>)writableComparator);
        for (int fillAllKeyCount = 0; fillAllKeyCount < allKeyCount; ++fillAllKeyCount) {
            Object object;
            if (isList) {
                WritableIntObjectInspector writableOI = (WritableIntObjectInspector)keyObjectInspector;
                int index = random.nextInt(keyCount);
                object = writableOI.create(index);
                while (allKeyTreeSet.contains(object)) {
                    index = random.nextBoolean() ? random.nextInt() : (random.nextBoolean() ? -1 : keyCount);
                    object = writableOI.create(index);
                }
            } else {
                while (allKeyTreeSet.contains(object = VectorRandomRowSource.randomWritable(random, (TypeInfo)keyTypeInfo, keyObjectInspector, DataTypePhysicalVariation.NONE, false))) {
                }
            }
            allKeyList.add(object);
            allKeyTreeSet.add(object);
        }
        ArrayList<Object> keyList = new ArrayList<Object>();
        TreeSet keyTreeSet = new TreeSet(writableComparator);
        int fillKeyCount = 0;
        while (fillKeyCount < keyCount) {
            Object newKey = allKeyList.get(random.nextInt(allKeyCount));
            if (keyTreeSet.contains(newKey)) continue;
            keyList.add(newKey);
            keyTreeSet.add(newKey);
            ++fillKeyCount;
        }
        if (isList) {
            ListTypeInfo listTypeInfo = new ListTypeInfo();
            listTypeInfo.setListElementTypeInfo(elementTypeInfo);
            typeInfo = listTypeInfo;
        } else {
            MapTypeInfo mapTypeInfo = new MapTypeInfo();
            mapTypeInfo.setMapKeyTypeInfo((TypeInfo)keyTypeInfo);
            mapTypeInfo.setMapValueTypeInfo(elementTypeInfo);
            typeInfo = mapTypeInfo;
        }
        String typeName = typeInfo.getTypeName();
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
        VectorRandomRowSource.GenerationSpec generationSpec = VectorRandomRowSource.GenerationSpec.createSameType((TypeInfo)typeInfo);
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        int columnNum = 1;
        if (!isScalarIndex) {
            generationSpecList.add(VectorRandomRowSource.GenerationSpec.createValueList((TypeInfo)keyTypeInfo, keyList));
            explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
            columnName = "col" + columnNum++;
            columns.add(columnName);
            keyColExpr = new ExprNodeColumnDesc((TypeInfo)keyTypeInfo, columnName, "table", false);
        } else {
            Object scalarWritable = keyList.get(random.nextInt(keyCount));
            Object scalarObject = VectorRandomRowSource.getNonWritableObject(scalarWritable, (TypeInfo)keyTypeInfo, keyObjectInspector);
            keyColExpr = new ExprNodeConstantDesc((TypeInfo)keyTypeInfo, scalarObject);
        }
        generationSpecList.add(VectorRandomRowSource.GenerationSpec.createValueList((TypeInfo)typeInfo, keyList));
        explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        columnName = "col" + columnNum++;
        columns.add(columnName);
        ExprNodeColumnDesc listOrMapColExpr = new ExprNodeColumnDesc((TypeInfo)typeInfo, columnName, "table", false);
        children.add((ExprNodeDesc)listOrMapColExpr);
        children.add((ExprNodeDesc)keyColExpr);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, allowNulls, true, explicitDataTypePhysicalVariationList);
        String[] columnNames = columns.toArray(new String[0]);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        GenericUDFIndex udf = new GenericUDFIndex();
        ObjectInspector[] argumentOIs = new ObjectInspector[]{objectInspector, keyObjectInspector};
        ObjectInspector outputObjectInspector = udf.initialize(argumentOIs);
        TypeInfo outputTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)outputObjectInspector);
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(elementTypeInfo, (GenericUDF)udf, children);
        System.out.println("here");
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[IndexTestMode.count][];
        block8: for (i = 0; i < IndexTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            IndexTestMode indexTestMode = IndexTestMode.values()[i];
            switch (indexTestMode) {
                case ROW_MODE: {
                    if (this.doRowCastTest((TypeInfo)typeInfo, columns, children, (GenericUDF)udf, exprDesc, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), elementObjectInspector, outputTypeInfo, resultObjects)) continue block8;
                    return false;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    if (this.doVectorCastTest((TypeInfo)typeInfo, columns, columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, (GenericUDF)udf, exprDesc, indexTestMode, batchSource, exprDesc.getWritableObjectInspector(), outputTypeInfo, resultObjects)) continue block8;
                    return false;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + indexTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < IndexTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                IndexTestMode indexTestMode = IndexTestMode.values()[v];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " sourceTypeName " + typeName + " " + indexTestMode + " result is NULL " + (String)(vectorResult == null ? "YES" : "NO result " + vectorResult.toString()) + " does not match row-mode expected result is NULL " + (String)(expectedResult == null ? "YES" : "NO result " + expectedResult.toString()) + " row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " sourceTypeName " + typeName + " " + indexTestMode + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ") row values " + Arrays.toString(randomRows[i]) + " exprDesc " + exprDesc.toString()));
            }
        }
        return true;
    }

    private boolean doRowCastTest(TypeInfo typeInfo, List<String> columns, List<ExprNodeDesc> children, GenericUDF udf, ExprNodeGenericFuncDesc exprDesc, Object[][] randomRows, ObjectInspector rowInspector, ObjectInspector elementObjectInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        try {
            evaluator.initialize(rowInspector);
        }
        catch (HiveException e) {
            return false;
        }
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result = evaluator.evaluate((Object)row);
            try {
                copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)elementObjectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            }
            catch (Exception e) {
                System.out.println("here");
                throw e;
            }
            resultObjects[i] = copyResult;
        }
        return true;
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, ObjectInspector objectInspector, Object[] resultObjects) {
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private boolean doVectorCastTest(TypeInfo typeInfo, List<String> columns, String[] columnNames, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, GenericUDF udf, ExprNodeGenericFuncDesc exprDesc, IndexTestMode indexTestMode, VectorRandomBatchSource batchSource, ObjectInspector objectInspector, TypeInfo outputTypeInfo, Object[] resultObjects) throws Exception {
        HiveConf hiveConf = new HiveConf();
        if (indexTestMode == IndexTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc, VectorExpressionDescriptor.Mode.PROJECTION);
        vectorExpression.transientInit((Configuration)hiveConf);
        if (indexTestMode == IndexTestMode.VECTOR_EXPRESSION && vectorExpression instanceof VectorUDFAdaptor) {
            System.out.println("*NO NATIVE VECTOR EXPRESSION* typeInfo " + typeInfo.toString() + " indexTestMode " + indexTestMode + " vectorExpression " + vectorExpression.toString());
        }
        System.out.println("*VECTOR EXPRESSION* " + vectorExpression.getClass().getSimpleName());
        VectorRandomRowSource rowSource = batchSource.getRowSource();
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, vectorizationContext.getScratchColumnTypeNames(), vectorizationContext.getScratchDataTypePhysicalVariations());
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{outputTypeInfo}, new int[]{vectorExpression.getOutputColumnNum()});
        Object[] scrqtchRow = new Object[1];
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, objectInspector, resultObjects);
            rowIndex += batch.size;
        }
        return true;
    }

    public static enum IndexTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = IndexTestMode.values().length;
        }
    }
}

